/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client;

import com.sygate.scm.common.configobject.schema.SemGroupPolicy;
import com.sygate.scm.common.configobject.schema.SoftwareDeploymentEntity;
import com.sygate.scm.common.configobject.schema.SoftwareDeploymentPolicy;
import com.sygate.scm.common.configobject.schema.SoftwarePackage;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.MultiLineLabel;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.SoftwarePackageHandler;
import com.sygate.scm.console.logicobject.AdminPrivilegeObject;
import com.sygate.scm.console.logicobject.CurrentPackageObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.SoftwareDeploymentEntityObject;
import com.sygate.scm.console.logicobject.SoftwarePackageObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.client.ClientRightPanel;
import com.sygate.scm.console.ui.client.dlg.DeployConfigurationDlg;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.renderer.CheckBoxRenderer;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.AutoUpgradeUtils;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class SoftwareUpdatePanel
extends ClientRightPanel {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String CLIENT = "com.sygate.scm.console.ui.client.client";
    private JPopupMenu popupMenu;
    private JMenuItem addMenu;
    private JMenuItem deleteMenu;
    private JMenuItem editMenu;
    private GroupObject groupObj;
    private ArrayList<SoftwareDeploymentEntityObject> listDeploymentEntityObj = new ArrayList();
    private JTable packageTable = new StripesTable(true, true);
    private JScrollPane packagePanel = new JScrollPane();
    private SortableTableModel tableModel = new SortableTableModel();
    private static final String[] COL_NAMES = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "SoftwareUpdatePanel.packageName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "SoftwareUpdatePanel.packageType"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "SoftwareUpdatePanel.version"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "SoftwareUpdatePanel.startTime"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "SoftwareUpdatePanel.availableOnServer")};
    private JLabel displayPackagesLbl = new JLabel();
    private String viewDot = MSGRES.getString("com.sygate.scm.console.ui.client.client", "SoftwareUpdatePanel.popupViewDot");
    private String editDot = MSGRES.getString("com.sygate.scm.console.ui.client.client", "SoftwareUpdatePanel.popupEditDot");
    private boolean readOnly = false;

    public SoftwareUpdatePanel() {
        this.initialize();
    }

    @Override
    public void executeTask(int taskIndex, Object userObject) {
        block9: {
            try {
                if (taskIndex == 18) {
                    this.doDeploy();
                } else if (taskIndex == 19) {
                    this.getClientPane().doCopyDeployments();
                } else if (taskIndex == 41) {
                    this.doEdit(this.getTable().getSelectedRow());
                } else if (taskIndex == 42) {
                    this.doDelete(this.getTable().getSelectedRow());
                }
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSGRES.getString(CLIENT, "SoftwareUpdatePanel.consoleError"), 0);
                if (!ex.needRelogin()) break block9;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    protected JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.editMenu = this.readOnly ? new JMenuItem(this.viewDot) : new JMenuItem(this.editDot);
            this.editMenu.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SoftwareUpdatePanel.this.handlePopupAction(e);
                }
            });
            this.deleteMenu = new JMenuItem(MSGRES.getString(CLIENT, "SoftwareUpdatePanel.popupDelete"));
            this.deleteMenu.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SoftwareUpdatePanel.this.handlePopupAction(e);
                }
            });
            this.addMenu = new JMenuItem(MSGRES.getString(CLIENT, "SoftwareUpdatePanel.popupAddDot"));
            this.addMenu.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SoftwareUpdatePanel.this.handlePopupAction(e);
                }
            });
            this.popupMenu.add(this.addMenu);
            this.popupMenu.add(this.editMenu);
            this.popupMenu.add(this.deleteMenu);
            this.validatePopup();
        }
        return this.popupMenu;
    }

    public void validatePopup() {
        boolean isEnabled = this.getTable().getSelectedRow() >= 0;
        this.editMenu.setEnabled(isEnabled);
        if (!this.readOnly) {
            this.editMenu.setText(this.editDot);
            this.addMenu.setEnabled(true);
            this.deleteMenu.setEnabled(isEnabled);
        } else {
            this.editMenu.setText(this.viewDot);
            this.addMenu.setEnabled(false);
            this.deleteMenu.setEnabled(false);
        }
    }

    public void handlePopupAction(ActionEvent e) {
        block7: {
            try {
                this.validatePopup();
                if (e.getSource() == this.addMenu) {
                    this.doDeploy();
                } else if (e.getSource() == this.editMenu) {
                    this.doEdit(this.getTable().getSelectedRow());
                } else if (e.getSource() == this.deleteMenu) {
                    this.doDelete(this.getTable().getSelectedRow());
                }
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSGRES.getString(CLIENT, "SoftwareUpdatePanel.consoleError"), 0);
                if (!ex.needRelogin()) break block7;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_compusers_pane_install_packages";
    }

    @Override
    protected String getHtmlTemplateFileName() {
        return null;
    }

    @Override
    protected int getTaskType() {
        return 5;
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        String dispStr = MessageResources.getInstance().getString(CLIENT, "SoftwareUpdatePanel.presentPackages");
        this.displayPackagesLbl.setText(dispStr);
        this.add((Component)this.displayPackagesLbl, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 10, 0), 0, 0));
        this.add((Component)this.packagePanel, new GridBagConstraints(0, 1, 2, 3, 1.0, 3.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.packagePanel.getViewport().add((Component)this.packageTable, null);
        this.packagePanel.getViewport().addMouseListener(new popupMenuListener());
        this.packageTable.setModel(this.tableModel);
        this.tableModel.setColumnNames(COL_NAMES);
        TableColumnModel columnModel = this.packageTable.getColumnModel();
        TableColumn versionColumn = columnModel.getColumn(2);
        JLegacyPkgVersionCellRender render = new JLegacyPkgVersionCellRender();
        versionColumn.setCellRenderer(render);
        this.tableModel.addTableModelListener(render);
        this.packageTable.setSelectionMode(0);
        this.packageTable.addMouseListener(new popupMenuListener());
        this.tableModel.addMouseListenerToHeaderInTable(this.packageTable);
        UIUtilities.setTableColumnWidth(this.packageTable, new float[]{0.15f, 0.35f, 0.1f, 0.3f, 0.1f}, (int)this.packageTable.getPreferredScrollableViewportSize().getWidth());
        TableColumn column = this.packageTable.getColumnModel().getColumn(4);
        column.setCellRenderer(new CheckBoxRenderer(false, false, true));
        this.popupMenu = this.getPopupMenu();
        this.packageTable.add(this.getPopupMenu());
    }

    protected void doUpdateCommonTaskText() {
    }

    @Override
    protected void doCommonTasks(String command) {
    }

    @Override
    public void setSelectedItem(Object item) {
        if (item == null) {
            return;
        }
        this.groupObj = (GroupObject)item;
        this.readOnly = this.groupObj.getAccessConstraint() == 2 || !AdminPrivilegeObject.isCurrentAdminHasFullAccessPackagePrivilege();
        this.addMenu.setEnabled(!this.readOnly);
        this.deleteMenu.setEnabled(!this.readOnly);
        try {
            this.listDeploymentEntityObj.clear();
            SemGroupPolicy groupPolicy = SoftwarePackageHandler.getGroupPolicy(this.groupObj);
            SoftwareDeploymentPolicy swDeploymentPolicy = SoftwarePackageHandler.getSoftwareDeploymentPolicy(groupPolicy);
            Vector<TableRow> data = new Vector<TableRow>();
            if (swDeploymentPolicy != null) {
                for (SoftwareDeploymentEntity entity : swDeploymentPolicy.getSoftwareDeploymentEntity()) {
                    long creationTime = entity.getCreationTime();
                    SoftwarePackage softwarePackage = null;
                    boolean isAvailable = true;
                    softwarePackage = SoftwarePackageHandler.getSoftwarePackageFromDeploymentEntity(entity, false);
                    if (softwarePackage == null || Utility.getBooleanValue((Boolean)softwarePackage.getOptSuspended(), (Boolean)false)) {
                        try {
                            softwarePackage = SoftwarePackageHandler.getSoftwarePackageFromSiteReplicaitonCache(entity);
                        }
                        catch (ConsoleException ex) {
                            ConsoleLogger.log("setSelectedItem:  cannot find the SoftwarePackage from replication cache, skip...");
                        }
                        isAvailable = false;
                    }
                    if (softwarePackage == null || Utility.getBooleanValue((Boolean)softwarePackage.getOptSuspended(), (Boolean)false)) continue;
                    if (GUIManager.isSoftwarePackageBroken(softwarePackage.getId())) {
                        isAvailable = false;
                    }
                    data.add(new PackageTableObject(softwarePackage, creationTime, isAvailable));
                    SoftwareDeploymentEntityObject entityObj = new SoftwareDeploymentEntityObject(entity, softwarePackage, isAvailable);
                    this.listDeploymentEntityObj.add(entityObj);
                }
            }
            this.tableModel.setDataVector(data);
            this.tableModel.fireTableDataChanged();
            if (this.packageTable.getRowCount() > 0) {
                this.packageTable.setRowSelectionInterval(0, 0);
            }
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSGRES.getString(CLIENT, "SoftwareUpdatePanel.consoleError"), 0);
            if (ex.needRelogin()) {
                Manager.getFrame().showLoginPanel();
            }
        }
        catch (Throwable ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    private SoftwareDeploymentEntityObject findEntityObject(String pkgId) {
        SoftwareDeploymentEntityObject entity = null;
        if (!this.listDeploymentEntityObj.isEmpty()) {
            for (int i = 0; i < this.listDeploymentEntityObj.size(); ++i) {
                SoftwareDeploymentEntityObject oneEntity = this.listDeploymentEntityObj.get(i);
                if (oneEntity == null) {
                    return null;
                }
                if (oneEntity.getSoftwarePackage().getId().compareToIgnoreCase(pkgId) != 0) continue;
                entity = oneEntity;
            }
        }
        return entity;
    }

    private SoftwareDeploymentEntityObject getSoftwareDeploymentEntityObject(int index) {
        String pkgobj = this.getCurrentSelectedPackageId(index);
        if (pkgobj == null) {
            return null;
        }
        SoftwareDeploymentEntityObject entity = this.findEntityObject(pkgobj);
        if (entity == null) {
            return null;
        }
        return entity;
    }

    private SoftwarePackage getSoftwarePackage(int index) {
        String pkgobj = this.getCurrentSelectedPackageId(index);
        if (pkgobj == null) {
            return null;
        }
        SoftwareDeploymentEntityObject entity = this.findEntityObject(pkgobj);
        if (entity == null) {
            return null;
        }
        return entity.getSoftwarePackage();
    }

    private SoftwareDeploymentEntity getSoftwareDeploymentEntity(int index) {
        String pkgobj = this.getCurrentSelectedPackageId(index);
        if (pkgobj == null) {
            return null;
        }
        SoftwareDeploymentEntityObject entity = this.findEntityObject(pkgobj);
        if (entity == null) {
            return null;
        }
        return entity.getSoftwareDeploymentEntity();
    }

    private ArrayList<String> getDeployedPackageIdList() {
        int size = this.listDeploymentEntityObj.size();
        ArrayList<String> list = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            SoftwareDeploymentEntityObject entity = this.listDeploymentEntityObj.get(i);
            list.add(entity.getSoftwarePackage().getId());
        }
        return list;
    }

    private void doDeploy() throws ConsoleException {
        if (!SoftwarePackageHandler.hasCurrentPackage()) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(CLIENT, "SoftwareUpdatePanel.createSoftwarePackageFirstMsg"), MSGRES.getString(CLIENT, "SoftwareUpdatePanel.error"), 0);
            return;
        }
        ArrayList<CurrentPackageObject> listUndeployedPackages = SoftwarePackageHandler.getUnAssignedCurrentSoftwarePackages(this.getDeployedPackageIdList());
        if (listUndeployedPackages == null || listUndeployedPackages.size() < 1) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MSGRES.getString(CLIENT, "SoftwareUpdatePanel.allAreDeployedMsg"), MSGRES.getString(CLIENT, "SoftwareUpdatePanel.warning"), 2);
            return;
        }
        DeployConfigurationDlg dlg = new DeployConfigurationDlg(listUndeployedPackages, this.groupObj);
        if (dlg.isOk()) {
            SoftwareDeploymentEntity entityNew = dlg.generateNewEntity();
            SoftwareDeploymentEntity entityDup = dlg.getDuplicatedEntity();
            SoftwareDeploymentPolicy policy = SoftwarePackageHandler.retrieveOrCreateSoftwareDeploymentPolicy(this.groupObj);
            if (policy == null) {
                Object[] obj = new Object[]{this.groupObj.getName()};
                String str = MSGRES.getString(CLIENT, "SoftwareUpdatePanel.failedRetriveOrCreatePolicyUnderGroup0Msg");
                String fm = MessageFormat.format(str, obj);
                JOptionPane.showMessageDialog(Manager.getFrame(), fm, MSGRES.getString(CLIENT, "SoftwareUpdatePanel.error"), 0);
                return;
            }
            if (entityDup != null) {
                SoftwarePackageHandler.deleteSoftwareDeploymentEntity(policy, entityDup);
            }
            SoftwarePackageHandler.addSoftwareDeploymentEntity(policy, entityNew);
            ConsoleLogger.logAdminEvent(12296);
        }
        dlg.dispose();
        this.refresh();
        int lastRowIndex = this.packageTable.getRowCount() - 1;
        if (lastRowIndex > 0) {
            this.packageTable.setRowSelectionInterval(lastRowIndex, lastRowIndex);
        }
    }

    private void doEdit(int index) throws ConsoleException {
        SoftwareDeploymentEntityObject entityObj = this.getSoftwareDeploymentEntityObject(index);
        if (entityObj == null) {
            return;
        }
        if (!entityObj.isSoftwarePackageAvailable()) {
            UIUtilities.showErrorDialog(MSGRES.getString(CLIENT, "SoftwareUpdatePanel.softwarePackageNotAvailable"));
            return;
        }
        DeployConfigurationDlg dlg = new DeployConfigurationDlg(entityObj, this.groupObj);
        if (!dlg.isOk()) {
            return;
        }
        dlg.modifyExistingEntity(entityObj);
        SoftwarePackageHandler.updateSoftwareDeploymentEntity(entityObj.getSoftwareDeploymentEntity());
        ConsoleLogger.logAdminEvent(12298);
        dlg.dispose();
        this.getTable().setRowSelectionInterval(index, index);
    }

    private void doDelete(int index) throws ConsoleException {
        if (this.groupObj.getAccessConstraint() == 2) {
            Object[] obj = new Object[]{this.groupObj.getName()};
            String str = MSGRES.getString(CLIENT, "SoftwareUpdatePanel.cantDeleteDeploymentPackage");
            String fm = MessageFormat.format(str, obj);
            JOptionPane.showMessageDialog(Manager.getFrame(), fm, MSGRES.getString(CLIENT, "SoftwareUpdatePanel.error"), 0);
            return;
        }
        SoftwarePackage sp = this.getSoftwarePackage(index);
        if (sp == null) {
            ConsoleLogger.log("SoftwareUpdatePanel>> doDelete: Error-> SoftwarePackage is null!! index=" + index);
            return;
        }
        Object[] obj = new Object[]{sp.getName()};
        String str = MSGRES.getString(CLIENT, "SoftwareUpdatePanel.wantToDeleteDeploymentForPackage0Msg");
        String fm = MessageFormat.format(str, obj);
        MultiLineLabel multiL = new MultiLineLabel(fm);
        if (0 != JOptionPane.showConfirmDialog(Manager.getFrame(), multiL, MSGRES.getString(CLIENT, "SoftwareUpdatePanel.deleteDeploymentMsg"), 0)) {
            return;
        }
        ConsoleLogger.log("SoftwareUpdatePanel>> doDelete: index=" + index + ", package=" + sp.getName() + ", group=" + this.groupObj.getName());
        SoftwareDeploymentEntity entity = this.getSoftwareDeploymentEntity(index);
        SoftwarePackageHandler.deleteSoftwareDeploymentEntity(this.groupObj, entity);
        ConsoleLogger.logAdminEvent(12297);
        this.refresh();
    }

    private boolean containMultipleWindowsPackageVersion(TableModel tm) {
        if (tm instanceof SortableTableModel) {
            SortableTableModel model = (SortableTableModel)tm;
            Vector data = (Vector)Cast.cast(model.getDataVector());
            int legacyWinPkgNum = 0;
            int pkgNum = 0;
            for (PackageTableObject pkgObj : data) {
                if (pkgObj.isMacPkg()) continue;
                if (pkgObj.isLegacyWindowsPkg()) {
                    ++legacyWinPkgNum;
                } else {
                    ++pkgNum;
                }
                if (legacyWinPkgNum <= 0 || pkgNum <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public JTable getTable() {
        return this.packageTable;
    }

    @Override
    public void addTableSelectionListener(ListSelectionListener listener) {
        this.getTable().getSelectionModel().addListSelectionListener(listener);
    }

    @Override
    public int getTableSelectedItem() {
        switch (this.getTable().getSelectedRow()) {
            case -1: {
                return 5;
            }
        }
        return 7;
    }

    public String getCurrentSelectedPackageId(int rowSelected) {
        SoftwarePackage pkg;
        String pkgId = null;
        if (rowSelected < 0) {
            return null;
        }
        PackageTableObject obj = (PackageTableObject)this.tableModel.getRow(rowSelected);
        if (obj != null && (pkg = obj.getSoftwarePackage()) != null) {
            pkgId = pkg.getId();
        }
        return pkgId;
    }

    private static class PackageTableObject
    implements TableRow {
        private SoftwarePackage sp;
        private boolean isAvailable;
        private long time;

        public PackageTableObject(SoftwarePackage sp, long time, boolean isAvailable) {
            this.sp = sp;
            this.time = time;
            this.isAvailable = isAvailable;
        }

        public boolean isLegacyWindowsPkg() {
            return AutoUpgradeUtils.isLegacyWindowsPackageForAutoUpgrade((SoftwarePackage)this.sp);
        }

        public boolean isMacPkg() {
            return AutoUpgradeUtils.isMacSoftwarePackage((SoftwarePackage)this.sp);
        }

        @Override
        public void setValueAt(Object value, int index) {
        }

        public SoftwarePackage getSoftwarePackage() {
            return this.sp;
        }

        @Override
        public Object getValueAt(int index) {
            switch (index) {
                case 0: {
                    return this.sp.getName();
                }
                case 1: {
                    return SoftwarePackageObject.getTypeDisplayString(this.sp.getPackageInfo().getType());
                }
                case 2: {
                    return this.sp.getPackageInfo().getVersion();
                }
                case 3: {
                    return Utility.getLongDateTimeString((long)this.time, null);
                }
                case 4: {
                    return this.isAvailable;
                }
            }
            return null;
        }

        @Override
        public Class<?> getValueTypeAt(int index) {
            switch (index) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
                case 3: {
                    return Date.class;
                }
                case 4: {
                    return Boolean.class;
                }
            }
            return null;
        }
    }

    private class JLegacyPkgVersionCellRender
    extends JLabel
    implements TableCellRenderer,
    TableModelListener {
        private static final long serialVersionUID = 1L;
        private boolean isMultiplePkgVersion = false;

        private JLegacyPkgVersionCellRender() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            this.setHorizontalTextPosition(10);
            if (value == null) {
                this.setText("");
                return this;
            }
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            if (value instanceof String) {
                this.setText((String)value);
            } else {
                this.setText("");
            }
            TableModel tm = table.getModel();
            if (tm instanceof SortableTableModel) {
                SortableTableModel stm = (SortableTableModel)tm;
                Vector data = (Vector)Cast.cast(stm.getDataVector());
                PackageTableObject pto = (PackageTableObject)data.get(row);
                pto.isLegacyWindowsPkg();
            }
            this.setIcon(null);
            return this;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            TableModel tm = (TableModel)e.getSource();
            this.isMultiplePkgVersion = SoftwareUpdatePanel.this.containMultipleWindowsPackageVersion(tm);
        }
    }

    private class popupMenuListener
    extends MouseAdapter {
        private popupMenuListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1) {
                if (e.getClickCount() == 2) {
                    try {
                        if (SoftwareUpdatePanel.this.packageTable.getSelectedRowCount() > 0) {
                            SoftwareUpdatePanel.this.doEdit(SoftwareUpdatePanel.this.packageTable.getSelectedRow());
                        }
                    }
                    catch (ConsoleException ex) {
                        JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSGRES.getString(SoftwareUpdatePanel.CLIENT, "SoftwareUpdatePanel.consoleError"), 0);
                        if (ex.needRelogin()) {
                            Manager.getFrame().showLoginPanel();
                        }
                    }
                }
            } else {
                int row = SoftwareUpdatePanel.this.packageTable.rowAtPoint(e.getPoint());
                if (row >= 0) {
                    SoftwareUpdatePanel.this.packageTable.setRowSelectionInterval(row, row);
                }
                SoftwareUpdatePanel.this.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
                SoftwareUpdatePanel.this.validatePopup();
            }
        }
    }
}

