/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client;

import com.sygate.scm.console.logicobject.CurrentPackageObject;
import com.sygate.scm.console.ui.client.networkaudit.RemotePushComputerObject;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.util.Utility;

public class RemoteDeploymentHelper {
    private static final String[] LEGACY_OS_TYPES = new String[]{"Windows 2000", "Windows XP", "Windows 2003"};
    private static final String[] LEGACY_OS_SPS = new String[]{"Service Pack 3", "Service Pack 2", "Service Pack 1"};

    public static boolean isLegacyOS(RemotePushComputerObject entry, String pkgVersion) {
        boolean isLegacy;
        block4: {
            String platform;
            String sp;
            String os;
            block3: {
                isLegacy = false;
                os = entry.getDescription();
                sp = entry.getServicePack();
                platform = entry.getPlatformType();
                if (os.contains("Windows 2000")) {
                    return true;
                }
                if (pkgVersion == null || Utility.compareVersion((String)pkgVersion, (String)"14.0.0.0") < 0) break block3;
                for (int i = 0; i < LEGACY_OS_TYPES.length; ++i) {
                    if (!os.startsWith(LEGACY_OS_TYPES[i])) continue;
                    isLegacy = true;
                }
                break block4;
            }
            if (!"WIN32".equalsIgnoreCase(platform)) break block4;
            for (int i = 0; i < LEGACY_OS_TYPES.length; ++i) {
                if (!os.startsWith(LEGACY_OS_TYPES[i]) || sp != null && sp.trim().length() != 0 && !RemoteDeploymentHelper.legacyServicepack(sp, LEGACY_OS_SPS[i])) continue;
                isLegacy = true;
            }
        }
        return isLegacy;
    }

    static boolean legacyServicepack(String target, String standard) {
        String sp;
        int idx1;
        boolean isLegacy = false;
        int idx = target.indexOf("Service Pack");
        if (idx < 0) {
            return true;
        }
        if (idx != 0) {
            target = target.substring(idx);
        }
        if ((idx1 = (sp = target.replace("Service Pack", "").trim()).indexOf(" ")) > 0) {
            sp = sp.substring(0, idx1).trim();
        }
        String sp2 = standard.replace("Service Pack", "").trim();
        if (sp == null || sp.length() < 1) {
            return true;
        }
        if (Utility.compareVersion((String)sp, (String)sp2) < 0) {
            isLegacy = true;
        }
        return isLegacy;
    }

    public static boolean isLatestVersionAlreadyInstalled(CurrentPackageObject packageObj, RemotePushComputerObject entry) {
        boolean isLatest = false;
        String sepVersion = entry.getSepVersion();
        try {
            String pkgVersion;
            if (entry.isSEPInstalled() && sepVersion != null && sepVersion.length() > 0 && Utility.compareVersion((String)sepVersion, (String)(pkgVersion = packageObj.getSoftwarePackageObject().getVersion(true))) >= 0) {
                isLatest = true;
            }
        }
        catch (Exception e) {
            ConsoleLogger.log("isLatestVersionAlreadyInstalled: Error while comparing version of installed sep with package version");
            ConsoleLogger.log(e);
        }
        return isLatest;
    }
}

