/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.SoftwarePackageHandler;
import com.sygate.scm.console.logicobject.RecycleBinObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;

public class RecycleBinTablePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    JScrollPane packagePanel = new JScrollPane();
    private static final String[] COL_NAMES = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "RecycleBinTablePanel.packageNameCName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "RecycleBinTablePanel.descriptionCName")};
    private SortableTableModel model = new SortableTableModel();
    JTable packageTable = new StripesTable();
    private JMenuItem restoreMenuItem = new JMenuItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "RecycleBinTablePanel.restoreMenu"));
    private JMenuItem deleteMenuItem = new JMenuItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "RecycleBinTablePanel.deleteMenu"));
    private JPopupMenu popup = new JPopupMenu();

    public RecycleBinTablePanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.add((Component)this.packagePanel, "Center");
        this.packagePanel.getViewport().add((Component)this.packageTable, null);
        this.model.setColumnNames(COL_NAMES);
        this.model.setEditMode(false);
        this.packageTable.setModel(this.model);
        this.model.addMouseListenerToHeaderInTable(this.packageTable);
        this.packageTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                int[] rows = RecycleBinTablePanel.this.packageTable.getSelectedRows();
                if (rows == null || rows.length == 0) {
                    rows = new int[]{RecycleBinTablePanel.this.packageTable.rowAtPoint(new Point(e.getX(), e.getY()))};
                    RecycleBinTablePanel.this.packageTable.changeSelection(rows[0], 0, false, false);
                }
                if (rows == null || rows.length == 0) {
                    return;
                }
                if (!e.isPopupTrigger()) {
                    RecycleBinTablePanel.this.restoreMenuItem.setEnabled(false);
                    RecycleBinTablePanel.this.deleteMenuItem.setEnabled(false);
                    return;
                }
                RecycleBinTablePanel.this.restoreMenuItem.setEnabled(true);
                RecycleBinTablePanel.this.deleteMenuItem.setEnabled(true);
                RecycleBinTablePanel.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
        this.setupPopupMenu();
    }

    private void setupPopupMenu() {
        this.restoreMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecycleBinTablePanel.this.restoreMenuItemActionPerformed(e);
            }
        });
        this.popup.add(this.restoreMenuItem);
        this.deleteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecycleBinTablePanel.this.deleteMenuItemActionPerformed(e);
            }
        });
        this.popup.add(this.deleteMenuItem);
    }

    private void setupTable() {
        block4: {
            int len = this.model.getRowCount();
            for (int i = len - 1; i >= 0; --i) {
                this.model.removeRow(i);
            }
            try {
                ArrayList<RecycleBinObject> vPackage = SoftwarePackageHandler.getRecycleBinPackages();
                len = vPackage.size();
                for (int i = 0; i < len; ++i) {
                    RecycleBinObject co = vPackage.get(i);
                    this.model.addRow(co);
                }
            }
            catch (ConsoleException e) {
                JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "RecycleBinTablePanel.consoleError"), 0);
                if (!e.needRelogin()) break block4;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    public void refresh(Object item) {
        this.setupTable();
    }

    private void restoreMenuItemActionPerformed(ActionEvent e) {
        this.doRestore();
    }

    public void doRestore() {
        block4: {
            int[] rows = this.packageTable.getSelectedRows();
            if (rows == null || rows.length == 0) {
                String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "RecycleBinTablePanel.selectPackageMsg");
                JOptionPane.showMessageDialog(Manager.getFrame(), msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "RecycleBinTablePanel.error"), 0);
                return;
            }
            try {
                for (int i = 0; i < rows.length; ++i) {
                    TableRow tableRow = this.model.getRow(rows[i]);
                    SoftwarePackageHandler.movePackage((RecycleBinObject)tableRow);
                }
                this.setupTable();
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "RecycleBinTablePanel.consoleError"), 0);
                if (!ex.needRelogin()) break block4;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    private void deleteMenuItemActionPerformed(ActionEvent e) {
        this.doDelete();
    }

    public void doDelete() {
        block5: {
            int[] rows = this.packageTable.getSelectedRows();
            if (rows == null || rows.length == 0) {
                String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "RecycleBinTablePanel.selectPackageMsg");
                JOptionPane.showMessageDialog(Manager.getFrame(), msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "RecycleBinTablePanel.error"), 0);
                return;
            }
            try {
                int size = rows.length;
                Object[] obj = new Object[]{Integer.toString(size)};
                String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "RecycleBinTablePanel.doYouWantToDelete0PackageMsg");
                String fm = MessageFormat.format(str, obj);
                if (0 != JOptionPane.showConfirmDialog(Manager.getFrame(), fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "RecycleBinTablePanel.warning"), 0)) {
                    return;
                }
                for (int i = 0; i < size; ++i) {
                    TableRow tableRow = this.model.getRow(rows[i]);
                    RecycleBinObject rbo = (RecycleBinObject)tableRow;
                    SoftwarePackageHandler.delPackage(rbo);
                }
                this.setupTable();
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "RecycleBinTablePanel.consoleError"), 0);
                if (!ex.needRelogin()) break block5;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    void setListSelectionListener(ListSelectionListener listener) {
        ListSelectionModel selectionModel = this.packageTable.getSelectionModel();
        selectionModel.addListSelectionListener(listener);
    }

    boolean isPackageSelected() {
        return this.packageTable.getSelectedRow() > -1;
    }
}

