/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.ui.client.ClientRightPanel;
import com.sygate.scm.console.ui.client.HtmlPanel;
import com.sygate.scm.console.ui.client.RecycleBinTablePanel;
import com.sygate.scm.console.ui.util.SideBar;
import com.sygate.scm.console.ui.util.TaskObject;
import com.sygate.scm.console.ui.util.TaskPanelBase;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionListener;

public class RecycleBinPanel
extends ClientRightPanel {
    private static final long serialVersionUID = 1L;
    private static final int RESTORE_PACKAGE = 1;
    private static final int DELETE_PACKAGE = 2;
    RecycleBinTablePanel tablePanel = new RecycleBinTablePanel();
    HtmlPanel titlePane = null;
    private List<TaskObject> packageSelectedList;
    private RecycleBinTaskPane rightPanel = new RecycleBinTaskPane();

    public RecycleBinPanel(ListSelectionListener tableListener) {
        try {
            this.jbInit();
            this.tablePanel.setListSelectionListener(tableListener);
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
        }
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_pane_install_packages_recycle_bin";
    }

    @Override
    protected int getTaskType() {
        return -1;
    }

    protected void initTitlePane() {
        String titleTemplateName = "template_packagerecyclebin_title.htm";
        this.titlePane = new HtmlPanel(titleTemplateName);
        this.titlePane.updateText();
    }

    protected void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.setBorder(new JScrollPane().getBorder());
        JPanel panelMain = new JPanel();
        panelMain.setLayout(new BorderLayout());
        panelMain.add((Component)this.rightPanel, "Center");
        this.add((Component)panelMain, "Center");
    }

    public List<List<TaskObject>> getTaskList(TreeItem item) {
        ArrayList<List<TaskObject>> currentTaskList = new ArrayList<List<TaskObject>>();
        if (this.tablePanel.isPackageSelected()) {
            if (this.packageSelectedList == null) {
                Icon action = SideBar.getActionIcon();
                this.packageSelectedList = new ArrayList<TaskObject>();
                this.packageSelectedList.add(new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "RecycleBinPanel.restore"), 1, action));
                this.packageSelectedList.add(new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "RecycleBinPanel.delete"), 2, action));
            }
            currentTaskList.add(this.packageSelectedList);
        } else {
            currentTaskList.add(new ArrayList());
        }
        return currentTaskList;
    }

    @Override
    public void executeTask(int taskIndex, Object userObject) {
        RecycleBinTablePanel panel = this.getRecycleBinTablePanel();
        switch (taskIndex) {
            case 1: {
                panel.doRestore();
                break;
            }
            case 2: {
                panel.doDelete();
                break;
            }
        }
    }

    @Override
    protected String getHtmlTemplateFileName() {
        return "template_packagerecyclebin_commontask.htm";
    }

    @Override
    public void setSelectedItem(Object item) {
        if (item == null) {
            return;
        }
        this.tablePanel.refresh(item);
    }

    public RecycleBinTablePanel getRecycleBinTablePanel() {
        return this.tablePanel;
    }

    private class RecycleBinTaskPane
    extends TaskPanelBase {
        private static final long serialVersionUID = 1L;

        RecycleBinTaskPane() {
            this.initialize();
        }

        @Override
        protected Component getContentPanel() {
            return RecycleBinPanel.this.tablePanel;
        }

        protected String getTitleIconName() {
            return "recycle_bin_24.gif";
        }

        @Override
        protected String getTitleName() {
            return "Recycle Bin";
        }
    }
}

