/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.ui.client.ClientRightPanel;
import com.sygate.scm.console.ui.policy.HistoryPane;
import com.sygate.scm.console.ui.policy.PolicySummaryPane;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;

public class PolicyDeploymentPanel
extends ClientRightPanel {
    private static final long serialVersionUID = 1L;
    private PolicySummaryPane sumPane;
    private HistoryPane hisPane;

    public PolicyDeploymentPanel() {
        this.initialize();
    }

    @Override
    public void setSelectedItem(Object item) {
        if (item == null) {
            return;
        }
        GroupObject grpObj = (GroupObject)item;
        try {
            GroupPolicyObject aPObj = PolicyHandler.getGroupPolicyByGroupFromDB(grpObj);
            this.sumPane.setObject(aPObj);
            this.hisPane.setObject(aPObj.getGroupPolicyHistoryCheckId());
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    @Override
    public void executeTask(int taskIndex, Object userObject) {
        try {
            if (taskIndex == 0) {
                this.sumPane.addLocation();
            } else if (taskIndex == 3) {
                this.sumPane.editLocations();
            } else if (taskIndex == 19) {
                this.getClientPane().doCopyPolicy();
            } else if (taskIndex == 20) {
                this.getClientPane().doPastePolicy();
            } else if (taskIndex == 9) {
                this.getClientPane().doAddGroup();
            } else if (taskIndex == 45) {
                this.getClientPane().doExportSylink();
            } else if (taskIndex == 46) {
                this.getClientPane().doEditProps();
            } else if (taskIndex == 47) {
                this.getClientPane().doDeleteGroup();
            }
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PolicyDeploymentPanel.consoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_compusers_pane_policies";
    }

    @Override
    protected String getHtmlTemplateFileName() {
        return null;
    }

    @Override
    protected int getTaskType() {
        return 3;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getInnerPanel(), "Center");
    }

    private JSplitPane getInnerPanel() {
        JSplitPane pane = new JSplitPane(0);
        pane.setBorder(null);
        pane.setDividerLocation(1.0);
        pane.setResizeWeight(0.89);
        this.hisPane = new HistoryPane();
        this.sumPane = new PolicySummaryPane(this.hisPane);
        pane.add((Component)this.sumPane, "top");
        pane.add((Component)this.hisPane, "bottom");
        Dimension dimension = this.sumPane.getMaximumSize();
        dimension.height = (int)((double)dimension.height * 0.8);
        this.sumPane.setPreferredSize(dimension);
        return pane;
    }
}

