/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.PackageInfo;
import com.sygate.scm.common.configobject.schema.PhysicalFile;
import com.sygate.scm.common.configobject.schema.PresharedSecret;
import com.sygate.scm.common.configobject.schema.SemAgentPolicy;
import com.sygate.scm.common.configobject.schema.SemClientGroup;
import com.sygate.scm.common.configobject.schema.SemConfigRoot;
import com.sygate.scm.common.configobject.schema.SemServerList;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.common.configobject.schema.SemSiteArray;
import com.sygate.scm.common.configobject.schema.ServerCertificate;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.AjaxSwingManager;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.handler.SoftwarePackageHandler;
import com.sygate.scm.console.handler.WhiteListHandler;
import com.sygate.scm.console.logicobject.CommunicationObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.logicobject.ServerListObject;
import com.sygate.scm.console.logicobject.SoftwarePackageObject;
import com.sygate.scm.console.logicobject.WhiteListObject;
import com.sygate.scm.console.ui.client.ExportLinuxPackageWorker;
import com.sygate.scm.console.ui.client.ExportMacPackageWorker;
import com.sygate.scm.console.ui.client.PackageProgressListener;
import com.sygate.scm.console.ui.client.PackageworkerErrorState;
import com.sygate.scm.console.ui.client.TextPackageProgressListener;
import com.sygate.scm.console.ui.client.dlg.ExportFolderChooser;
import com.sygate.scm.console.ui.client.dlg.InProgressDlg;
import com.sygate.scm.console.ui.util.MultiLineMsgBox;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.Env;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.console.util.NativeCommandUtilities;
import com.sygate.scm.console.util.ScmProperties;
import com.sygate.scm.util.ConstantValue;
import com.sygate.scm.util.IOUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.PackageUtil;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.SwingWorker;
import com.sygate.scm.util.TimeCounter;
import com.sygate.scm.util.Utility;
import com.sygate.scm.util.XmlParser;
import com.sygate.scm.util.ZipUtil;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.swing.JDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class PackageWorker
extends SwingWorker
implements WindowListener {
    private static final char TILDE_CHAR = '~';
    private static final String TILDE_STRING = "~";
    public static final String SINGLE_EXE_FILE_NAME = "setup.exe";
    public static final String SINGLE_ZIP_FILE_NAME = "setup.zip";
    public static final String TEMP_PROFILE_FILE = "temp_profile.xml";
    public static final String TEMP_IDS_FILE = "temp_ids.xml";
    public static final String CONFIG_XML = "sylink.xml";
    public static final String SET_AID = "setAid.ini";
    private static final String INVALID_PACKAGE_MSG = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.invalidPackageMsg");
    protected static final int MAX_SELECTED_DIR_PATH_FOR_EXPORT = 80;
    private static Logger logger = Logger.getLogger(PackageWorker.class.getName());
    boolean needRelogin = false;
    boolean doExport = false;
    private boolean displayExportBtn = false;
    protected boolean isCreateExe = false;
    protected int agentMode = 1;
    protected String clientExportZipFilePath = null;
    private PackageworkerErrorState state;
    private final Set<String> lstFilesToCleanOnExit = new HashSet<String>();
    boolean isAllDone = false;
    String finishMsg = "";
    private String msgboxTitle = "";
    TimeCounter counter = new TimeCounter();
    protected PackageProgressListener progressListener = null;
    String dlgTitle = "";
    private static String invalidDir = null;

    public void setAgentMode(int mode) {
        this.agentMode = mode;
    }

    public int getAgentMode() {
        return this.agentMode;
    }

    public boolean needRelogin() {
        return this.needRelogin;
    }

    public boolean isAllDone() {
        return this.isAllDone;
    }

    protected String getTimeCounterDisplayString() {
        return this.counter.getDuration() + " (" + this.counter.getDuration() / 1000L + "s)";
    }

    protected void addFileToCleanUpList(String path) {
        File file;
        if (path != null && path.trim().length() > 0 && (file = new File(path)).exists() && file.isFile()) {
            this.lstFilesToCleanOnExit.add(path);
        }
    }

    private void cleanAllTempFilesOnExit() {
        for (String path : this.lstFilesToCleanOnExit) {
            Utility.deleteFile((String)path);
        }
    }

    protected void setDlgTitle(String title) {
        this.dlgTitle = title;
    }

    protected void createDlg(SwingWorker worker, String title, String msg) {
        if (this.progressListener == null) {
            this.progressListener = new InProgressDlg((Frame)Manager.getFrame(), true);
            if (this.progressListener instanceof InProgressDlg) {
                ((InProgressDlg)this.progressListener).init(worker, title, msg, this);
            }
        }
    }

    public boolean isCancelled() {
        if (this.progressListener != null) {
            return this.progressListener.isCancelled();
        }
        return false;
    }

    public void setFinishMsg(String finishMsg) {
        this.finishMsg = finishMsg;
    }

    protected void setMsgBoxTitle(String title) {
        this.msgboxTitle = title;
    }

    protected void showMsgBox(String msg, boolean error) {
        if (this.progressListener instanceof Component) {
            MultiLineMsgBox box = new MultiLineMsgBox((Component)((Object)this.progressListener), this.msgboxTitle);
            box.init(msg, 55, error ? 0 : 1, -1);
            AjaxSwingCommonUtil.updateSwingAgentBrowser((boolean)true);
            box.show();
        } else {
            this.setState(new PackageworkerErrorState(this.msgboxTitle, msg, error));
        }
    }

    protected void showExportPackageButton(boolean show) {
        this.setExportVisible(show);
    }

    public void finished() {
        System.out.println("Done PackageWorker!");
        if (this.progressListener != null) {
            this.progressListener.showFinished(this.isAllDone, this.finishMsg);
        }
    }

    public Object construct() {
        this.isAllDone = false;
        try {
            this.isAllDone = this.doWork();
        }
        catch (Throwable ex) {
            System.out.println("PackageWorker>> construct: Throwable..." + ex.getLocalizedMessage());
            LoggerUtilities.logException((Throwable)ex);
            this.showMsgBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.unexpectedErrorInMiddleOfPackageWorkerMsg"), true);
        }
        finally {
            this.cleanAllTempFilesOnExit();
            if (!this.isAllDone) {
                this.cleanup();
            }
        }
        System.out.println("PackageWorker>> construct: Done!");
        return null;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        System.out.println("PackageWorker>> construct: X button is clicked!");
        this.cancelInProgressDlg();
    }

    private void cancelInProgressDlg() {
        this.progressListener.stopInMiddle();
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    public boolean begin() {
        block8: {
            this.createDlg(this, this.dlgTitle, "");
            this.start();
            if (this.progressListener instanceof JDialog) {
                ((JDialog)((Object)this.progressListener)).setVisible(true);
            } else if (this.progressListener instanceof TextPackageProgressListener) {
                this.get();
            }
            System.out.println("PackageWorker>> after dlg, isAllDone=" + this.isAllDone);
            if (!this.isCancelled()) break block8;
            this.interrupt();
            System.out.println("PackageWorker>> cancelled!");
            this.afterCancellation();
            boolean bl = false;
            return bl;
        }
        try {
            this.afterWork();
        }
        catch (Throwable ex) {
            System.out.println("PackageWorker>> begin: Throwable...");
            LoggerUtilities.logException((Throwable)ex);
            this.showMsgBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.unexpectedErrorInPackageWorkerMsg"), true);
        }
        return true;
    }

    protected void afterCancellation() {
        this.showMsgBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.actionCancelledMsg"), true);
        if (!this.isAllDone) {
            this.cleanup();
        }
    }

    protected abstract boolean doWork() throws ConsoleException;

    protected abstract void afterWork();

    protected void cleanup() {
    }

    protected boolean createExportDir(String fullExportDir) {
        int result = PackageWorker.createDir(fullExportDir);
        if (result != 0) {
            System.out.println("PackageWorker>> createExportDir: Error-> code=" + result + "; Failed to create " + invalidDir + ", source=" + fullExportDir);
            return false;
        }
        return true;
    }

    public static String generateExportFullPathForGroup(SoftwarePackageObject packageObj, String exportRootDir, GroupObject groupObj, String osForExport) {
        return PackageWorker.getGroupPathForExport(packageObj, exportRootDir, groupObj.getSemClientGroup(), osForExport);
    }

    public static String generateExportFullPathForDefault(SoftwarePackageObject packageObj, String exportRootDir, String osForExport) {
        return PackageWorker.getGroupPathForExport(packageObj, exportRootDir, null, osForExport);
    }

    protected SemServerList getDefaultServerList() {
        SemServerList serverList;
        block2: {
            serverList = null;
            try {
                serverList = GUIManager.getDefaultServerList();
            }
            catch (Throwable ex) {
                System.out.println("PackageWorker>> getDefaultServerList: Error-> failed to get default server list!");
                LoggerUtilities.logException((Throwable)ex);
                this.showMsgBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.failedToRetrieveDefaultPolicyListMsg"), true);
                if (!(ex instanceof ConsoleException) || ((ConsoleException)ex).getErrorCode() != 0x11010000) break block2;
                this.needRelogin = true;
            }
        }
        return serverList;
    }

    protected boolean modifyConfigXmlForExportUnmanaged(String exportPath) {
        boolean alwaysConnect = false;
        String xml = exportPath + File.separator + CONFIG_XML;
        XmlParser parser = new XmlParser();
        Document doc = null;
        if (new File(xml).exists()) {
            if (!parser.readXmlFile(xml)) {
                Object[] obj = new Object[]{CONFIG_XML, exportPath};
                String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.faileedToRead0Under1");
                String fm = MessageFormat.format(str, obj);
                ConsoleLogger.log(fm);
                this.showMsgBox(INVALID_PACKAGE_MSG, true);
                return false;
            }
            doc = parser.getDocument();
        } else {
            doc = parser.newDocument();
        }
        Element elementServerSettings = PackageUtil.modifyServerSettings((Document)doc, (String)Manager.getCurrentDomainId());
        Element elementCommConf = PackageUtil.modifyCommConf((Document)doc, (Element)elementServerSettings);
        PackageUtil.modifyRegisterClient((Document)doc, (Element)elementCommConf, null, (int)this.agentMode);
        try {
            PackageUtil.modifyAgentCommunicationSetting((Document)doc, (boolean)alwaysConnect, (PresharedSecret)DataobjectManager.getInstance().getSemConfigRoot().getOptPresharedSecret(), (Element)elementCommConf);
        }
        catch (Exception ex) {
            ConsoleLogger.log(ex.getMessage());
        }
        this.removeSeverList(elementCommConf);
        this.removeServerCertList(elementCommConf);
        if (!parser.saveXml(xml)) {
            Object[] obj = new Object[]{CONFIG_XML, exportPath};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.failedToSave0Under1Msg");
            String fm = MessageFormat.format(str, obj);
            this.showMsgBox(fm, true);
            return false;
        }
        System.out.println("PackageWorker>> modifySylink: Done! xml=" + xml);
        return true;
    }

    private void removeServerCertList(Element elementCommConf) {
        ArrayList<String> listPath = new ArrayList<String>();
        listPath.add("ServerCertList");
        Element elementServerCertList = XmlParser.getChildElementByPath(listPath, (Element)elementCommConf);
        if (elementServerCertList != null) {
            elementCommConf.removeChild(elementServerCertList);
        }
    }

    private void removeSeverList(Element elementCommConf) {
        ArrayList<String> listPath = new ArrayList<String>();
        listPath.add("ServerList");
        Element elementServerList = XmlParser.getChildElementByPath(listPath, (Element)elementCommConf);
        if (elementServerList != null) {
            elementCommConf.removeChild(elementServerList);
        }
    }

    protected boolean modifyConfigXml(SemServerList serverList, String preferredGroup, String exportPath, boolean alwaysConnect) {
        if (serverList == null || serverList.getSemServerBlockCount() < 1) {
            System.out.println("PackageWorker>> modifyConfigXml: Error-> serverList is invalid!");
            this.showMsgBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.policyListInvalidMsg"), true);
            return false;
        }
        String xml = exportPath + File.separator + CONFIG_XML;
        XmlParser parser = new XmlParser();
        Document doc = null;
        if (new File(xml).exists()) {
            if (!parser.readXmlFile(xml)) {
                Object[] obj = new Object[]{CONFIG_XML, exportPath};
                String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.faileedToRead0Under1");
                String fm = MessageFormat.format(str, obj);
                ConsoleLogger.log(fm);
                this.showMsgBox(INVALID_PACKAGE_MSG, true);
                return false;
            }
            doc = parser.getDocument();
        } else {
            doc = parser.newDocument();
        }
        Element elementServerSettings = PackageUtil.modifyServerSettings((Document)doc, (String)Manager.getCurrentDomainId());
        Element elementCommConf = PackageUtil.modifyCommConf((Document)doc, (Element)elementServerSettings);
        PackageUtil.modifyRegisterClient((Document)doc, (Element)elementCommConf, (String)preferredGroup, (int)this.agentMode);
        try {
            PackageUtil.modifyAgentCommunicationSetting((Document)doc, (boolean)alwaysConnect, (PresharedSecret)DataobjectManager.getInstance().getSemConfigRoot().getOptPresharedSecret(), (Element)elementCommConf);
        }
        catch (Exception ex) {
            ConsoleLogger.log(ex.getMessage());
        }
        PackageUtil.modifyServerList((Document)doc, (SemServerList)serverList, null, (Element)elementCommConf, (String)String.valueOf(ScmProperties.getWebServerPort()));
        try {
            PackageUtil.modifyServerCertList((Document)doc, this.getAllSites(), (Element)elementCommConf);
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
        }
        if (!parser.saveXml(xml)) {
            Object[] obj = new Object[]{CONFIG_XML, exportPath};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.failedToSave0Under1Msg");
            String fm = MessageFormat.format(str, obj);
            this.showMsgBox(fm, true);
            return false;
        }
        System.out.println("PackageWorker>> modifySylink: Done! xml=" + xml);
        return true;
    }

    protected ArrayList<SemSite> getAllSites() throws ConsoleException {
        SemConfigRoot configRoot = DataobjectManager.getInstance().getSemConfigRoot();
        SemSiteArray siteArray = configRoot.getSemSiteArray();
        ArrayList<SemSite> sites = new ArrayList<SemSite>();
        int objCount = siteArray.getObjReferenceCount();
        for (int objIndex = 0; objIndex < objCount; ++objIndex) {
            ObjReference objRef = siteArray.getObjReference(objIndex);
            if (!objRef.getTargetType().equals("SemSite")) continue;
            String siteId = objRef.getTargetId();
            sites.add(DataobjectManager.getInstance().getSemSite(siteId));
        }
        return sites;
    }

    protected Boolean needSignatureVerification(GroupPolicyObject groupPolicy) {
        ServerCertificate serverCert;
        SemAgentPolicy agentPolicy;
        Boolean signatureVerification = null;
        if (groupPolicy != null && (agentPolicy = groupPolicy.getSemAgentPolicyObject()) != null && (serverCert = agentPolicy.getOptServerCertificate()) != null && (signatureVerification = serverCert.getOptEnableSignatureValidation()) == null) {
            signatureVerification = serverCert.getDefEnableSignatureValidation();
        }
        return signatureVerification;
    }

    protected boolean modifyConfigXmlEx(SemServerList serverList, String preferredGroup, String exportPath, boolean alwaysConnect, GroupPolicyObject groupPolicy) throws Exception {
        if (serverList == null || serverList.getSemServerBlockCount() < 1) {
            System.out.println("PackageWorker>> modifyConfigXml: Error-> serverList is invalid!");
            throw new Exception(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.policyListInvalidMsg"));
        }
        String xml = exportPath + File.separator + CONFIG_XML;
        XmlParser parser = new XmlParser();
        Document doc = null;
        if (new File(xml).exists()) {
            if (!parser.readXmlFile(xml)) {
                Object[] obj = new Object[]{CONFIG_XML, exportPath};
                String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.faileedToRead0Under1");
                String fm = MessageFormat.format(str, obj);
                ConsoleLogger.log(fm);
                throw new Exception(INVALID_PACKAGE_MSG);
            }
            doc = parser.getDocument();
        } else {
            doc = parser.newDocument();
        }
        Element elementServerSettings = PackageUtil.modifyServerSettings((Document)doc, (String)Manager.getCurrentDomainId());
        Element elementCommConf = PackageUtil.modifyCommConf((Document)doc, (Element)elementServerSettings);
        this.agentMode = this.getAgentMode();
        PackageUtil.modifyRegisterClient((Document)doc, (Element)elementCommConf, (String)preferredGroup, (int)this.agentMode);
        try {
            Element elementAgentCommunication = PackageUtil.modifyAgentCommunicationSetting((Document)doc, (boolean)alwaysConnect, (PresharedSecret)DataobjectManager.getInstance().getSemConfigRoot().getOptPresharedSecret(), (Element)elementCommConf);
            CommunicationObject commObj = null;
            if (groupPolicy != null) {
                commObj = groupPolicy.getCommunicationObject();
            }
            if (commObj != null) {
                elementAgentCommunication.setAttribute("CommunicationMode", commObj.getMode() == 0 ? "PUSH" : "PULL");
                elementAgentCommunication.setAttribute(commObj.getMode() == 0 ? "PushHeartbeatSeconds" : "PullHeartbeatSeconds", "" + commObj.getHeartbeat());
            }
        }
        catch (Exception ex) {
            ConsoleLogger.log(ex.getMessage());
        }
        PackageUtil.modifyServerList((Document)doc, (SemServerList)serverList, (Boolean)this.needSignatureVerification(groupPolicy), (Element)elementCommConf, (String)String.valueOf(ScmProperties.getWebServerPort()));
        try {
            PackageUtil.modifyServerCertList((Document)doc, this.getAllSites(), (Element)elementCommConf);
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
        }
        if (!parser.saveXml(xml)) {
            Object[] obj = new Object[]{CONFIG_XML, exportPath};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.failedToSave0Under1Msg");
            String fm = MessageFormat.format(str, obj);
            throw new Exception(fm);
        }
        System.out.println("PackageWorker>> modifySylink: Done! xml=" + xml);
        return true;
    }

    protected boolean unzipFile(String zipFile, String destinationDir) {
        boolean unzipResult = false;
        try {
            ZipUtil.unzipFile((File)new File(zipFile), (String)destinationDir);
            unzipResult = true;
        }
        catch (Exception ex) {
            System.out.println("PackageWorker>> retrievePhsicalFileBinaryData: Error-> unzilFile...");
            LoggerUtilities.logException((Throwable)ex);
        }
        if (!unzipResult) {
            this.showMsgBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.failedToUnzipPackageMsg"), true);
            return false;
        }
        return true;
    }

    protected boolean unzipPhsicalFileBinaryData(String fileName, String destinationDir) throws Exception {
        if (fileName == null) {
            System.out.println("PackageWorker>> unzipPhsicalFileBinaryData: Error-> bytes is null!");
            return false;
        }
        boolean unzipResult = false;
        try {
            ZipUtil.unzipFile((String)fileName, (String)destinationDir);
            unzipResult = true;
        }
        catch (Exception ex) {
            System.out.println("PackageWorker>> retrievePhsicalFileBinaryData: Error-> unzilFile...");
            LoggerUtilities.logException((Throwable)ex);
            unzipResult = false;
        }
        if (!unzipResult) {
            throw new Exception(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.failedToUnzipPackageMsg"));
        }
        return true;
    }

    protected boolean createSingleZip(String exportFullPath, String clientExportZipFilePath) throws IOException {
        String dir = new File(exportFullPath).getParent();
        String zipFileName = exportFullPath + File.pathSeparator + SINGLE_ZIP_FILE_NAME;
        File zipFile = new File(dir, SINGLE_ZIP_FILE_NAME);
        TimeCounter counter = new TimeCounter();
        try {
            counter.start();
            System.out.println("Begin Zip...");
            ZipUtil.zipData((int)-1, (String)exportFullPath, (String)zipFile.getAbsolutePath());
            counter.stop();
            System.out.println("Done Zip: " + zipFileName + ", elapsed time=" + counter.getDuration() + " (" + counter.getDuration() / 1000L + "s)");
        }
        catch (Throwable ex) {
            System.out.println("PackageWorker>> createSingleZip: Error-> Failed to create single zip: " + zipFile.getAbsolutePath());
            LoggerUtilities.logException((Throwable)ex);
            return false;
        }
        if (!Utility.emptyDir((String)exportFullPath, (boolean)false)) {
            Object[] obj = new Object[]{exportFullPath};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.cannotDeleteExportFolder0Msg");
            String fm = MessageFormat.format(str, obj);
            this.progressListener.setProgressMsg(null, fm, true, true, -1);
            System.out.println("PackageWorker>> createSingleZip: Error-> Failed to empty export dir before creating zip: " + exportFullPath);
            Utility.delete((File)zipFile);
            return false;
        }
        File targetZip = new File(exportFullPath, SINGLE_ZIP_FILE_NAME);
        if (!zipFile.renameTo(targetZip)) {
            Utility.copyFileNIOTransfer((File)zipFile, (File)targetZip);
            Utility.delete((File)zipFile);
        }
        AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> {
            this.clientExportZipFilePath = targetZip.getAbsolutePath();
            AjaxSwingManager.endOperation();
        });
        return true;
    }

    protected boolean createSingleExe(String exportFullPath, String clientExportZipFilePath) throws IOException {
        String exeDir = NativeCommandUtilities.buildConsoleExe("MakeSFX.exe");
        if (exeDir == null || exeDir.length() < 1) {
            System.out.println("PackageWorker>> createSingleExe: Warning-> no exe dir for MakeSFX.exe!");
            return false;
        }
        this.addFileToCleanUpList(exeDir + File.separator + "MakeSFX.exe");
        File targetExeFile = new File(exportFullPath, SINGLE_EXE_FILE_NAME);
        String targetExe = targetExeFile.getAbsolutePath();
        System.out.println("PackageWorker>> createSingleExe: single exe=" + targetExe);
        String zipFilePath = exportFullPath + File.separator + "FULL.ZIP";
        boolean result = false;
        try {
            result = PackageUtil.runMakeSFX((String)exeDir, (String)targetExe, (String)zipFilePath);
        }
        catch (Throwable ex) {
            System.out.println("PackageWorker>> createSingleExe: Error-> Failed to run MakeSFX...");
            LoggerUtilities.logException((Throwable)ex);
        }
        AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> {
            this.clientExportZipFilePath = targetExe;
            AjaxSwingManager.endOperation();
        });
        if (!result) {
            System.out.println("PackageWorker>> createSingleExe: Error-> Failed to create a single exe: zip=" + zipFilePath + ", target exe=" + targetExe);
        }
        PackageWorker.removeAllFileExceptExe(exportFullPath);
        return result;
    }

    private static boolean removeAllFileExceptExe(String targetDir) {
        File[] fileList;
        File dir = new File(targetDir);
        boolean succeeded = false;
        if (dir.exists() && dir.isDirectory() && (fileList = dir.listFiles()) != null) {
            for (int i = 0; i < fileList.length; ++i) {
                String Name;
                if (!fileList[i].exists() || (Name = fileList[i].getName()) == null || Name.endsWith(".exe")) continue;
                System.out.println("PackageWorker>> removeAllFileExceptExe: Name Of the file deleted" + fileList[i].getName());
                Utility.delete((File)fileList[i]);
                succeeded = true;
            }
        }
        return succeeded;
    }

    public String getClientExportZipFilePath(String fileName) {
        ExportFolderChooser fc = new ExportFolderChooser();
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            fc.setDialogType(1);
            fc.setSelectedFile(new File(fileName));
            fc.updateUI();
            if (0 != fc.showSaveDialog(Manager.getFrame())) {
                return null;
            }
        } else if (0 != fc.showOpenDialog(Manager.getFrame())) {
            return null;
        }
        if (fc.getSelectedFile() == null) {
            return null;
        }
        String path = fc.getSelectedFile().getAbsolutePath();
        if (path == null || path.trim().length() == 0) {
            return null;
        }
        return path;
    }

    public void downloadSingleFile() {
        String zipFileName = Env.getCurrentPackageZipName();
        String targetPath = null;
        targetPath = this.getClientExportZipFilePath(zipFileName);
        if (targetPath != null) {
            boolean result;
            File src = new File(Utility.getTempDir() + File.separator + zipFileName);
            File dest = new File(targetPath);
            if (dest.exists()) {
                System.out.println("Target file already exists, clean it " + dest.getAbsolutePath());
                Utility.deleteFile((File)dest);
            }
            if (!(result = src.renameTo(dest))) {
                System.out.println("The File move operation failed. Try copying it: " + dest.getAbsolutePath());
                Utility.copyFileNIOTransfer((File)src, (File)dest);
                Utility.deleteFile((File)src);
            }
            PackageWorker.cleanupTargetDirectory(Path.of(targetPath, new String[0]));
        }
    }

    public static void cleanupTargetDirectory(Path targetPath) {
        try (Stream<Path> files = Files.list(targetPath.getParent());){
            files.filter(entry -> !entry.equals(targetPath) && Files.isRegularFile(entry, new LinkOption[0])).map(Path::toFile).forEach(Utility::deleteFile);
        }
        catch (IOException e) {
            LoggerUtilities.logException((Throwable)e);
        }
    }

    protected SemServerList retrieveGroupServerList(GroupObject groupObj) throws Exception {
        SemServerList serverList = null;
        try {
            GroupPolicyObject groupPolicy = PolicyHandler.getGroupPolicyByGroup(groupObj);
            CommunicationObject co = groupPolicy.getCommunicationObject();
            ServerListObject serverListObj = co.getServerList();
            serverList = serverListObj.getSemServerList();
            if (serverList == null) {
                System.out.println("ExportPackageWorker>> retrieveGroupServerList: Error-> failed to retrieve server list in the communication setting from group " + groupObj.getName());
                Object[] obj = new Object[]{groupObj.getName()};
                String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.failedRetrieveServerListInCommunicationSettingForGroup0Msg");
                String fm = MessageFormat.format(str, obj);
                throw new Exception(fm);
            }
        }
        catch (ConsoleException ex) {
            System.out.println("ExportPackageWorker>> retrieveGroupServerList: Exception... ");
            LoggerUtilities.logException((Throwable)ex);
            Object[] obj = new Object[]{groupObj.getName(), ex.getMessage()};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.failedRetrieveServerListforGroup01Msg");
            String fm = MessageFormat.format(str, obj);
            this.needRelogin = ex.needRelogin();
            throw new Exception(fm, ex);
        }
        return serverList;
    }

    protected String generateAllowListFullFilePathForProfile(String exportFullPath, WhiteListObject allowList, boolean master) {
        PhysicalFile physicalFile = allowList.getPhysicalFile(master);
        if (physicalFile == null) {
            return null;
        }
        String checksum = physicalFile.getFileChecksum();
        return exportFullPath + File.separator + "protection" + checksum + ".dat";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean saveAllowListFileForProfile(String exeDir, String exportFullPath, WhiteListObject allowList, boolean master) throws ConsoleException {
        String path = this.generateAllowListFullFilePathForProfile(exportFullPath, allowList, master);
        if (path == null) {
            return true;
        }
        byte[] bytes = WhiteListHandler.getChecksumeFile(allowList, master);
        if (bytes == null || bytes.length <= 0) {
            return true;
        }
        System.out.println("ExportPackageWorker>> saveAllowListFileForProfile: master=" + master + ", file=" + path + ", size=" + bytes.length);
        String tempFile = path + ".tmp";
        try {
            Utility.createFile((byte[])bytes, (String)tempFile, (boolean)false);
            if (!Utility.runEncryptor((String)exeDir, (String)tempFile, (String)path, (boolean)true)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            Utility.delete((String)tempFile);
        }
        return true;
    }

    protected boolean retrieveAllowListFiles(GroupObject groupObj, String exportFullPath) throws Exception {
        try {
            ArrayList<WhiteListObject> listAllowListObjs = SoftwarePackageHandler.retrieveWhiteListObjsFromGroup(groupObj);
            if (listAllowListObjs == null || listAllowListObjs.size() < 1) {
                System.out.println("ExportPackageWorker>> retrieveAllowListFiles: no allow list");
                return true;
            }
            String exeDir = null;
            try {
                exeDir = NativeCommandUtilities.buildConsoleExe("encrypt.exe");
            }
            catch (IOException ex) {
                LoggerUtilities.logException((Throwable)ex);
                throw new Exception(ex.getMessage(), ex);
            }
            if (exeDir == null || exeDir.length() < 1) {
                throw new Exception(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.failedRetrieveEncryptorProgramMsg"));
            }
            this.addFileToCleanUpList(exeDir + File.separator + "encrypt.exe");
            this.progressListener.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.savingAllowListFilesMsg"), false, true, -1);
            System.out.println("ExportPackageWorker>> retrieveAllowListFiles: allow list size=" + listAllowListObjs.size());
            for (int i = 0; i < listAllowListObjs.size(); ++i) {
                WhiteListObject allowList = listAllowListObjs.get(i);
                System.out.println("ExportPackageWorker>> retrieveAllowListFiles:\t" + i + ", name=" + allowList.getName());
                if (!this.saveAllowListFileForProfile(exeDir, exportFullPath, allowList, true)) {
                    throw new Exception(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.failedEncryptAndGenerateAllowListMsg"));
                }
                if (this.saveAllowListFileForProfile(exeDir, exportFullPath, allowList, false)) continue;
                throw new Exception(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.failedEncryptAndGenerateAllowListMsg"));
            }
            return true;
        }
        catch (ConsoleException ex) {
            System.out.println("ExportPackageWorker>> retrieveAllowListFiles: ConsoleException... ");
            LoggerUtilities.logException((Throwable)ex);
            Object[] obj = new Object[]{groupObj.getName(), ex.getMessage()};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.failedRetrieveServerListforGroup01Msg");
            String fm = MessageFormat.format(str, obj);
            this.needRelogin = ex.needRelogin();
            throw new Exception(fm, ex);
        }
    }

    protected boolean retrieveGroupProfile(GroupObject groupObj, SoftwarePackageObject packageObj, String exportFullPath, String preferredGroup, int preferredMode) throws Exception {
        return this.retrieveGroupProfile(groupObj, packageObj, exportFullPath, preferredGroup, preferredMode, false);
    }

    protected boolean retrieveGroupProfile(GroupObject groupObj, SoftwarePackageObject packageObj, String exportFullPath, String preferredGroup, int preferredMode, boolean removeCommunicationSet) throws Exception {
        String outputFilePath;
        byte[][] data = null;
        int packageType = packageObj.getType();
        data = SoftwarePackageHandler.retrieveGroupProfile(this, groupObj.getId(), packageType);
        if (this.isCanceled()) {
            return false;
        }
        if (data == null) {
            Object[] obj = new Object[]{groupObj.getName()};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.failedRetrievePolicyFilesForGroup0Msg");
            String fm = MessageFormat.format(str, obj);
            throw new Exception(fm);
        }
        if (data[0] == null || data[0].length < 1) {
            Object[] obj = new Object[]{groupObj.getName()};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.failedRetrieveProfileForGroup0Msg");
            String fm = MessageFormat.format(str, obj);
            throw new Exception(fm);
        }
        String filePath = exportFullPath + File.separator + TEMP_PROFILE_FILE;
        PackageInfo packageInfo = packageObj.getPackageInfo();
        if (packageInfo != null && ("LINUXRPM".equalsIgnoreCase(packageInfo.getOptPlatformType()) || "LINUXDPKG".equalsIgnoreCase(packageInfo.getOptPlatformType()) || "Mac".equalsIgnoreCase(packageInfo.getOptPlatformType()))) {
            if (!Utility.createLinuxAgentFormatProfile((byte[])data[0], (String)filePath)) {
                logger.log(Level.SEVERE, "PackageWorker>> retrieveGroupProfile: Error-> failed to createLinuxAgentFormatProfile, filePath is : " + filePath);
                Object[] obj = new Object[]{filePath};
                String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.faileSaveProfile0Msg");
                String fm = MessageFormat.format(str, obj);
                throw new Exception(fm);
            }
        } else if (!Utility.createAgentFormatProfile((byte[])data[0], (String)filePath)) {
            Object[] obj = new Object[]{filePath};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.faileSaveProfile0Msg");
            String fm = MessageFormat.format(str, obj);
            throw new Exception(fm);
        }
        System.out.println("PackageWorker>> retrieveGroupProfile: saved temp group profile for group=" + groupObj.getName() + ", id=" + groupObj.getId());
        String exeDir = null;
        try {
            exeDir = NativeCommandUtilities.buildConsoleExe("encrypt.exe");
        }
        catch (IOException ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw new Exception(ex.getMessage(), ex);
        }
        if (exeDir == null || exeDir.length() < 1) {
            throw new Exception(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.faileRetrieveEncryptorProgamMsg"));
        }
        this.addFileToCleanUpList(exeDir + File.separator + "encrypt.exe");
        Utility.updatePreferredModeAndGroup((String)filePath, (int)preferredMode, (String)preferredGroup);
        if (removeCommunicationSet) {
            Utility.removeCommunicationSettings((String)filePath);
        }
        if (!Utility.runEncryptor((String)exeDir, (String)filePath, (String)(outputFilePath = exportFullPath + File.separator + "serdef.dat"), (boolean)true)) {
            Object[] obj = new Object[]{outputFilePath};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.failedEncryptAndGenerateGroupProfile0Msg");
            String fm = MessageFormat.format(str, obj);
            throw new Exception(fm);
        }
        this.progressListener.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.savedGroupProfle"), false, true, -1);
        if (data.length < 2 || data[1] == null || data[1].length < 1) {
            System.out.println("PackageWorker>> retrieveGroupProfile: No group IPS file is retrieved! group=" + groupObj.getName() + ", id=" + groupObj.getId() + ", package type=" + packageType);
            return true;
        }
        if (!(this instanceof ExportMacPackageWorker) && !(this instanceof ExportLinuxPackageWorker)) {
            filePath = exportFullPath + File.separator + TEMP_IDS_FILE;
            if (!Utility.createFile((byte[])data[1], (String)filePath, (boolean)false)) {
                Object[] obj = new Object[]{filePath};
                String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.failedSaveIDSFile0Msg");
                String fm = MessageFormat.format(str, obj);
                throw new Exception(fm);
            }
            System.out.println("PackageWorker>> retrieveGroupProfile: saved temp group IDS file for group=" + groupObj.getName() + ", id=" + groupObj.getId());
            outputFilePath = exportFullPath + File.separator + "sdi.dat";
            if (!Utility.runEncryptor((String)exeDir, (String)filePath, (String)outputFilePath, (boolean)true)) {
                Object[] obj = new Object[]{outputFilePath};
                String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.failedEncryptAndGenerateGroupFile0Msg");
                String fm = MessageFormat.format(str, obj);
                throw new Exception(fm);
            }
            this.progressListener.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.savedGroupIPSFileMsg"), false, true, -1);
        } else {
            System.out.println("PackageWorker>> IDS file not applicable for Mac packages. Hence do not calculate and display the status message for the same");
        }
        return true;
    }

    protected boolean modifyConfigXmlForExport(String preferredGroup, SemServerList serverList, String exportFullPath, boolean isManaged) {
        SemServerList serverListForExport = serverList;
        boolean alwaysConnect = isManaged;
        if (serverListForExport == null && (serverListForExport = this.getDefaultServerList()) == null) {
            return false;
        }
        if (!isManaged) {
            return this.modifyConfigXmlForExportUnmanaged(exportFullPath);
        }
        return this.modifyConfigXml(serverListForExport, preferredGroup, exportFullPath, alwaysConnect);
    }

    protected boolean modifyConfigXmlForExportEx(String preferredGroup, SemServerList serverList, String exportFullPath, GroupPolicyObject groupPolicy, boolean isManaged) throws Exception {
        if (isManaged) {
            if (serverList == null && (serverList = this.getDefaultServerList()) == null) {
                return false;
            }
            return this.modifyConfigXmlEx(serverList, preferredGroup, exportFullPath, isManaged, groupPolicy);
        }
        return this.modifyConfigXmlForExportUnmanaged(exportFullPath);
    }

    public static String getInvalidDir() {
        return invalidDir;
    }

    public static int isValidDir(String strDir) {
        StringBuffer sbuff = new StringBuffer("");
        int iResult = IOUtilities.isValidDir((String)strDir, (StringBuffer)sbuff);
        if (sbuff.length() > 0) {
            invalidDir = sbuff.toString();
        }
        return iResult;
    }

    public static int createDir(String strDir) {
        File f;
        int iResult = -2;
        if (StringUtilities.isEmpty((String)strDir)) {
            iResult = -1;
            return iResult;
        }
        if (strDir.endsWith(File.separator)) {
            strDir = strDir.substring(0, strDir.length() - 1);
        }
        if ((f = new File(strDir)).exists()) {
            iResult = f.isDirectory() ? 0 : 1;
        } else {
            int i;
            Vector<String> vParents = new Vector<String>();
            vParents.addElement(strDir);
            File tempFile = new File(strDir);
            String strParent = tempFile.getParent();
            while (strParent != null) {
                tempFile = new File(strParent);
                if (tempFile.exists()) {
                    strParent = tempFile.getAbsolutePath();
                    break;
                }
                vParents.addElement(strParent);
                strParent = tempFile.getParent();
            }
            for (i = vParents.size() - 1; i > -1; --i) {
                tempFile = new File((String)vParents.elementAt(i));
                System.out.println("creating < " + i + ", " + (String)vParents.elementAt(i) + ", " + tempFile.getAbsolutePath() + " >");
                if (tempFile.mkdir()) continue;
                invalidDir = tempFile.getAbsolutePath();
                strParent = (String)vParents.elementAt(i);
                iResult = 10;
                ++i;
                break;
            }
            if (iResult == 10) {
                for (i = 0; i < vParents.size(); ++i) {
                    tempFile = new File((String)vParents.elementAt(i));
                    System.out.println("deleteing < " + i + ", " + (String)vParents.elementAt(i) + ", " + tempFile.getAbsolutePath() + " >");
                    Utility.delete((File)tempFile);
                }
            } else {
                iResult = f.exists() ? (f.isDirectory() ? 0 : 1) : -2;
            }
        }
        return iResult;
    }

    protected static ArrayList<String> generateExportFullPathes(SoftwarePackageObject packageObj, String exportRootDir, ArrayList<GroupObject> listGroups, String osForExport) {
        ArrayList<String> listExportDirs = new ArrayList<String>();
        if (listGroups == null || listGroups.size() < 1) {
            listExportDirs.add(PackageWorker.generateExportFullPathForDefault(packageObj, exportRootDir, osForExport));
        } else {
            for (int i = 0; i < listGroups.size(); ++i) {
                GroupObject groupObj = listGroups.get(i);
                listExportDirs.add(PackageWorker.generateExportFullPathForGroup(packageObj, exportRootDir, groupObj, osForExport));
            }
        }
        return listExportDirs;
    }

    public void setExportBtnVisible(boolean aflag) {
        this.displayExportBtn = aflag;
    }

    public boolean getExportBtnVisible() {
        return this.displayExportBtn;
    }

    public boolean isRequestExport() {
        return this.doExport;
    }

    public void setRequestExport(boolean aflag) {
        this.doExport = aflag;
    }

    private static String getGroupPathForExport(SoftwarePackageObject packageObj, String rootDir, SemClientGroup semClientGroup, String osForExport) {
        Object fullName = "";
        if (semClientGroup == null) {
            fullName = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.exportFullPathForDefaultClientGroup");
        } else {
            fullName = semClientGroup.getName();
            for (AbstractSchema asParent = semClientGroup.getParent(); asParent != null && asParent instanceof SemClientGroup; asParent = asParent.getParent()) {
                SemClientGroup parent = (SemClientGroup)asParent;
                fullName = parent.getName() + "_" + (String)fullName;
            }
        }
        return PackageWorker.getExportFullPathForGroup(rootDir, PackageWorker.sanitizeGroupName((String)fullName), packageObj, osForExport);
    }

    protected static String sanitizeGroupName(String groupName) {
        String invalidChars = "\"/\\*?<>|:&";
        String regEx = invalidChars.replace("\\", "\\\\");
        Pattern p = Pattern.compile("[" + regEx + "]");
        return p.matcher(groupName).replaceAll("#");
    }

    protected static String getExportFullPathForGroup(String rootDir, String subDirName, SoftwarePackageObject packageObj, String osForExport) {
        if (!((String)rootDir).endsWith(File.separator)) {
            rootDir = (String)rootDir + File.separator;
        }
        Object fullPath = (String)rootDir + subDirName;
        String platformType = "WIN32BIT";
        if (packageObj != null) {
            platformType = packageObj.getPackagePlatformString();
            fullPath = (String)fullPath + "_";
            fullPath = (String)fullPath + platformType;
            if (!StringUtilities.isEmpty((String)osForExport)) {
                fullPath = (String)fullPath + "_" + osForExport;
            }
            fullPath = (String)fullPath + File.separator;
            fullPath = (String)fullPath + packageObj.getClientPackageDisplayString(true);
        }
        boolean isMacPackage = "Mac".equals(platformType);
        int maxTargetExportPath = ConstantValue.getMaxPackageExportPath((boolean)isMacPackage);
        if (((String)fullPath).length() > maxTargetExportPath) {
            if (((String)fullPath).charAt(maxTargetExportPath - 1) == '\\' || ((String)fullPath).charAt(maxTargetExportPath - 1) == '/') {
                --maxTargetExportPath;
            }
            fullPath = ((String)fullPath).substring(0, maxTargetExportPath);
            fullPath = (String)fullPath + TILDE_STRING;
        }
        int count = 0;
        boolean hasTildeCharAtEnd = ((String)fullPath).charAt(((String)fullPath).length() - 1) == '~';
        Object tempStr = fullPath;
        while (new File((String)tempStr).exists()) {
            tempStr = fullPath;
            if (!hasTildeCharAtEnd) {
                tempStr = StringUtilities.join((String)tempStr, (String)TILDE_STRING);
            }
            tempStr = StringUtilities.join((String)tempStr, (String)String.valueOf(++count));
        }
        try {
            fullPath = new File((String)tempStr).getCanonicalPath();
        }
        catch (IOException ex) {
            ConsoleLogger.logError(ex.getMessage());
        }
        if (StringUtilities.isEmpty((String)fullPath)) {
            ConsoleLogger.logError("PackageWorker>> getExportFullPathForGroup: Error-> Failed to get group path!! group=" + subDirName);
        }
        return fullPath;
    }

    protected String getFullPathForSepCommunicationUpdater(String rootDir, SemClientGroup semClientGroup) {
        Object fullName = "";
        if (semClientGroup == null) {
            fullName = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.exportFullPathForDefaultClientGroup");
        } else {
            fullName = semClientGroup.getName();
            for (AbstractSchema asParent = semClientGroup.getParent(); asParent != null && asParent instanceof SemClientGroup; asParent = asParent.getParent()) {
                SemClientGroup parent = (SemClientGroup)asParent;
                fullName = parent.getName() + "_" + (String)fullName;
            }
        }
        return PackageWorker.getExportFullPathForGroup(rootDir, PackageWorker.sanitizeGroupName((String)fullName) + "_SepCommunicationUpdater", null, "");
    }

    public void setProgressMsg(String title, String msg, boolean bold, boolean enableStopButton, int value) {
        this.progressListener.setProgressMsg(title, msg, bold, enableStopButton, value);
        AjaxSwingCommonUtil.updateSwingAgentBrowser((boolean)true);
    }

    public int getMaxValue() {
        return this.progressListener.getMaxValue();
    }

    public int getMinValue() {
        return this.progressListener.getMinValue();
    }

    public int getProgressValue() {
        return this.progressListener.getProgressValue();
    }

    public void disposeDialog() {
        this.progressListener.disposeUI();
    }

    public void setExportVisible(boolean isExportVisible) {
        if (this.progressListener instanceof InProgressDlg) {
            ((InProgressDlg)this.progressListener).setExportVisible(isExportVisible);
        }
    }

    public void setProgressListener(PackageProgressListener listener) {
        if (listener != null) {
            this.progressListener = listener;
        }
    }

    public PackageProgressListener getProgressListener() {
        return this.progressListener;
    }

    public PackageworkerErrorState getState() {
        return this.state;
    }

    public void setState(PackageworkerErrorState s) {
        this.state = s;
    }

    protected String getOsForExport() {
        return "";
    }
}

