/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client;

import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.HTMLUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.SimpleTemplateParser;
import javax.swing.JTextPane;

public class HtmlPanel
extends JTextPane {
    private static final long serialVersionUID = 1L;
    protected SimpleTemplateParser templateParser = null;
    protected String templateFileName = "";

    public HtmlPanel() {
        this.setContentType("text/html");
        this.setEditable(false);
    }

    public HtmlPanel(String templateFileName) {
        this.templateFileName = templateFileName;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
        }
    }

    protected void jbInit() throws Exception {
        this.initParser();
        if (this.templateParser != null) {
            this.templateParser.setProperty("%CSSSTYLE%", HTMLUtilities.getStyleSheet());
        }
        this.setContentType("text/html");
        this.setEditable(false);
    }

    protected void initParser() throws ConsoleException {
        if (this.templateParser == null) {
            this.templateParser = new SimpleTemplateParser();
            if (this.templateFileName != null && this.templateFileName.length() > 0) {
                this.templateParser.loadTemplateFromResource(this.templateFileName, ConsoleMain.class);
            }
        }
    }

    public void updateText() {
        String text = this.templateParser.parse();
        this.setText(text);
        this.setCaretPosition(0);
    }

    public SimpleTemplateParser getTemplateParser() {
        return this.templateParser;
    }
}

