/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.SemClientHandler;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.ui.client.ClientRightPanel;
import com.sygate.scm.console.ui.client.XSLTPanel;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.HTMLUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.SimpleTemplateParser;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.text.MessageFormat;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GroupStatusPanel
extends ClientRightPanel {
    private static final long serialVersionUID = 1L;

    public GroupStatusPanel() {
        super(true);
        this.initialize();
        this.updateHtmlPane();
    }

    @Override
    public void setSelectedItem(Object item) {
        if (item == null) {
            return;
        }
        GroupObject group = (GroupObject)item;
        SimpleTemplateParser templateParser = this.getHtmlParser();
        try {
            templateParser.setProperty("%STRIPE_COLOR%", UIColorUtilities.colorToString((Color)UIColorUtilities.TABLE_STRIPE));
            templateParser.setProperty("%URL_BASE%", GroupStatusPanel.getUrlOfConsoleMainDir());
            templateParser.setProperty("%GROUP_ID%", group.getId());
            templateParser.setProperty("%GROUP_NAME%", Utility.escapeRegexString((String)HTMLUtilities.filter((String)group.getDisplayName())));
            templateParser.setProperty("%GROUP_DESCRIPTION%", Utility.escapeRegexString((String)HTMLUtilities.filterAndConvertNewLines((String)group.getDescription())));
            templateParser.setProperty("%GROUP_FULL_PATHNAME%", Utility.escapeRegexString((String)HTMLUtilities.filter((String)group.getFullGroupPath())));
            String str = Integer.toString(SemClientHandler.getCountOfDistinctPhysicalComputers(group.getId()));
            templateParser.setProperty("%GROUP_NUM_PHYSICAL_COMPUTERS%", str);
            str = Integer.toString(SemClientHandler.getCountOfDistinctRegisteredUsers(group.getId()));
            templateParser.setProperty("%GROUP_NUM_REGISTERED_USERS%", str);
            templateParser.setProperty("%GROUP_CREATOR%", HTMLUtilities.filterAndConvertNewLines((String)group.getCreator()));
            templateParser.setProperty("%GROUP_CREATION_TIME%", group.getCreationTimeDisplayString());
            templateParser.setProperty("%GROUP_MODIFIED_TIME%", group.getModificationTimeDisplayString());
            templateParser.setProperty("%GROUP_BLOCK_NEW_CLIENT%", group.getBlockNewUserStatusString());
            String[] serialNumbers = group.getSerialNumbers();
            templateParser.setProperty("%GROUP_PROFILE_SERIAL_NUMBER%", serialNumbers[0]);
            templateParser.setProperty("%GROUP_SIGNATURE_FILE_SERIAL_NUMBER%", serialNumbers[2]);
            templateParser.setProperty("%GROUP_PROFILE_POLICY_DATE%", serialNumbers[1]);
            this.updateHtmlPane();
        }
        catch (ConsoleException ex) {
            int errorCode = ex.getErrorCode();
            if (ex.needRelogin()) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "GroupStatusPanel.consoleError"), 0);
                Manager.getFrame().showLoginPanel();
                return;
            }
            if (errorCode == 0x16010000) {
                Object[] obj = new Object[]{group.getName()};
                String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "GroupStatusPanel.group0NotExistMsg");
                String fm = MessageFormat.format(str, obj);
                JOptionPane.showMessageDialog(Manager.getFrame(), fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "GroupStatusPanel.consoleError"), 0);
                this.getClientPane().removeSelectedNode();
                return;
            }
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "GroupStatusPanel.consoleError"), 0);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    @Override
    public void executeTask(int taskIndex, Object userObject) {
        if (taskIndex == 9) {
            this.getClientPane().doAddGroup();
        } else if (taskIndex == 43) {
            this.getClientPane().doImportOU();
        } else if (taskIndex == 47) {
            this.getClientPane().doDeleteGroup();
        } else if (taskIndex == 2) {
            this.getClientPane().doRenameGroup();
        } else if (taskIndex == 5) {
            this.getClientPane().doMoveGroup();
        } else if (taskIndex == 3) {
            this.getClientPane().doEditProps();
        } else if (taskIndex == 19) {
            this.getClientPane().doCopyPolicy();
        } else if (taskIndex == 20) {
            this.getClientPane().doPastePolicy();
        }
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_compusers_pane_details";
    }

    @Override
    protected void updateHtmlPane() {
        SimpleTemplateParser templateParser = this.getHtmlParser();
        templateParser.setProperty("%LOGO%", ConsoleMain.logoURL.toString());
        templateParser.setProperty("%INFO%", ConsoleMain.informURL.toString());
        templateParser.setProperty("%QUESTION%", ConsoleMain.questionURL.toString());
        templateParser.setProperty("%ACTION%", ConsoleMain.actionURL.toString());
        templateParser.setProperty("%HOME%", ConsoleMain.globalURL.toString());
        templateParser.setProperty("%BLUELINE%", ConsoleMain.blueLineURL.toString());
        super.updateHtmlPane();
    }

    @Override
    protected int getTaskType() {
        return 4;
    }

    @Override
    protected String getHtmlTemplateFileName() {
        return "template_clientgroupprops.xsl";
    }

    @Override
    protected XSLTPanel getXSLTPanel() {
        return new XSLTPanel(this.getHtmlTemplateFileName()){
            private static final long serialVersionUID = 1L;

            @Override
            protected void createTableInfo(Document doc, Element parent) throws ConsoleException {
                try {
                    int i;
                    Element tabElem = doc.createElement("TableInfo");
                    parent.appendChild(tabElem);
                    MessageResources msgRes = MessageResources.getInstance();
                    String[] keys = new String[]{"GroupID", "GroupName", "Description", "FullPathName", "NoOfPhysicalComputers", "NoOfRegisteredUsers", "CreatedBy", "CreationDate", "ModificationDate", "BlockNewUserComputer", "ProfileSerialNumber", "ProfileDate", "IntrusionPreventionChecksum"};
                    String[] values = new String[keys.length];
                    for (i = 0; i < keys.length; ++i) {
                        values[i] = msgRes.getString("com.sygate.scm.console.ui.client.client", "GroupStatusPanel." + keys[i]);
                    }
                    for (i = 0; i < keys.length; ++i) {
                        Element infoElem = doc.createElement(keys[i]);
                        infoElem.setAttribute("Info", values[i]);
                        tabElem.appendChild(infoElem);
                    }
                }
                catch (Exception ex) {
                    LoggerUtilities.logException((Throwable)ex);
                    throw new ConsoleException(ex);
                }
            }
        };
    }

    private void initialize() {
        JScrollPane sp = new JScrollPane(this.getHtmlPane());
        sp.setBorder(null);
        this.setLayout(new BorderLayout());
        this.add((Component)sp, "Center");
    }
}

