/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.ui.client.ClientRightPanel;
import com.sygate.scm.console.ui.client.HtmlPanel;
import com.sygate.scm.console.ui.util.TaskPanelBase;
import com.sygate.scm.util.HTMLUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.SimpleTemplateParser;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.text.MessageFormat;

public class GroupAccessDeniedPanel
extends TaskPanelBase {
    private static final long serialVersionUID = 1L;
    private HtmlPanel pane = new HtmlPanel("template_clientgroupaccessdenied.htm");

    public GroupAccessDeniedPanel() {
        this.initialize();
    }

    public void setSelectedItem(TreeItem item) {
        Object[] obj = new Object[]{item.getName()};
        String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "GroupAccessDeniedPanel.title");
        this.updateTitle(MessageFormat.format(str, obj));
        GroupObject group = (GroupObject)item;
        SimpleTemplateParser templateParser = this.pane.getTemplateParser();
        try {
            templateParser.setProperty("%URL_BASE%", ClientRightPanel.getUrlOfConsoleMainDir());
            templateParser.setProperty("%ACCESS_DENIED%", MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "GroupAccessDeniedPanel.accessDenied"));
            Object[] name = new Object[]{Utility.escapeRegexString((String)HTMLUtilities.filterAndConvertNewLines((String)group.getName()))};
            String pattern = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "GroupAccessDeniedPanel.noPrivilege");
            templateParser.setProperty("%NO_PRIVILEGE%", MessageFormat.format(pattern, name));
            this.pane.updateText();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    protected int getTaskType() {
        return 6;
    }

    @Override
    protected Component getContentPanel() {
        return this.pane;
    }

    protected String getTitleIconName() {
        return "client_group_16.png";
    }

    @Override
    protected String getTitleName() {
        return "";
    }
}

