/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client;

import com.sygate.scm.common.configobject.rpc.RpcData;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.statping.ClientSearchCriteriaPingMapping;
import com.sygate.scm.common.statping.TaskHits;
import com.sygate.scm.console.handler.LicenseHandler;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.ui.client.ClientQueryTableModel;
import com.sygate.scm.console.ui.client.ClientSearchResultPanel;
import com.sygate.scm.console.ui.client.dlg.FindObjectDlg;
import com.sygate.scm.console.ui.monitoring.dataquery.TableCriteriaList;
import com.sygate.scm.console.ui.util.NonClientTableColumnMap;
import com.sygate.scm.console.ui.util.ObjectComparator;
import com.sygate.scm.console.ui.util.QueryPanelBase;
import com.sygate.scm.console.ui.util.ResultTablePanel;
import com.sygate.scm.console.ui.util.SearchTable;
import com.sygate.scm.console.ui.util.TableColumnMap;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.renderer.JLabelCellRenderer;
import com.sygate.scm.util.SwingWorker;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class FindObjectPanel
extends QueryPanelBase {
    private static final long serialVersionUID = 1L;
    private static final String[] COL_NAMES = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "FindObjectPanel.nameCName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "FindObjectPanel.operatingSystemCName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "FindObjectPanel.domainCName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "FindObjectPanel.descriptonCName")};
    private ClientQueryTableModel clientQueryTableModel = new ClientQueryTableModel();
    private boolean searchComputer = true;
    private FindObjectDlg findObjectDlg;
    private ClientSearchResultPanel clientSearchResultPanel;
    private JPanel clientTitlePanel;
    private static ObjectComparator objComparator = new ObjectComparator();
    private transient SwingWorker worker = null;

    public FindObjectPanel(FindObjectDlg findObjectDlg) {
        super("");
        this.findObjectDlg = findObjectDlg;
        this.setSearchTable(new SearchTable(this.searchModel));
        this.initialize();
    }

    public void setSearchMode(boolean isComputer) {
        this.searchComputer = isComputer;
        this.setSearchTable();
        this.searchModel.reset();
    }

    @Override
    public void setTitlePanel(JPanel p) {
        this.clientTitlePanel = p;
        super.setTitlePanel(p);
    }

    @Override
    protected JPanel getTitlePanel() {
        if (this.clientTitlePanel == null) {
            this.clientTitlePanel = new JPanel(new BorderLayout());
        }
        return this.clientTitlePanel;
    }

    @Override
    protected ResultTablePanel getResultTablePanel() {
        if (this.clientSearchResultPanel == null) {
            this.initTable();
        }
        return this.clientSearchResultPanel;
    }

    private RpcData getQueryString(ArrayList<GroupObject> groupList) {
        RpcData rpc = this.jTSearch.getCriteria();
        StringBuilder groupIds = new StringBuilder();
        if (groupList != null && groupList.size() != 0) {
            int count = groupList.size();
            for (int i = 0; i < count; ++i) {
                GroupObject group = groupList.get(i);
                groupIds.append("," + group.getId());
            }
        }
        if (groupIds.length() > 0) {
            Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"ID_LIST", (String)groupIds.substring(1));
        }
        return rpc;
    }

    @Override
    protected void search() {
        super.search();
        this.worker = new SwingWorker(){
            private boolean isValidSql = false;
            private List<Integer> searchCriteriaHints = new ArrayList<Integer>();

            public Object construct() {
                ArrayList<GroupObject> groupList = null;
                FindObjectPanel.this.resultPanel.enableProgressPanel();
                FindObjectPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                if (FindObjectPanel.this.findObjectDlg != null) {
                    String grouppaths = FindObjectPanel.this.findObjectDlg.getGroupPath();
                    System.out.println("Group path got is--" + grouppaths);
                    if ("".equals(grouppaths)) {
                        String msgs = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "FindObjectPanel.enterAGroupName");
                        JOptionPane.showMessageDialog(FindObjectPanel.this.findObjectDlg, msgs, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "FindObjectPanel.searchComputersOrUsers"), 0);
                        return null;
                    }
                    groupList = FindObjectPanel.this.findObjectDlg.getGroupList();
                    if (groupList == null || groupList.size() < 1) {
                        String groupPath = FindObjectPanel.this.findObjectDlg.getGroupPath();
                        System.out.println("FindObjectPanel>> search: Error-> group is NOT found! path=" + groupPath);
                        String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "FindObjectPanel.specifiedGroupNotFoundMsg");
                        if (groupPath != null && groupPath.length() > 0) {
                            Object[] obj = new Object[]{groupPath};
                            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "FindObjectPanel.group0NotFoundMsg");
                            msg = MessageFormat.format(str, obj);
                        }
                        JOptionPane.showMessageDialog(FindObjectPanel.this.findObjectDlg, msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "FindObjectPanel.searchComputersOrUsers"), 0);
                        return null;
                    }
                }
                RpcData rpc = FindObjectPanel.this.getQueryString(groupList);
                this.isValidSql = FindObjectPanel.this.clientQueryTableModel.setQueryString(rpc, FindObjectPanel.this.searchComputer);
                this.setSearchCriteriaHints();
                return null;
            }

            private void setSearchCriteriaHints() {
                ClientSearchCriteriaPingMapping mapping = ClientSearchCriteriaPingMapping.getInstance();
                int rowCount = FindObjectPanel.this.jTSearch.getRowCount();
                for (int i = 0; i < rowCount; ++i) {
                    String columnName;
                    TableColumnMap tcm;
                    String tableName;
                    String key;
                    Integer subModuleID;
                    Object objSearch = FindObjectPanel.this.jTSearch.getModel().getValueAt(i, 0);
                    if (!(objSearch instanceof TableColumnMap) || (subModuleID = mapping.getSubModuleID(key = mapping.getCriteriaMappingKey(tableName = (tcm = (TableColumnMap)objSearch).getTableName(), columnName = tcm.getColumnName()))) == null) continue;
                    this.searchCriteriaHints.add(subModuleID);
                }
            }

            public void finished() {
                if (this.isValidSql && !this.isCanceled()) {
                    FindObjectPanel.this.resultPanel.refresh("", "");
                    FindObjectPanel.this.findObjectDlg.pack();
                }
                FindObjectPanel.this.resultPanel.disableProgressPanel();
                FindObjectPanel.this.setCursor(Cursor.getDefaultCursor());
                FindObjectPanel.this.resultPanel.disableProgressPanel();
                if (FindObjectPanel.this.clientQueryTableModel.getRowCount() == 0) {
                    String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "FindObjectPanel.message.NoResultsFound");
                    String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "FindObjectPanel.title.NoResultsFound");
                    JOptionPane.showMessageDialog(FindObjectPanel.this.findObjectDlg, msg, title, 0);
                }
                if (this.searchCriteriaHints.size() > 0) {
                    for (Integer subModuleID : this.searchCriteriaHints) {
                        TaskHits.getInstance().incrementMapItem(18708, subModuleID.intValue());
                    }
                }
            }
        };
        this.worker.start();
    }

    @Override
    protected void stop() {
        super.stop();
        if (this.worker != null) {
            this.worker.interrupt();
        }
    }

    @Override
    protected void setSearchTable() {
        JComboBox<Object> searchFieldComboBox = this.jTSearch.getSearchFieldComboBox();
        searchFieldComboBox.removeAllItems();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add("");
        TableColumnMap[] agentList = TableCriteriaList.getAgentCriteria();
        for (int i = 0; i < agentList.length; ++i) {
            if ("PEP_ONOFF".equals(agentList[i].getColumnName()) && !LicenseHandler.isPEPActivated()) continue;
            arrayList.add(new NonClientTableColumnMap(agentList[i]));
        }
        TableColumnMap[] computerList = TableCriteriaList.getComputerCriteria();
        for (int i = 0; i < computerList.length; ++i) {
            if (computerList[i].getType() == 13) {
                arrayList.add(computerList[i]);
                continue;
            }
            arrayList.add(new NonClientTableColumnMap(computerList[i]));
        }
        TableColumnMap[] clientList = TableCriteriaList.getClientCriteria();
        for (int i = 0; i < clientList.length; ++i) {
            arrayList.add(clientList[i]);
        }
        TableColumnMap[] patternList = TableCriteriaList.getCompositeCriteria();
        for (int i = 0; i < patternList.length; ++i) {
            arrayList.add(new NonClientTableColumnMap(patternList[i]));
        }
        TableColumnMap[] localQueryList = FindObjectPanel.getQueryCriteria(this.searchComputer);
        for (int i = 0; i < localQueryList.length; ++i) {
            arrayList.add(localQueryList[i]);
        }
        Object[] list = arrayList.toArray();
        Arrays.sort(list, objComparator);
        this.jTSearch.appendComboBoxItem(searchFieldComboBox, list);
    }

    public ClientQueryTableModel getModel() {
        return this.clientQueryTableModel;
    }

    private void initTable() {
        this.clientSearchResultPanel = new ClientSearchResultPanel(this, this.clientQueryTableModel);
        this.clientQueryTableModel.setColumnNames(COL_NAMES, true);
        JTable resultTable = this.clientSearchResultPanel.getTable();
        float[] colSizes = new float[]{0.3f, 0.3f, 0.4f};
        Dimension size = resultTable.getPreferredScrollableViewportSize();
        UIUtilities.resizeColumns(resultTable, colSizes, size.width);
        resultTable.setAutoResizeMode(1);
        Enumeration<TableColumn> columns = this.clientSearchResultPanel.getTable().getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            column.setCellRenderer(new JLabelCellRenderer());
        }
    }

    public static TableColumnMap[] getQueryCriteria(boolean isSearchComputer) {
        TableColumnMap[] list = new TableColumnMap[]{new TableColumnMap("SEM_CLIENT", "COMPUTER_NAME", MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", isSearchComputer ? "FindObjectPanel.computerNameCName" : "FindObjectPanel.logonComputerNameCName")), new TableColumnMap("SEM_CLIENT", "USER_NAME", MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", isSearchComputer ? "FindObjectPanel.logonUserNameCName" : "FindObjectPanel.userNameCName")), new TableColumnMap("SEM_CLIENT", "DESCRIPTION", MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "FindObjectPanel.descriptionCName")), new NonClientTableColumnMap("SEM_AGENT", "FULL_NAME", MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "FindObjectPanel.fullNameCName")), new NonClientTableColumnMap("SEM_AGENT", "EMAIL", MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "FindObjectPanel.emailAddressCName")), new NonClientTableColumnMap("SEM_AGENT", "JOB_TITLE", MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "FindObjectPanel.jobTitleCName")), new NonClientTableColumnMap("SEM_AGENT", "DEPARTMENT", MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "FindObjectPanel.departmentCName")), new NonClientTableColumnMap("SEM_AGENT", "EMPLOYEE_NUMBER", MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "FindObjectPanel.employeeNumberCName")), new NonClientTableColumnMap("SEM_AGENT", "EMPLOYMENT_STATUS", MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "FindObjectPanel.employmentStatusCName")), new NonClientTableColumnMap("SEM_AGENT", "OFFICE_PHONE", MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "FindObjectPanel.officeNumberCName")), new NonClientTableColumnMap("SEM_AGENT", "MOBILE_PHONE", MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "FindObjectPanel.mobilePhoneCName")), new NonClientTableColumnMap("SEM_AGENT", "HOME_PHONE", MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "FindObjectPanel.homePhoneCName"))};
        Arrays.sort(list, new ObjectComparator());
        return list;
    }
}

