/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client;

import com.sygate.scm.common.configobject.schema.AmlLowBandwidth;
import com.sygate.scm.common.configobject.schema.ClientInstallationFeatures;
import com.sygate.scm.common.configobject.schema.EnabledClientFeatures;
import com.sygate.scm.common.configobject.schema.InstallationOption;
import com.sygate.scm.common.configobject.schema.RebootOptions;
import com.sygate.scm.common.configobject.schema.SemConfigRoot;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.MultiLineLabel;
import com.sygate.scm.console.handler.GroupHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.ui.admin.logicobject.ClientInstallationFeatureObject;
import com.sygate.scm.console.ui.admin.logicobject.ClientInstallationSettingObject;
import com.sygate.scm.console.ui.client.ExportPackageSettings;
import com.sygate.scm.console.ui.client.ExportPackageWorker;
import com.sygate.scm.console.ui.client.TextPackageProgressListener;
import com.sygate.scm.console.ui.policy.dialog.RebootOptionsPanel;
import com.sygate.scm.console.ui.policy.lu.LuUtility;
import com.sygate.scm.console.ui.policy.util.PolicyUtil;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.CloudUtil;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.console.util.NativeCommandUtilities;
import com.sygate.scm.util.IOUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.PackageContentsUtil;
import com.sygate.scm.util.PackageUtil;
import com.sygate.scm.util.ServerVersion;
import com.sygate.scm.util.Utility;
import com.sygate.scm.util.ZipUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class ExportWindowsPackageWorker
extends ExportPackageWorker {
    private static Logger logger = Logger.getLogger(ExportWindowsPackageWorker.class.getName());
    boolean isExportDefault = true;
    private ClientInstallationSettingObject settingObj;
    private ClientInstallationFeatureObject featureObj;
    private boolean retainExistingFeatures;
    private boolean isPrefGroupSet = true;
    boolean isManaged = false;
    boolean cloudEnrolled = false;
    private int packageContentOption = 0;
    private List<String> downloadedContentList = null;
    private static final MessageResourcesFile MSG_RES = new MessageResourcesFile("com.sygate.scm.console.ui.client.client");

    public ExportWindowsPackageWorker(ExportPackageSettings settings) {
        super(settings);
        this.setSettings();
    }

    private void setSettings() {
        this.listGroups = this.settings.getGroups();
        if (this.listGroups == null || this.listGroups.isEmpty()) {
            this.isExportDefault = true;
        } else {
            this.isExportDefault = false;
            this.isPrefGroupSet = this.settings.isAddClientToGroup();
        }
        this.packageObj = this.settings.getExportedPackage();
        this.exportDir = this.settings.getExportedDir();
        this.isCreateExe = this.settings.isSingleExe();
        this.settingObj = this.settings.getInstallSettings();
        this.featureObj = this.settings.getFeatureSet();
        this.retainExistingFeatures = this.settings.isRetainExistingClientFeatures();
        this.isManaged = this.settings.isManaged();
        this.packageContentOption = this.settings.getContentOption();
        this.cloudEnrolled = CloudUtil.isCloudEnrolled(Manager.getCurrentDomainId());
        this.setAgentMode(this.settings.isAgentMode());
        if (this.isExportDefault) {
            this.setFinishMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.errorHappenedMsg"));
        }
    }

    @Override
    protected void afterWork() {
        block3: {
            if (this.isAllDone) {
                try {
                    ConsoleLogger.logAdminEvent(12291);
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "ExportPackageWorker>> afterWork: Error-> failed to log!");
                    if (!(ex instanceof ConsoleException) || ((ConsoleException)ex).getErrorCode() != 0x11010000) break block3;
                    this.needRelogin = true;
                }
            }
        }
    }

    @Override
    protected boolean doExportDefault() throws ConsoleException {
        block35: {
            SemConfigRoot root;
            boolean isIdcEnabled;
            ClientInstallationFeatures features = this.getFeatures();
            String version = this.packageObj.getVersion(true);
            if (!this.showErrorDialogForADDefenseFeatureOnlySelected(version, features)) {
                return false;
            }
            this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.prepareMsg"), true, true, 0);
            this.exportFullPath = ExportWindowsPackageWorker.generateExportFullPathForDefault(this.packageObj, this.exportDir, "");
            Object[] obj = new Object[]{Integer.toString(this.packageObj.getType())};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.unknowPackageTypeMsg");
            String fm = MessageFormat.format(str, obj);
            if (this.exportFullPath == null || this.exportFullPath.length() <= 0) {
                this.showMsgBox(fm, true);
                return false;
            }
            Object[] obj1 = new Object[]{this.exportFullPath};
            str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.createFolderMsg");
            fm = MessageFormat.format(str, obj1);
            if (!AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                this.setProgressMsg(null, fm, true, true, 1);
            }
            if (this.isCancelled()) {
                return false;
            }
            if (!this.createExportDir(this.exportFullPath)) {
                str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.failedToCreateExportPathMsg");
                fm = MessageFormat.format(str, obj1);
                if (!AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                    this.showMsgBox(fm, true);
                }
                return false;
            }
            this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.retrievingPackageDataFromServer"), true, true, 7);
            if (this.isCancelled()) {
                return false;
            }
            try {
                logger.log(Level.SEVERE, Utility.getPerformanceLog((String)"custom deployment", (String)"get pacakge from server", (boolean)true));
                if (!this.retrieveAndUnzipPackagePhysicalFile(this.isCreateExe)) {
                    return false;
                }
                logger.log(Level.SEVERE, Utility.getPerformanceLog((String)"custom deployment", (String)"get pacakge from server", (boolean)false));
            }
            catch (Exception e1) {
                this.showMsgBox(e1.getMessage(), true);
                return false;
            }
            boolean isSMB = this.isSMBProduct();
            InstallationOption installOption = this.getInstallationOption();
            if (Utility.compareVersion((String)this.packageObj.getVersion(true), (String)"14.0.0.0") >= 0) {
                boolean contentAdded = false;
                boolean lowBandwidthEnabled = new AmlLowBandwidth().getDefEnableLowBandwidth();
                try {
                    contentAdded = this.addLatestContent(this.packageObj.getSoftwarePackage().getId(), version, this.packageObj.getPackageInfo().getOptPlatformType(), this.packageObj.getPackageInfo().getType(), isSMB, PackageUtil.isReducedInstallSizeSpecified((InstallationOption)installOption), PackageUtil.isDarkNetwork((InstallationOption)installOption), lowBandwidthEnabled);
                }
                catch (ConsoleException e1) {
                    this.showMsgBox(e1.getMessage(), true);
                    return false;
                }
                if (!contentAdded) {
                    logger.info("ExportPackageWorker> doExportToGroup>> Warning-> Unable to add latest content!");
                    this.showContentNotAvaibaleWarning();
                }
                PackageContentsUtil.cleanupContents((String)this.exportFullPath, (EnabledClientFeatures)this.featureObj.getEnabledFeaturesByPackageVersion(Boolean.TRUE.equals(this.packageObj.getPackageInfo().getOptSecurityFixPackage()) ? this.packageObj.getPackageInfo().getOptProductBuildNum() : this.packageObj.getPackageInfo().getVersion()));
            }
            try {
                this.addPaidLicense(this.exportFullPath, this.packageObj.getPackageInfo().getType());
            }
            catch (Exception e1) {
                this.showMsgBox(e1.getMessage(), true);
                return false;
            }
            String packListExePath = null;
            try {
                packListExePath = NativeCommandUtilities.buildConsoleExe("packlist.exe");
            }
            catch (IOException ex) {
                LoggerUtilities.logException((Throwable)ex);
                this.showMsgBox(ex.getMessage(), true);
                return false;
            }
            if (packListExePath == null || packListExePath.length() < 1) {
                logger.log(Level.SEVERE, "ExportPackageWorker>> doExportDefault: Warning-> no exe dir!");
                return false;
            }
            this.addFileToCleanUpList(packListExePath + File.separator + "packlist.exe");
            String packageBuildNumber = this.packageObj.getBuildNumber();
            if (packageBuildNumber == null || packageBuildNumber.length() < 1) {
                this.showMsgBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.failedToRetrieveBuildNumberMsg"), true);
                return false;
            }
            logger.log(Level.INFO, "ExportPackageWorker>> doExportDefault: buildnumber={0}", packageBuildNumber);
            String newPackageChecksum = PackageUtil.generatePackList((String)packListExePath, (String)packageBuildNumber, (String)this.exportFullPath, (String)this.exportFullPath, (boolean)true);
            if (newPackageChecksum == null) {
                this.showMsgBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.failedToGetNewChecksumMsg"), true);
                return false;
            }
            this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.modifyingConfigurationFileMsg"), true, true, 8);
            if (this.isCancelled()) {
                return false;
            }
            GroupObject tempGroup = GroupHandler.getDefaultGroupObject();
            GroupObject globalGroup = tempGroup.getParentGroup();
            String preferredGroup = globalGroup.getName() + "\\" + tempGroup.getName();
            if (!this.modifyConfigXmlForExport(preferredGroup, this.serverList, this.exportFullPath, this.isManaged)) {
                return false;
            }
            RebootOptions options = this.getRebootOptions();
            if (!PackageUtil.modifySetAidIniSetupIni((String)newPackageChecksum, (InstallationOption)installOption, (ClientInstallationFeatures)features, (boolean)this.hasFeatures(), (String)this.exportFullPath, (boolean)true, (boolean)LuUtility.isGroupPolicyUseLiveUpdateServer(tempGroup), (RebootOptions)options, (String)version)) {
                return false;
            }
            String setupIni = this.exportFullPath + File.separator + "setup.ini";
            if (PackageUtil.isPackageAvailForIdcSetting((String)setupIni) && !(isIdcEnabled = (root = DataobjectManager.getInstance().getSemConfigRoot()).getOptTelemetryClientInstallData().getOptEnabled().booleanValue()) && !PackageUtil.modifySetupIni((String)setupIni, (boolean)isIdcEnabled)) {
                return false;
            }
            if (this.isCreateExe) {
                this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.creatSingleExeFileMsg"), true, true, 9);
                if (this.isCancelled()) {
                    return false;
                }
                try {
                    if (!this.createSingleExe()) {
                        str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.failedToCreateSingleExeUnderMsg");
                        fm = MessageFormat.format(str, obj1);
                        this.showMsgBox(fm, true);
                        return false;
                    }
                    break block35;
                }
                catch (Exception ex) {
                    LoggerUtilities.logException((Throwable)ex);
                    Object[] obj2 = new Object[]{this.exportFullPath, ex.getMessage()};
                    str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.failedToCreateSingleExeUnder01Msg");
                    fm = MessageFormat.format(str, obj2);
                    this.showMsgBox(fm, true);
                    return false;
                }
            }
            if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.creatSingleZipFileMsg"), true, true, 9);
                if (this.isCancelled()) {
                    return false;
                }
                try {
                    if (!this.createSingleZip(this.exportFullPath, this.clientExportZipFilePath)) {
                        str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.failedToCreateSingleZipUnderMsg");
                        fm = MessageFormat.format(str, obj1);
                        this.showMsgBox(fm, true);
                        return false;
                    }
                }
                catch (IOException ex) {
                    LoggerUtilities.logException((Throwable)ex);
                    Object[] obj2 = new Object[]{this.exportFullPath, ex.getMessage()};
                    str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.failedToCreateSingleZipUnder01Msg");
                    fm = MessageFormat.format(str, obj2);
                    this.showMsgBox(fm, true);
                    return false;
                }
            }
        }
        Utility.deleteFileAnyCaseFromFolder((String)"Contents.info", (String)this.exportFullPath);
        this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.fiinishMsg"), true, true, 10);
        this.setFinishMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.CompletedSuccessfullyMsg"));
        return true;
    }

    private boolean hasFeatures() {
        int type = this.packageObj.getType();
        return ClientInstallationFeatureObject.hasCustomizedFeatures(type);
    }

    private InstallationOption getInstallationOption() {
        if (this.settingObj != null) {
            return this.settingObj.getInstallationOption();
        }
        return this.packageObj.getInstallationOption();
    }

    private ClientInstallationFeatures getFeatures() {
        if (this.featureObj != null) {
            return this.featureObj.getClientInstallationFeatures();
        }
        return null;
    }

    private RebootOptions getRebootOptions() {
        RebootOptions options = null;
        if (this.settingObj != null && (options = this.settingObj.getOptRebootOptions()) == null) {
            options = RebootOptionsPanel.getDefaultRebootOptions();
        }
        return options;
    }

    @Override
    protected boolean doExportToGroup(GroupObject groupObj, Boolean isGroupID, double maxProgressStepPerGroup) throws Exception {
        double increment;
        block43: {
            SemConfigRoot root;
            boolean isIdcEnabled;
            boolean removeLocCommunicationSets;
            ClientInstallationFeatures feature = this.getFeatures();
            String version = this.packageObj.getVersion(true);
            if (!this.showErrorDialogForADDefenseFeatureOnlySelected(version, feature)) {
                return false;
            }
            int totalSubSteps = this.isCreateExe ? 7 : 6;
            increment = maxProgressStepPerGroup / (double)totalSubSteps;
            double currentProgressValue = this.getProgressValue();
            this.exportFullPath = this.generateExportFullPath(groupObj, isGroupID, "");
            Object[] obj = new Object[]{this.exportFullPath};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.creatFolderMsg");
            String fm = MessageFormat.format(str, obj);
            currentProgressValue += increment;
            if (!AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                this.setProgressMsg(null, fm, false, true, (int)currentProgressValue);
            }
            if (this.isCancelled()) {
                return false;
            }
            if (!this.createExportDir(this.exportFullPath)) {
                str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.failedToCreateExportPath");
                fm = MessageFormat.format(str, obj);
                throw new Exception(fm);
            }
            this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.retrievingGroupServerListMsg"), false, true, (int)(currentProgressValue += increment));
            if (this.isCancelled()) {
                return false;
            }
            this.serverList = this.retrieveGroupServerList(groupObj);
            if (!this.selectManagementServerForGroup(groupObj)) {
                return false;
            }
            this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.retrievingPackageDataFromServerMsg"), false, true, (int)(currentProgressValue += increment));
            if (this.isCancelled()) {
                return false;
            }
            logger.log(Level.SEVERE, Utility.getPerformanceLog((String)"custom deployment", (String)"get pacakge from server", (boolean)true));
            if (!this.retrieveAndUnzipPackagePhysicalFile(this.isCreateExe)) {
                return false;
            }
            logger.log(Level.SEVERE, Utility.getPerformanceLog((String)"custom deployment", (String)"get pacakge from server", (boolean)false));
            boolean isSMB = this.isSMBProduct();
            InstallationOption installOption = this.getInstallationOption();
            boolean darkNetwork = PackageUtil.isDarkNetwork((InstallationOption)installOption);
            boolean lowBandwidthEnabled = new AmlLowBandwidth().getDefEnableLowBandwidth();
            if (this.cloudEnrolled && !darkNetwork) {
                lowBandwidthEnabled = PolicyUtil.isLowBandwidthEnabled(groupObj, this.packageObj.getVersion(true));
            }
            if (Utility.compareVersion((String)this.packageObj.getVersion(true), (String)"14.0.0.0") >= 0) {
                boolean contentAdded = true;
                try {
                    contentAdded = this.addLatestContent(this.packageObj.getSoftwarePackage().getId(), version, this.packageObj.getPackageInfo().getOptPlatformType(), this.packageObj.getPackageInfo().getType(), isSMB, PackageUtil.isReducedInstallSizeSpecified((InstallationOption)installOption), darkNetwork, lowBandwidthEnabled);
                }
                catch (ConsoleException e1) {
                    this.showMsgBox(e1.getMessage(), true);
                    throw e1;
                }
                if (!contentAdded) {
                    logger.info("ExportPackageWorker> doExportToGroup>> Warning-> Unable to add latest content!");
                    this.showContentNotAvaibaleWarning();
                }
                PackageContentsUtil.cleanupContents((String)this.exportFullPath, (EnabledClientFeatures)this.featureObj.getEnabledFeaturesByPackageVersion(version));
            }
            this.addPaidLicense(this.exportFullPath, this.packageObj.getPackageInfo().getType());
            if (this.isManaged && this.cloudEnrolled) {
                try {
                    this.addConnectionFile(this.exportFullPath);
                }
                catch (ConsoleException e1) {
                    if (e1.getErrorCode() == -50331648) {
                        Object[] obj1 = new Object[]{ServerVersion.CURRENT_CED_VERSION, Utility.getLanguage()};
                        UIUtilities.showHTMLMessageDialog(Manager.getFrame(), e1.getMessageWithoutErrorCode(), MSG_RES.getString("ExportPackageWorker.boostrapUrlKbText"), "", MessageFormat.format(MSG_RES.getString("ExportPackageWorker.boostrapUrlKbLink"), obj1), MSG_RES.getString("ExportPackageWorker.boostrapUrlErrorDlgBoxTitle"), 0, false);
                    }
                    return false;
                }
            }
            this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.retrievingGroupProfileFromServer"), false, true, (int)(currentProgressValue += increment));
            if (this.isCancelled()) {
                return false;
            }
            String preferredGroup = null;
            if (this.isPrefGroupSet) {
                preferredGroup = GroupHandler.getGroupFullPath(groupObj);
            }
            boolean bl = removeLocCommunicationSets = !this.isManaged;
            if (!this.retrieveGroupProfile(groupObj, this.packageObj, this.exportFullPath, preferredGroup, this.agentMode, removeLocCommunicationSets)) {
                return false;
            }
            if (this.isCancelled()) {
                return false;
            }
            if (!this.retrieveAllowListFiles(groupObj, this.exportFullPath)) {
                return false;
            }
            String packListExePath = null;
            try {
                packListExePath = NativeCommandUtilities.buildConsoleExe("packlist.exe");
            }
            catch (IOException ex) {
                LoggerUtilities.logException((Throwable)ex);
                throw new Exception(ex.getMessage());
            }
            if (packListExePath == null || packListExePath.length() < 1) {
                logger.log(Level.SEVERE, "ExportPackageWorker>> doExportToGroup: Warning-> no exe dir!");
                return false;
            }
            this.addFileToCleanUpList(packListExePath + File.separator + "packlist.exe");
            String packageBuildNumber = this.packageObj.getBuildNumber();
            if (packageBuildNumber == null || packageBuildNumber.length() < 1) {
                throw new Exception(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.failedToRetrieveBuildNumberMsg"));
            }
            logger.log(Level.INFO, "ExportPackageWorker>> doExportToGroup: buildnumber={0}", packageBuildNumber);
            String newPackageChecksum = PackageUtil.generatePackList((String)packListExePath, (String)packageBuildNumber, (String)this.exportFullPath, (String)this.exportFullPath, (boolean)true);
            if (newPackageChecksum == null) {
                throw new Exception(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.failedToGetNewChecksumMsg"));
            }
            this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.modifyingConfigFileMsg"), false, true, (int)(currentProgressValue += increment));
            if (this.isCancelled()) {
                return false;
            }
            GroupPolicyObject groupPolicy = null;
            try {
                groupPolicy = PolicyHandler.getGroupPolicyByGroup(groupObj);
            }
            catch (Exception e1) {
                LoggerUtilities.logException((Throwable)e1);
                throw new Exception(e1.getMessage());
            }
            if (!this.modifyConfigXmlForExportEx(preferredGroup, this.serverList, this.exportFullPath, groupPolicy, this.isManaged)) {
                return false;
            }
            RebootOptions options = this.getRebootOptions();
            if (!PackageUtil.modifySetAidIniSetupIni((String)newPackageChecksum, (InstallationOption)installOption, (ClientInstallationFeatures)feature, (boolean)this.hasFeatures(), (String)this.exportFullPath, (boolean)true, (boolean)LuUtility.isGroupPolicyUseLiveUpdateServer(groupObj), (RebootOptions)options, (String)this.packageObj.getVersion(true), (boolean)lowBandwidthEnabled, (boolean)this.retainExistingFeatures)) {
                return false;
            }
            String setupIni = this.exportFullPath + File.separator + "setup.ini";
            if (PackageUtil.isPackageAvailForIdcSetting((String)setupIni) && !(isIdcEnabled = (root = DataobjectManager.getInstance().getSemConfigRoot()).getOptTelemetryClientInstallData().getOptEnabled().booleanValue()) && !PackageUtil.modifySetupIni((String)setupIni, (boolean)isIdcEnabled)) {
                return false;
            }
            if (this.isCreateExe) {
                this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.creatingSingleExeFileMsg"), false, true, (int)(currentProgressValue += increment));
                if (this.isCancelled()) {
                    return false;
                }
                try {
                    if (!this.createSingleExe()) {
                        str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.failedToCreateASingleExeUnderMsg");
                        fm = MessageFormat.format(str, obj);
                        throw new Exception(fm);
                    }
                    break block43;
                }
                catch (IOException ex) {
                    LoggerUtilities.logException((Throwable)ex);
                    Object[] obj1 = new Object[]{this.exportFullPath, ex.getMessage()};
                    str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.failedToCreateASingleExeUnder01Msg");
                    fm = MessageFormat.format(str, obj1);
                    throw new Exception(fm);
                }
            }
            if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.creatSingleZipFileMsg"), false, true, (int)currentProgressValue);
                if (this.isCancelled()) {
                    return false;
                }
                try {
                    if (!this.createSingleZip(this.exportFullPath, this.clientExportZipFilePath)) {
                        str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.failedToCreateSingleZipUnderMsg");
                        fm = MessageFormat.format(str, obj);
                        throw new Exception(fm);
                    }
                }
                catch (IOException ex) {
                    LoggerUtilities.logException((Throwable)ex);
                    Object[] obj2 = new Object[]{this.exportFullPath, ex.getMessage()};
                    str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.failedToCreateSingleZipUnder01Msg");
                    fm = MessageFormat.format(str, obj2);
                    throw new Exception(fm);
                }
            }
        }
        Utility.deleteFileAnyCaseFromFolder((String)"Contents.info", (String)this.exportFullPath);
        this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.finishingMsg"), false, false, (int)(currentProgressValue += increment));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean createSingleExe() throws IOException {
        boolean result;
        block15: {
            String version;
            List<String> contents;
            NativeCommandUtilities.extractSsawrapper(this.exportFullPath);
            Object toolFile = NativeCommandUtilities.buildConsoleExe("SEPMPackageTool.exe");
            if (toolFile == null || ((String)toolFile).length() < 1) {
                ConsoleLogger.log("ExportPackageWorker>> createSingleExe: Warning-> no tool dir for SEPMPackageTool.exe");
                return false;
            }
            toolFile = (String)toolFile + File.separator + "SEPMPackageTool.exe";
            this.addFileToCleanUpList((String)toolFile);
            String zipFilePath = this.exportFullPath + File.separator + "FULL.ZIP";
            File sourceZip = new File(zipFilePath);
            if (!sourceZip.exists()) {
                ConsoleLogger.log("ExportPackageWorker>> createSingleExe: Warning-> no source ZIP in temp folder!");
                return false;
            }
            ArrayList<CallSite> listFilesToBeAdded = new ArrayList<CallSite>();
            String appRemoverPath = this.exportFullPath + File.separator + "TPAR";
            File fileAppRemover = new File(this.exportFullPath + File.separator + "TPAR");
            if (fileAppRemover.exists()) {
                listFilesToBeAdded.add((CallSite)((Object)appRemoverPath));
            }
            if (!listFilesToBeAdded.isEmpty()) {
                ZipUtil.addFilesToExistingZip((File)sourceZip, listFilesToBeAdded);
            }
            HashSet<String> arr = new HashSet<String>();
            arr.add("packlist.xml");
            arr.add("sylink.xml");
            arr.add("SsaWrapper.exe");
            arr.add("setAid.ini");
            arr.add("setup.ini");
            arr.add("sdi.dat");
            arr.add("serdef.dat");
            arr.add("connect.dat");
            if (this.licenseFileName != null) {
                arr.add(this.licenseFileName);
            }
            if ((contents = this.getDownloadedContentList()) != null && !contents.isEmpty()) {
                for (int i = 0; i < contents.size(); ++i) {
                    String entry = contents.get(i);
                    if (entry == null) continue;
                    arr.add(entry.toString());
                }
            }
            if (Utility.compareVersion((String)(version = this.packageObj.getVersion(true)), (String)"12.0") > 0) {
                arr.add("VDefs.zip");
                arr.add("IDSDefs.zip");
                arr.add("BashDefs.zip");
                arr.add("STICDefs.zip");
                arr.add("SMRDefs.zip");
                arr.add("EDRDefs.zip");
                arr.add("NTRDefs.zip");
                arr.add("ACDefs.zip");
                arr.add("TDADDefs.zip");
                arr.add("SEFDefs.zip");
            } else {
                arr.add("VDefHub.zip");
                arr.add("IPSDef.zip");
            }
            String[] fileFilter = arr.toArray(new String[0]);
            StringBuffer toolLogs = new StringBuffer();
            result = false;
            try {
                result = ZipUtil.runBT((char)'a', (String)zipFilePath, (String)this.exportFullPath, (String)this.exportFullPath, (String[])fileFilter, (String)toolFile, (StringBuffer)toolLogs);
                if (!result) {
                    ConsoleLogger.log("ExportPackageWorker>> createSingleExe: Failed to create a single exe: zip=" + zipFilePath);
                    break block15;
                }
                boolean bl = this.createSingleExe(this.exportFullPath, this.clientExportZipFilePath);
                return bl;
            }
            catch (Exception ex) {
                ConsoleLogger.log("ExportPackageWorker>> createSingleExe: Failed to run SEPMPackageTool or MakeSFX...");
                LoggerUtilities.logException((Throwable)ex);
            }
            finally {
                Utility.delete((String)zipFilePath);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean addLatestContent(String pkgId, String targetVersion, String platformType, int pkgType, boolean isSMB, boolean reducedSize, boolean darkNetwork, boolean lowBandwidthEnabled) throws ConsoleException {
        String tempFile;
        boolean succeeded;
        block17: {
            BufferedOutputStream bos;
            BufferedInputStream bis;
            InputStream is;
            block16: {
                boolean bl;
                block15: {
                    succeeded = false;
                    tempFile = this.exportFullPath + File.separator + "Content.zip";
                    is = null;
                    bis = null;
                    bos = null;
                    ClientInstallationFeatures features = this.getFeatures();
                    if (pkgType == 151) {
                        Logger.getLogger("").log(Level.SEVERE, "RemotePushInstallClientHandler>> copyLatestContent: No content needed for SNAC.");
                        this.removeAllOldHubsDefs(targetVersion);
                        return true;
                    }
                    if (features == null) {
                        logger.log(Level.FINE, "ClientInstallationFeatures is null, return false");
                        return false;
                    }
                    try {
                        bos = new BufferedOutputStream(new FileOutputStream(tempFile));
                        byte[] data = null;
                        if (isSMB) {
                            data = features.getBytes();
                        }
                        if ((is = GUIManager.getLatestContentFile(pkgId, targetVersion, platformType, pkgType, this.packageContentOption, features.getId(), data, reducedSize, darkNetwork, lowBandwidthEnabled)) == null) {
                            bl = false;
                            IOUtilities.closeInputStream((InputStream)is);
                            break block15;
                        }
                        bis = new BufferedInputStream(is);
                        int iBufferSize = 1024;
                        byte[] buffer = new byte[iBufferSize];
                        while (true) {
                            int bytesRead;
                            if ((bytesRead = bis.read(buffer)) == -1) {
                                ((OutputStream)bos).flush();
                                succeeded = true;
                                IOUtilities.closeInputStream((InputStream)is);
                                break block16;
                            }
                            ((OutputStream)bos).write(buffer, 0, bytesRead);
                        }
                    }
                    catch (Exception e1) {
                        logger.info("ExportWindowsPackageWorker> addLatestContent>> No contents available from the server for package: id = " + pkgId);
                        logger.log(Level.SEVERE, e1.getMessage());
                        break block17;
                    }
                }
                IOUtilities.closeInputStream(bis);
                IOUtilities.closeOutputStream((OutputStream)bos);
                return bl;
            }
            IOUtilities.closeInputStream((InputStream)bis);
            IOUtilities.closeOutputStream((OutputStream)bos);
            break block17;
            finally {
                IOUtilities.closeInputStream(is);
                IOUtilities.closeInputStream(bis);
                IOUtilities.closeOutputStream((OutputStream)bos);
            }
        }
        if (succeeded && !this.contentPostprocess(tempFile, targetVersion)) {
            succeeded = false;
        }
        try {
            Utility.deleteFile((String)tempFile);
            Utility.deleteFileAnyCaseFromFolder((String)"Contents.info", (String)this.exportFullPath);
            return succeeded;
        }
        catch (Exception exp) {
            logger.info("ExportWindowsPackageWorker> addLatestContent>> Failed to delete temp content.zip.");
            logger.log(Level.SEVERE, exp.getMessage());
        }
        return succeeded;
    }

    private boolean contentPostprocess(String tempFile, String targetVersion) {
        boolean tf = true;
        File contentTemp = new File(this.exportFullPath + File.separator + "PackageContents");
        if (!contentTemp.exists() && !contentTemp.mkdirs()) {
            logger.log(Level.SEVERE, "Not able to create folder: {0}", contentTemp.getPath());
        }
        try {
            this.unzipContents(tempFile, contentTemp.getCanonicalPath());
            List<String> contents = this.getLatestContentList(contentTemp.getAbsolutePath() + File.separator + "Contents.info");
            if (contents == null || contents.isEmpty()) {
                tf = false;
                logger.log(Level.SEVERE, "Not able to read content list, no contents downlaoded.");
            } else {
                this.setDownloadedContentList(contents);
                this.removeOldHubsDefsFromExportDir(contents);
                Utility.copyDir((String)contentTemp.getAbsolutePath(), (String)this.exportFullPath, (boolean)false);
                Utility.deleteDir((File)contentTemp);
            }
        }
        catch (IOException e1) {
            logger.log(Level.SEVERE, "Not able to unpack contents.");
            tf = false;
        }
        return tf;
    }

    private void removeOldHubsDefsFromExportDir(List<String> contents) {
        if (contents == null) {
            return;
        }
        for (int i = 0; i < contents.size(); ++i) {
            String entry = contents.get(i);
            if (entry == null || entry.length() <= 0) continue;
            String toRemove = this.getOldHubNames(entry);
            Utility.deleteFileAnyCaseFromFolder((String)toRemove, (String)this.exportFullPath);
        }
    }

    private String getOldHubNames(String entry) {
        String hubName = "";
        if (entry == null || entry.isEmpty()) {
            return null;
        }
        if (entry.toLowerCase().compareToIgnoreCase("VDefs.zip") == 0) {
            hubName = "VDefHub.zip";
        } else if (entry.toLowerCase().compareToIgnoreCase("IPSDefs.zip") == 0 || entry.toLowerCase().compareToIgnoreCase("IDSDefs.zip") == 0) {
            hubName = "IPSDef.zip";
        }
        return hubName;
    }

    private void removeAllOldHubsDefs(String version) {
        String srcVdef = this.exportFullPath + File.separator + "VDefs.zip";
        String srcIPSHub = this.exportFullPath + File.separator + "IDSDefs.zip";
        String srcBashdef = this.exportFullPath + File.separator + "BashDefs.zip";
        String srcVdef11 = this.exportFullPath + File.separator + "VDefHub.zip";
        String srcIPSdef11 = this.exportFullPath + File.separator + "IPSDef.zip";
        if (Utility.compareVersion((String)version, (String)"12.0") > 0) {
            Utility.removeFileFromDir((String)srcVdef, (String)this.exportFullPath);
            Utility.removeFileFromDir((String)srcIPSHub, (String)this.exportFullPath);
            Utility.removeFileFromDir((String)srcBashdef, (String)this.exportFullPath);
        } else if (Utility.compareVersion((String)version, (String)"12.0") <= 0) {
            Utility.removeFileFromDir((String)srcVdef11, (String)this.exportFullPath);
            Utility.removeFileFromDir((String)srcIPSdef11, (String)this.exportFullPath);
        }
    }

    private boolean unzipContents(String tempFile, String exportFullPath) {
        File zipFile = new File(tempFile);
        if (zipFile.length() > 0L) {
            try {
                ZipUtil.unzipFile((File)zipFile, (String)exportFullPath);
            }
            catch (IOException e1) {
                return false;
            }
            Utility.delete((File)zipFile);
        }
        return true;
    }

    private List<String> getLatestContentList(String infoFile) {
        ArrayList<String> catList = new ArrayList<String>();
        File contentLog = new File(infoFile);
        if (!contentLog.exists()) {
            logger.log(Level.SEVERE, "ExportWindowsPackageWorker::getLatestContentList() ->No content downloaded from server at this time");
            return catList;
        }
        try (FileInputStream fis = new FileInputStream(infoFile);
             BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fis, Charset.defaultCharset()));){
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                catList.add(line);
            }
        }
        catch (IOException ex) {
            catList = null;
            LoggerUtilities.logException((Throwable)ex);
        }
        return catList;
    }

    public void setDownloadedContentList(List<String> downloadedContentList) {
        this.downloadedContentList = downloadedContentList;
    }

    public List<String> getDownloadedContentList() {
        return this.downloadedContentList;
    }

    private boolean showErrorDialogForADDefenseFeatureOnlySelected(String productVersion, ClientInstallationFeatures clientInstallationFeatures) {
        if (!PackageUtil.isAtleastOneFeatureSelected((String)productVersion, (ClientInstallationFeatures)clientInstallationFeatures)) {
            String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigGeneralPanel.NoFeatureEnabled");
            MultiLineLabel multiL = new MultiLineLabel(msg);
            JOptionPane.showMessageDialog(Manager.getFrame(), multiL, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "DeployConfigGeneralPanel.NoFeatureEnabledTitle"), 0);
            return false;
        }
        return true;
    }

    private void showContentNotAvaibaleWarning() {
        if (!(this.getProgressListener() instanceof TextPackageProgressListener)) {
            UIUtilities.showWarningDialog(MSG_RES.getString("ExportPackageWorker.failedToRetrieveContentFromServer"));
        }
    }
}

