/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.AjaxSwingManager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.handler.SoftwarePackageHandler;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.ui.client.ExportPackageSettings;
import com.sygate.scm.console.ui.client.ExportPackageWorker;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.NativeCommandUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.PackageUtil;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExportSepCommunicationPackageWorker
extends ExportPackageWorker {
    private static Logger logger = Logger.getLogger(ExportSepCommunicationPackageWorker.class.getName());
    boolean isExportDefault = true;
    boolean isManaged = false;

    public ExportSepCommunicationPackageWorker(ExportPackageSettings settings) {
        super(settings);
        this.setSettings();
    }

    private void setSettings() {
        this.listGroups = this.settings.getGroups();
        this.isExportDefault = this.listGroups == null || this.listGroups.size() == 0;
        this.isCreateExe = this.settings.isSingleExe();
        this.exportDir = this.settings.getExportedDir();
        this.setAgentMode(this.settings.isAgentMode());
    }

    @Override
    protected void afterWork() {
        block3: {
            if (this.isAllDone) {
                try {
                    ConsoleLogger.logAdminEvent(12291);
                }
                catch (Throwable ex) {
                    logger.log(Level.SEVERE, "ExportPackageWorker>> afterWork: Error-> failed to log!");
                    if (!(ex instanceof ConsoleException) || ((ConsoleException)ex).getErrorCode() != 0x11010000) break block3;
                    this.needRelogin = true;
                }
            }
        }
    }

    @Override
    protected boolean doExportToGroup(GroupObject groupObj, Boolean isGroupID, double maxProgressStepPerGroup) throws Exception {
        int totalSubSteps = this.isCreateExe ? 7 : 6;
        double increment = maxProgressStepPerGroup / (double)totalSubSteps;
        double currentProgressValue = this.getProgressValue();
        this.exportFullPath = this.generateCommunicationExportFullPathForGroup(groupObj);
        String platform = this.settings.isMacCommunicationSettings() ? "Mac" : "Windows";
        Object[] obj = new Object[]{this.exportFullPath};
        String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.creatFolderMsg");
        String fm = MessageFormat.format(str, obj);
        currentProgressValue += increment;
        if (!AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            this.setProgressMsg(null, fm, false, true, (int)currentProgressValue);
        }
        if (this.isCancelled()) {
            return false;
        }
        if (!this.createExportDir(this.exportFullPath)) {
            str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.failedToCreateExportPath");
            fm = MessageFormat.format(str, obj);
            throw new Exception(fm);
        }
        this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.retrievingGroupServerListMsg"), false, true, (int)(currentProgressValue += increment));
        if (this.isCancelled()) {
            return false;
        }
        GroupPolicyObject groupPolicy = null;
        try {
            groupPolicy = PolicyHandler.getGroupPolicyByGroup(groupObj);
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
            throw new Exception(e.getMessage());
        }
        PolicyHandler.exportSylink(this.exportFullPath, groupPolicy, this.agentMode, false);
        int retValue = SoftwarePackageHandler.getSylinkDrop(this.exportFullPath, platform);
        if (retValue != 1) {
            return false;
        }
        if ("Mac".equals(platform)) {
            PackageUtil.writeSylinkdropOptionsXMLForMac((String)this.exportFullPath);
        } else {
            PackageUtil.writeSylinkdropOptionsXML((String)this.exportFullPath);
        }
        if (this.isCreateExe) {
            this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.creatingSingleExeFileMsg"), false, true, (int)(currentProgressValue += increment));
            if (this.isCancelled()) {
                return false;
            }
            try {
                if (!this.createSingleZip(this.exportFullPath, this.clientExportZipFilePath)) {
                    str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.failedToCreateSingleZipUnderMsg");
                    fm = MessageFormat.format(str, obj);
                    throw new Exception(fm);
                }
            }
            catch (IOException ex) {
                LoggerUtilities.logException((Throwable)ex);
                Object[] obj2 = new Object[]{this.exportFullPath, ex.getMessage()};
                str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.failedToCreateSingleZipUnder01Msg");
                fm = MessageFormat.format(str, obj2);
                throw new Exception(fm);
            }
            File targetZipFile = new File(this.exportFullPath, "setup.zip");
            File renamedFile = new File(this.exportFullPath, "SepCommunicationUpdater.zip");
            boolean renamed = targetZipFile.renameTo(renamedFile);
            if (!renamed) {
                System.out.println("PackageWorker>> rename to " + renamedFile + " failed!");
            }
        }
        this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.finishingMsg"), false, false, (int)(currentProgressValue += increment));
        return true;
    }

    protected boolean createSingleExe() throws IOException {
        String exeDir = NativeCommandUtilities.buildConsoleExe("MakeSFX.exe");
        if (exeDir == null || exeDir.length() < 1) {
            System.out.println("PackageWorker>> createSingleExe: Warning-> no exe dir for MakeSFX.exe!");
            return false;
        }
        this.addFileToCleanUpList(exeDir + File.separator + "MakeSFX.exe");
        File targetExeFile = new File(this.exportFullPath, "SepCommunicationUpdater.exe");
        String targetExe = targetExeFile.getAbsolutePath();
        System.out.println("PackageWorker>> createSingleExe: single exe=" + targetExe);
        String zipFilePath = this.exportFullPath + File.separator + "setup.zip";
        boolean result = false;
        try {
            result = PackageUtil.runMakeSFX((String)exeDir, (String)targetExe, (String)zipFilePath);
        }
        catch (Throwable ex) {
            System.out.println("PackageWorker>> createSingleExe: Error-> Failed to run MakeSFX...");
            LoggerUtilities.logException((Throwable)ex);
        }
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            this.clientExportZipFilePath = targetExe;
            AjaxSwingManager.endOperation();
        }
        if (!result) {
            System.out.println("PackageWorker>> createSingleExe: Error-> Failed to create a single exe: zip=" + zipFilePath + ", target exe=" + targetExe);
        }
        ExportSepCommunicationPackageWorker.removeAllFileExceptExe(this.exportFullPath);
        return result;
    }

    private static boolean removeAllFileExceptExe(String targetDir) {
        File[] fileList;
        File dir = new File(targetDir);
        boolean succeeded = false;
        if (dir.exists() && dir.isDirectory() && (fileList = dir.listFiles()) != null) {
            for (int i = 0; i < fileList.length; ++i) {
                String Name;
                if (!fileList[i].exists() || (Name = fileList[i].getName()) == null || Name.endsWith(".exe")) continue;
                System.out.println("PackageWorker>> removeAllFileExceptExe: Name Of the file deleted" + fileList[i].getName());
                boolean deleted = fileList[i].delete();
                if (!deleted) {
                    System.out.println("PackageWorker>> delete " + fileList[i].getName() + " failed!");
                }
                succeeded = true;
            }
        }
        return succeeded;
    }

    @Override
    protected boolean doExportDefault() {
        return true;
    }
}

