/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client;

import com.sygate.scm.console.logicobject.SoftwarePackageObject;
import com.sygate.scm.console.ui.client.AbstractExportPackageValidator;
import com.sygate.scm.console.ui.client.ExportCommunicationPackageValidator;
import com.sygate.scm.console.ui.client.ExportLinuxNormalPackageValidator;
import com.sygate.scm.console.ui.client.ExportLinuxPackageWorker;
import com.sygate.scm.console.ui.client.ExportLinuxStubPackageWorker;
import com.sygate.scm.console.ui.client.ExportMacNormalPackageValidator;
import com.sygate.scm.console.ui.client.ExportMacPackageWorker;
import com.sygate.scm.console.ui.client.ExportPackageSettings;
import com.sygate.scm.console.ui.client.ExportPackageWorker;
import com.sygate.scm.console.ui.client.ExportSepCommunicationPackageWorker;
import com.sygate.scm.console.ui.client.ExportWindowsPackageValidator;
import com.sygate.scm.console.ui.client.ExportWindowsPackageWorker;
import com.sygate.scm.console.ui.client.PackageWorker;
import com.sygate.scm.util.ConstantValue;
import com.sygate.scm.util.PackageUtil;
import java.util.List;

public class ExportPackageWorkerFacotry {
    private static ExportPackageWorkerFacotry factory;

    public static ExportPackageWorkerFacotry getInstance() {
        if (null == factory) {
            factory = new ExportPackageWorkerFacotry();
        }
        return factory;
    }

    public PackageWorker getExportPackageWorker(ExportPackageSettings settings) {
        ExportPackageWorker worker = null;
        SoftwarePackageObject spo = settings.getExportedPackage();
        String platform = spo.getPackageInfo().getOptPlatformType();
        if (platform == null) {
            return null;
        }
        if ("WIN32BIT".equals(platform) || "WIN64BIT".equals(platform)) {
            worker = new ExportWindowsPackageWorker(settings);
        } else if ("Mac".equals(platform)) {
            worker = ConstantValue.isMacPackageOfZipFormatType((int)spo.getType()) ? new ExportMacPackageWorker(settings) : new ExportWindowsPackageWorker(settings);
        } else if ("LINUXRPM".equals(platform) || "LINUXDPKG".equals(platform)) {
            worker = new ExportLinuxPackageWorker(settings);
        } else if (PackageUtil.isLinuxStub((String)platform)) {
            worker = new ExportLinuxStubPackageWorker(settings);
        }
        return worker;
    }

    public PackageWorker getSepCommunicationExportPackageWorker(ExportPackageSettings settings) {
        ExportSepCommunicationPackageWorker worker = new ExportSepCommunicationPackageWorker(settings);
        return worker;
    }

    public AbstractExportPackageValidator getExportPackageValidator(SoftwarePackageObject packageObj) {
        if (packageObj == null) {
            return new ExportCommunicationPackageValidator((SoftwarePackageObject)null);
        }
        if (packageObj.isMacNormalPackage()) {
            return new ExportMacNormalPackageValidator(packageObj);
        }
        if (packageObj.isLinuxNormalPackage()) {
            return new ExportLinuxNormalPackageValidator(packageObj);
        }
        return new ExportWindowsPackageValidator(packageObj);
    }

    public AbstractExportPackageValidator getExportPackageValidator(List<SoftwarePackageObject> listPackageObj) {
        if (listPackageObj.size() == 0) {
            return new ExportCommunicationPackageValidator(listPackageObj);
        }
        SoftwarePackageObject packageObj = listPackageObj.get(0);
        if (packageObj.isMacNormalPackage()) {
            return new ExportMacNormalPackageValidator(listPackageObj);
        }
        return new ExportWindowsPackageValidator(listPackageObj);
    }
}

