/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client;

import com.sygate.scm.common.configobject.schema.ClientPackageLicenseInfo;
import com.sygate.scm.common.configobject.schema.PackageInfo;
import com.sygate.scm.common.configobject.schema.PresharedSecret;
import com.sygate.scm.common.configobject.schema.SemClientGroup;
import com.sygate.scm.common.configobject.schema.SemClientGroupTree;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.configobject.schema.SemServerList;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.handler.GroupHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.SoftwarePackageHandler;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.SoftwarePackageObject;
import com.sygate.scm.console.ui.client.ExportPackageSettings;
import com.sygate.scm.console.ui.client.PackageWorker;
import com.sygate.scm.console.ui.client.dlg.InProgressDlg;
import com.sygate.scm.console.ui.client.dlg.SelectDefaultMgmtServerDlg;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.console.util.NativeCommandUtilities;
import com.sygate.scm.console.util.ScmProperties;
import com.sygate.scm.console.util.ServerNotReadyForExportException;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.SwingWorker;
import com.sygate.scm.util.TimeCounter;
import com.sygate.scm.util.Utility;
import com.sygate.scm.util.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class ExportPackageWorker
extends PackageWorker {
    protected ExportPackageSettings settings;
    protected SoftwarePackageObject packageObj = null;
    String licenseFileName = null;
    protected String exportFullPath = null;
    protected String exportDir = null;
    protected ArrayList<String> listGroups = null;
    protected SemServerList serverList = null;
    protected boolean isSepCommunicationUpdater = false;
    protected SemServerList commonServerList = null;
    protected HashMap<String, SemServerList> serverListMap = new HashMap();
    public static final int MAX_RETRY = 6;
    private static final MessageResourcesFile MSG_RES = new MessageResourcesFile("com.sygate.scm.console.ui.client.client");

    public ExportPackageWorker(ExportPackageSettings settings) {
        this.agentMode = settings.isAgentMode();
        this.settings = settings;
        this.packageObj = settings.getExportedPackage();
        this.exportDir = settings.getExportedDir();
        this.listGroups = settings.getGroups();
        this.isSepCommunicationUpdater = settings.isSepCommunicationUpdater();
        this.clientExportZipFilePath = settings.getClientExportZipFilePath();
        this.setMsgBoxTitle(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.exportPackageTitle"));
        this.setDlgTitle(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.exportPackageDlgTitle"));
    }

    @Override
    protected boolean doWork() throws ConsoleException {
        System.out.println(Utility.getPerformanceLog((String)"custom deployment", (String)"export total time", (boolean)true));
        this.listGroups = this.settings.getGroups();
        boolean bResult = false;
        this.setRequestExport(true);
        bResult = this.listGroups == null || this.listGroups.size() == 0 ? this.doExportDefault() : this.doExportToGroups();
        System.out.println(Utility.getPerformanceLog((String)"custom deployment", (String)"do export total time", (boolean)false));
        String pFolder = SoftwarePackageHandler.getPackageCacheFolder(this.settings);
        File fFile = new File(pFolder);
        if (fFile.exists()) {
            Utility.deleteDir((String)pFolder);
        }
        return bResult;
    }

    @Override
    protected void afterWork() {
        block3: {
            if (this.isAllDone) {
                try {
                    ConsoleLogger.logAdminEvent(12291);
                }
                catch (Throwable ex) {
                    System.out.println("ExportPackageWorker>> afterWork: Error-> failed to log!");
                    if (!(ex instanceof ConsoleException) || ((ConsoleException)ex).getErrorCode() != 0x11010000) break block3;
                    this.needRelogin = true;
                }
            }
        }
    }

    protected boolean isSepCommunicationUpdater() {
        return this.isSepCommunicationUpdater;
    }

    protected abstract boolean doExportToGroup(GroupObject var1, Boolean var2, double var3) throws Exception;

    protected abstract boolean doExportDefault() throws ConsoleException;

    @Override
    protected void cleanup() {
        super.cleanup();
        Utility.deleteDir((String)new File(this.exportFullPath).getPath());
    }

    protected String addPaidLicense(String exportPath, int packageType) throws Exception {
        String result = null;
        ClientPackageLicenseInfo info = null;
        this.licenseFileName = null;
        try {
            if (packageType == 105) {
                info = GUIManager.getClientPackageLicenseInfo(packageType);
            } else if (packageType == 151) {
                info = GUIManager.getClientPackageLicenseInfo(packageType);
            }
        }
        catch (Exception e) {
            ConsoleLogger.log("ExportPackageWorker>> addPaidLicense: Fail to retrieve latest paid license");
            ConsoleLogger.log(e);
            String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.exportLicenseErrorMsg");
            throw new Exception(msg);
        }
        if (info == null) {
            ConsoleLogger.log(" get null ClientPackageLicenseInfo in ExportPackageWorker for packageType=" + packageType);
            return null;
        }
        if (!info.getOptPackageNeedLicense().booleanValue()) {
            ConsoleLogger.log("ExportPackageWorker >> No need to add license to package");
            return null;
        }
        String fileName = info.getOptExportedLicenseFileName();
        String licenseContent = info.getOptLicenseFileContent();
        if (licenseContent != null && licenseContent.trim().length() > 0) {
            try {
                File licenseFile = new File(exportPath + File.separator + fileName);
                Utility.writeContentToFileEx((File)licenseFile, (String)licenseContent);
                this.licenseFileName = fileName;
                ConsoleLogger.log("ExportPackageWorker>> addPaidLicense " + this.licenseFileName);
                result = fileName;
            }
            catch (Exception e) {
                ConsoleLogger.log("ExportPackageWorker>> addPaidLicense: Fail to write paid licesne to file");
                ConsoleLogger.log(e);
                String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.exportLicenseErrorMsg");
                throw new Exception(msg);
            }
        } else {
            ConsoleLogger.log("ExportPackageWorker>> no paid license is added ");
        }
        return result;
    }

    protected void addConnectionFile(String exportPath) throws ConsoleException {
        String salt = "{2DEA8527-95A0-49CF-897C-AF4155106F6C}";
        PresharedSecret ps = DataobjectManager.getInstance().getSemConfigRoot().getOptPresharedSecret();
        if (ps == null) {
            return;
        }
        String kcs = ps.getSecretHash();
        String tempFile = exportPath + File.separator + "connect.dat";
        try {
            String connectionInfo = GUIManager.getCloudConnectionInfo(Manager.getCurrentDomainId());
            byte[] kcsBytes = kcs.getBytes(Charset.defaultCharset());
            byte[] saltBytes = "{2DEA8527-95A0-49CF-897C-AF4155106F6C}".getBytes(Charset.defaultCharset());
            Utility.writeContentToFile((File)new File(tempFile), (String)Utility.encryptProfileValue((String)connectionInfo, (byte[])Utility.getProfileKey((byte[])kcsBytes, (byte[])saltBytes), (String)GUIDGenerator.getInstance().getGUIDString()));
        }
        catch (IOException exc) {
            throw new ConsoleException(exc);
        }
        catch (GeneralSecurityException exc) {
            throw new ConsoleException(exc);
        }
    }

    protected boolean doExportToGroups() {
        TimeCounter counter = new TimeCounter();
        counter.start();
        System.out.println("ExportPackageWorker: " + counter.toString());
        ArrayList<String> listGroups = this.settings.getGroups();
        this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.prepareMsg"), true, true, 0);
        if (listGroups == null || listGroups.size() < 1) {
            this.showMsgBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.noGroupSelectedMsg"), true);
            return false;
        }
        SemClientGroup groupGlobal = null;
        try {
            DataobjectManager data = DataobjectManager.getInstance();
            SemDomain domain = (SemDomain)data.getObjectByGUID("SemDomain", Manager.getCurrentDomainId());
            String groupTreeId = domain.getObjReference().getTargetId();
            SemClientGroupTree tree = (SemClientGroupTree)DataobjectManager.getInstance().getObjectByGUID("SemClientGroupTree", groupTreeId);
            groupGlobal = tree.getSemClientGroup();
        }
        catch (ConsoleException ex) {
            System.out.println("ExportPackageWorker>> deExportToGroups: Exception while retrieving global group");
            Object[] obj = new Object[]{GroupHandler.getGlobalGroupName(), ex.getMessage()};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.failedToRetrieveGlobalGroupInfoFromServerMsg");
            String fm = MessageFormat.format(str, obj);
            this.showMsgBox(fm, true);
            this.needRelogin = ex.needRelogin();
            LoggerUtilities.logException((Throwable)ex);
            return false;
        }
        System.out.println("ExportPackageWorker: after group " + counter.toString());
        if (this.isCancelled()) {
            return false;
        }
        int groupCount = listGroups.size();
        double maxProgressStepPerGroup = (double)this.getMaxValue() / (double)groupCount;
        for (int i = 0; i < listGroups.size(); ++i) {
            Object[] obj1;
            String idGroup = listGroups.get(i);
            GroupObject groupObj = null;
            if (groupGlobal.getId().equals(idGroup)) {
                groupObj = new GroupObject(groupGlobal);
            } else {
                try {
                    groupObj = GroupHandler.getGroupById(groupGlobal, idGroup);
                }
                catch (ConsoleException ex) {
                    Object[] obj = new Object[]{ex.getMessage()};
                    String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.failedToRetrieveGroupInfoFromServerMsg");
                    String fm = MessageFormat.format(str, obj);
                    System.out.println("ExportPackageWorker>> deExportToGroups: Exception while retrieving group id=" + idGroup);
                    this.showMsgBox(fm, true);
                    this.needRelogin = ex.needRelogin();
                    LoggerUtilities.logException((Throwable)ex);
                    return false;
                }
            }
            System.out.println("ExportPackageWorker: after groupObj " + counter.toString());
            Object[] obj = new Object[]{GroupHandler.getGroupFullPath(groupObj)};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.msgWorkingOnGroup");
            String fm = MessageFormat.format(str, obj);
            this.setProgressMsg(null, fm, true, true, -1);
            if (this.isCancelled()) {
                return false;
            }
            try {
                if (!this.doExportToGroup(groupObj, false, maxProgressStepPerGroup) && !this.isCancelled()) {
                    System.out.println("ExportPackageWorker>> deExportToGroups: Error-> Failed to export to group=" + groupObj.getName());
                    String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.msgExportPackageGroupFailed");
                    obj1 = new Object[]{groupObj.getName()};
                    String fmt = MessageFormat.format(msg, obj1);
                    this.setProgressMsg(null, fmt, true, true, -1);
                    this.showMsgBox(fmt, true);
                    return false;
                }
                System.out.println("ExportPackageWorker: after doexport " + counter.toString());
                continue;
            }
            catch (ServerNotReadyForExportException ex) {
                System.out.println("Reporting export failure as export package not yet created under client package");
                LoggerUtilities.logException((Throwable)ex);
                Utility.deleteDir((String)this.exportFullPath);
                this.showMsgBox(ex.getMessage(), true);
                return false;
            }
            catch (Exception e) {
                System.out.println("ExportPackageWorker>> deExportToGroups: Error-> Failed to export to group=" + groupObj.getName());
                LoggerUtilities.logException((Throwable)e);
                Utility.deleteDir((String)this.exportFullPath);
                obj1 = new Object[]{groupObj.getName()};
                String str1 = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.msgFailedtoExportToGroup");
                String fm1 = MessageFormat.format(str1, obj1);
                this.setProgressMsg(null, fm1, true, true, -1);
                Object[] obj2 = new Object[]{groupObj.getName(), groupObj.getId()};
                String str2 = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.msgTryUsingGroupID");
                String fm2 = MessageFormat.format(str2, obj2);
                this.setProgressMsg(null, fm2, true, true, -1);
                try {
                    if (this.doExportToGroup(groupObj, true, maxProgressStepPerGroup)) continue;
                    System.out.println("ExportPackageWorker>> deExportToGroups: Error-> Failed to export to group=" + groupObj.getName());
                    return false;
                }
                catch (Exception exception) {
                    System.out.println("ExportPackageWorker>> deExportToGroups: Error-> Failed to export to group=" + groupObj.getName());
                    this.showMsgBox(exception.getMessage(), true);
                    return false;
                }
            }
        }
        counter.stop();
        this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.finishMsg"), true, true, 10);
        this.setFinishMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.completedSuccessfullyMsg"));
        return true;
    }

    protected boolean copyPackageFiles(String sourceDir, String targetDir) {
        if (!Utility.copyDir((String)sourceDir, (String)targetDir, (boolean)false)) {
            this.showMsgBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.failedToCopyMsg"), true);
            return false;
        }
        return true;
    }

    protected boolean retrieveZipPackagePhysicalFile() throws Exception {
        return this.retrievePackagePhysicalFile(true);
    }

    protected boolean retrievePackagePhysicalFile(boolean singleFile) {
        PackageInfo packageInfo = this.packageObj.getPackageInfo();
        if (packageInfo == null) {
            this.showMsgBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.failedToRetrievePackageInforFromServerMsg"), true);
            return false;
        }
        ConsoleLogger.log("ExportPackageWorker >> retrievePackagePhysicalFile, package name: " + this.packageObj.getName() + ", isSecurityFix: " + this.packageObj.isSecurityFixContent() + ", ProductBuildNum: " + packageInfo.getOptProductBuildNum() + ", checksum: " + packageInfo.getChecksum() + ", version: " + packageInfo.getVersion());
        int result = SoftwarePackageHandler.getFileByChecksum(packageInfo.getChecksum(), singleFile, false, this);
        int count = 0;
        int retries = 6;
        try {
            retries = Integer.parseInt(ScmProperties.get("scm.server.probegroupdir.threshold", String.valueOf(6)));
        }
        catch (Exception e) {
            retries = 6;
        }
        boolean isReadyMsg = false;
        while (result != 1 && result != 9 && count < retries && result != 200) {
            result = SoftwarePackageHandler.getFileByChecksum(packageInfo.getChecksum(), singleFile, true, this);
            if (!isReadyMsg) {
                ConsoleLogger.log(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "SoftwarePackageHandler.waitingForServer"));
                this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "SoftwarePackageHandler.waitingForServer"), false, true, 0);
                isReadyMsg = true;
            }
            Utility.threadSleep((int)10);
            ++count;
        }
        if (result != 1) {
            this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.msgExportPackageFailedforGroup"), true, true, -1);
            this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "SoftwarePackageHandler.ServerNotReady"), true, true, 0);
            return false;
        }
        return true;
    }

    protected boolean retrieveAndUnzipPackagePhysicalFile(boolean singleFile) throws Exception {
        if (!this.retrievePackagePhysicalFile(singleFile)) {
            return false;
        }
        if (this.isCancelled()) {
            return false;
        }
        if (!singleFile) {
            String packageFolder = SoftwarePackageHandler.getPackageCacheFolder(this.settings);
            String srcFolder = packageFolder + File.separator + this.packageObj.getPackageInfo().getChecksum() + File.separator + "FULL";
            return Utility.copyDir((String)srcFolder, (String)this.exportFullPath, (boolean)true);
        }
        String srcPackage = SoftwarePackageHandler.getPackageCacheFolder(this.settings) + File.separator + this.packageObj.getPackageInfo().getChecksum() + File.separator + "FULL.ZIP";
        String ptEXEFile = NativeCommandUtilities.buildConsoleExe("SEPMPackageTool.exe") + File.separator + "SEPMPackageTool.exe";
        ArrayList<String> arr = new ArrayList<String>();
        arr.add("packlist.xml");
        arr.add("sylink.xml");
        arr.add("setAid.ini");
        arr.add("setup.ini");
        String version = this.packageObj.getVersion(true);
        if (Utility.compareVersion((String)version, (String)"12.0") > 0) {
            arr.add("VDefs.zip");
            arr.add("BashDefs.zip");
            arr.add("IDSDefs.zip");
            arr.add("STICDefs.zip");
            arr.add("SMRDefs.zip");
            arr.add("EDRDefs.zip");
            arr.add("NTRDefs.zip");
            arr.add("TDADDefs.zip");
            arr.add("ACDefs.zip");
            arr.add("SEFDefs.zip");
        } else {
            arr.add("VDefHub.zip");
            arr.add("IPSDef.zip");
        }
        String[] file_filter = arr.toArray(new String[0]);
        StringBuffer logbuffer = new StringBuffer();
        return ZipUtil.runBT((char)'d', (String)srcPackage, null, (String)this.exportFullPath, (String[])file_filter, (String)ptEXEFile, (StringBuffer)logbuffer);
    }

    protected void removeVdefandIpsZips(String srcFolder) {
        String srcVdef = srcFolder + File.separator + "VDefHub.zip";
        String srcIPSdef = srcFolder + File.separator + "IPSDef.zip";
        Utility.removeFileFromDir((String)srcVdef, (String)this.exportFullPath);
        Utility.removeFileFromDir((String)srcIPSdef, (String)this.exportFullPath);
    }

    protected String generateCommunicationExportFullPathForGroup(GroupObject groupObj) {
        return this.getFullPathForSepCommunicationUpdater(this.exportDir, groupObj.getSemClientGroup());
    }

    protected String generateExportFullPathForGroup(GroupObject groupObj, String osForExport) {
        return ExportPackageWorker.generateExportFullPathForGroup(this.packageObj, this.exportDir, groupObj, osForExport);
    }

    protected String generateExportFullPath(GroupObject groupObj, boolean isGroupID, String osForExport) throws Exception {
        String path = this.generateExportFullPathForGroup(groupObj, osForExport);
        if (isGroupID) {
            Utility.emptyDir((String)path, (boolean)true);
            StringBuffer buf = new StringBuffer();
            buf.append(this.exportDir);
            if (!this.exportDir.endsWith(File.separator)) {
                buf.append(File.separator);
            }
            String dir = groupObj.getId();
            buf.append(dir);
            if (this.packageObj != null) {
                buf.append("_");
                buf.append(this.packageObj.getPackageInfo().getOptPlatformType());
                buf.append(File.separator);
                buf.append(this.packageObj.getClientPackageDisplayString(true));
            }
            path = buf.toString();
        }
        if (path == null || path.length() <= 0) {
            throw new Exception(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.pathInvalidMsg"));
        }
        return path;
    }

    protected boolean isSMBProduct() {
        return LicenseObject.getInstance().isSBProduct();
    }

    protected boolean isSNACProductSupported() {
        LicenseObject lObj = LicenseObject.getInstance();
        return lObj.isSNACOnlyProduct() || lObj.isALLProduct();
    }

    protected boolean selectManagementServerForGroup(GroupObject groupObj) {
        boolean result = true;
        if (this.serverList.getName().equals(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.DefPolicyManagerListNameForNoSite"))) {
            this.serverList = this.serverListMap.get(groupObj.getId());
            if (this.serverList == null) {
                this.serverList = this.commonServerList;
                if (this.serverList == null) {
                    SelectDefaultMgmtServerDlg serverDlg = new SelectDefaultMgmtServerDlg(groupObj);
                    if (serverDlg.isCancel()) {
                        return false;
                    }
                    this.serverList = serverDlg.getSemServerList();
                    if (this.serverList == null) {
                        return false;
                    }
                    this.serverListMap.put(groupObj.getId(), this.serverList);
                    if (serverDlg.isYesToAll()) {
                        this.commonServerList = this.serverList;
                    }
                }
            }
        }
        return result;
    }

    @Override
    protected void createDlg(SwingWorker worker, String title, String msg) {
        super.createDlg(worker, title, msg);
        if (this.progressListener instanceof InProgressDlg) {
            ((InProgressDlg)this.progressListener).setStopWarningMsg(MSG_RES.getString("ExportPackageWorker.stopWarningTitle"), MSG_RES.getString("ExportPackageWorker.stopWarningMsg"));
        }
    }

    public ExportPackageSettings getSettings() {
        return this.settings;
    }
}

