/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.AjaxSwingManager;
import com.sygate.scm.console.handler.GroupHandler;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.handler.SoftwarePackageHandler;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.ui.client.ExportPackageSettings;
import com.sygate.scm.console.ui.client.ExportPackageWorker;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.NativeCommandUtilities;
import com.sygate.scm.util.ConstantValue;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.MacPackageFormatHelper;
import com.sygate.scm.util.PackageUtil;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import com.sygate.scm.util.ZipUtil;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;

public class ExportMacPackageWorker
extends ExportPackageWorker {
    public static final String MAC_EXPORT_XML_CFG_REG = "^(.*\\.mpkg)[\\\\|/].*";

    public ExportMacPackageWorker(ExportPackageSettings settings) {
        super(settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doExportDefault() {
        this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.prepareMsg"), true, true, 0);
        String osForExport = this.settings.isMac1015OrUp() ? ConstantValue.getMacExportPath((String)this.packageObj.getPackageInfo().getVersion()) : "";
        this.exportFullPath = ExportMacPackageWorker.generateExportFullPathForDefault(this.packageObj, this.exportDir, osForExport);
        boolean ret = false;
        try {
            if (this.doGeneralExportToGroup(null, 10.0)) {
                this.setFinishMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.CompletedSuccessfullyMsg"));
                ret = true;
            } else if (!this.isCancelled()) {
                this.setFinishMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.errorHappenedMsg"));
            }
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
            System.out.println("ExportPackageWorker>> doExportDefault: Error-> Failed to export default package.");
            this.showMsgBox(e.getMessage(), true);
            this.setFinishMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.errorHappenedMsg"));
        }
        finally {
            this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.finishMsg"), true, true, 10);
        }
        return ret;
    }

    @Override
    protected boolean doExportToGroup(GroupObject groupObj, Boolean isGroupID, double maxProgressStepPerGroup) throws Exception {
        String osForExport = this.settings.isMac1015OrUp() ? ConstantValue.getMacExportPath((String)this.packageObj.getPackageInfo().getVersion()) : "";
        this.exportFullPath = this.generateExportFullPath(groupObj, isGroupID, osForExport);
        return this.doGeneralExportToGroup(groupObj, maxProgressStepPerGroup);
    }

    private boolean doGeneralExportToGroup(GroupObject groupObj, double maxProgressStepPerGroup) throws Exception {
        int totalSubSteps = 6;
        double increment = maxProgressStepPerGroup / (double)totalSubSteps;
        double currentProgressValue = this.getProgressValue();
        boolean isManaged = this.settings.isManaged();
        if (isManaged && groupObj == null) {
            groupObj = GroupHandler.getDefaultGroupObject();
        }
        Object[] obj = new Object[]{this.exportFullPath};
        String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.creatFolderMsg");
        String fm = MessageFormat.format(str, obj);
        currentProgressValue += increment;
        if (!AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            this.setProgressMsg(null, fm, false, true, (int)currentProgressValue);
        }
        if (this.isCancelled()) {
            return false;
        }
        if (!this.createExportDir(this.exportFullPath)) {
            str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.failedToCreateExportPath");
            fm = MessageFormat.format(str, obj);
            throw new Exception(fm);
        }
        this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.retrievingPackageDataFromServerMsg"), false, true, (int)(currentProgressValue += increment));
        if (this.isCancelled()) {
            return false;
        }
        System.out.println(Utility.getPerformanceLog((String)"custom deployment", (String)"get pacakge from server", (boolean)true));
        if (!this.retrieveZipPackagePhysicalFile()) {
            throw new Exception(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportMacPackageWorker.retrieveZipPackageFaild"));
        }
        System.out.println(Utility.getPerformanceLog((String)"custom deployment", (String)"get pacakge from server", (boolean)false));
        if (this.isCancelled()) {
            return false;
        }
        String srcFilePath = SoftwarePackageHandler.getPackageCacheFolder(this.settings) + File.separator + this.packageObj.getPackageInfo().getChecksum() + File.separator + "FULL.ZIP";
        MacPackageFormatHelper pkgFmtHelper = new MacPackageFormatHelper(srcFilePath);
        if (pkgFmtHelper.isInvalidPackage()) {
            this.showMsgBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportMacPackageWorker.unknownMacCIP"), true);
            return false;
        }
        String pkgName = pkgFmtHelper.getPackageName();
        if (StringUtilities.isEmpty((String)pkgName)) {
            throw new Exception(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportMacPackageWorker.retrieveZipPackageFaild"));
        }
        String targetFilePath = this.exportFullPath + File.separator + "FULL.ZIP";
        String toolPath = NativeCommandUtilities.buildConsoleExe("SEPMPackageTool.exe") + File.separator + "SEPMPackageTool.exe";
        this.addFileToCleanUpList(toolPath);
        String configFile = pkgFmtHelper.getConfigFilePath(true);
        String profileFile = pkgFmtHelper.getProfileFilePath(true);
        String setAidIni = pkgFmtHelper.getSetAidIni(true);
        String virusDefs = pkgFmtHelper.getVirusDefsPath(true);
        String plugins = pkgFmtHelper.getPlugins(true);
        String[] filesToExtract = null;
        filesToExtract = this.settings.isExcludeContent() ? new String[]{profileFile, configFile, virusDefs, plugins, setAidIni} : new String[]{profileFile, configFile, plugins, setAidIni};
        PackageUtil.extractFilesFromZipFile((String)srcFilePath, null, (String)this.exportFullPath, (String[])pkgFmtHelper.getFilesToExtract(filesToExtract), (String)toolPath);
        String tempFullZipPath = this.exportFullPath + File.separator + "FULL.ZIP";
        if (!Utility.isFileReadable((String)tempFullZipPath)) {
            throw new Exception(tempFullZipPath + "does not exist!");
        }
        String configFilePath = this.exportFullPath + File.separator + pkgFmtHelper.getConfigDirPath(true);
        int result = Utility.createDir((String)configFilePath);
        if (result != 0) {
            System.out.println("Failed to create folder: " + configFilePath + " Result: " + result);
            return false;
        }
        String preferredGroup = null;
        boolean modifySylinkSucceed = false;
        if (isManaged) {
            GroupPolicyObject groupPolicy;
            this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.retrievingGroupServerListMsg"), false, true, (int)(currentProgressValue += increment));
            if (this.isCancelled()) {
                return false;
            }
            this.serverList = this.retrieveGroupServerList(groupObj);
            if (!this.selectManagementServerForGroup(groupObj)) {
                return false;
            }
            this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.modifyingConfigFileMsg"), false, true, (int)(currentProgressValue += increment));
            if (this.isCancelled()) {
                return false;
            }
            preferredGroup = GroupHandler.getGroupFullPath(groupObj);
            modifySylinkSucceed = this.modifyConfigXmlForExportEx(preferredGroup, this.serverList, configFilePath, groupPolicy = PolicyHandler.getGroupPolicyByGroup(groupObj), isManaged);
            if (!modifySylinkSucceed) {
                throw new Exception(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportMacPackageWorker.modifyConfigXMLFaild"));
            }
        }
        boolean modifySetAidSuccess = PackageUtil.modifySetAidIniMac((String)configFilePath, (boolean)this.settings.isKeepAllDataOnUpgrade());
        System.out.println("Status of update setAid.ini " + modifySetAidSuccess);
        String licenseFile = this.addPaidLicense(configFilePath, this.packageObj.getPackageInfo().getType());
        File profile = new File(this.exportFullPath + File.separator + profileFile);
        currentProgressValue += increment;
        if (groupObj != null) {
            this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.retrievingGroupProfileFromServer"), false, true, (int)currentProgressValue);
            if (this.isCancelled()) {
                return false;
            }
            if (profile.exists()) {
                Utility.deleteFile((String)profile.getAbsolutePath());
            }
            if (!this.retrieveGroupProfile(groupObj, this.packageObj, configFilePath, preferredGroup, this.agentMode)) {
                return false;
            }
        }
        String[] archive_filter = null;
        ArrayList<Object> filterList = new ArrayList<Object>();
        if (isManaged) {
            filterList.add(configFile);
        }
        filterList.add(profileFile);
        filterList.add(setAidIni);
        if (licenseFile != null) {
            String licensePath = pkgFmtHelper.getConfigDirPath(true) + File.separator + licenseFile;
            filterList.add(licensePath);
        }
        Object[] archiveFilterObj = filterList.toArray();
        archive_filter = new String[archiveFilterObj.length];
        System.arraycopy(archiveFilterObj, 0, archive_filter, 0, archiveFilterObj.length);
        if (!PackageUtil.putFilesToZipFile((String)targetFilePath, (String)this.exportFullPath, (String)this.exportFullPath, (String[])pkgFmtHelper.getFilesToAdd(archive_filter, filesToExtract, this.exportFullPath), (String)toolPath)) {
            return false;
        }
        String newFilename = this.exportFullPath + File.separator + pkgFmtHelper.getInstallationArchiveName() + ".zip";
        if (this.settings.isMac1015OrUp()) {
            ConsoleLogger.log("Start to extract package for mac 10.15.");
            String packageFolder = SoftwarePackageHandler.getPackageCacheFolder(this.settings);
            String extractFolder = packageFolder + File.separator + "extract" + GUIDGenerator.getInstance().getGUIDString();
            File extFolder = new File(extractFolder);
            if (!extFolder.exists()) {
                if (!extFolder.mkdirs()) {
                    ConsoleLogger.log("Fail to create folder to extract package for mac 10.15.");
                    return false;
                }
                ConsoleLogger.log("Created folder to extract package for mac 10.15.");
                if (ZipUtil.unzipFile((String)targetFilePath, (String)extractFolder)) {
                    Utility.deleteFile((String)targetFilePath);
                    HashMap<String, Integer> fileNameAndPermission = new HashMap<String, Integer>();
                    fileNameAndPermission.put("Symantec Endpoint Protection Installer", 493);
                    fileNameAndPermission.put("preinstall", 493);
                    fileNameAndPermission.put("postinstall", 493);
                    ZipUtil.zipFileWithPermission((String)extractFolder, (String)newFilename, fileNameAndPermission);
                }
                ConsoleLogger.log("Finish to extract package for mac 10.15.");
            }
        } else {
            this.renameZipFile(targetFilePath, newFilename);
        }
        Utility.deleteDir((String)(this.exportFullPath + File.separator + pkgName));
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            this.clientExportZipFilePath = newFilename;
            AjaxSwingManager.endOperation();
        }
        this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.finishingMsg"), false, false, (int)(currentProgressValue += increment));
        return true;
    }

    private boolean renameZipFile(String originalFileName, String targetFileName) {
        File originalFile = new File(originalFileName);
        File targetFile = new File(targetFileName);
        if (targetFile.exists()) {
            Utility.deleteFile((String)targetFileName);
        }
        return originalFile.renameTo(targetFile);
    }
}

