/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.AjaxSwingManager;
import com.sygate.scm.console.handler.GroupHandler;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.handler.SoftwarePackageHandler;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.ui.client.ExportLinuxPackageWorker;
import com.sygate.scm.console.ui.client.ExportPackageSettings;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.NativeCommandUtilities;
import com.sygate.scm.util.LinuxPackageFormatHelper;
import com.sygate.scm.util.PackageUtil;
import com.sygate.scm.util.Utility;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.MessageFormat;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public class ExportLinuxStubPackageWorker
extends ExportLinuxPackageWorker {
    private static final String LINUX_INSTALLER = "LinuxInstaller";
    private static final String MANIFEST = "manifest";

    public ExportLinuxStubPackageWorker(ExportPackageSettings settings) {
        super(settings);
    }

    @Override
    protected boolean doExportDefault() {
        super.showMsgBox(UIUtilities.NOT_SUPPORTED_ON_NEW_LINUX_TIP, true);
        return false;
    }

    @Override
    protected boolean doExportToGroup(GroupObject groupObj, Boolean isGroupID, double maxProgressStepPerGroup) throws Exception {
        this.exportFullPath = super.generateExportFullPath(groupObj, isGroupID, "");
        return this.doGeneralExportToGroup(groupObj, maxProgressStepPerGroup);
    }

    private boolean doGeneralExportToGroup(GroupObject groupObj, double maxProgressStepPerGroup) throws Exception {
        String[] packageFiles;
        int totalSubSteps = 6;
        double increment = maxProgressStepPerGroup / 6.0;
        double currentProgressValue = this.getProgressValue();
        boolean isManaged = this.settings.isManaged();
        if (isManaged && groupObj == null) {
            groupObj = GroupHandler.getDefaultGroupObject();
        }
        if (groupObj == null) {
            super.showMsgBox(UIUtilities.NOT_SUPPORTED_ON_NEW_LINUX_TIP, true);
            return false;
        }
        Object[] obj = new Object[]{this.exportFullPath};
        String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.creatFolderMsg");
        String fm = MessageFormat.format(str, obj);
        currentProgressValue += increment;
        if (!AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            this.setProgressMsg(null, fm, false, true, (int)currentProgressValue);
        }
        if (this.isCancelled()) {
            return false;
        }
        if (!this.createExportDir(this.exportFullPath)) {
            str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.failedToCreateExportPath");
            fm = MessageFormat.format(str, obj);
            throw new Exception(fm);
        }
        this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.retrievingPackageDataFromServerMsg"), false, true, (int)(currentProgressValue += increment));
        if (this.isCancelled()) {
            return false;
        }
        ConsoleLogger.log(Utility.getPerformanceLog((String)"custom deployment", (String)"get package from server", (boolean)true));
        if (!super.retrieveZipPackagePhysicalFile()) {
            throw new Exception(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportLinuxPackageWorker.retrieveZipPackageFaild"));
        }
        ConsoleLogger.log(Utility.getPerformanceLog((String)"custom deployment", (String)"get pacakge from server", (boolean)false));
        if (this.isCancelled()) {
            return false;
        }
        String srcFilePath = SoftwarePackageHandler.getPackageCacheFolder(this.settings) + File.separator + this.packageObj.getPackageInfo().getChecksum() + File.separator + "FULL.ZIP";
        LinuxPackageFormatHelper linuxPackageFormatHelper = new LinuxPackageFormatHelper(srcFilePath);
        if (linuxPackageFormatHelper.isInvalidPackage()) {
            this.showMsgBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportLinuxPackageWorker.unknownLinuxCIP"), true);
            return false;
        }
        String toolPath = NativeCommandUtilities.buildConsoleExe("SEPMPackageTool.exe") + File.separator + "SEPMPackageTool.exe";
        super.addFileToCleanUpList(toolPath);
        String sylinkFile = linuxPackageFormatHelper.getSylinkFilePath();
        PackageUtil.extractFilesFromZipFile((String)srcFilePath, null, (String)this.exportFullPath, (String[])new String[]{sylinkFile, LINUX_INSTALLER, MANIFEST}, (String)toolPath);
        String preferredGroup = null;
        boolean modifySylinkFileSucceed = false;
        if (isManaged) {
            this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.retrievingGroupServerListMsg"), false, true, (int)(currentProgressValue += increment));
            if (this.isCancelled()) {
                return false;
            }
            this.serverList = super.retrieveGroupServerList(groupObj);
            if (!super.selectManagementServerForGroup(groupObj)) {
                return false;
            }
            this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.modifyingConfigFileMsg"), false, true, (int)(currentProgressValue += increment));
            if (this.isCancelled()) {
                return false;
            }
        } else {
            super.showMsgBox(UIUtilities.NOT_SUPPORTED_ON_NEW_LINUX_TIP, true);
            return false;
        }
        preferredGroup = GroupHandler.getGroupFullPath(groupObj);
        GroupPolicyObject groupPolicyObject = PolicyHandler.getGroupPolicyByGroup(groupObj);
        modifySylinkFileSucceed = super.modifyConfigXmlForExportEx(preferredGroup, this.serverList, this.exportFullPath, groupPolicyObject, isManaged);
        if (!modifySylinkFileSucceed) {
            throw new Exception(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportLinuxPackageWorker.modifyConfigXMLFaild"));
        }
        String licenseFile = super.addPaidLicense(this.exportFullPath, this.packageObj.getPackageInfo().getType());
        this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.retrievingGroupProfileFromServer"), false, true, (int)(currentProgressValue += increment));
        if (this.isCancelled()) {
            return false;
        }
        if (!super.retrieveGroupProfile(groupObj, this.packageObj, this.exportFullPath, preferredGroup, this.agentMode)) {
            return false;
        }
        String linuxInstallerPath = this.exportFullPath + File.separator + LINUX_INSTALLER;
        if (!this.addFilesToLinuxInstaller(linuxInstallerPath, packageFiles = new String[]{sylinkFile, "serdef.dat", licenseFile, MANIFEST})) {
            return false;
        }
        Utility.delete((String)(this.exportFullPath + File.separator + "FULL.ZIP"));
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            this.clientExportZipFilePath = linuxInstallerPath;
            AjaxSwingManager.endOperation();
        }
        this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.finishingMsg"), false, false, (int)(currentProgressValue += increment));
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean addFilesToLinuxInstaller(String linuxInstaller, String[] packageFiles) {
        try (FileOutputStream fos = new FileOutputStream(linuxInstaller, true);
             BufferedOutputStream bos = new BufferedOutputStream(fos);
             GZIPOutputStream gos = new GZIPOutputStream(bos);
             TarArchiveOutputStream tarArchive = new TarArchiveOutputStream((OutputStream)gos);){
            String[] stringArray = packageFiles;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                Path manifestPath;
                boolean isSuccess;
                String fileName = stringArray[n2];
                String filePath = this.exportFullPath + File.separator + fileName;
                if (fileName.equals(MANIFEST) && !(isSuccess = this.removeCarriageReturn(manifestPath = Paths.get(filePath, new String[0])))) {
                    ConsoleLogger.log("Not able to replace the Carrige Return from the manifest file");
                    boolean bl = false;
                    return bl;
                }
                File file = new File(filePath);
                tarArchive.putArchiveEntry(new TarArchiveEntry(file, fileName));
                try (FileInputStream fis = new FileInputStream(file);
                     BufferedInputStream bis = new BufferedInputStream(fis);){
                    IOUtils.copy((InputStream)bis, (OutputStream)tarArchive);
                    tarArchive.closeArchiveEntry();
                }
                Utility.delete((File)file);
                ++n2;
            }
            return true;
        }
        catch (IOException ex) {
            ConsoleLogger.log(ex.getMessage());
            return false;
        }
    }

    private boolean removeCarriageReturn(Path manifestPath) throws IOException {
        String content = Files.readString(manifestPath, StandardCharsets.UTF_8);
        content = content.replace("\r", "");
        Files.delete(manifestPath);
        boolean isFileCreated = manifestPath.toFile().createNewFile();
        if (isFileCreated) {
            Files.writeString(manifestPath, (CharSequence)content, StandardCharsets.UTF_8, StandardOpenOption.WRITE);
            return true;
        }
        return false;
    }
}

