/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.AjaxSwingManager;
import com.sygate.scm.console.handler.GroupHandler;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.handler.SoftwarePackageHandler;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.ui.client.ExportPackageSettings;
import com.sygate.scm.console.ui.client.ExportPackageWorker;
import com.sygate.scm.console.ui.client.PackageWorker;
import com.sygate.scm.console.util.NativeCommandUtilities;
import com.sygate.scm.util.LinuxPackageFormatHelper;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.PackageUtil;
import com.sygate.scm.util.Utility;
import java.io.File;
import java.text.MessageFormat;

public class ExportLinuxPackageWorker
extends ExportPackageWorker {
    public ExportLinuxPackageWorker(ExportPackageSettings settings) {
        super(settings);
    }

    @Override
    protected boolean doExportDefault() {
        super.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.prepareMsg"), true, true, 0);
        this.exportFullPath = PackageWorker.generateExportFullPathForDefault(this.packageObj, this.exportDir, "");
        boolean ret = false;
        try {
            if (this.doGeneralExportToGroup(null, 10.0)) {
                super.setFinishMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.CompletedSuccessfullyMsg"));
                ret = true;
            } else if (!this.isCancelled()) {
                super.setFinishMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.errorHappenedMsg"));
            }
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
            System.out.println("ExportPackageWorker>> doExportDefault: Error-> Failed to export default package.");
            super.showMsgBox(e.getMessage(), true);
            super.setFinishMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.errorHappenedMsg"));
        }
        finally {
            super.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.finishMsg"), true, true, 10);
        }
        return ret;
    }

    @Override
    protected boolean doExportToGroup(GroupObject groupObj, Boolean isGroupID, double maxProgressStepPerGroup) throws Exception {
        this.exportFullPath = super.generateExportFullPath(groupObj, isGroupID, "");
        return this.doGeneralExportToGroup(groupObj, maxProgressStepPerGroup);
    }

    private boolean doGeneralExportToGroup(GroupObject groupObj, double maxProgressStepPerGroup) throws Exception {
        int totalSubSteps = 6;
        double increment = maxProgressStepPerGroup / (double)totalSubSteps;
        double currentProgressValue = this.getProgressValue();
        boolean isManaged = this.settings.isManaged();
        if (isManaged && groupObj == null) {
            groupObj = GroupHandler.getDefaultGroupObject();
        }
        Object[] obj = new Object[]{this.exportFullPath};
        String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.creatFolderMsg");
        String fm = MessageFormat.format(str, obj);
        currentProgressValue += increment;
        if (!AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            this.setProgressMsg(null, fm, false, true, (int)currentProgressValue);
        }
        if (this.isCancelled()) {
            return false;
        }
        if (!this.createExportDir(this.exportFullPath)) {
            str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.failedToCreateExportPath");
            fm = MessageFormat.format(str, obj);
            throw new Exception(fm);
        }
        this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.retrievingPackageDataFromServerMsg"), false, true, (int)(currentProgressValue += increment));
        if (this.isCancelled()) {
            return false;
        }
        System.out.println(Utility.getPerformanceLog((String)"custom deployment", (String)"get pacakge from server", (boolean)true));
        if (!super.retrieveZipPackagePhysicalFile()) {
            throw new Exception(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportLinuxPackageWorker.retrieveZipPackageFaild"));
        }
        System.out.println(Utility.getPerformanceLog((String)"custom deployment", (String)"get pacakge from server", (boolean)false));
        if (this.isCancelled()) {
            return false;
        }
        String srcFilePath = SoftwarePackageHandler.getPackageCacheFolder(this.settings) + File.separator + this.packageObj.getPackageInfo().getChecksum() + File.separator + "FULL.ZIP";
        LinuxPackageFormatHelper linuxPackageFormatHelper = new LinuxPackageFormatHelper(srcFilePath);
        if (linuxPackageFormatHelper.isInvalidPackage()) {
            this.showMsgBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportLinuxPackageWorker.unknownLinuxCIP"), true);
            return false;
        }
        String targetFilePath = this.exportFullPath + File.separator + "FULL.ZIP";
        String toolPath = NativeCommandUtilities.buildConsoleExe("SEPMPackageTool.exe") + File.separator + "SEPMPackageTool.exe";
        super.addFileToCleanUpList(toolPath);
        String sylinkFilePath = linuxPackageFormatHelper.getSylinkFilePath();
        String serDefDatFilePath = "Configuration" + File.separator + "serdef.dat";
        String licenseFilePath = "Configuration" + File.separator + "sep.slf";
        PackageUtil.extractFilesFromZipFile((String)srcFilePath, null, (String)this.exportFullPath, (String[])new String[]{sylinkFilePath, serDefDatFilePath, licenseFilePath}, (String)toolPath);
        String sylinkFileAndProfileFileDirPath = this.exportFullPath + File.separator + "Configuration";
        String preferredGroup = null;
        boolean modifySylinkFileSucceed = false;
        if (isManaged) {
            this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.retrievingGroupServerListMsg"), false, true, (int)(currentProgressValue += increment));
            if (this.isCancelled()) {
                return false;
            }
            this.serverList = super.retrieveGroupServerList(groupObj);
            if (!super.selectManagementServerForGroup(groupObj)) {
                return false;
            }
            this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.modifyingConfigFileMsg"), false, true, (int)(currentProgressValue += increment));
            if (this.isCancelled()) {
                return false;
            }
            preferredGroup = GroupHandler.getGroupFullPath(groupObj);
            GroupPolicyObject groupPolicyObject = PolicyHandler.getGroupPolicyByGroup(groupObj);
            modifySylinkFileSucceed = super.modifyConfigXmlForExportEx(preferredGroup, this.serverList, sylinkFileAndProfileFileDirPath, groupPolicyObject, isManaged);
        } else {
            this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.modifyingConfigFileMsg"), false, true, (int)(currentProgressValue += 2.0 * increment));
            if (this.isCancelled()) {
                return false;
            }
            modifySylinkFileSucceed = super.modifyConfigXmlForExportUnmanaged(sylinkFileAndProfileFileDirPath);
        }
        if (!modifySylinkFileSucceed) {
            throw new Exception(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportLinuxPackageWorker.modifyConfigXMLFaild"));
        }
        String licenseFileName = super.addPaidLicense(sylinkFileAndProfileFileDirPath, this.packageObj.getPackageInfo().getType());
        currentProgressValue += increment;
        if (groupObj != null) {
            this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.retrievingGroupProfileFromServer"), false, true, (int)currentProgressValue);
            if (this.isCancelled()) {
                return false;
            }
            if (!super.retrieveGroupProfile(groupObj, this.packageObj, sylinkFileAndProfileFileDirPath, preferredGroup, this.agentMode)) {
                return false;
            }
        }
        String[] archiveFileFilter = null;
        archiveFileFilter = licenseFileName != null ? new String[]{sylinkFilePath, serDefDatFilePath, licenseFilePath} : new String[]{sylinkFilePath, serDefDatFilePath};
        if (!PackageUtil.putFilesToZipFile((String)targetFilePath, (String)this.exportFullPath, (String)this.exportFullPath, (String[])archiveFileFilter, (String)toolPath)) {
            return false;
        }
        String newFilename = this.exportFullPath + File.separator + "SymantecEndpointProtection.zip";
        this.renameZipFile(targetFilePath, newFilename);
        Utility.deleteDir((String)(this.exportFullPath + File.separator + "Configuration"));
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            this.clientExportZipFilePath = newFilename;
            AjaxSwingManager.endOperation();
        }
        this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ExportPackageWorker.finishingMsg"), false, false, (int)(currentProgressValue += increment));
        return true;
    }

    private boolean renameZipFile(String originalFileName, String targetFileName) {
        File originalFile = new File(originalFileName);
        File targetFile = new File(targetFileName);
        if (targetFile.exists()) {
            Utility.deleteFile((String)targetFileName);
        }
        return originalFile.renameTo(targetFile);
    }
}

