/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.client.ClientComputersTablePanel;
import com.sygate.scm.console.ui.client.ClientViewTableModel;
import com.sygate.scm.console.ui.util.SortableTableModel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class CustomViewSortableTableModel
extends SortableTableModel {
    private static final long serialVersionUID = 6283013264847251759L;
    private ClientViewTableModel customModel;
    private SortMouseAdapter mouseListener = null;

    public CustomViewSortableTableModel(boolean isCaseSensitive) {
        super(isCaseSensitive);
    }

    public void setCCTModel(ClientViewTableModel cctModel) {
        this.customModel = cctModel;
    }

    private ClientViewTableModel getCustomModel() {
        return this.customModel;
    }

    private void sortTable(int sortModelColOrder, int sortViewColOrder, boolean isAscending) {
        try {
            this.customModel.setSortModelColOrder(sortModelColOrder);
            this.customModel.setSortViewColOrder(sortViewColOrder);
            this.customModel.setSortDir(isAscending);
            this.customModel.getPanelHandle().sort();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
        }
        this.fireTableDataChanged();
    }

    @Override
    public void addMouseListenerToHeaderInTable(JTable table) {
        CustomViewSortableTableModel sorter = this;
        JTable tableView = table;
        tableView.setColumnSelectionAllowed(false);
        JTableHeader th = tableView.getTableHeader();
        if (this.mouseListener != null) {
            th.removeMouseListener(this.mouseListener);
        }
        this.mouseListener = new SortMouseAdapter(sorter, table);
        th.addMouseListener(this.mouseListener);
        this.mouseListener.setResource(table, sorter);
    }

    protected class SortMouseAdapter
    extends MouseAdapter {
        private JTable sortTableView;
        private CustomViewSortableTableModel sorter;

        public SortMouseAdapter(CustomViewSortableTableModel sorter, JTable tableView) {
            this.sorter = sorter;
            this.sortTableView = tableView;
        }

        public void setResource(JTable tableView, CustomViewSortableTableModel sorter) {
            this.sortTableView = tableView;
            this.sorter = sorter;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TableColumn column;
            String columnName;
            CustomViewSortableTableModel.this.customModel = (ClientViewTableModel)this.sortTableView.getModel();
            TableColumnModel colModel = ((JTableHeader)e.getSource()).getColumnModel();
            int columnViewIndex = colModel.getColumnIndexAtX(e.getX());
            int columnModelIndex = this.sortTableView.convertColumnIndexToModel(columnViewIndex);
            if (CustomViewSortableTableModel.this.customModel.getViewType() == 2 && ((columnName = (String)(column = colModel.getColumn(columnViewIndex)).getHeaderValue()).equalsIgnoreCase(ClientComputersTablePanel.IPS_DEFINITIONS) || columnName.equalsIgnoreCase(ClientComputersTablePanel.DOWNLOAD_PROTECTION_DEFINITIONS) || columnName.equalsIgnoreCase(ClientComputersTablePanel.SORNA_DEFINITIONS) || columnName.equalsIgnoreCase(ClientComputersTablePanel.EDR_DEFINITIONS) || columnName.equalsIgnoreCase(ClientComputersTablePanel.WTR_DEFINITIONS) || columnName.equalsIgnoreCase(ClientComputersTablePanel.TDAD_DEFINITIONS))) {
                return;
            }
            if (e.getClickCount() != 1 || columnModelIndex < 0 || CustomViewSortableTableModel.this.getDataVector() == null || !this.sortTableView.isEnabled()) {
                return;
            }
            int lastSortModelOrder = this.sorter.getCustomModel().getSortModelColOrder();
            boolean lastSortIsAscending = this.sorter.getCustomModel().isSortDir();
            if (lastSortModelOrder == columnModelIndex) {
                this.sorter.sortTable(columnModelIndex, columnViewIndex, !lastSortIsAscending);
            } else {
                this.sorter.sortTable(columnModelIndex, columnViewIndex, lastSortIsAscending);
            }
        }
    }
}

