/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.client.ClientCustomTableModel;
import com.sygate.scm.console.ui.util.SortableTableModel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class CustomSortableTableModel
extends SortableTableModel {
    private static final long serialVersionUID = 1L;
    private ClientCustomTableModel customModel;

    public CustomSortableTableModel(boolean isCaseSensitive) {
        this.sortedColumn = -1;
    }

    public void setCCTModel(ClientCustomTableModel cctModel) {
        this.customModel = cctModel;
    }

    public CustomSortableTableModel(String[] columnNames, int[] columnMapping) {
        super(columnNames, columnMapping);
        this.sortedColumn = -1;
    }

    @Override
    public void sortTable(int column, boolean switchDir) {
        try {
            this.customModel.setSortOrder(column);
            this.isAscending = !this.isAscending;
            this.customModel.setSortDir(this.isAscending);
            this.sortedColumn = column;
            this.customModel.getPanelHandle().putClientProperty("cssClass", "customSortableTablesortTable");
            this.customModel.getPanelHandle().sort();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
        }
        this.fireTableDataChanged();
    }

    @Override
    public void addMouseListenerToHeaderInTable(JTable table) {
        CustomSortableTableModel sorter = this;
        JTable tableView = table;
        tableView.setColumnSelectionAllowed(false);
        MouseSortingAdapter listMouseListener = new MouseSortingAdapter(tableView, sorter);
        JTableHeader th = tableView.getTableHeader();
        th.putClientProperty("cssClass", "customSortableTablejTableHeader");
        MouseListener[] mls = th.getMouseListeners();
        for (int i = 0; i < mls.length; ++i) {
            if (!(mls[i] instanceof MouseSortingAdapter)) continue;
            th.removeMouseListener(mls[i]);
        }
        th.addMouseListener(listMouseListener);
    }

    @Override
    public int getSortedColumn() {
        return this.sortedColumn;
    }

    static class MouseSortingAdapter
    extends MouseAdapter {
        JTable tableView;
        CustomSortableTableModel sorter;

        MouseSortingAdapter(JTable table, CustomSortableTableModel sortModel) {
            this.tableView = table;
            this.sorter = sortModel;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TableColumnModel colModel = this.tableView.getColumnModel();
            int columnViewIndex = colModel.getColumnIndexAtX(e.getX());
            int columnModelIndex = this.tableView.convertColumnIndexToModel(columnViewIndex);
            if (e.getClickCount() != 1 || columnModelIndex < 0 || !this.tableView.isEnabled()) {
                return;
            }
            if (this.sorter.sortedColumn == columnModelIndex) {
                this.sorter.sortTable(columnModelIndex, false);
            } else {
                this.sorter.sortTable(columnModelIndex, true);
            }
        }
    }
}

