/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client;

import com.sygate.scm.common.acl.AdminACLUtils;
import com.sygate.scm.common.acl.AuthorizationManager;
import com.sygate.scm.common.acl.Permission;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.PackageInfo;
import com.sygate.scm.common.configobject.schema.PackageLuInfo;
import com.sygate.scm.common.configobject.schema.SemAdministrator;
import com.sygate.scm.common.configobject.schema.SemClientGroup;
import com.sygate.scm.common.configobject.schema.SemClientGroupTree;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.AjaxSwingManager;
import com.sygate.scm.common.ui.ClientAgent;
import com.sygate.scm.common.ui.HtmlEnabledJList;
import com.sygate.scm.common.ui.MultiLineLabel;
import com.sygate.scm.common.util.AdminUtils;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.AdminHandler;
import com.sygate.scm.console.handler.GroupHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.SoftwarePackageHandler;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.CurrentPackageObject;
import com.sygate.scm.console.logicobject.DomainObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.SoftwarePackageObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.client.CreateNewPackageWorker;
import com.sygate.scm.console.ui.client.ExportPackageWorkerFacotry;
import com.sygate.scm.console.ui.client.PackageSortableTableModel;
import com.sygate.scm.console.ui.client.PackageWorker;
import com.sygate.scm.console.ui.client.PlatformIconNameCellRenderer;
import com.sygate.scm.console.ui.client.dlg.CreateNewSoftwareDlg;
import com.sygate.scm.console.ui.client.dlg.ExportPackagDlgFactory;
import com.sygate.scm.console.ui.client.dlg.ExportPackageDlg;
import com.sygate.scm.console.ui.client.dlg.PackagePropertyDlg;
import com.sygate.scm.console.ui.util.AniStripPanel;
import com.sygate.scm.console.ui.util.DefaultTableRow;
import com.sygate.scm.console.ui.util.ListMessageBox;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.SwingWorkerExecutor;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.UiTableUtils;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.Env;
import com.sygate.scm.console.util.ExceptionHandler;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.ErrorMsg;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.URLUtility;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.lang.invoke.CallSite;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class CurrentPackageTablePanel
extends JPanel
implements ListSelectionListener {
    private static final long serialVersionUID = 7386716707628681410L;
    private static Logger logger = Logger.getLogger(CurrentPackageTablePanel.class.getName());
    private static final String AUTOMATION_PACKAGE_TABLE = "PackageTable";
    private static final String AUTOMATION_PACKAGE_ADD = "PackageAdd";
    private static final String AUTOMATION_PACKAGE_EXPORT = "PackageExport";
    private static final String AUTOMATION_PACKAGE_DELETE = "PackageDelete";
    private static final String AUTOMATION_PACKAGE_PROPERTIES = "PackageProperties";
    private static final String AUTOMATION_PACKAGE_COLUMN_NAME = "ColumnPackageName";
    private static final MessageResources clientRes = MessageResources.getInstance();
    private static final String CLIENT_RES = "com.sygate.scm.console.ui.client.client";
    private static final String I18N_ERR_MESSAGE_TITLE = clientRes.getString("com.sygate.scm.console.ui.client.client", "CurrentPackageTablePanel.error");
    private static final String I18N_CONSOLE_ERROR = clientRes.getString("com.sygate.scm.console.ui.client.client", "CurrentPackageTablePanel.consoleError");
    private JScrollPane deployPanel = new JScrollPane();
    private JScrollPane packagePanel = new JScrollPane();
    private transient SwingWorker<List<String>, Void> searchThread = null;
    private AniStripPanel panelSearchAni = new AniStripPanel();
    protected static final String[] COL_NAMES = new String[]{clientRes.getString("com.sygate.scm.console.ui.client.client", "CurrentPackageTablePanel.packageNameCName"), clientRes.getString("com.sygate.scm.console.ui.client.client", "CurrentPackageTablePanel.platformType"), clientRes.getString("com.sygate.scm.console.ui.client.client", "CurrentPackageTablePanel.packageTypeCName"), clientRes.getString("com.sygate.scm.console.ui.client.client", "CurrentPackageTablePanel.sizeCName"), clientRes.getString("com.sygate.scm.console.ui.client.client", "CurrentPackageTablePanel.latestUpdate")};
    private static final Map<String, String> LEGACY_PRODUCT_NAME_MAP = Map.of("SPC AntiVirus Client LINUX", "SESM AntiVirus Linux Client");
    private static final Map<String, String> LEGACY_PLATFORM_NAME_MAP = Map.of("LINUXRPM", "LINUXSTUB", "LINUXDPKG", "LINUXSTUB");
    private static final float[] COL_DIMENSIONS = new float[]{0.36f, 0.08f, 0.1f, 0.06f, 0.4f};
    private PackageSortableTableModel packageModel = new PackageSortableTableModel();
    private JTable packageTable = new StripesTable(true, true);
    private Object packageTableSyncLock = new Object();
    private int mCurSelectedRow = -1;
    private JMenuItem newMenuItem = new JMenuItem(clientRes.getString("com.sygate.scm.console.ui.client.client", "CurrentPackageTablePanel.addDotMenu"));
    private JMenuItem exportMenuItem = new JMenuItem(clientRes.getString("com.sygate.scm.console.ui.client.client", "CurrentPackageTablePanel.exportPackageMenu"));
    private JMenuItem deleteMenuItem = new JMenuItem(clientRes.getString("com.sygate.scm.console.ui.client.client", "CurrentPackageTablePanel.deletePackageMenu"));
    private JMenuItem propertiesMenuItem = new JMenuItem(clientRes.getString("com.sygate.scm.console.ui.client.client", "CurrentPackageTablePanel.propertiesMenu"));
    private JPopupMenu popup = new JPopupMenu();
    private HtmlEnabledJList deployList = new HtmlEnabledJList();
    private DefaultListModel<Object> deployListModel = null;
    private static final int LINK_COLUMN = 0;
    public static final int VERSION_COLUMN = 3;
    private int lastSelectedRow = -1;
    private boolean readOnly;

    public CurrentPackageTablePanel(boolean readOnly) {
        this.readOnly = readOnly;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
        }
    }

    public SortableTableModel getModel() {
        return this.packageModel;
    }

    private void jbInit() throws Exception {
        UIUtilities.setName(this, "packageManagement", UIUtilities.ComponentType.JPANEL, AUTOMATION_PACKAGE_TABLE);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.packagePanel, new GridBagConstraints(0, 1, 1, 3, 1.0, 3.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.packagePanel.getViewport().add(this.packageTable);
        this.packagePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CurrentPackageTablePanel.this.maybeShowPopup(e);
            }
        });
        this.add((Component)this.deployPanel, new GridBagConstraints(0, 4, 1, 3, 1.0, 3.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.deployListModel = new DefaultListModel();
        this.deployList.setModel(this.deployListModel);
        this.deployPanel.getViewport().add((Component)this.deployList, null);
        this.packageModel.setColumnNames(COL_NAMES);
        this.packageModel.setEditMode(false);
        this.packageTable.setModel(this.packageModel);
        this.packageModel.addMouseListenerToHeaderInTable(this.packageTable);
        TableColumn linkColumn = this.packageTable.getColumnModel().getColumn(0);
        linkColumn.setCellRenderer(new HyperLinkCellRenderer());
        this.packageTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent me) {
                int colAtPoint = CurrentPackageTablePanel.this.packageTable.columnAtPoint(new Point(me.getX(), me.getY()));
                int modelColumnAtPoint = CurrentPackageTablePanel.this.packageTable.convertColumnIndexToModel(colAtPoint);
                int rowAtPoint = CurrentPackageTablePanel.this.packageTable.rowAtPoint(new Point(me.getX(), me.getY()));
                String urlString = CurrentPackageTablePanel.this.getPatchLinkURL(rowAtPoint);
                if (modelColumnAtPoint == 0 && urlString != null && urlString.trim().length() > 0) {
                    CurrentPackageTablePanel.this.packageTable.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    CurrentPackageTablePanel.this.packageTable.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        this.packageTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int colAtPoint = CurrentPackageTablePanel.this.packageTable.columnAtPoint(new Point(e.getX(), e.getY()));
                int modelColumnAtPoint = CurrentPackageTablePanel.this.packageTable.convertColumnIndexToModel(colAtPoint);
                int rowAtPoint = CurrentPackageTablePanel.this.packageTable.rowAtPoint(new Point(e.getX(), e.getY()));
                String urlString = CurrentPackageTablePanel.this.getPatchLinkURL(rowAtPoint);
                if (e.getClickCount() >= 2) {
                    CurrentPackageTablePanel.this.propertiesMenuItemActionPerformed();
                } else if (modelColumnAtPoint == 0 && rowAtPoint == CurrentPackageTablePanel.this.lastSelectedRow && urlString != null && urlString.trim().length() > 0) {
                    URLUtility.showURL((String)urlString);
                    return;
                }
                CurrentPackageTablePanel.this.lastSelectedRow = rowAtPoint;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                CurrentPackageTablePanel.this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                CurrentPackageTablePanel.this.maybeShowPopup(e);
            }
        });
        this.packageTable.setSelectionMode(2);
        this.setColumnRenderers(this.packageTable);
        this.setPrefferedColumnSizeForTables(this.packageTable);
        ListSelectionModel selectionModel = this.packageTable.getSelectionModel();
        selectionModel.addListSelectionListener(this);
        this.setupPopupMenu();
        this.setupSearchAniPanel();
    }

    private int[] getSelectedRows(boolean forceSelection, MouseEvent e) {
        int[] rows = null;
        boolean ctrlKeyPressed = (e.getModifiers() & 2) != 0;
        Point clickedPoint = e.getPoint();
        rows = this.packageTable.getSelectedRows();
        if (forceSelection && clickedPoint != null) {
            int row = this.packageTable.rowAtPoint(clickedPoint);
            int column = this.packageTable.columnAtPoint(clickedPoint);
            if (row != -1 && this.outOfRange(row, rows) && !ctrlKeyPressed && e.isPopupTrigger()) {
                rows = new int[]{row};
                this.packageTable.changeSelection(rows[0], 0, false, false);
                this.packageTable.editCellAt(rows[0], column);
            }
            if ((rows = this.packageTable.getSelectedRows()).length == 1) {
                this.packageTable.changeSelection(rows[0], column, false, false);
                this.packageTable.editCellAt(rows[0], column);
            }
        }
        return rows;
    }

    private boolean outOfRange(int row, int[] rows) {
        boolean outOfRange = true;
        if (rows != null) {
            for (int row2 : rows) {
                if (row != row2) continue;
                outOfRange = false;
                break;
            }
        }
        return outOfRange;
    }

    public boolean isSelectedPackagesExportable() {
        return this.isExportable(this.getSelectedPackaged());
    }

    private boolean isExportable(CurrentPackageObject cpo) {
        if (cpo == null) {
            return false;
        }
        SoftwarePackageObject spo = cpo.getSoftwarePackageObject();
        int packageType = spo.getPackageType();
        return packageType != 300 && packageType != 301;
    }

    private void maybeShowPopup(MouseEvent e) {
        int count = this.packageTable.getSelectedRowCount();
        if (!e.isPopupTrigger() && e.getButton() == 1) {
            this.newMenuItem.setEnabled(false);
            this.exportMenuItem.setEnabled(false);
            this.deleteMenuItem.setEnabled(false);
            this.propertiesMenuItem.setEnabled(false);
            return;
        }
        this.getSelectedRows(true, e);
        if (!this.readOnly) {
            this.newMenuItem.setEnabled(true);
            PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
            if (AuthorizationManager.getInstance().checkPermission(context, (Permission)AuthorizationManager.SpecialPermission.ONE_GROUP_FULL_ACCESS) && this.isExportable(this.getSelectedPackaged())) {
                this.exportMenuItem.setEnabled(count == 1);
            } else {
                this.exportMenuItem.setEnabled(false);
            }
        } else {
            this.newMenuItem.setEnabled(false);
            this.exportMenuItem.setEnabled(false);
        }
        this.deleteMenuItem.setEnabled(this.isSelectedPackagesDeletable());
        this.propertiesMenuItem.setEnabled(count == 1);
        this.popup.show(e.getComponent(), e.getX(), e.getY());
    }

    public boolean isSelectedPackagesDeletable() {
        DataobjectManager manager = DataobjectManager.getInstance();
        if (!AdminUtils.isLimitedAdmin((SemAdministrator)manager.getCurrentAdministrator())) {
            return true;
        }
        return this.isDeletable(this.readOnly, this.packageTable.getSelectedRowCount(), this.getSelectedPackageIds());
    }

    private List<String> getSelectedPackageIds() {
        int[] rowSelected = this.packageTable.getSelectedRows();
        ArrayList<String> result = new ArrayList<String>();
        for (int rowIndex : rowSelected) {
            result.add(((CurrentPackageObject)this.packageModel.getRow(rowIndex)).getId());
        }
        return result;
    }

    private boolean isDeletable(boolean readOnly, int selectedRowCount, List<String> selectedPackageIds) {
        SemClientGroupTree groupTree;
        if (readOnly || selectedRowCount <= 0) {
            return false;
        }
        DataobjectManager manager = DataobjectManager.getInstance();
        PrivilegeContext context = manager.getCurrentPrivilegeContext();
        HashSet<String> relatedGroupIds = new HashSet<String>();
        for (String packageId : selectedPackageIds) {
            Map<String, String> groupMap = null;
            try {
                groupMap = manager.getGroupPathsMapByPackageId(packageId);
            }
            catch (ConsoleException e) {
                ConsoleLogger.log(e);
            }
            if (groupMap == null) continue;
            relatedGroupIds.addAll(groupMap.keySet());
        }
        if (relatedGroupIds.size() == 0) {
            return true;
        }
        try {
            groupTree = manager.getCurrentClientGroupTree();
        }
        catch (ConsoleException e) {
            ConsoleLogger.log(e);
            AuthorizationManager aManager = AuthorizationManager.getInstance();
            return aManager.checkPermission(context, (Permission)AuthorizationManager.PackagePermission.FULL_ACCESS);
        }
        return AdminACLUtils.hasAllFullAccessPermission((PrivilegeContext)context, (SemClientGroup)groupTree.getSemClientGroup(), relatedGroupIds);
    }

    private void setPrefferedColumnSizeForTables(JTable table) {
        UIUtilities.setTableColumnWidth(table, COL_DIMENSIONS, (int)table.getPreferredScrollableViewportSize().getWidth());
    }

    private void setupSearchAniPanel() {
        if (!this.panelSearchAni.isInit()) {
            ConsoleLogger.log("** panelSearchAni init For Search **");
            this.panelSearchAni.init(ConsoleMain.class, "searchani.gif", 8, false);
        }
        this.panelSearchAni.setBackground(this.deployList.getBackground());
    }

    private void setupPopupMenu() {
        this.newMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CurrentPackageTablePanel.this.newMenuItemActionPerformed();
            }
        });
        UIUtilities.setName(this.newMenuItem, "packageManagement", UIUtilities.ComponentType.JMENUITEM, AUTOMATION_PACKAGE_ADD);
        this.popup.add(this.newMenuItem);
        this.exportMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CurrentPackageTablePanel.this.exportMenuItemActionPerformed();
            }
        });
        UIUtilities.setName(this.exportMenuItem, "packageManagement", UIUtilities.ComponentType.JMENUITEM, AUTOMATION_PACKAGE_EXPORT);
        this.popup.add(this.exportMenuItem);
        this.deleteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CurrentPackageTablePanel.this.deleteMenuItemActionPerformed();
            }
        });
        UIUtilities.setName(this.deleteMenuItem, "packageManagement", UIUtilities.ComponentType.JMENUITEM, AUTOMATION_PACKAGE_DELETE);
        this.popup.add(this.deleteMenuItem);
        this.popup.add(new JSeparator());
        this.propertiesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CurrentPackageTablePanel.this.propertiesMenuItemActionPerformed();
            }
        });
        UIUtilities.setName(this.propertiesMenuItem, "packageManagement", UIUtilities.ComponentType.JMENUITEM, AUTOMATION_PACKAGE_PROPERTIES);
        this.popup.add(this.propertiesMenuItem);
        if (this.readOnly) {
            this.newMenuItem.setEnabled(false);
            this.deleteMenuItem.setEnabled(false);
        }
    }

    private void setupTable(CurrentPackageObject cpo, boolean exportPackage) {
        ListSelectionListener[] selectionListener;
        DefaultListSelectionModel selectionModel = (DefaultListSelectionModel)this.packageTable.getSelectionModel();
        for (ListSelectionListener element : selectionListener = selectionModel.getListSelectionListeners()) {
            selectionModel.removeListSelectionListener(element);
        }
        int[] colWidth = UiTableUtils.getTableColumnWidths(this.packageTable);
        this.packageModel.removeAll();
        SortableTableModel tempModel = new SortableTableModel();
        String text = MessageResources.getInstance().getString(CLIENT_RES, "ClientPanel.loadingMsg");
        Vector<Object> rowData = new Vector<Object>();
        rowData.add(text);
        DefaultTableRow tableRow = new DefaultTableRow(rowData);
        tempModel.addRow(tableRow);
        this.packageTable.setModel(tempModel);
        PackageTableSetupWorker swingWorkerHistory = this.createWorker(cpo, this.packageModel, this.packageTable, selectionModel, selectionListener, colWidth, exportPackage);
        SwingWorkerExecutor.getInstance().execute(swingWorkerHistory);
    }

    PackageTableSetupWorker createWorker(CurrentPackageObject cpo, PackageSortableTableModel packageModel, JTable packageTable, DefaultListSelectionModel selectionModel, ListSelectionListener[] selectionListener, int[] colWidth, boolean exportPackage) {
        return new PackageTableSetupWorker(cpo, packageModel, packageTable, selectionModel, selectionListener, colWidth, exportPackage);
    }

    public void refresh(Object item) {
        this.setupTable(null, false);
    }

    private void newMenuItemActionPerformed() {
        this.doNewPackage();
    }

    public void doNewPackage() {
        CreateNewSoftwareDlg dlg = new CreateNewSoftwareDlg(clientRes.getString(CLIENT_RES, "CurrentPackageTablePanel.addNewPackageMsg"), null);
        if (dlg.isOk()) {
            CurrentPackageObject cpo = dlg.generateCurrentPackageObject();
            CreateNewPackageWorker worker = new CreateNewPackageWorker(cpo);
            worker.setExportBtnVisible(true);
            worker.begin();
            if (worker.isCreateDone()) {
                this.setupTable(cpo, worker.isRequestExport());
            }
            if (worker.needRelogin()) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ErrorMsg.getMessage((int)7), I18N_CONSOLE_ERROR, 0);
                Manager.getFrame().showLoginPanel();
            }
        }
        dlg.dispose();
    }

    private void exportMenuItemActionPerformed() {
        this.doExport();
    }

    public boolean isMacPackage() {
        CurrentPackageObject cpo = this.getSelectedPackaged();
        if (cpo == null) {
            return false;
        }
        SoftwarePackageObject spo = cpo.getSoftwarePackageObject();
        return spo.isMacNormalPackage();
    }

    public void doExport() {
        try {
            if (this.packageTable.getSelectedRowCount() > 1) {
                JOptionPane.showMessageDialog(Manager.getFrame(), clientRes.getString(CLIENT_RES, "CurrentPackageTablePanel.selectOnlyOnePackageToExportMsg"), I18N_ERR_MESSAGE_TITLE, 0);
                return;
            }
            int row = this.packageTable.getSelectedRow();
            if (row < 0) {
                String msg = clientRes.getString(CLIENT_RES, "CurrentPackageTablePanel.selectThePackageToExportMsg");
                JOptionPane.showMessageDialog(Manager.getFrame(), msg, I18N_ERR_MESSAGE_TITLE, 0);
                return;
            }
            CurrentPackageObject cpo = this.getSelectedPackaged();
            if (cpo == null) {
                return;
            }
            SoftwarePackageObject spo = cpo.getSoftwarePackageObject();
            PackageWorker worker = null;
            ExportPackageDlg dlg = ExportPackagDlgFactory.getInstance().getExportPackageDlg(cpo, clientRes.getString(CLIENT_RES, "CurrentPackageTablePanel.exportPackageTitle") + " " + spo.getName(), this.readOnly);
            if (dlg.isOk()) {
                AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> {
                    AjaxSwingManager.beginOperation();
                    File exportFolder = new File(Utility.getTempDir() + File.separator + Env.getWebConsoleIndex());
                    String zipFileName = "setup_" + Env.getWebConsoleIndex() + "_" + spo.getId() + ".zip";
                    Env.setCurrentPackageZipName(zipFileName);
                    if (exportFolder.exists()) {
                        Utility.emptyDir((String)exportFolder.getAbsolutePath(), (boolean)false);
                    }
                });
                worker = ExportPackageWorkerFacotry.getInstance().getExportPackageWorker(dlg.getExportPackageSettings());
                if (worker != null) {
                    worker.begin();
                } else {
                    JOptionPane.showMessageDialog(Manager.getFrame(), clientRes.getString(CLIENT_RES, "CurrentPackageTablePanel.invalidPkgInfoError"), clientRes.getString(CLIENT_RES, "CurrentPackageTablePanel.packageError"), 0);
                }
            }
            dlg.dispose();
            if (worker != null && worker.needRelogin()) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ErrorMsg.getMessage((int)7), I18N_CONSOLE_ERROR, 0);
                Manager.getFrame().showLoginPanel();
            }
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), I18N_CONSOLE_ERROR, 0);
            if (ex.needRelogin()) {
                Manager.getFrame().showLoginPanel();
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    private void deleteMenuItemActionPerformed() {
        this.doDeletePackages();
    }

    public void doDeletePackages() {
        block7: {
            int[] rows = this.packageTable.getSelectedRows();
            if (rows == null || rows.length == 0) {
                String msg = clientRes.getString(CLIENT_RES, "CurrentPackageTablePanel.selectPackagesToDelete");
                JOptionPane.showMessageDialog(Manager.getFrame(), msg, I18N_ERR_MESSAGE_TITLE, 0);
                return;
            }
            try {
                String msg = rows.length == 1 ? clientRes.getString(CLIENT_RES, "CurrentPackageTablePanel.deleteSelectedPackage") : clientRes.getString(CLIENT_RES, "CurrentPackageTablePanel.deleteSelectedPackages");
                MultiLineLabel multiL = new MultiLineLabel(msg);
                if (0 != JOptionPane.showConfirmDialog(Manager.getFrame(), multiL, clientRes.getString(CLIENT_RES, "CurrentPackageTablePanel.warningDialogTitle"), 0)) {
                    return;
                }
                for (int row : rows) {
                    Map<DomainObject, List<String>> groupsMap;
                    TableRow tableRow = this.packageModel.getRow(row);
                    CurrentPackageObject cpo = (CurrentPackageObject)tableRow;
                    if (this.isLatestPackageWithPVLCheck(row, true, true)) {
                        String pkgName = cpo.getSoftwarePackage().getName();
                        String str = clientRes.getString(CLIENT_RES, "CurrentPackageTablePanel.cantDeleteLatestPackage");
                        str = MessageFormat.format(str, pkgName);
                        JOptionPane.showMessageDialog(Manager.getFrame(), str, clientRes.getString(CLIENT_RES, "SoftwareUpdatePanel.error"), 0);
                        continue;
                    }
                    if (this.isLatestPackageWithPVLCheck(row, false, true)) {
                        String str = clientRes.getString(CLIENT_RES, "CurrentPackageTablePanel.cantDeleteLatestPackageWarning");
                        MultiLineLabel msg_panel = new MultiLineLabel(str = MessageFormat.format(str, cpo.getSoftwarePackage().getName(), cpo.getPackagePlatformString(), cpo.getSoftwarePackageObject().getLanguageDisplayString()), 50);
                        int ret = JOptionPane.showConfirmDialog(Manager.frame, msg_panel, clientRes.getString(CLIENT_RES, "SoftwareUpdatePanel.warning"), 2, 2);
                        if (2 == ret) continue;
                    }
                    if (!this.canDeleteDeployedPackageForOtherDomain(cpo) || !this.checkDeployedPackageForDelete(cpo, groupsMap = this.getDeployedGroupsByPackage(cpo))) continue;
                    this.deleteSoftwareDeploymentEntities(cpo, groupsMap);
                    SoftwarePackageHandler.delPackage(cpo);
                }
                this.setupTable(null, false);
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), I18N_CONSOLE_ERROR, 0);
                if (!ex.needRelogin()) break block7;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    public void deleteSoftwareDeploymentEntities(CurrentPackageObject cpo, Map<DomainObject, List<String>> groupsMap) throws ConsoleException {
        if (groupsMap.size() > 0) {
            String packageId = cpo.getId();
            Set<Map.Entry<DomainObject, List<String>>> groupSet = groupsMap.entrySet();
            for (Map.Entry<DomainObject, List<String>> domainGroups : groupSet) {
                List<String> groupsInDomain = domainGroups.getValue();
                String domainId = domainGroups.getKey().getId();
                for (String fullGroupPath : groupsInDomain) {
                    GroupObject group = GroupHandler.getGroupByFullPathForDomain(fullGroupPath, domainId);
                    SoftwarePackageHandler.deleteSoftwareDeploymentEntity(group, packageId);
                }
            }
        }
    }

    public boolean canDeleteDeployedPackageForOtherDomain(CurrentPackageObject cpo) {
        boolean canDelete = true;
        AdminObject currentAdmin = new AdminObject(DataobjectManager.getInstance().getCurrentAdministrator());
        if (!currentAdmin.isSysAdmin()) {
            try {
                GUIManager.checkDeleteObject((TopLevelObject)cpo.getSoftwarePackage(), null, Manager.getCurrentDomainId());
            }
            catch (ConsoleException ce) {
                String pkgName = cpo.getSoftwarePackage().getName();
                String str = clientRes.getString(CLIENT_RES, "CurrentPackageTablePanel.cantDeleteExistInOtherDomain");
                str = MessageFormat.format(str, pkgName);
                JOptionPane.showMessageDialog(Manager.getFrame(), str, clientRes.getString(CLIENT_RES, "SoftwareUpdatePanel.error"), 0);
                canDelete = false;
            }
        }
        return canDelete;
    }

    public Map<DomainObject, List<String>> getDeployedGroupsByPackage(CurrentPackageObject cpo) throws ConsoleException {
        List<DomainObject> domainList;
        String packageId = cpo.getId();
        AdminObject currentAdmin = new AdminObject(DataobjectManager.getInstance().getCurrentAdministrator());
        DomainObject currentDomain = new DomainObject(DataobjectManager.getInstance().getCurrentSemDomain());
        if (currentAdmin.isSysAdmin()) {
            domainList = AdminHandler.getDomainList();
        } else {
            domainList = new ArrayList<DomainObject>();
            domainList.add(currentDomain);
        }
        Iterator<DomainObject> iter = domainList.iterator();
        HashMap<DomainObject, List<String>> groupMap = new HashMap<DomainObject, List<String>>();
        while (iter.hasNext()) {
            ArrayList<String> groups = new ArrayList<String>();
            DomainObject domainObject = iter.next();
            List<String> list = DataobjectManager.getInstance().getGroupPathsByPackageId(packageId, domainObject.getId());
            if (list == null || list.size() < 1) continue;
            for (int i = 0; i < list.size(); ++i) {
                groups.add(list.get(i));
            }
            groupMap.put(domainObject, groups);
        }
        return groupMap;
    }

    protected boolean checkDeployedPackageForDelete(CurrentPackageObject cpo, Map<DomainObject, List<String>> groupMap) throws ConsoleException {
        boolean willToDelete = true;
        String str = clientRes.getString(CLIENT_RES, "CurrentPackageTablePanel.doYouWantToDeleteTheUpgradeMsg");
        String groupInStr = clientRes.getString(CLIENT_RES, "CurrentPackageTablePanel.groupIn");
        String domainStr = clientRes.getString(CLIENT_RES, "CurrentPackageTablePanel.domainAndColon");
        String fm = MessageFormat.format(str, cpo.getPackageName());
        if (groupMap.size() > 0) {
            ArrayList<CallSite> msgList = new ArrayList<CallSite>();
            Set<Map.Entry<DomainObject, List<String>>> groupSet = groupMap.entrySet();
            for (Map.Entry<DomainObject, List<String>> domainGroups : groupSet) {
                msgList.add((CallSite)((Object)("<html>" + groupInStr + " <b>" + domainGroups.getKey().getName() + "</b> " + domainStr + "</html>")));
                List<String> groupsInDomain = domainGroups.getValue();
                for (String group : groupsInDomain) {
                    msgList.add((CallSite)((Object)("   " + group)));
                }
            }
            ListMessageBox box = new ListMessageBox(Manager.getFrame(), 65, clientRes.getString(CLIENT_RES, "CurrentPackageTablePanel.warning"), fm, 0, 0, msgList);
            if (0 != box.show()) {
                willToDelete = false;
            }
        }
        return willToDelete;
    }

    public boolean isLatestPackageWithPVLCheck(int index, boolean ignoreLanguageCheck, boolean refreshObjectFromDb) throws ConsoleException {
        boolean result = true;
        DataobjectManager manager = DataobjectManager.getInstance();
        TableRow tableRow = this.packageModel.getRow(index);
        CurrentPackageObject thePackageObj = (CurrentPackageObject)tableRow;
        PackageInfo CurPackInf = thePackageObj.getSoftwarePackage().getPackageInfo();
        if (refreshObjectFromDb) {
            CurPackInf = manager.getSoftwarePackage(thePackageObj.getSoftwarePackage().getId()).getPackageInfo();
        }
        PackageLuInfo CurLUInfo = CurPackInf.getOptPackageLuInfo();
        String szCurProduct = Optional.ofNullable(LEGACY_PRODUCT_NAME_MAP.get(CurLUInfo.getServerProduct())).orElse(CurLUInfo.getServerProduct());
        String szCurLang = CurPackInf.getOptLanuage();
        if (CurPackInf.getOptPackageLuInfo() != null) {
            szCurLang = CurPackInf.getOptPackageLuInfo().getClientLanguage();
        }
        String szCurPlatform = Optional.ofNullable(LEGACY_PLATFORM_NAME_MAP.get(CurPackInf.getOptPlatformType())).orElse(CurPackInf.getOptPlatformType());
        String szCurVer = Boolean.TRUE.equals(CurPackInf.getOptSecurityFixPackage()) ? CurPackInf.getOptProductBuildNum() : CurPackInf.getVersion();
        ConsoleLogger.log("isLatestPackageWithPVLCheck>> szCurProduct: " + szCurProduct + ", szCurLang: " + szCurLang + ", szCurPlatform: " + szCurPlatform + ", szCurVer: " + szCurVer + ", ignoreLanguageCheck: " + ignoreLanguageCheck);
        int pkgNum = this.packageTable.getRowCount();
        for (int i = 0; i < pkgNum; ++i) {
            tableRow = this.packageModel.getRow(i);
            CurrentPackageObject packageObj = (CurrentPackageObject)tableRow;
            if (i == index) continue;
            PackageInfo packInf = packageObj.getSoftwarePackage().getPackageInfo();
            if (refreshObjectFromDb) {
                packInf = manager.getSoftwarePackage(packageObj.getSoftwarePackage().getId()).getPackageInfo();
            }
            PackageLuInfo luInfo = CurPackInf.getOptPackageLuInfo();
            String szProduct = Optional.ofNullable(LEGACY_PRODUCT_NAME_MAP.get(luInfo.getServerProduct())).orElse(luInfo.getServerProduct());
            String szLang = packInf.getOptLanuage();
            if (packInf.getOptPackageLuInfo() != null) {
                szLang = packInf.getOptPackageLuInfo().getClientLanguage();
            }
            String szPlatform = Optional.ofNullable(LEGACY_PLATFORM_NAME_MAP.get(packInf.getOptPlatformType())).orElse(packInf.getOptPlatformType());
            String szVer = Boolean.TRUE.equals(packInf.getOptSecurityFixPackage()) ? packInf.getOptProductBuildNum() : packInf.getVersion();
            ConsoleLogger.log("isLatestPackageWithPVLCheck>> szProduct: " + szProduct + ", szLang: " + szLang + ", szPlatform: " + szPlatform + ", szVer: " + szVer + ", ignoreLanguageCheck: " + ignoreLanguageCheck);
            if (!szCurProduct.equals(szProduct) || !ignoreLanguageCheck && !szCurLang.equals(szLang) || !szCurPlatform.equals(szPlatform) || Utility.compareVersion((String)szCurVer, (String)szVer) >= 0) continue;
            result = false;
            break;
        }
        ConsoleLogger.log("isLatestPackageWithPVLCheck>> result: " + result + ", ignoreLanguageCheck: " + ignoreLanguageCheck);
        return result;
    }

    private void propertiesMenuItemActionPerformed() {
        this.doProps();
    }

    public void doProps() {
        try {
            if (this.packageTable.getSelectedRowCount() > 1) {
                JOptionPane.showMessageDialog(Manager.getFrame(), clientRes.getString(CLIENT_RES, "CurrentPackageTablePanel.selectOnlyOneToSeePropertiesMsg"), clientRes.getString(CLIENT_RES, "CurrentPackageTablePanel.perperties"), 0);
                return;
            }
            int row = this.packageTable.getSelectedRow();
            if (row < 0) {
                String msg = clientRes.getString(CLIENT_RES, "CurrentPackageTablePanel.selectAPackageMsg");
                JOptionPane.showMessageDialog(Manager.getFrame(), msg, I18N_ERR_MESSAGE_TITLE, 0);
                return;
            }
            CurrentPackageObject cpo = this.getSelectedPackaged();
            if (cpo == null) {
                JOptionPane.showMessageDialog(Manager.getFrame(), clientRes.getString(CLIENT_RES, "CurrentPackageTablePanel.selectAPackageMsg"), I18N_ERR_MESSAGE_TITLE, 0);
                return;
            }
            PackagePropertyDlg dlg = new PackagePropertyDlg(cpo, true, this.readOnly);
            if (dlg.isOk()) {
                cpo.setName(dlg.getPackageName());
                cpo.setDescription(dlg.getDescription());
                SoftwarePackageHandler.updatePackage(cpo);
                ConsoleLogger.logAdminEvent(12295);
                if (dlg.isPackageNameChanged()) {
                    this.packageModel.sortTable(-1);
                    this.setSelection(cpo, true);
                }
            }
            dlg.dispose();
            this.packageTable.updateUI();
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), I18N_CONSOLE_ERROR, 0);
            if (ex.needRelogin()) {
                Manager.getFrame().showLoginPanel();
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    public void setSelection(CurrentPackageObject cpo, boolean reselect) {
        if (cpo == null) {
            return;
        }
        CurrentPackageObject row = null;
        if (!reselect && (row = this.getSelectedPackaged()) != null && row.getId().equals(cpo.getId())) {
            return;
        }
        this.packageTable.getSelectionModel().clearSelection();
        int count = this.packageModel.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = (CurrentPackageObject)this.packageModel.getRow(i);
            if (!row.getId().equals(cpo.getId())) continue;
            this.packageTable.setRowSelectionInterval(i, i);
            return;
        }
        ConsoleLogger.log("CurrentPackageTablePanel>> setSelection: Warning - NOT found package name=" + cpo.getPackageName() + ", id=" + cpo.getId());
    }

    public CurrentPackageObject getSelectedPackaged() {
        int rowSelected = this.packageTable.getSelectedRow();
        if (rowSelected < 0) {
            return null;
        }
        return (CurrentPackageObject)this.packageModel.getRow(rowSelected);
    }

    protected void showDeployListPanel(boolean show) {
        if (show) {
            this.panelSearchAni.stop();
        } else {
            this.deployListModel.removeAllElements();
        }
        this.doSearch();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e != null && e.getValueIsAdjusting()) {
            return;
        }
        if (this.packageTable.getSelectedRow() == this.mCurSelectedRow) {
            return;
        }
        this.mCurSelectedRow = this.packageTable.getSelectedRow();
        ConsoleLogger.log("CurrentPackagePanel>> valueChanged: mCurSelectedRow=" + this.mCurSelectedRow);
        this.doSearch();
    }

    void setListSelectionListener(ListSelectionListener listener) {
        ListSelectionModel selectionModel = this.packageTable.getSelectionModel();
        selectionModel.addListSelectionListener(listener);
    }

    boolean isPackageSelected() {
        return this.packageTable.getSelectedRow() > -1;
    }

    public void updateDeployList() {
        this.doSearch();
    }

    private synchronized void doSearch() {
        final CurrentPackageObject cpo = this.getSelectedPackaged();
        if (cpo == null) {
            return;
        }
        this.deployListModel.removeAllElements();
        String str = "<html>" + clientRes.getString(CLIENT_RES, "CurrentPackageTablePanel.theLoadingPackageDeploymentHTML") + "</html>";
        this.deployListModel.addElement(MessageFormat.format(str, cpo.getPackageName()));
        this.deployList.updateUI();
        if (this.searchThread != null && !this.searchThread.getState().equals((Object)SwingWorker.StateValue.DONE)) {
            this.searchThread.cancel(true);
        }
        this.searchThread = new SwingWorker<List<String>, Void>(){

            @Override
            protected List<String> doInBackground() throws ConsoleException {
                AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> ClientAgent.getCurrentInstance().setUpdateBrowserInterval(1));
                return GroupHandler.getGroupPathsByPackageId(cpo.getId());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                try {
                    List list = (List)this.get();
                    CurrentPackageTablePanel.this.deployListModel.removeAllElements();
                    if (list == null || list.size() < 1) {
                        String str = "<html>" + clientRes.getString(CurrentPackageTablePanel.CLIENT_RES, "CurrentPackageTablePanel.packageIsNotDeployedHTML") + "</html>";
                        CurrentPackageTablePanel.this.deployListModel.addElement(MessageFormat.format(str, cpo.getPackageName()));
                    } else {
                        String str = "<html>" + clientRes.getString(CurrentPackageTablePanel.CLIENT_RES, "CurrentPackageTablePanel.packageisBeingDeployedHTML") + "</html>";
                        CurrentPackageTablePanel.this.deployListModel.addElement(MessageFormat.format(str, cpo.getPackageName()));
                        for (String path : list) {
                            CurrentPackageTablePanel.this.deployListModel.addElement("<html><b>" + path + "</b></html>\n");
                        }
                    }
                    CurrentPackageTablePanel.this.deployList.updateUI();
                }
                catch (CancellationException ce) {
                    ExceptionHandler.handleCancellationException(ce);
                }
                catch (InterruptedException ex) {
                    ConsoleLogger.log("SearchDeploymentThread interrupted:" + ex.getMessage());
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException eex) {
                    this.handleExeption(eex);
                }
                finally {
                    AjaxSwingCommonUtil.updateSwingAgentBrowser((boolean)true, (int)0);
                }
            }

            private void handleExeption(Exception ex) {
                ConsoleLogger.log("SearchDeploymentThread>> run: Exception...");
                if (!Manager.isConsoleLogout()) {
                    ConsoleLogger.log(ex);
                    JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), I18N_CONSOLE_ERROR, 0);
                    String str = "<html>" + clientRes.getString(CurrentPackageTablePanel.CLIENT_RES, "CurrentPackageTablePanel.theSearchOfPackageHTML") + "</html>";
                    CurrentPackageTablePanel.this.deployListModel.addElement(MessageFormat.format(str, cpo.getPackageName()));
                    if (ex instanceof ConsoleException && ((ConsoleException)ex).needRelogin()) {
                        Manager.getFrame().showLoginPanel();
                    }
                }
            }
        };
        SwingWorkerExecutor.getInstance().execute(this.searchThread);
    }

    void setColumnRenderers(JTable thisTable) {
        thisTable.getColumnModel().getColumn(1).setCellRenderer(new PlatformIconNameCellRenderer());
        thisTable.getColumnModel().getColumn(0).setCellRenderer(new PackageNameTableCellRenderer());
    }

    private String getPatchLinkURL(int row) {
        CurrentPackageObject cpo = (CurrentPackageObject)this.packageModel.getRow(row);
        if (cpo == null) {
            return null;
        }
        String urlString = cpo.getSoftwarePackageObject().getPackageInfo().getOptReleaseNotesUrl();
        return urlString;
    }

    class PackageTableSetupWorker
    extends SwingWorker<List<CurrentPackageObject>, Void> {
        private CurrentPackageObject cpo;
        private PackageSortableTableModel packageModel;
        private JTable packageTable;
        private DefaultListSelectionModel selectionModel;
        private ListSelectionListener[] selectionListener;
        private int[] colWidth;
        private boolean exportPackage = false;
        private String workerId = GUIDGenerator.getInstance().getGUIDString();

        public PackageTableSetupWorker(CurrentPackageObject cpo, PackageSortableTableModel packageModel, JTable packageTable, DefaultListSelectionModel selectionModel, ListSelectionListener[] selectionListener, int[] colWidth, boolean exportPackage) {
            this.cpo = cpo;
            this.packageModel = packageModel;
            this.packageTable = packageTable;
            this.selectionModel = selectionModel;
            this.selectionListener = selectionListener;
            this.colWidth = colWidth;
            this.exportPackage = exportPackage;
        }

        @Override
        protected List<CurrentPackageObject> doInBackground() throws Exception {
            logger.log(Level.INFO, "CurrentPackageTablePanel >> doInBackground() beginning, Thread-{0}", this.workerId);
            AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> ClientAgent.getCurrentInstance().setUpdateBrowserInterval(1));
            ArrayList<CurrentPackageObject> pkgs = SoftwarePackageHandler.getCurrentSoftwarePackages();
            logger.log(Level.INFO, "CurrentPackageTablePanel >> doInBackground() done! Thread-{0}", this.workerId);
            return pkgs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            logger.log(Level.INFO, "CurrentPackageTablePanel >> done() beginning, exportPackage: {0}, Thread-{1}", new Object[]{this.exportPackage, this.workerId});
            try {
                this.updateTable((List)this.get());
            }
            catch (InterruptedException ie) {
                logger.log(Level.SEVERE, "InterruptedException: ", ie);
                Thread.currentThread().interrupt();
            }
            catch (CancellationException ce) {
                ExceptionHandler.handleCancellationException(ce);
            }
            catch (ExecutionException e) {
                logger.log(Level.SEVERE, "ExecutionException: ", e);
                String errorText = MessageResources.getInstance().getString(CurrentPackageTablePanel.CLIENT_RES, "CurrentPackageTablePanel.error.retrievePackages");
                String heading = MessageResources.getInstance().getString(CurrentPackageTablePanel.CLIENT_RES, "CurrentPackagePanel.error");
                JOptionPane.showMessageDialog(Manager.getFrame(), errorText, heading, 0);
            }
            finally {
                AjaxSwingCommonUtil.updateSwingAgentBrowser((boolean)true, (int)0);
                logger.log(Level.INFO, "CurrentPackageTablePanel >> done() finished, Thread-{0}", this.workerId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateTable(List<CurrentPackageObject> packages) {
            logger.log(Level.INFO, "CurrentPackageTablePanel >> updateTable() beginning, Package Size: {0}, Thread-{1}", new Object[]{this.exportPackage, this.workerId});
            Object object = CurrentPackageTablePanel.this.packageTableSyncLock;
            synchronized (object) {
                this.packageModel.removeAll();
                Optional.ofNullable(packages).orElse(List.of()).forEach(co -> this.packageModel.addRow((TableRow)co));
                this.packageTable.setModel(this.packageModel);
                CurrentPackageTablePanel.this.setColumnRenderers(this.packageTable);
                ((Stream)Arrays.stream(this.selectionListener).sequential()).forEach(element -> this.selectionModel.removeListSelectionListener((ListSelectionListener)element));
                ((Stream)Arrays.stream(this.selectionListener).sequential()).forEach(element -> this.selectionModel.addListSelectionListener((ListSelectionListener)element));
                UiTableUtils.setTableColumnWidths(this.packageTable, this.colWidth);
                this.packageModel.fireTableDataChanged();
                AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> {
                    ClientAgent.getCurrentInstance().getHTMLPage().setComponentDirty((Component)CurrentPackageTablePanel.this.packagePanel, true);
                    ClientAgent.getCurrentInstance().getHTMLPage().setComponentDirty((Component)CurrentPackageTablePanel.this.deployPanel, true);
                });
                this.selectAndHighLightRow(this.cpo, this.packageModel);
                if (this.exportPackage) {
                    logger.log(Level.INFO, "CurrentPackageTablePanel >> setupTable: Export package...");
                    CurrentPackageTablePanel.this.doExport();
                    logger.log(Level.INFO, "CurrentPackageTablePanel >> setupTable: Export package finished!");
                }
            }
            logger.log(Level.INFO, "CurrentPackageTablePanel >> updateTable() Done! Thread-{0}", this.workerId);
        }

        private void selectAndHighLightRow(CurrentPackageObject cpo, SortableTableModel packageModel) {
            if (this.packageTable.getRowCount() > 0) {
                int rowSelected = 0;
                if (cpo != null) {
                    for (int index = 0; index < packageModel.getRowCount(); ++index) {
                        CurrentPackageObject curRow = (CurrentPackageObject)packageModel.getRow(index);
                        if (!curRow.getId().equalsIgnoreCase(cpo.getId())) continue;
                        rowSelected = index;
                        packageModel.setRow(index, cpo);
                        break;
                    }
                }
                this.packageTable.setRowSelectionInterval(rowSelected, rowSelected);
                Rectangle cellRect = this.packageTable.getCellRect(rowSelected, 0, false);
                if (cellRect != null) {
                    this.packageTable.scrollRectToVisible(cellRect);
                }
                CurrentPackageTablePanel.this.mCurSelectedRow = this.packageTable.getSelectedRow();
                CurrentPackageTablePanel.this.updateDeployList();
            }
        }
    }

    private static class PackageNameTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private PackageNameTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            UIUtilities.setName((JComponent)comp, "packageManagement", UIUtilities.ComponentType.JTABLE, "ColumnPackageName_" + String.valueOf(value));
            return comp;
        }
    }

    public class HyperLinkCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = -1073591329044710110L;
        String hyperlinkStart = "<html><body><a href=\"\">";
        String hyperlinkEnd = "</a></body></html>";
        String packageName = "";

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String urlString = CurrentPackageTablePanel.this.getPatchLinkURL(row);
            this.setOpaque(true);
            if (value == null) {
                this.setText("");
                return this;
            }
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            if (urlString != null && urlString.trim().length() > 0) {
                this.setText(this.hyperlinkStart + value + this.hyperlinkEnd);
            } else {
                this.setText((String)value);
            }
            return this;
        }
    }
}

