/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client;

import com.sygate.scm.common.acl.AuthorizationManager;
import com.sygate.scm.common.acl.Permission;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.configobject.schema.SemAdministrator;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.configobject.schema.SoftwarePackage;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.util.AdminUtils;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.SoftwarePackageHandler;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.AdminPrivilegeObject;
import com.sygate.scm.console.logicobject.CurrentPackageObject;
import com.sygate.scm.console.logicobject.DomainObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.ui.client.ClientRightPanel;
import com.sygate.scm.console.ui.client.CurrentPackageTablePanel;
import com.sygate.scm.console.ui.client.HtmlPanel;
import com.sygate.scm.console.ui.client.dlg.SetUserInfoDlg;
import com.sygate.scm.console.ui.client.dlg.UpdatePackageWizard;
import com.sygate.scm.console.ui.util.TaskObject;
import com.sygate.scm.console.ui.util.TaskPanelBase;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.PackageUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionListener;

public class CurrentPackagePanel
extends ClientRightPanel {
    private static final long serialVersionUID = 657825696293828144L;
    private static final String AUTOMATION_PACKAGE_TASK_PANEL = "PackageSideTaskMenuItem";
    private static final String AUTOMATION_PACKAGE_ADD = "PackageAdd";
    private static final String AUTOMATION_PACKAGE_EXPORT = "PackageExport";
    private static final String AUTOMATION_PACKAGE_DELETE = "PackageDelete";
    private static final String AUTOMATION_PACKAGE_PROPERTIES_EDIT = "EditPackageProperties";
    private static final String AUTOMATION_PACKAGE_PROPERTIES_VIEW = "ViewPackageProperties";
    private static final String AUTOMATION_PACKAGE_DEPLOY = "PackageDeploy";
    private static final String AUTOMATION_USER_COLLECTION = "UserInfomationCollection";
    private static final int CREATE_PACKAGE = 1;
    private static final int EXPORT_PACKAGE = 4;
    private static final int PROPS_PACKAGE = 6;
    private static final int UPDATE_PACKAGE_GROUPS_WIZARD = 9;
    private static final int SET_USER_INFO = 10;
    private static final int DELETE_PACKAGE = 11;
    CurrentPackageTablePanel tablePanel = null;
    HtmlPanel titlePane = null;
    protected boolean readOnly;
    private CurrentPackageTaskPane rightPanel = null;

    public CurrentPackagePanel(ListSelectionListener tableListener) {
        try {
            AuthorizationManager manager = AuthorizationManager.getInstance();
            PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
            this.readOnly = !manager.checkPermission(context, (Permission)AuthorizationManager.PackagePermission.FULL_ACCESS);
            this.tablePanel = new CurrentPackageTablePanel(this.readOnly);
            this.rightPanel = new CurrentPackageTaskPane();
            this.jbInit();
            this.tablePanel.setListSelectionListener(tableListener);
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
        }
    }

    @Override
    public void refresh() {
    }

    @Override
    public void executeTask(int taskIndex, Object userObject) {
        switch (taskIndex) {
            case 1: {
                this.getCurrentPackageTablePanel().doNewPackage();
                break;
            }
            case 4: {
                this.getCurrentPackageTablePanel().doExport();
                break;
            }
            case 6: {
                this.getCurrentPackageTablePanel().doProps();
                break;
            }
            case 9: {
                this.doPackageUpgrade(this.getCurrentPackageTablePanel().getSelectedPackaged());
                break;
            }
            case 10: {
                this.setUserInformation();
                break;
            }
            case 11: {
                this.getCurrentPackageTablePanel().doDeletePackages();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void doPackageUpgrade(CurrentPackageObject cpo) {
        UpdatePackageWizard updatePackageWizard = new UpdatePackageWizard(cpo);
        if (updatePackageWizard.isOk()) {
            this.getCurrentPackageTablePanel().updateDeployList();
        }
    }

    @Override
    protected int getTaskType() {
        return -1;
    }

    protected void initTitlePane() {
        String titleTemplateName = "template_packagecurrent_title.htm";
        this.titlePane = new HtmlPanel(titleTemplateName);
        this.titlePane.updateText();
    }

    protected void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.setBorder(new JScrollPane().getBorder());
        JPanel panelMain = new JPanel();
        panelMain.setLayout(new BorderLayout());
        panelMain.add((Component)this.rightPanel, "Center");
        UIUtilities.setName(panelMain, "packageManagement", UIUtilities.ComponentType.JPANEL, AUTOMATION_PACKAGE_TASK_PANEL);
        this.add((Component)panelMain, "Center");
    }

    @Override
    protected String getHtmlTemplateFileName() {
        if (Manager.isSystemAdmin(DataobjectManager.getInstance().getCurrentAdministrator())) {
            return "template_packagecurrent_commontask.htm";
        }
        return "template_packagecurrent_commontask_nootherdomain.htm";
    }

    private void setUserInformation() {
        try {
            SemDomain curDomain = DataobjectManager.getInstance().getCurrentSemDomain();
            DomainObject curDomainObj = new DomainObject(curDomain);
            SetUserInfoDlg dlg = new SetUserInfoDlg(curDomainObj.getAdditionalUserInfoCollectorObject(false));
            if (dlg.isOk()) {
                dlg.updateData(curDomainObj.getAdditionalUserInfoCollectorObject(true));
                DataobjectManager.getInstance().updateSemDomain("Merge", curDomain);
            }
            dlg.dispose();
        }
        catch (ConsoleException ex) {
            System.err.println("CurrentPackagePanel->executeTask: Can't set User Information Collection.");
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    private boolean allowUpgradeAndExportWizard() {
        try {
            return SoftwarePackageHandler.hasCurrentPackage() && AdminPrivilegeObject.isCurrentAdminHasComputerUserPrivilege() && AdminPrivilegeObject.isCurrentAdminHasFullAccessPackagePrivilege() && AdminObject.retrieveCurrentAdminObject().hasGroupFullAccessRight();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            if (ex instanceof ConsoleException) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CurrentPackagePanel.error"), 0);
                if (((ConsoleException)ex).needRelogin()) {
                    Manager.getFrame().showLoginPanel();
                }
            }
            return false;
        }
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_pane_install_packages_client_install_packages";
    }

    public List<List<TaskObject>> getTaskList(TreeItem item) {
        TaskObject task;
        ArrayList<List<TaskObject>> currentTaskList = new ArrayList<List<TaskObject>>();
        ArrayList<TaskObject> firstList = new ArrayList<TaskObject>();
        ArrayList<TaskObject> secondList = new ArrayList<TaskObject>();
        ImageIcon addAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("add.png")));
        ImageIcon editAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("edit.png")));
        ImageIcon exportAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("export.png")));
        ImageIcon updateAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("updatePackage.png")));
        ImageIcon deleteAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("delete.png")));
        ImageIcon useraction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("set_user16a.png")));
        ArrayList<TaskObject> listForDynTasks = null;
        if (this.tablePanel.isPackageSelected()) {
            if (!this.readOnly) {
                if (this.allowUpgradeAndExportWizard() && this.tablePanel.isSelectedPackagesExportable()) {
                    task = new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CurrentPackagePanel.exportPackage"), 4, exportAction);
                    task.setAutomationLabel(AUTOMATION_PACKAGE_EXPORT);
                    firstList.add(task);
                }
                if (this.tablePanel.isSelectedPackagesDeletable()) {
                    task = new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CurrentPackagePanel.deletePackage"), 11, deleteAction);
                    task.setAutomationLabel(AUTOMATION_PACKAGE_DELETE);
                    firstList.add(task);
                }
                task = new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CurrentPackagePanel.editProperties"), 6, editAction);
                task.setAutomationLabel(AUTOMATION_PACKAGE_PROPERTIES_EDIT);
                firstList.add(task);
            } else {
                task = new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CurrentPackagePanel.viewProperties"), 6, editAction);
                task.setAutomationLabel(AUTOMATION_PACKAGE_PROPERTIES_VIEW);
                firstList.add(task);
            }
            listForDynTasks = secondList;
        } else {
            listForDynTasks = firstList;
        }
        if (!this.readOnly) {
            PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
            boolean hasPermission = AuthorizationManager.getInstance().checkPermission(context, (Permission)AuthorizationManager.SpecialPermission.ONE_GROUP_FULL_ACCESS);
            boolean isUpgradable = true;
            if (this.getCurrentPackageTablePanel().getSelectedPackaged() != null) {
                isUpgradable = PackageUtil.isPackageAutoUpgradable((SoftwarePackage)this.getCurrentPackageTablePanel().getSelectedPackaged().getSoftwarePackage());
            }
            if (isUpgradable && hasPermission) {
                TaskObject task2 = new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CurrentPackagePanel.updatePackageMultiGroupsWizard"), 9, updateAction);
                task2.setAutomationLabel(AUTOMATION_PACKAGE_DEPLOY);
                listForDynTasks.add(task2);
            }
        }
        if (!this.readOnly) {
            task = new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CurrentPackagePanel.createPackage"), 1, addAction);
            task.setAutomationLabel(AUTOMATION_PACKAGE_ADD);
            listForDynTasks.add(task);
            if (!AdminUtils.isLimitedAdmin((SemAdministrator)DataobjectManager.getInstance().getCurrentAdministrator())) {
                TaskObject task2 = new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CurrentPackagePanel.setUserInformation"), 10, useraction);
                task2.setAutomationLabel(AUTOMATION_USER_COLLECTION);
                secondList.add(task2);
            }
        }
        currentTaskList.add(firstList);
        currentTaskList.add(secondList);
        return currentTaskList;
    }

    @Override
    public void setSelectedItem(Object item) {
        if (item == null) {
            return;
        }
        this.tablePanel.refresh(item);
    }

    public CurrentPackageTablePanel getCurrentPackageTablePanel() {
        return this.tablePanel;
    }

    private class CurrentPackageTaskPane
    extends TaskPanelBase {
        private static final long serialVersionUID = 6053414187800183603L;

        CurrentPackageTaskPane() {
            this.initialize();
        }

        @Override
        protected Component getContentPanel() {
            JPanel contentPanel = new JPanel(new BorderLayout(0, 5));
            contentPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            contentPanel.add((Component)CurrentPackagePanel.this.tablePanel, "Center");
            return contentPanel;
        }

        @Override
        protected String getTitleName() {
            return MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CurrentPackagePanel.titleName");
        }
    }
}

