/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client;

import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.schema.InstallationOption;
import com.sygate.scm.common.configobject.schema.RebootOptions;
import com.sygate.scm.common.configobject.schema.SemServerList;
import com.sygate.scm.common.configobject.schema.SoftwarePackage;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.SoftwarePackageHandler;
import com.sygate.scm.console.logicobject.CurrentPackageObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.SoftwarePackageObject;
import com.sygate.scm.console.ui.admin.logicobject.ClientInstallPoolObject;
import com.sygate.scm.console.ui.admin.logicobject.ClientInstallationSettingObject;
import com.sygate.scm.console.ui.client.PackageWorker;
import com.sygate.scm.console.ui.client.dlg.InProgressDlg;
import com.sygate.scm.console.ui.dlg.SimpleProgressDlg;
import com.sygate.scm.console.ui.policy.dialog.RebootOptionsPanel;
import com.sygate.scm.console.ui.policy.lu.LuUtility;
import com.sygate.scm.console.ui.util.MultiLineMsgBox;
import com.sygate.scm.console.util.AjaxSwingUtil;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.NativeCommandUtilities;
import com.sygate.scm.util.ConstantValue;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.MacPackageFormatHelper;
import com.sygate.scm.util.PackageUtil;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.SwingWorker;
import com.sygate.scm.util.Utility;
import com.sygate.scm.util.ZipUtil;
import java.awt.Cursor;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import org.xml.sax.SAXException;

public class CreateNewPackageWorker
extends PackageWorker {
    private CurrentPackageObject currentPackage = null;
    private String fileZip = null;
    SemServerList serverListForImport = null;
    private boolean isCreateDone = false;
    private boolean isPackageAdded = false;
    private String tempDir = null;
    private static final MessageResourcesFile MSG_RES = new MessageResourcesFile("com.sygate.scm.console.ui.client.client");
    private SimpleProgressDlg deleteOnCancelDlg = null;

    public CreateNewPackageWorker(CurrentPackageObject currentPackage) {
        this.currentPackage = currentPackage;
        this.fileZip = CreateNewPackageWorker.generateZipFilePath(currentPackage);
        this.serverListForImport = currentPackage.getImportServerList();
        this.isCreateDone = false;
        this.setMsgBoxTitle(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CreateNewPackageWorker.createNewPackageTitle"));
        this.setDlgTitle(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CreateNewPackageWorker.creatingPackageDlgTitle"));
    }

    public CreateNewPackageWorker(CurrentPackageObject currentPackageObject, String string) {
        this.currentPackage = currentPackageObject;
        this.fileZip = CreateNewPackageWorker.generateZipFilePath(this.currentPackage);
        this.serverListForImport = this.currentPackage.getImportServerList();
        this.isCreateDone = false;
        this.setMsgBoxTitle(string);
        this.setDlgTitle(string);
    }

    @Override
    protected void afterCancellation() {
        System.out.println("CreateNewPackageWorker>> doCancellation: cancelling...");
        if (this.isPackageAdded) {
            this.deletePackage();
        }
        super.afterCancellation();
        System.out.println("CreateNewPackageWorker>> doCancellation: cancelled!");
    }

    @Override
    protected void cleanup() {
        if (null != this.tempDir) {
            Utility.emptyDir((String)this.tempDir, (boolean)true);
            Utility.deleteDir((String)this.tempDir);
        }
        super.cleanup();
    }

    @Override
    public void finished() {
        if (!this.isAllDone && !this.isCancelled() && StringUtilities.isEmpty((String)this.finishMsg)) {
            this.setFinishMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CreateNewPackageWorker.errorHappenedMsg"));
        }
        super.finished();
    }

    @Override
    protected void afterWork() {
    }

    private void checkDatandConvert() {
        Object newDir = "";
        String sourceDir = this.currentPackage.getSrcDirectory();
        System.out.println("CreateNewPackageWorker>> checkDatandConvert-> Source dir is..." + sourceDir);
        if (sourceDir != null && sourceDir.endsWith(ConstantValue.getSupportedpackagefiletypesByIndex((int)2))) {
            String datext = ConstantValue.getSupportedpackagefiletypesByIndex((int)2);
            String zipext = ConstantValue.getSupportedpackagefiletypesByIndex((int)1);
            String fileName = sourceDir.substring(0, sourceDir.length() - datext.length());
            newDir = fileName + zipext;
            System.out.println("CreateNewPackageWorker>> checkDatandConvert-> new Source dir is..." + (String)newDir);
            this.currentPackage.setSrcDirectory((String)newDir);
        }
    }

    @Override
    protected boolean doWork() {
        RebootOptions options;
        List<ClientInstallationSettingObject> listInstall;
        boolean isMacZipPackage = false;
        boolean isWinZipPackage = false;
        boolean isLinuxZipPackage = false;
        if (this.isCancelled()) {
            return false;
        }
        AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(this::checkDatandConvert);
        String sourceDir = this.currentPackage.getSrcDirectory();
        System.out.println("CreateNewPackageWorker>> doWork-> Source dir is..." + sourceDir);
        if (sourceDir != null && !new File(sourceDir).isDirectory() && sourceDir.endsWith(ConstantValue.getSupportedpackagefiletypesByIndex((int)0))) {
            try {
                System.out.println("CreateNewPackageWorker>> doWork-> Reading meta data...");
                return this.doImportInfo(sourceDir);
            }
            catch (ConsoleException ex) {
                if (ex.getErrorCode() == 369360896) {
                    String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CreateNewPackageWorker.serverBusy") + ex.getMessageString();
                    this.showMsgBox(msg, false);
                } else {
                    LoggerUtilities.logException((Throwable)ex);
                }
                return false;
            }
            catch (Exception ex) {
                this.showMsgBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "CreateNewSoftwareDlg.error"), true);
                LoggerUtilities.logException((Throwable)ex);
                return false;
            }
        }
        if (!this.isImportAllowed(this.currentPackage.getSoftwarePackage())) {
            return false;
        }
        if (sourceDir != null && !new File(sourceDir).isDirectory() && sourceDir.endsWith(ConstantValue.getSupportedpackagefiletypesByIndex((int)1))) {
            if ("Mac".equals(this.currentPackage.getPackagePlatformString())) {
                isMacZipPackage = true;
            } else if (ConstantValue.isLinuxPlatform((String)this.currentPackage.getPackagePlatformString())) {
                isLinuxZipPackage = true;
            } else {
                isWinZipPackage = true;
            }
        }
        System.out.println("CreateNewPackageWorker>> doWork-> Package format is windows zip =" + isWinZipPackage);
        System.out.println("CreateNewPackageWorker>> doWork-> Package format is mac zip =" + isMacZipPackage);
        System.out.println("CreateNewPackageWorker>> doWork-> Package format is linux zip =" + isLinuxZipPackage);
        Object[] obj = new Object[]{AjaxSwingUtil.getDisplayFileName(sourceDir)};
        String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CreateNewPackageWorker.sourceDirectoryofPackageMsg");
        String fm = MessageFormat.format(str, obj);
        this.setProgressMsg(null, fm, true, true, 0);
        if (!isMacZipPackage) {
            if (!isWinZipPackage && !isLinuxZipPackage) {
                this.tempDir = CreateNewPackageWorker.generateTempDir(this.currentPackage);
            } else {
                System.out.println("CreateNewPackageWorker>> doWork-> generateTempDirForZipPkg called ...");
                this.tempDir = CreateNewPackageWorker.generateTempDirForZipPkg(this.currentPackage.getSrcDirectory());
                if (isWinZipPackage) {
                    this.fileZip = this.tempDir + ".zip";
                } else if (isLinuxZipPackage) {
                    this.fileZip = this.tempDir + "Temp.zip";
                }
            }
        } else {
            this.tempDir = CreateNewPackageWorker.generateTempDirForZipPkg(this.currentPackage.getSrcDirectory());
            this.fileZip = this.tempDir + File.separator + this.currentPackage.getNameFromSrcDirectory();
        }
        System.out.println("CreateNewPackageWorker>> doWork-> generateTempDirForZipPkg created tempDir=" + this.tempDir);
        System.out.println("CreateNewPackageWorker>> doWork-> generateTempDirForZipPkg created fileZip=" + this.fileZip);
        Object[] obj1 = new Object[]{AjaxSwingUtil.getDisplayFileName(this.tempDir)};
        str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CreateNewPackageWorker.tempDirectoryofPackageMsg");
        fm = MessageFormat.format(str, obj1);
        this.setProgressMsg(null, fm, true, true, 0);
        String actualPackageDir = this.tempDir;
        if (isMacZipPackage && this.tempDir != null) {
            String srcDirectoryName = "";
            File[] fileList = new File(this.tempDir).listFiles();
            if (fileList != null) {
                for (File file : fileList) {
                    if (file == null || !file.isDirectory()) continue;
                    srcDirectoryName = file.getName();
                }
            }
            this.tempDir = this.tempDir + File.separator + srcDirectoryName;
        }
        if (!(isMacZipPackage || isWinZipPackage || isLinuxZipPackage || this.doCopySourceToTemp(sourceDir, this.tempDir))) {
            return false;
        }
        if (this.isCancelled()) {
            return false;
        }
        SoftwarePackageObject packageObj = this.currentPackage.getSoftwarePackageObject();
        String targetDir = this.tempDir;
        Object configFileDir = targetDir;
        MacPackageFormatHelper pkgFmtHelper = null;
        if (!new File(targetDir + File.separator + "sylink.xml").exists() && !new File((String)(configFileDir = targetDir + File.separator + "Configuration") + File.separator + "sylink.xml").exists()) {
            pkgFmtHelper = new MacPackageFormatHelper(sourceDir);
            configFileDir = targetDir + File.separator + pkgFmtHelper.getRelativeConfigDirPath();
        }
        if (this.isCancelled()) {
            return false;
        }
        this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CreateNewPackageWorker.generatingPackListMsg"), true, true, 2);
        String packageBuildNumber = packageObj.getBuildNumber();
        if (packageBuildNumber == null || packageBuildNumber.length() < 1) {
            this.showMsgBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CreateNewPackageWorker.failedToRetrieveBuildNumberMsg"), true);
            return false;
        }
        System.out.println("CreateNewPackageWorker>> doWork: buildnumber=" + packageBuildNumber);
        String newPackageChecksum = "";
        if (!isMacZipPackage) {
            System.out.println("This is not a Mac package so calculate checksum for the same.");
            String packListExePath = null;
            try {
                packListExePath = NativeCommandUtilities.buildConsoleExe("packlist.exe");
            }
            catch (IOException ex) {
                LoggerUtilities.logException((Throwable)ex);
                this.showMsgBox(ex.getMessage(), true);
                return false;
            }
            if (packListExePath == null || packListExePath.length() < 1) {
                System.out.println("CreateNewPackageWorker>> doWork: Warning-> no exe dir!");
                return false;
            }
            this.addFileToCleanUpList(packListExePath + File.separator + "packlist.exe");
            newPackageChecksum = PackageUtil.generatePackList((String)packListExePath, (String)packageBuildNumber, (String)targetDir, (String)targetDir, (boolean)true);
            System.out.println("package checksum for the client package is: " + newPackageChecksum);
            if (newPackageChecksum == null) {
                this.showMsgBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CreateNewPackageWorker.failedToGetNewChecksumMsg"), true);
                return false;
            }
            packageObj.setCheckSum(newPackageChecksum);
        } else {
            System.out.println("This is a mac package. Do not calculate checksum. Only read from setaid.ini");
            newPackageChecksum = PackageUtil.readPackageChecksumfromSetaidIni((String)configFileDir);
            if (newPackageChecksum == null || newPackageChecksum.length() == 0) {
                newPackageChecksum = GUIDGenerator.getInstance().getGUIDString();
                System.out.println("As package checksum is missing assign a new GUID for checksum: " + newPackageChecksum);
            }
            System.out.println("package checksum for the client package is: " + newPackageChecksum);
            packageObj.setCheckSum(newPackageChecksum);
        }
        if (this.isCancelled()) {
            return false;
        }
        this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CreateNewPackageWorker.modifyingConfigFileMsg"), true, true, 3);
        if (this.serverListForImport == null) {
            this.serverListForImport = this.getDefaultServerList();
            if (this.serverListForImport == null) {
                return false;
            }
        }
        if (!this.modifyConfigXml(this.serverListForImport, null, (String)configFileDir, true)) {
            return false;
        }
        ClientInstallPoolObject poolSettings = null;
        try {
            poolSettings = new ClientInstallPoolObject();
        }
        catch (ConsoleException e1) {
            return false;
        }
        try {
            listInstall = poolSettings.getAllObjects();
        }
        catch (ConsoleException e1) {
            return false;
        }
        ClientInstallationSettingObject settings = listInstall.get(0);
        if (settings == null) {
            settings = new ClientInstallationSettingObject();
        }
        if ((options = settings.getOptRebootOptions()) == null) {
            options = RebootOptionsPanel.getDefaultRebootOptions();
        }
        String version = this.currentPackage.getSoftwarePackageObject().getVersion();
        if (!PackageUtil.modifySetAidIniSetupIni((String)newPackageChecksum, (InstallationOption)this.getInstallationOption(null, packageObj), null, (boolean)false, (String)configFileDir, (boolean)true, (boolean)false, (RebootOptions)options, (String)version)) {
            return false;
        }
        if (this.isCancelled()) {
            return false;
        }
        this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CreateNewPackageWorker.zippingFolderMsg"), true, true, 4);
        if (isMacZipPackage) {
            CreateNewPackageWorker.deletePacklistFile(actualPackageDir);
            boolean isZipSuccess = false;
            try {
                String outputFolder = actualPackageDir;
                String zipFilePath = this.fileZip;
                String exePath = NativeCommandUtilities.buildConsoleExe("SEPMPackageTool.exe") + File.separator + "SEPMPackageTool.exe";
                if (exePath != null && exePath.length() > 0) {
                    this.addFileToCleanUpList(exePath);
                }
                if (pkgFmtHelper == null) {
                    pkgFmtHelper = new MacPackageFormatHelper(sourceDir);
                }
                String pkgName = pkgFmtHelper.getPackageName();
                String pathPrefix = pkgName + "/" + pkgFmtHelper.getConfigDirPathWithSeperator() + "/";
                String configFile = pathPrefix + "sylink.xml";
                String setAidIni = pathPrefix + "setAid.ini";
                String setupIni = pathPrefix + "setup.ini";
                String[] extract_filter = new String[]{configFile, setAidIni, setupIni};
                isZipSuccess = PackageUtil.putFilesToZipFile((String)zipFilePath, (String)outputFolder, (String)outputFolder, (String[])extract_filter, (String)exePath);
                System.out.println("result : " + isZipSuccess);
            }
            catch (Exception e) {
                isZipSuccess = false;
            }
            if (!isZipSuccess) {
                return isZipSuccess;
            }
        } else if (!this.doCreateZipFile(targetDir, this.fileZip, isLinuxZipPackage)) {
            return false;
        }
        if (this.isCancelled()) {
            return false;
        }
        this.isPackageAdded = false;
        this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CreateNewPackageWorker.addingPackageMsg"), true, true, 7);
        this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CreateNewPackageWorker.doNotCancel"), true, true, 7);
        if (!this.doAddPackage(this.currentPackage, this.fileZip)) {
            return false;
        }
        this.isPackageAdded = true;
        if (this.isCancelled()) {
            return false;
        }
        this.isCreateDone = true;
        try {
            LuUtility.reRegisterLiveUpdateEntries();
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            return false;
        }
        this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CreateNewPackageWorker.finishingActionMsg"), true, true, 10);
        if (isMacZipPackage || isWinZipPackage || isLinuxZipPackage) {
            this.tempDir = actualPackageDir;
        }
        this.cleanup();
        this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CreateNewPackageWorker.doneMsg"), true, true, 10);
        this.setFinishMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CreateNewPackageWorker.completedSuccessfullyMsg"));
        return true;
    }

    private boolean doCopySourceToTemp(String sourceDir, String tempDir) {
        System.out.println("CreateNewPackageWorker>> doCopySourceToTemp->  copy src =" + sourceDir + " to temp= " + tempDir);
        Utility.emptyDir((String)tempDir, (boolean)true);
        if (!Utility.copyDir((String)sourceDir, (String)tempDir, (boolean)true)) {
            this.showMsgBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CreateNewPackageWorker.failedToCopyMsg"), true);
            return false;
        }
        Utility.delete((File)new File(tempDir, "TPAR"));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doCreateZipFile(String sourceDir, String zipFileName, boolean isLinux) {
        System.out.println("CreateNewPackageWorker>> doCreateZipFile: Begin... source=" + sourceDir + ", zipFileName=" + zipFileName);
        try {
            Utility.deleteFile((String)zipFileName);
            this.counter.start();
            System.out.println("CreateNewPackageWorker>> doCreateZipFile: zipping the source dir...");
            ZipUtil.zipData((int)-1, (String)sourceDir, (String)zipFileName, (boolean)false, (boolean)isLinux);
            this.counter.stop();
        }
        catch (Throwable ex) {
            System.out.println("CreateNewPackageWorker>> doCreateZipFile: Exception... ");
            LoggerUtilities.logException((Throwable)ex);
            this.showMsgBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CreateNewPackageWorker.failedToCreateZipFileMsg"), true);
            boolean bl = false;
            return bl;
        }
        System.out.println("CreateNewPackageWorker>> doCreateZipFile: Done! elapsed time=" + this.getTimeCounterDisplayString());
        return true;
    }

    private void enableStopButton(boolean enable) {
        if (this.progressListener instanceof InProgressDlg) {
            ((InProgressDlg)this.progressListener).enableStopButton(enable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doAddPackage(CurrentPackageObject currentPackage, String zipFileName) {
        System.out.println("CreateNewPackageWorker>> doAddPackage: Begin...");
        try {
            this.counter.start();
            this.enableStopButton(false);
            if (!SoftwarePackageHandler.addPackage(currentPackage, zipFileName)) {
                boolean bl = false;
                return bl;
            }
            this.counter.stop();
        }
        catch (ConsoleException ex) {
            System.out.println("CreateNewPackageWorker>> doAddPackage: ConsoleException... ");
            if (ex.getErrorCode() == 369360896) {
                String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CreateNewPackageWorker.serverBusy") + ex.getMessageString();
                this.showMsgBox(msg, false);
            } else {
                LoggerUtilities.logException((Throwable)ex);
                this.showMsgBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CreateNewPackageWorker.failedToAddPackageMsg"), true);
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable ex) {
            System.out.println("CreateNewPackageWorker>> doAddPackage: Exception... ");
            LoggerUtilities.logException((Throwable)ex);
            this.showMsgBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CreateNewPackageWorker.failedToAddPackageMsg"), true);
            boolean bl = false;
            return bl;
        }
        finally {
            this.enableStopButton(true);
        }
        System.out.println("CreateNewPackageWorker>> doAddPackage: Done! elapsed time=" + this.getTimeCounterDisplayString());
        return true;
    }

    private InstallationOption getInstallationOption(ClientInstallationSettingObject settingObj, SoftwarePackageObject packageObj) {
        if (settingObj != null) {
            return settingObj.getInstallationOption();
        }
        return packageObj.getInstallationOption();
    }

    public boolean isCreateDone() {
        if (this.isCreateDone) {
            this.setExportVisible(true);
        }
        try {
            this.currentPackage.setSoftwarePackage(DataobjectManager.getInstance().getSoftwarePackage(this.currentPackage.getId()));
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
        }
        return this.isCreateDone;
    }

    public static String generateZipFilePath(CurrentPackageObject cpo) {
        String path = CreateNewPackageWorker.generateTempDir(cpo) + ".zip";
        return path;
    }

    public static String generateZipFilePathForZipPkg(CurrentPackageObject cpo) {
        Object path = CreateNewPackageWorker.generateTempDir(cpo);
        if (!((String)path).endsWith(".zip")) {
            path = (String)path + ".zip";
        }
        return path;
    }

    public static String generateTempDir(CurrentPackageObject cpo) {
        String path = cpo.getSrcDirectory() + "Temp";
        return path;
    }

    public static String generateTempDirForZipPkg(String zippedPkgPath) {
        String zipext;
        Object path;
        File zipFile = new File(zippedPkgPath);
        String zipFilePath = zippedPkgPath;
        if (zipFile.isFile()) {
            zipFilePath = zipFile.getParent();
        }
        if (((String)(path = zipFilePath + File.separator + zipFile.getName())).endsWith(zipext = ConstantValue.getSupportedpackagefiletypesByIndex((int)1))) {
            path = ((String)path).substring(0, ((String)path).length() - zipext.length());
        }
        return path;
    }

    private static void deletePacklistFile(String tmpDir) {
        File packListXml = new File(tmpDir + File.separator + "packlist.xml");
        if (packListXml.exists()) {
            Utility.deleteFile((String)packListXml.getName());
        }
    }

    public void deletePackage() {
        try {
            SwingWorker sw = new SwingWorker(){

                public Object construct() {
                    boolean result = false;
                    try {
                        SoftwarePackageHandler.delPackage(CreateNewPackageWorker.this.currentPackage);
                        result = true;
                    }
                    catch (Exception e) {
                        System.out.println("Exception while deleting the cancelled package: " + CreateNewPackageWorker.this.currentPackage.getPackageName());
                    }
                    return result;
                }

                public void finished() {
                    if (CreateNewPackageWorker.this.deleteOnCancelDlg != null) {
                        CreateNewPackageWorker.this.deleteOnCancelDlg.setCursor(Cursor.getDefaultCursor());
                        CreateNewPackageWorker.this.deleteOnCancelDlg.dispose();
                    }
                }
            };
            sw.start();
            String heading = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CreateNewPackageWorker.cancel.delpackage.heading");
            String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CreateNewPackageWorker.cancel.delpackage.pleaseWait");
            this.deleteOnCancelDlg = new SimpleProgressDlg((Frame)Manager.getFrame(), heading, msg, true);
            this.deleteOnCancelDlg.setCursor(Cursor.getPredefinedCursor(3));
            this.deleteOnCancelDlg.setVisible(true);
            sw.get();
        }
        catch (Throwable ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doImportInfo(String sourceInfo) throws ConsoleException, IOException, SAXException, ValidationException {
        String zipFile = SoftwarePackageHandler.getZipFile(sourceInfo);
        if (this.isCancelled()) {
            return false;
        }
        this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CreateNewPackageWorker.readingPackageMsg"), true, true, 7);
        SoftwarePackage sp = PackageUtil.readSoftwarePackage((String)sourceInfo);
        int importType = sp.getPackageInfo().getType();
        if (!this.isImportAllowed(sp)) {
            return false;
        }
        if (!this.isCorrectPackageType(importType)) {
            MultiLineMsgBox optionPane = new MultiLineMsgBox(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CurrentPackageTablePanel.addNewPackageMsg"));
            optionPane.init(PackageUtil.getLicenseAbsenceMsg((int)importType), 60, 0, -1);
            optionPane.show();
            this.disposeDialog();
            return false;
        }
        String packageName = this.currentPackage.getPackageName();
        String description = this.currentPackage.getDescription();
        this.currentPackage.setSoftwarePackage(sp);
        sp.setName(packageName);
        sp.setOptDescription(description);
        if (this.isCancelled()) {
            return false;
        }
        this.isPackageAdded = false;
        try {
            PackageUtil.checkCompressedPackageFileIntegrity((String)zipFile, (SoftwarePackage)sp);
        }
        catch (IOException e) {
            MultiLineMsgBox optionPane = new MultiLineMsgBox(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CurrentPackageTablePanel.addNewPackageMsg"));
            optionPane.init(e.getMessage(), 60, 0, -1);
            optionPane.show();
            this.disposeDialog();
            return false;
        }
        this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CreateNewPackageWorker.addingPackageMsg"), true, true, 7);
        this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CreateNewPackageWorker.doNotCancel"), true, true, 7);
        boolean isSuccess = false;
        try {
            this.enableStopButton(false);
            isSuccess = SoftwarePackageHandler.addPackage(this.currentPackage, zipFile);
        }
        finally {
            this.enableStopButton(true);
        }
        if (isSuccess) {
            this.isPackageAdded = true;
            boolean showExport = true;
            String version = this.currentPackage.getSoftwarePackageObject().getVersion();
            if (Utility.compareVersion((String)version, (String)"12.1.0.0") < 0 && Utility.compareVersion((String)version, (String)"12.0.0.0") > 0 && !LicenseObject.getInstance().isSBProduct()) {
                showExport = false;
                this.setExportBtnVisible(showExport);
            }
        }
        if (this.isCancelled()) {
            return false;
        }
        if (isSuccess) {
            LuUtility.reRegisterLiveUpdateEntries();
            this.setProgressMsg(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CreateNewPackageWorker.doneMsg"), true, true, 10);
            this.setFinishMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CreateNewPackageWorker.completedSuccessfullyMsg"));
            this.isCreateDone = true;
        } else {
            this.disposeDialog();
        }
        return isSuccess;
    }

    private boolean isImportAllowed(SoftwarePackage sp) {
        boolean isAllowed = true;
        if (!PackageUtil.isSoftwarePackageSupported((SoftwarePackage)sp)) {
            MultiLineMsgBox errorMsgBox = new MultiLineMsgBox(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CurrentPackageTablePanel.error"));
            String errorText = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "CurrentPackageTablePanel.sepImportNotAllowed");
            errorMsgBox.init(errorText, 80, 0, -1);
            errorMsgBox.show();
            this.disposeDialog();
            isAllowed = false;
        }
        return isAllowed;
    }

    private boolean isCorrectPackageType(int iType) {
        LicenseObject lObj = LicenseObject.getInstance();
        if (lObj.isSAVOnlyProduct() && iType == 105) {
            return true;
        }
        if (lObj.isSNACOnlyProduct() && iType == 151) {
            return true;
        }
        return lObj.isALLProduct() && (iType == 105 || iType == 151);
    }

    public CurrentPackageObject getCurrentPackageObject() {
        return this.currentPackage;
    }

    @Override
    protected void createDlg(SwingWorker worker, String title, String msg) {
        super.createDlg(worker, title, msg);
        if (this.progressListener instanceof InProgressDlg) {
            ((InProgressDlg)this.progressListener).setStopWarningMsg(MSG_RES.getString("CreateNewPackageWorker.stopWarningTitle"), MSG_RES.getString("CreateNewPackageWorker.stopWarningMsg"));
        }
    }
}

