/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client;

import com.sygate.scm.common.configobject.TimeUtil;
import com.sygate.scm.common.configobject.schema.Command;
import com.sygate.scm.common.configobject.schema.RebootOptions;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ui.client.dlg.RebootSelectDlg;
import com.sygate.scm.console.ui.client.dlg.ScanSelectDlg;
import com.sygate.scm.console.ui.client.dlg.ScanSelectPowerEraserDlg;
import com.sygate.scm.util.GUIDGenerator;
import java.text.MessageFormat;
import java.util.HashMap;

public class CommandUtil {
    private static HashMap<String, String> actionNameMap = new HashMap();

    private static String getCmdRes(String resTag) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", resTag);
    }

    public static Command getCommand(String cmdName, String groupName) {
        Command cmd = new Command();
        String scanDesc = "";
        cmd.setFeature(Command.AV);
        if ("ScanNow".equals(cmdName)) {
            cmdName = ScanSelectDlg.getScanNameFromDialog(false);
            if (cmdName == null) {
                return null;
            }
            scanDesc = groupName == null ? CommandUtil.getCmdRes("ClientSearchResultPanel.scanCmdDesc1") : CommandUtil.getCmdRes("ClientSearchResultPanel.scanCmdDesc");
        } else if ("Update_Now".equals(cmdName)) {
            cmd.setFeature(Command.LU);
            scanDesc = groupName == null ? CommandUtil.getCmdRes("ClientSearchResultPanel.updateCmdDesc1") : CommandUtil.getCmdRes("ClientSearchResultPanel.updateCmdDesc");
        } else if ("Update_ScanNow".equals(cmdName)) {
            cmdName = ScanSelectDlg.getScanNameFromDialog(true);
            if (cmdName == null) {
                return null;
            }
            scanDesc = groupName == null ? CommandUtil.getCmdRes("ClientSearchResultPanel.updateScanCmdDesc1") : CommandUtil.getCmdRes("ClientSearchResultPanel.updateScanCmdDesc");
        } else if ("PowerEraser".equals(cmdName)) {
            ScanSelectPowerEraserDlg dlg = ScanSelectPowerEraserDlg.getShowDialog();
            if (dlg == null) {
                return null;
            }
            scanDesc = groupName == null ? CommandUtil.getCmdRes("ClientSearchResultPanel.scanCmdDesc1") : CommandUtil.getCmdRes("ClientSearchResultPanel.scanCmdDesc");
            cmdName = dlg.getScanName();
            RebootOptions options = dlg.getRebootOptions();
            if (options != null) {
                cmd.setOptRebootOptions(options);
            }
        } else if ("Reboot".equals(cmdName)) {
            RebootOptions options = RebootSelectDlg.getInstance().getRebootOptionsFromDialog(true);
            if (options == null) {
                return null;
            }
            cmd.setFeature(Command.CMC);
            cmd.setOptRebootOptions(options);
            scanDesc = groupName == null ? CommandUtil.getCmdRes("ClientSearchResultPanel.rebootCmdDesc1") : CommandUtil.getCmdRes("ClientSearchResultPanel.rebootCmdDesc");
        } else if ("ApOn".equals(cmdName)) {
            scanDesc = groupName == null ? CommandUtil.getCmdRes("ClientSearchResultPanel.apOnCmdDesc1") : CommandUtil.getCmdRes("ClientSearchResultPanel.apOnCmdDesc");
        } else if ("ApOff".equals(cmdName)) {
            scanDesc = groupName == null ? CommandUtil.getCmdRes("ClientSearchResultPanel.apOffCmdDesc1") : CommandUtil.getCmdRes("ClientSearchResultPanel.apOffCmdDesc");
        } else if ("FwOn".equals(cmdName)) {
            cmd.setFeature(Command.FW);
            scanDesc = groupName == null ? CommandUtil.getCmdRes("ClientSearchResultPanel.fwOnCmdDesc1") : CommandUtil.getCmdRes("ClientSearchResultPanel.fwOnCmdDesc");
        } else if ("FwOff".equals(cmdName)) {
            cmd.setFeature(Command.FW);
            scanDesc = groupName == null ? CommandUtil.getCmdRes("ClientSearchResultPanel.fwOffCmdDesc1") : CommandUtil.getCmdRes("ClientSearchResultPanel.fwOffCmdDesc");
        } else if ("DaOn".equals(cmdName)) {
            cmd.setFeature(Command.AV);
            scanDesc = groupName == null ? CommandUtil.getCmdRes("ClientSearchResultPanel.daOnCmdDesc1") : CommandUtil.getCmdRes("ClientSearchResultPanel.daOnCmdDesc");
        } else if ("DaOff".equals(cmdName)) {
            cmd.setFeature(Command.AV);
            scanDesc = groupName == null ? CommandUtil.getCmdRes("ClientSearchResultPanel.daOffCmdDesc1") : CommandUtil.getCmdRes("ClientSearchResultPanel.daOffCmdDesc");
        } else if ("Collect_FileFingerprintList".equals(cmdName)) {
            cmd.setFeature(Command.CMC);
            scanDesc = groupName == null ? CommandUtil.getCmdRes("ClientSearchResultPanel.collectFileFingerprintListCmdDesc1") : CommandUtil.getCmdRes("ClientSearchResultPanel.collectFileFingerprintListCmdDesc");
        } else if ("AdminQuarantineEnabled".equals(cmdName)) {
            scanDesc = groupName == null ? CommandUtil.getCmdRes("ClientSearchResultPanel.adminQuarantineEnabledCmdDesc1") : CommandUtil.getCmdRes("ClientSearchResultPanel.adminQuarantineEnabledCmdDesc");
        } else if ("AdminQuarantineDisabled".equals(cmdName)) {
            scanDesc = groupName == null ? CommandUtil.getCmdRes("ClientSearchResultPanel.adminQuarantineDisabledCmdDesc1") : CommandUtil.getCmdRes("ClientSearchResultPanel.adminQuarantineDisabledCmdDesc");
        }
        scanDesc = MessageFormat.format(scanDesc, groupName);
        GUIDGenerator generator = GUIDGenerator.getInstance();
        String guid = generator.getGUIDString();
        cmd.setId(guid);
        cmd.setName(cmdName);
        cmd.setOptDescription(scanDesc);
        cmd.setSeqNumber(Long.valueOf(TimeUtil.getServerTime()));
        return cmd;
    }

    public static String getActionName(String cmdName) {
        return actionNameMap.get(cmdName);
    }

    static {
        actionNameMap.put("ScanNow", CommandUtil.getCmdRes("ClientSearchResultPanel.scanComputerUserNowLabel"));
        actionNameMap.put("Update_Now", CommandUtil.getCmdRes("ClientSearchResultPanel.updateComputerUserNowLabel"));
        actionNameMap.put("Update_ScanNow", CommandUtil.getCmdRes("ClientSearchResultPanel.updateAndScanComputerUserNowLabel"));
        actionNameMap.put("Reboot", CommandUtil.getCmdRes("ClientSearchResultPanel.rebootLabel"));
        actionNameMap.put("ApOn", CommandUtil.getCmdRes("ClientSearchResultPanel.apOnLabel"));
        actionNameMap.put("ApOff", CommandUtil.getCmdRes("ClientSearchResultPanel.apOffLabel"));
        actionNameMap.put("FwOn", CommandUtil.getCmdRes("ClientSearchResultPanel.fwOnLabel"));
        actionNameMap.put("FwOff", CommandUtil.getCmdRes("ClientSearchResultPanel.fwOffLabel"));
        actionNameMap.put("DaOn", CommandUtil.getCmdRes("ClientSearchResultPanel.daOnLabel"));
        actionNameMap.put("DaOff", CommandUtil.getCmdRes("ClientSearchResultPanel.daOffLabel"));
        actionNameMap.put("PowerEraser", CommandUtil.getCmdRes("ClientSearchResultPanel.powerEraserScanComputerUserNowLabel"));
        actionNameMap.put("Collect_FileFingerprintList", CommandUtil.getCmdRes("ClientSearchResultPanel.collectFileFingerprintListLabel"));
        actionNameMap.put("AdminQuarantineEnabled", CommandUtil.getCmdRes("ClientSearchResultPanel.adminQuarantineEnabledLabel"));
        actionNameMap.put("AdminQuarantineDisabled", CommandUtil.getCmdRes("ClientSearchResultPanel.adminQuarantineDisabledLabel"));
        actionNameMap.put("Cloud_Managed", CommandUtil.getCmdRes("ClientSearchResultPanel.cloudManagedLabel"));
    }
}

