/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client;

import com.sygate.scm.common.configobject.schema.DisplayFilter;
import com.sygate.scm.console.handler.AdminHandler;
import com.sygate.scm.console.ui.client.ClientComputersTablePanel;
import com.sygate.scm.console.ui.client.CustomViewSortableTableModel;
import com.sygate.scm.console.ui.util.ResultTableModel;
import javax.swing.JTable;

public class ClientViewTableModel
extends ResultTableModel {
    private static final long serialVersionUID = 5483782211951013447L;
    protected int viewType = 0;
    protected boolean isInitialState = true;
    protected String sortColNameKey = null;
    protected int sortModelColOrder = -1;
    protected int sortViewColOrder = -1;
    protected boolean sortDir = true;
    protected ClientComputersTablePanel cctPanel;
    protected DisplayFilter currentAdminDisplayFilter = null;

    public ClientViewTableModel(DisplayFilter df) {
        this(false, df);
    }

    public ClientViewTableModel(boolean isCaseSensitive, DisplayFilter df) {
        super(new CustomViewSortableTableModel(isCaseSensitive));
        ((CustomViewSortableTableModel)this.model).setCCTModel(this);
        this.currentAdminDisplayFilter = df;
        int displayMax = AdminHandler.getCurrentSemAdminFilterPageSize(this.currentAdminDisplayFilter);
        this.setMaxPageRowNumber(displayMax);
    }

    @Override
    public void addMouseListenerToHeaderInTable(JTable table) {
        if (this.model != null && this.model instanceof CustomViewSortableTableModel) {
            ((CustomViewSortableTableModel)this.model).addMouseListenerToHeaderInTable(table);
        }
    }

    public int getSortModelColOrder() {
        return this.sortModelColOrder;
    }

    public void setSortModelColOrder(int sortModelColOrder) {
        this.sortModelColOrder = sortModelColOrder;
        this.isInitialState = false;
    }

    public int getSortViewColOrder() {
        return this.sortViewColOrder;
    }

    public void setSortViewColOrder(int sortViewColOrder) {
        this.sortViewColOrder = sortViewColOrder;
        this.isInitialState = false;
    }

    public String getSortColumnName(int column) {
        return this.columnNames[column];
    }

    public boolean isSortDir() {
        return this.sortDir;
    }

    public void setSortDir(boolean isAscending) {
        this.sortDir = isAscending;
    }

    public void setPanelHandle(ClientComputersTablePanel cctp) {
        this.cctPanel = cctp;
    }

    public ClientComputersTablePanel getPanelHandle() {
        return this.cctPanel;
    }

    public String getSortColNameKey() {
        if (this.cctPanel != null && !this.isInitialState) {
            this.sortColNameKey = this.cctPanel.getCurrentViewSortColNameKey(this.sortViewColOrder);
        }
        return this.sortColNameKey;
    }

    public void resumeModel2InitState() {
        this.isInitialState = true;
        this.sortColNameKey = null;
        this.sortModelColOrder = -1;
        this.sortViewColOrder = -1;
        this.sortDir = true;
        this.currentPage = 0;
    }

    public CustomViewSortableTableModel getSortDelegator() {
        return (CustomViewSortableTableModel)this.model;
    }

    protected String getStackTraceInformation(Exception e) {
        if (e == null) {
            return null;
        }
        StackTraceElement[] stackTraces = e.getStackTrace();
        StringBuilder traceMsg = new StringBuilder();
        if (stackTraces != null && stackTraces.length > 0) {
            for (int i = 0; i < stackTraces.length; ++i) {
                traceMsg.append(stackTraces[i].toString());
                traceMsg.append("\n");
            }
        }
        return traceMsg.toString();
    }

    public void setViewType(int i) {
        this.viewType = i;
    }

    public int getViewType() {
        return this.viewType;
    }
}

