/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client;

import com.sygate.scm.common.acl.AuthorizationManager;
import com.sygate.scm.common.acl.BasicPermission;
import com.sygate.scm.common.acl.GroupPermission;
import com.sygate.scm.common.acl.Permission;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.handler.SoftwarePackageHandler;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.AdminPrivilegeObject;
import com.sygate.scm.console.logicobject.AgentPolicyObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.client.ClientPanel;
import com.sygate.scm.console.ui.client.ClientTask;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.ScmProperties;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class ClientTreePopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = 5740621231722042744L;
    private static final MessageResources MSGREC = MessageResources.getInstance();
    private static final String CLIENT = "com.sygate.scm.console.ui.client.client";
    private static final boolean SYNC_OU_NOW_ENABLED = false;
    private JMenuItem newGroup = new JMenuItem(MSGREC.getString("com.sygate.scm.console.ui.client.client", "ClientPanel.addGroupMenu"));
    private JMenuItem importOU = new JMenuItem(MSGREC.getString("com.sygate.scm.console.ui.client.client", "ClientPanel.importOUMenu"));
    private JMenuItem syncNow = new JMenuItem(MSGREC.getString("com.sygate.scm.console.ui.client.client", "ClientPanel.syncNowMenu"));
    private JMenuItem delete = new JMenuItem(MSGREC.getString("com.sygate.scm.console.ui.client.client", "ClientPanel.DeleteMenu"));
    private JMenuItem rename = new JMenuItem(MSGREC.getString("com.sygate.scm.console.ui.client.client", "ClientPanel.RenameMenu"));
    private JMenuItem move = new JMenuItem(MSGREC.getString("com.sygate.scm.console.ui.client.client", "ClientPanel.MoveMenu"));
    private JMenuItem search = new JMenuItem(MSGREC.getString("com.sygate.scm.console.ui.client.client", "ClientPanel.searchComputersOrUsersMenu"));
    private JMenuItem properties = new JMenuItem(MSGREC.getString("com.sygate.scm.console.ui.client.client", "ClientPanel.propertiesMenu"));
    private JMenuItem scanGroup = new JMenuItem(MSGREC.getString("com.sygate.scm.console.ui.client.client", "ClientPanel.scanNowMenu"));
    private JMenuItem updateGroup = new JMenuItem(MSGREC.getString("com.sygate.scm.console.ui.client.client", "ClientPanel.updateMenu"));
    private JMenuItem updateScanGroup = new JMenuItem(MSGREC.getString("com.sygate.scm.console.ui.client.client", "ClientPanel.updateAndScanNowMenu"));
    private JMenuItem reboot = new JMenuItem(MSGREC.getString("com.sygate.scm.console.ui.client.client", "ClientPanel.rebootMenu"));
    private JMenuItem apOn = new JMenuItem(MSGREC.getString("com.sygate.scm.console.ui.client.client", "ClientPanel.apOnMenu"));
    private JMenuItem apOff = new JMenuItem(MSGREC.getString("com.sygate.scm.console.ui.client.client", "ClientPanel.apOffMenu"));
    private JMenuItem fwOn = new JMenuItem(MSGREC.getString("com.sygate.scm.console.ui.client.client", "ClientPanel.fwOnMenu"));
    private JMenuItem fwOff = new JMenuItem(MSGREC.getString("com.sygate.scm.console.ui.client.client", "ClientPanel.fwOffMenu"));
    private JMenuItem daOn = new JMenuItem(MSGREC.getString("com.sygate.scm.console.ui.client.client", "ClientPanel.daOnMenu"));
    private JMenuItem daOff = new JMenuItem(MSGREC.getString("com.sygate.scm.console.ui.client.client", "ClientPanel.daOffMenu"));
    private JMenuItem collectFileFingerprintList = new JMenuItem(MSGREC.getString("com.sygate.scm.console.ui.client.client", "ClientPanel.collectFileFingerprintListMenu"));
    private JMenuItem adminQuarantineEnabled = new JMenuItem(MSGREC.getString("com.sygate.scm.console.ui.client.client", "ClientPanel.adminQuarantineEnabledLabel"));
    private JMenuItem adminQuarantineDisabled = new JMenuItem(MSGREC.getString("com.sygate.scm.console.ui.client.client", "ClientPanel.adminQuarantineDisabledLabel"));
    private JMenuItem copyDeployment = new JMenuItem(MSGREC.getString("com.sygate.scm.console.ui.client.client", "ClientPanel.copyUpdateSettingsMenu"));
    private JMenuItem refresh = new JMenuItem(MSGREC.getString("com.sygate.scm.console.ui.client.client", "ClientPanel.refreshMenu"));
    private JMenuItem copyPolicy = new JMenuItem(MSGREC.getString("com.sygate.scm.console.ui.client.client", "ClientPanel.copyPolicyMenu"));
    private JMenuItem pastePolicy = new JMenuItem(MSGREC.getString("com.sygate.scm.console.ui.client.client", "ClientPanel.pastePolicyMenu"));
    private JMenu endPointAccess = new JMenu(MSGREC.getString("com.sygate.scm.console.ui.client.client", "ClientPanel.endPointActionsMenu"));
    private JMenuItem exportSylink = new JMenuItem(MSGREC.getString("com.sygate.scm.console.ui.client.client", "ClientPanel.exportSylinkMenu"));
    private JPopupMenu.Separator sep1 = new JPopupMenu.Separator();
    private JPopupMenu.Separator sep2 = new JPopupMenu.Separator();
    private JPopupMenu.Separator sep3 = new JPopupMenu.Separator();
    private JPopupMenu.Separator sep4 = new JPopupMenu.Separator();

    public ClientTreePopupMenu(final ClientPanel clientPanel) {
        LicenseObject licenseObject = LicenseObject.getInstance();
        this.newGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                clientPanel.doAddGroup();
            }
        });
        this.add(this.newGroup);
        this.importOU.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                clientPanel.doImportOU();
            }
        });
        if (!licenseObject.isSBProduct()) {
            this.add(this.importOU);
        }
        this.syncNow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                block2: {
                    GroupObject group = clientPanel.getSelectedGroup(true);
                    try {
                        clientPanel.syncOuForGroup(group);
                    }
                    catch (ConsoleException ex) {
                        LoggerUtilities.logException((Throwable)ex);
                        JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientTreePopupMenu.error"), 0);
                        if (!ex.needRelogin()) break block2;
                        Manager.getFrame().showLoginPanel();
                    }
                }
            }
        });
        if (!licenseObject.isSBProduct()) {
            this.add(this.syncNow);
        }
        this.delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                clientPanel.doDeleteGroup();
            }
        });
        this.add(this.delete);
        this.rename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                clientPanel.doRenameGroup();
            }
        });
        this.add(this.rename);
        this.move.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                clientPanel.doMoveGroup();
            }
        });
        if (!licenseObject.isSBProduct()) {
            this.add(this.move);
        }
        this.search.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                clientPanel.doSearch();
            }
        });
        this.add(this.search);
        this.properties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                clientPanel.doEditProps();
            }
        });
        this.add(this.properties);
        this.add(this.sep4);
        this.scanGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                clientPanel.executeCommand("ScanNow");
            }
        });
        if (AdminPrivilegeObject.hasCommandPrivilege("0xF1")) {
            this.endPointAccess.add(this.scanGroup);
        }
        this.updateGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                clientPanel.executeCommand("Update_Now");
            }
        });
        if (AdminPrivilegeObject.hasCommandPrivilege("0xF2")) {
            this.endPointAccess.add(this.updateGroup);
        }
        this.updateScanGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                clientPanel.executeCommand("Update_ScanNow");
            }
        });
        if (AdminPrivilegeObject.hasCommandPrivilege("0xF3")) {
            this.endPointAccess.add(this.updateScanGroup);
        }
        this.reboot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                clientPanel.executeCommand("Reboot");
            }
        });
        if (AdminPrivilegeObject.hasCommandPrivilege("0xF4")) {
            this.endPointAccess.add(this.reboot);
        }
        this.apOn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                clientPanel.executeCommand("ApOn");
            }
        });
        this.apOff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                clientPanel.executeCommand("ApOff");
            }
        });
        if (AdminPrivilegeObject.hasCommandPrivilege("0xF5")) {
            this.endPointAccess.add(this.apOn);
        }
        this.fwOn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                clientPanel.executeCommand("FwOn");
            }
        });
        if (AdminPrivilegeObject.hasCommandPrivilege("0xF6")) {
            this.endPointAccess.add(this.fwOn);
        }
        this.fwOff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                clientPanel.executeCommand("FwOff");
            }
        });
        if (AdminPrivilegeObject.hasCommandPrivilege("0xF7")) {
            this.endPointAccess.add(this.fwOff);
        }
        this.daOn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                clientPanel.executeCommand("DaOn");
            }
        });
        if (AdminPrivilegeObject.hasCommandPrivilege("0xF9")) {
            this.endPointAccess.add(this.daOn);
        }
        this.daOff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                clientPanel.executeCommand("DaOff");
            }
        });
        if (AdminPrivilegeObject.hasCommandPrivilege("0xFA")) {
            this.endPointAccess.add(this.daOff);
        }
        this.collectFileFingerprintList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                clientPanel.executeCommand("Collect_FileFingerprintList");
            }
        });
        if (AdminPrivilegeObject.hasCommandPrivilege("0xF12")) {
            this.endPointAccess.add(this.collectFileFingerprintList);
        }
        this.adminQuarantineEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent excep) {
                clientPanel.executeCommand("AdminQuarantineEnabled");
            }
        });
        if (ScmProperties.isDeceptionEnabled()) {
            this.endPointAccess.add(this.adminQuarantineEnabled);
        }
        this.adminQuarantineDisabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent excep) {
                clientPanel.executeCommand("AdminQuarantineDisabled");
            }
        });
        if (ScmProperties.isDeceptionEnabled()) {
            this.endPointAccess.add(this.adminQuarantineDisabled);
        }
        if (AdminPrivilegeObject.hasClientCommandPrivilege()) {
            this.add(this.endPointAccess);
            this.add(this.sep1);
        }
        this.copyDeployment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                clientPanel.doCopyDeployments();
            }
        });
        if (!licenseObject.isSBProduct()) {
            this.add(this.copyDeployment);
            this.add(this.sep2);
        }
        this.refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                clientPanel.refreshMenuItemActionPerformed(e);
            }
        });
        this.add(this.refresh);
        this.add(this.sep3);
        this.copyPolicy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                clientPanel.doCopyPolicy();
            }
        });
        this.add(this.copyPolicy);
        this.pastePolicy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                clientPanel.doPastePolicy();
            }
        });
        this.add(this.pastePolicy);
        this.exportSylink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                clientPanel.doExportSylink();
            }
        });
        this.add(this.exportSylink);
    }

    public void setMenuItem(GroupObject groupObj) {
        int count = 0;
        try {
            count = SoftwarePackageHandler.getSoftwareDeploymentEntityCount(groupObj);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        boolean isReadOnly = groupObj.getAccessConstraint() != 0;
        boolean isTemp = groupObj.isTemp();
        boolean isGlobal = groupObj.isGlobal();
        boolean isCloudNode = groupObj.isTypeCloudNode();
        boolean isTypeNativeOrTemp = groupObj.isTypeNative() || isTemp;
        this.endPointAccess.setEnabled(this.isEndPointAccessEnabled(groupObj));
        if (LicenseObject.getInstance().isSBProduct()) {
            AuthorizationManager manager = AuthorizationManager.getInstance();
            PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
            boolean result = manager.checkPermission(context, (Permission)new GroupPermission(groupObj.getSemClientGroup(), BasicPermission.AccessAction.FULL_ACCESS));
            this.newGroup.setEnabled(result);
        } else {
            this.newGroup.setEnabled(isTypeNativeOrTemp && !isReadOnly && !isTemp);
        }
        this.importOU.setEnabled(isTypeNativeOrTemp && !isReadOnly && !isTemp && AdminPrivilegeObject.isCurrentAdminHasRightToImportADOU());
        this.syncNow.setEnabled(!isTypeNativeOrTemp && !isCloudNode && !isReadOnly);
        this.delete.setEnabled(ClientPanel.canDelGroup(groupObj, false) && !isReadOnly);
        this.rename.setEnabled(isTypeNativeOrTemp && !isReadOnly && !isTemp && !isGlobal);
        this.move.setEnabled(ClientPanel.canMoveGroup(groupObj, false) && !isReadOnly);
        this.search.setEnabled(ClientTask.checkGroupReadOnlyPermission(groupObj));
        if (isCloudNode) {
            this.properties.setEnabled(false);
        }
        this.copyDeployment.setEnabled(count > 0);
        this.pastePolicy.setEnabled(PolicyHandler.hasCopiedObject(AgentPolicyObject.class) && !isReadOnly);
        this.syncNow.setVisible(false);
        this.exportSylink.setEnabled(!isReadOnly);
        boolean hasClient = AdminPrivilegeObject.isCurrentAdminHasComputerUserPrivilege();
        this.newGroup.setVisible(hasClient);
        this.importOU.setVisible(hasClient);
        this.syncNow.setVisible(hasClient);
        this.delete.setVisible(hasClient);
        this.rename.setVisible(hasClient);
        this.move.setVisible(hasClient);
        this.search.setVisible(hasClient);
        this.properties.setVisible(hasClient);
        this.scanGroup.setVisible(hasClient);
        this.updateGroup.setVisible(hasClient);
        this.updateScanGroup.setVisible(hasClient);
        this.reboot.setVisible(hasClient);
        this.apOn.setVisible(hasClient);
        this.apOff.setVisible(hasClient);
        this.fwOn.setVisible(hasClient);
        this.fwOff.setVisible(hasClient);
        this.collectFileFingerprintList.setVisible(hasClient);
        this.adminQuarantineEnabled.setVisible(hasClient);
        this.adminQuarantineDisabled.setVisible(hasClient);
        this.copyDeployment.setVisible(hasClient);
        this.refresh.setVisible(hasClient);
        this.sep1.setVisible(hasClient);
        this.sep2.setVisible(hasClient);
        boolean hasPolicy = AdminPrivilegeObject.isCurrentAdminHasPolicyPrivilege();
        this.sep3.setVisible(hasClient && hasPolicy);
        this.copyPolicy.setVisible(hasPolicy);
        if (this.copyPolicy.isVisible()) {
            if (AdminPrivilegeObject.isCurrentAdminHasAllPoliciesTypesPrivilege() && AdminObject.retrieveCurrentAdminObject().hasGroupFullAccessRight()) {
                this.copyPolicy.setEnabled(true);
            } else {
                this.copyPolicy.setEnabled(false);
            }
        }
        this.pastePolicy.setVisible(hasPolicy);
    }

    private boolean isEndPointAccessEnabled(GroupObject groupObj) {
        int access = groupObj.getAccessConstraint();
        switch (access) {
            case 1: {
                return false;
            }
            case 0: {
                return true;
            }
            case 2: {
                return AdminPrivilegeObject.canRunCommandsForReadOnlyGroup();
            }
        }
        return false;
    }
}

