/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.monitor.MonitorAgent;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.console.handler.GroupHandler;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.AdminPrivilegeObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.ui.client.ClientComputersPanel;
import com.sygate.scm.console.ui.client.ClientPanel;
import com.sygate.scm.console.ui.client.ClientRightPanel;
import com.sygate.scm.console.ui.client.GroupStatusPanel;
import com.sygate.scm.console.ui.client.PolicyDeploymentPanel;
import com.sygate.scm.console.ui.client.SoftwareUpdatePanel;
import com.sygate.scm.console.ui.util.SwingWorkerExecutor;
import com.sygate.scm.console.ui.util.TaskPanel;
import com.sygate.scm.console.ui.util.TaskPanelBase;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import java.awt.Component;
import java.awt.Font;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionListener;

public class ClientTaskPanel
extends TaskPanelBase
implements TaskPanel,
ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private static final String AUTOMATION_CLIENT_TASK_PANEL = "ClientTaskPanel";
    private static final String AUTOMATION_CLIENT_TASK_PACKAGE = "ClientPackage";
    private static final String AUTOMATION_CLIENT_TASK_POLICIES = "ClientPolicies";
    private static final int PANEL_INDEX_COMPUTERS_USERS = 0;
    private static final int PANEL_INDEX_INSTALLED_PACKAGES = 3;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String CLIENT = "com.sygate.scm.console.ui.client.client";
    private static final LicenseObject LIC_OBJ = LicenseObject.getInstance();
    private GroupStatusPanel detailPanel;
    private ClientComputersPanel cuPanel;
    private SoftwareUpdatePanel packagePanel;
    private PolicyDeploymentPanel policyPanel;
    private ClientPanel panelClient;
    private JTabbedPane jTBClient;
    private String selectedId;

    public ClientTaskPanel(ClientPanel panelClient) {
        this.panelClient = panelClient;
        this.initialize();
        panelClient.putClientProperty("cssClass", "clientTaskPanelPanelClient");
        this.addTableSelectionListener(panelClient);
    }

    private synchronized void addSerialNumberRefreshThread() {
        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){
            String latestSerialNumber = null;
            String currentSelectedId = null;

            @Override
            protected Object doInBackground() throws Exception {
                while (StringUtilities.isEmpty((String)this.latestSerialNumber)) {
                    try {
                        if (ClientTaskPanel.this.selectedId == null) continue;
                        this.currentSelectedId = ClientTaskPanel.this.selectedId;
                        GroupObject gpObj = GroupHandler.getGroupById(ClientTaskPanel.this.selectedId);
                        Thread.sleep(1000L);
                        this.latestSerialNumber = gpObj.getSerialNumbers()[0];
                    }
                    catch (InterruptedException ie) {
                        break;
                    }
                    catch (ConsoleException ce) {
                        break;
                    }
                }
                return this.latestSerialNumber;
            }

            @Override
            protected void done() {
                super.done();
                if (this.currentSelectedId != null && this.currentSelectedId.equals(ClientTaskPanel.this.selectedId)) {
                    ClientTaskPanel.this.updateGroupSeriaNumber(this.latestSerialNumber);
                }
            }
        };
        SwingWorkerExecutor.getInstance().execute(worker);
    }

    @Override
    public void executeTask(int taskIndex, Object userObject) {
        this.getSelectedPanel().executeTask(taskIndex, userObject);
    }

    @Override
    public void addTableSelectionListener(ListSelectionListener listener) {
        this.cuPanel.addTableSelectionListener(listener);
        this.packagePanel.addTableSelectionListener(listener);
    }

    @Override
    public int getTableSelectedItem() {
        return this.getSelectedPanel().getTableSelectedItem();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return this.getSelectedPanel().getContentSensitiveHelpToken();
    }

    @Override
    protected Component getContentPanel() {
        this.jTBClient = new JTabbedPane();
        this.detailPanel = new GroupStatusPanel();
        this.cuPanel = new ClientComputersPanel();
        this.packagePanel = new SoftwareUpdatePanel();
        this.policyPanel = new PolicyDeploymentPanel();
        UIUtilities.setName(this.jTBClient, "clientPage", UIUtilities.ComponentType.JMENUITEM, AUTOMATION_CLIENT_TASK_PANEL);
        UIUtilities.setName(this.policyPanel, "clientPage", UIUtilities.ComponentType.JPANEL, AUTOMATION_CLIENT_TASK_POLICIES);
        this.detailPanel.putClientProperty("cssClass", "clientTaskPaneldetailPanel");
        this.cuPanel.putClientProperty("cssClass", "clientTaskPanelcuPanel");
        this.packagePanel.putClientProperty("cssClass", "clientTaskPanelpackagePanel");
        this.policyPanel.putClientProperty("cssClass", "clientTaskPanelpolicyPanel");
        this.jTBClient.putClientProperty("cssClass", "clientTaskPaneljTBClient");
        AjaxSwingCommonUtil.executeIfWebConsoleIsNotRunning(() -> this.jTBClient.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.jTBClient.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ClientRightPanel panel = ClientTaskPanel.this.getSelectedPanel();
                if (panel != null) {
                    boolean startup = true;
                    String eventId = null;
                    String scenarioName = null;
                    GroupObject grpObj = ClientTaskPanel.this.panelClient.getSelectedGroup(false);
                    if (grpObj != null) {
                        startup = false;
                        scenarioName = grpObj.getName() + "_Task_" + ClientTaskPanel.this.getSelectedPanel().getTaskType();
                        MonitorAgent.getInstance().startScenario(scenarioName, "SEPM_Java");
                        eventId = MonitorAgent.getInstance().startEvent("UIRequest", null);
                    }
                    panel.setSelectedItem(ClientTaskPanel.this.panelClient.getSelectedGroup(false));
                    ClientTaskPanel.this.getClientPanel().updateTask(ClientTaskPanel.this.getSelectedPanel().getTaskType());
                    if (!startup) {
                        MonitorAgent.getInstance().stopEvent(eventId);
                        MonitorAgent.getInstance().stopScenario(scenarioName);
                    }
                }
            }
        });
        boolean hasClientPrivilege = AdminPrivilegeObject.isCurrentAdminHasComputerUserPrivilege();
        if (hasClientPrivilege) {
            if (LIC_OBJ.isSBProduct()) {
                this.jTBClient.add(MSGRES.getString(CLIENT, "ClientRightTabsPanel.usersOrComputersTab"), this.cuPanel);
            } else {
                this.jTBClient.add(MSGRES.getString(CLIENT, "clientRightTabsPanel.usersOrClientsTab"), this.cuPanel);
            }
        }
        if (AdminPrivilegeObject.isCurrentAdminHasPolicyPrivilege()) {
            this.jTBClient.addTab(null, this.policyPanel);
            JLabel panelTitle = new JLabel(MSGRES.getString(CLIENT, "ClientRightTabsPanel.policyTab"));
            Font f = panelTitle.getFont();
            panelTitle.setFont(f.deriveFont(f.getStyle() | 1));
            UIUtilities.setName(panelTitle, "clientPage", UIUtilities.ComponentType.JMENUITEM, AUTOMATION_CLIENT_TASK_POLICIES);
            this.jTBClient.setTabComponentAt(this.jTBClient.getTabCount() - 1, panelTitle);
        }
        boolean hasPackagePrivilege = AdminPrivilegeObject.isCurrentAdminHasPackagePrivilege();
        if (hasClientPrivilege && !LIC_OBJ.isSBProduct()) {
            this.jTBClient.add(MSGRES.getString(CLIENT, "ClientRightTabsPanel.detailTab"), this.detailPanel);
        }
        if (hasPackagePrivilege && !LIC_OBJ.isSBProduct()) {
            this.jTBClient.addTab(null, this.packagePanel);
            JLabel packagePanelTitle = new JLabel(MSGRES.getString(CLIENT, "ClientRightTabsPanel.packageTab"));
            Font f = packagePanelTitle.getFont();
            packagePanelTitle.setFont(f.deriveFont(f.getStyle() | 1));
            UIUtilities.setName(packagePanelTitle, "clientPage", UIUtilities.ComponentType.JMENUITEM, AUTOMATION_CLIENT_TASK_PACKAGE);
            this.jTBClient.setTabComponentAt(this.jTBClient.getTabCount() - 1, packagePanelTitle);
        }
        return this.jTBClient;
    }

    protected String getTitleIconName() {
        return "client_group_24.gif";
    }

    @Override
    protected String getTitleName() {
        return "";
    }

    public ClientPanel getClientPanel() {
        return this.panelClient;
    }

    public ClientComputersPanel getComputersPanel() {
        return this.cuPanel;
    }

    public void gotoGroupPanel(Object item) {
        this.detailPanel.setSelectedItem(item);
        this.jTBClient.setSelectedComponent(this.detailPanel);
    }

    public void gotoComputersPanel(Object item) {
        this.cuPanel.setSelectedItem(item);
        this.jTBClient.setSelectedIndex(0);
    }

    public void gotoDeploymentPanel(Object item) {
        this.packagePanel.setSelectedItem(item);
        this.jTBClient.setSelectedIndex(3);
    }

    public ClientRightPanel getSelectedPanel() {
        return (ClientRightPanel)this.jTBClient.getSelectedComponent();
    }

    public boolean isGroupPanelSelected() {
        return this.jTBClient.getSelectedComponent() == this.detailPanel;
    }

    public boolean isComputersPanelSelected() {
        return this.jTBClient.getSelectedIndex() == 0;
    }

    public boolean isDeploymentPanelSelected() {
        return this.jTBClient.getSelectedIndex() == 3;
    }

    public void setSelectedItem(TreeItem item) {
        this.updateTitle(this.createTitle(item));
        this.getSelectedPanel().setSelectedItem(item);
        this.updateGroupSerialNumber(item);
        this.selectedId = item.getId();
    }

    protected void updateGroupSerialNumber(TreeItem item) {
        String groupPolicySerial = null;
        if (item != null && item instanceof GroupObject && ((GroupObject)item).getSerialNumbers().length > 0) {
            groupPolicySerial = ((GroupObject)item).getSerialNumbers()[0];
        }
        this.updateGroupSeriaNumber(groupPolicySerial);
        this.addSerialNumberRefreshThread();
    }

    public void updateGroupSeriaNumber(String serialNo) {
        String format = MSGRES.getString(CLIENT, "ClientTaskPanel.groupPolicySerial");
        if (!StringUtilities.isEmpty((String)serialNo)) {
            this.getRightLabel().setText(MessageFormat.format(format, serialNo));
        } else {
            this.getRightLabel().setText(MessageFormat.format(format, ""));
        }
        this.getRightLabel().setVisible(true);
    }

    @Override
    public void refresh() {
        this.getSelectedPanel().refresh();
        if (this.selectedId != null) {
            try {
                this.updateGroupSerialNumber(GroupHandler.getGroupById(this.selectedId));
            }
            catch (ConsoleException e) {
                LoggerUtilities.logException((Throwable)e);
            }
        }
    }

    private String createTitle(TreeItem item) {
        GroupObject groupObj = (GroupObject)item;
        if (groupObj.getAccessConstraint() == 2) {
            Object[] obj = new Object[]{groupObj.getDisplayName()};
            String str = MSGRES.getString(CLIENT, "ClientTaskPanel.readOnlyTitle");
            return MessageFormat.format(str, obj);
        }
        return groupObj.getDisplayName();
    }
}

