/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client;

import com.sygate.scm.common.acl.AuthorizationManager;
import com.sygate.scm.common.acl.BasicPermission;
import com.sygate.scm.common.acl.GroupPermission;
import com.sygate.scm.common.acl.Permission;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.AdminPrivilegeObject;
import com.sygate.scm.console.logicobject.AgentPolicyObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.client.ClientPanel;
import com.sygate.scm.console.ui.client.ClientTaskPanel;
import com.sygate.scm.console.ui.client.EndTaskUsersPopupMenu;
import com.sygate.scm.console.ui.util.TaskObject;
import com.sygate.scm.console.ui.util.TaskPanel;
import com.sygate.scm.console.util.DataobjectManager;
import java.awt.Component;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;

public class ClientTask {
    public static final int COMPUTER_USERS_NO_SELECTION = 0;
    public static final int COMPUTER_USERS_ONE_SELECTION = 1;
    public static final int COMPUTER_USERS_MULTIPLE_SELECTION = 2;
    public static final int POLICY_DEPLOYMENT = 3;
    public static final int GROUP_DETAIL = 4;
    public static final int NO_INSTALLED_PACKAGE = 5;
    public static final int GROUP_ACCESS_DENIED = 6;
    public static final int INSTALLED_PACKAGE_SELECTED = 7;
    public static final int COMPUTER_USERS_ONE_SELECTION_COPY = 8;
    public static final int COMPUTER_USERS_MULTIPLE_SELECTION_COPY = 9;
    public static final int ADD = 0;
    public static final int IMPORT = 1;
    public static final int RENAME = 2;
    public static final int EDIT = 3;
    public static final int DELETE = 4;
    public static final int MOVE = 5;
    public static final int SHOW = 6;
    public static final int HIDE = 7;
    public static final int ABOUT = 8;
    public static final int ADD_GROUP = 9;
    public static final int ADD_COMPUTER = 10;
    public static final int ADD_USER = 12;
    public static final int ENABLE_SENSOR = 13;
    public static final int DISABLE_SENSOR = 14;
    public static final int EDIT_SENSOR = 15;
    public static final int SEARCH = 16;
    public static final int FILTER = 17;
    public static final int DEPLOY = 18;
    public static final int COPY = 19;
    public static final int PASTE = 20;
    public static final int SCAN_COMPUTER_USER_NOW = 21;
    public static final int UPDATE_COMPUTER_USER = 22;
    public static final int UPDATE_SCAN_COMPUTER_USER = 23;
    public static final int REBOOT_COMPUTER_USER = 24;
    public static final int APON_COMPUTER_USER = 25;
    public static final int APOFF_COMPUTER_USER = 26;
    public static final int FWON_COMPUTER_USER = 27;
    public static final int FWOFF_COMPUTER_USER = 28;
    public static final int POWER_ERASER_SCAN_COMPUTER_USER = 53;
    public static final int DAON_COMPUTER_USER = 49;
    public static final int DAOFF_COMPUTER_USER = 50;
    public static final int COLLECT_FILE_FINGERPRINT_LIST = 54;
    public static final int ADMIN_QUARANTINE_ENABLED = 57;
    public static final int ADMIN_QUARANTINE_DISABLED = 58;
    public static final int SCAN_GROUP_NOW = 29;
    public static final int UPDATE_GROUP = 30;
    public static final int UPDATE_SCAN_GROUP = 31;
    public static final int REBOOT_GROUP = 32;
    public static final int APON_GROUP = 33;
    public static final int APOFF_GROUP = 34;
    public static final int FWON_GROUP = 35;
    public static final int FWOFF_GROUP = 36;
    public static final int DAON_GROUP = 51;
    public static final int DAOFF_GROUP = 52;
    public static final int END_POINT_ACTIONS_GROUP = 38;
    public static final int END_POINT_ACTIONS_USER = 39;
    public static final int INSTALL_PACKAGE_EXPORT = 40;
    public static final int INSTALL_PACKAGE_EDIT = 41;
    public static final int INSTALL_PACKAGE_DELETE = 42;
    public static final int IMPORT_OU = 43;
    public static final int EXPORT_SYLINK = 45;
    public static final int EDIT_GROUP = 46;
    public static final int DELETE_GROUP = 47;
    public static final int ADD_NEW_COMPUTERS = 48;
    public static final int LAST_USED = 54;
    private static final Icon addComputerAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("addcomputer.png")));
    private static final Icon copyAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("copy.png")));
    private static final Icon pasteAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("paste.png")));
    private static final Icon manageAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("manage_locations.png")));
    private static final Icon impActiveAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("import.png")));
    private static final Icon addGroupAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("add.png")));
    private static final Icon addInstalledAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("add.png")));
    private static final Icon editAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("edit.png")));
    private static final Icon renameAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("rename.png")));
    private static final Icon moveGroupAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("move_group.png")));
    private static final Icon addLocationAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("addLocation.png")));
    private static final Icon runCommandAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("run_command.png")));
    private static final Icon displayFilterAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("display_filter.png")));
    private static final Icon searchAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("searchComputerUser.png")));
    private static final Icon deleteAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("delete.png")));
    private static final Icon moveComputerAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("moveComputer.png")));
    private static final Icon configureLanSensorAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("config.png")));
    private static final Icon enableUnmanaged = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("unmanaged_enable.png")));
    private static final Icon disableUnmanaged = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("unmanaged_disable.png")));
    private static final Icon exportSylinkAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("export.png")));
    private static final MessageResources MSG_RES = MessageResources.getInstance();
    private static final String CLIENT = "com.sygate.scm.console.ui.client.client";
    private static final String AUTOMATION_TASK_NAME_DEPLOY_PACKAGE = "DeployClientPackage";
    private final ClientPanel panel;
    private boolean isCopyLinkDisplayable;
    private TaskPanel taskPanel = null;
    private EndTaskUsersPopupMenu endTaskUsersPopupMenu;

    public ClientTask(ClientPanel panel) {
        this.panel = panel;
    }

    public List<List<TaskObject>> getTask(int type) {
        Component comp = this.panel.getCurrentTaskPanel();
        if (!(comp instanceof TaskPanel)) {
            return new ArrayList<List<TaskObject>>();
        }
        this.taskPanel = (TaskPanel)((Object)this.panel.getCurrentTaskPanel());
        int tableSelType = this.taskPanel.getTableSelectedItem();
        if (tableSelType != -1) {
            type = tableSelType;
        }
        boolean isReadOnly = this.panel.getSelectedGroup(false).getAccessConstraint() == 2;
        GroupObject group = this.panel.getSelectedGroup(false);
        switch (type) {
            case 0: {
                return this.getComputerUserNoSelectionTask(isReadOnly, group);
            }
            case 1: {
                return this.getComputerUserOneSelectionTask(isReadOnly, false, this.isSelectedOneUserMode(this.taskPanel), this.isSelectedOneLanSensor(this.taskPanel), this.getSelectedOneClientOsType(this.taskPanel), group);
            }
            case 2: {
                return this.getComputerUserMultipleSelectionTask(isReadOnly, false, group);
            }
            case 3: {
                return this.getPolicyDeploymentTask(isReadOnly, group);
            }
            case 4: {
                return this.getGroupDetailTask(isReadOnly, group);
            }
            case 5: {
                return this.getInstalledPackageTask(isReadOnly || !AdminPrivilegeObject.isCurrentAdminHasFullAccessPackagePrivilege());
            }
            case 7: {
                return this.getSelectedInstalledPackageTask(isReadOnly || !AdminPrivilegeObject.isCurrentAdminHasFullAccessPackagePrivilege());
            }
            case 6: {
                return this.getGroupAccessDeniedTask();
            }
            case 8: {
                return this.getComputerUserOneSelectionTask(isReadOnly, true, this.isSelectedOneUserMode(this.taskPanel), this.isSelectedOneLanSensor(this.taskPanel), this.getSelectedOneClientOsType(this.taskPanel), group);
            }
            case 9: {
                return this.getComputerUserMultipleSelectionTask(isReadOnly, true, group);
            }
        }
        return new ArrayList<List<TaskObject>>();
    }

    public Integer getSelectedOneClientOsType(TaskPanel taskPanel) {
        if (taskPanel instanceof ClientTaskPanel) {
            ClientTaskPanel clientTaskPanel = (ClientTaskPanel)taskPanel;
            return clientTaskPanel.getComputersPanel().getComputersTablePanel().getSelectedOneClientOsType();
        }
        return null;
    }

    private boolean isSelectedOneUserMode(TaskPanel taskPanel) {
        if (taskPanel instanceof ClientTaskPanel) {
            ClientTaskPanel clientTaskPanel = (ClientTaskPanel)taskPanel;
            return clientTaskPanel.getComputersPanel().isSelectedOneUserMode();
        }
        return false;
    }

    private boolean isSelectedOneLanSensor(TaskPanel taskPanel) {
        if (taskPanel instanceof ClientTaskPanel) {
            ClientTaskPanel clientTaskPanel = (ClientTaskPanel)taskPanel;
            return clientTaskPanel.getComputersPanel().isSelectedOneLanSensor();
        }
        return false;
    }

    private List<List<TaskObject>> getComputerUserNoSelectionTask(boolean isReadOnly, GroupObject group) {
        ArrayList<TaskObject> task = new ArrayList<TaskObject>();
        this.addTaskAddNewComputers(isReadOnly, task);
        this.createComputerCommonTask(isReadOnly, task, group);
        ArrayList<List<TaskObject>> list = new ArrayList<List<TaskObject>>();
        list.add(task);
        return list;
    }

    private void addTaskAddNewComputers(boolean isReadOnly, List<TaskObject> task) {
        AuthorizationManager manager = AuthorizationManager.getInstance();
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        if (!isReadOnly && manager.checkPermission(context, (Permission)AuthorizationManager.PackagePermission.FULL_ACCESS)) {
            task.add(new TaskObject(MSG_RES.getString(CLIENT, LicenseObject.getInstance().isSBProduct() ? "ClientTask.addNewComputers" : "ClientTask.addNewClient"), 48, addComputerAction));
        }
    }

    private List<List<TaskObject>> getComputerUserOneSelectionTask(boolean isReadOnly, boolean isCopy, boolean isUserMode, boolean isLanSensore, Integer osType, GroupObject group) {
        LicenseObject licenseObject = LicenseObject.getInstance();
        ArrayList<TaskObject> task = new ArrayList<TaskObject>();
        this.addTaskAddNewComputers(isReadOnly, task);
        task.add(new TaskObject(MSG_RES.getString(CLIENT, "ClientTask.editComputerUserProperties"), 3, editAction));
        if (!isReadOnly && !group.isTypeCloudNode()) {
            if (!group.isTypeAd()) {
                task.add(new TaskObject(MSG_RES.getString(CLIENT, "ClientTask.delComputerUser"), 4, deleteAction));
            }
            if (isCopy) {
                task.add(new TaskObject(MSG_RES.getString(CLIENT, "ClientTask.copyComputerUser"), 5, moveComputerAction));
            } else {
                task.add(new TaskObject(MSG_RES.getString(CLIENT, "ClientTask.moveComputerUser"), 5, moveComputerAction));
            }
            if (!licenseObject.isSNACOnlyProduct() && osType != null && 2 != osType && isUserMode && !licenseObject.isSBProduct()) {
                if (isLanSensore) {
                    task.add(new TaskObject(MSG_RES.getString(CLIENT, "ClientTask.disableSensor"), 14, disableUnmanaged));
                } else {
                    task.add(new TaskObject(MSG_RES.getString(CLIENT, "ClientTask.enableSensor"), 13, enableUnmanaged));
                }
            }
        }
        if (AdminPrivilegeObject.hasClientCommandPrivilege() && (!isReadOnly || AdminPrivilegeObject.canRunCommandsForReadOnlyGroup())) {
            task.add(new TaskObject(MSG_RES.getString(CLIENT, "ClientTask.endPointActionsUser"), 39, runCommandAction));
            if (this.taskPanel == null) {
                this.taskPanel = (TaskPanel)((Object)this.panel.getCurrentTaskPanel());
            }
            if (this.taskPanel instanceof ClientTaskPanel) {
                this.endTaskUsersPopupMenu = new EndTaskUsersPopupMenu(((ClientTaskPanel)this.taskPanel).getComputersPanel().getComputersTablePanel());
            }
            this.enableCommands(true, osType);
            this.panel.getSideBarObject().setEndTaskUsersPopupMenu(this.endTaskUsersPopupMenu);
        }
        if (!licenseObject.isSNACOnlyProduct() && isLanSensore) {
            task.add(new TaskObject(MSG_RES.getString(CLIENT, "ClientTask.editSensor"), 15, configureLanSensorAction));
        }
        ArrayList<List<TaskObject>> list = new ArrayList<List<TaskObject>>();
        list.add(task);
        ArrayList<TaskObject> secList = new ArrayList<TaskObject>();
        this.createComputerCommonTask(isReadOnly, secList, group);
        list.add(secList);
        return list;
    }

    private List<List<TaskObject>> getComputerUserMultipleSelectionTask(boolean isReadOnly, boolean isCopy, GroupObject group) {
        ArrayList<TaskObject> task = new ArrayList<TaskObject>();
        if (!isReadOnly && !group.isTypeCloudNode()) {
            this.addTaskAddNewComputers(isReadOnly, task);
            task.add(new TaskObject(MSG_RES.getString(CLIENT, "ClientTask.delComputerUser"), 4, deleteAction));
            if (isCopy) {
                task.add(new TaskObject(MSG_RES.getString(CLIENT, "ClientTask.copyComputerUser"), 5, moveComputerAction));
            } else {
                task.add(new TaskObject(MSG_RES.getString(CLIENT, "ClientTask.moveComputerUser"), 5, moveComputerAction));
            }
            this.enableCommands(false, null);
        }
        if (AdminPrivilegeObject.hasClientCommandPrivilege() && (!isReadOnly || AdminPrivilegeObject.canRunCommandsForReadOnlyGroup())) {
            task.add(new TaskObject(MSG_RES.getString(CLIENT, "ClientTask.endPointActionsUser"), 39, runCommandAction));
            this.enableCommands(false, null);
        }
        ArrayList<List<TaskObject>> list = new ArrayList<List<TaskObject>>();
        list.add(task);
        ArrayList<TaskObject> secList = new ArrayList<TaskObject>();
        this.createComputerCommonTask(isReadOnly, secList, group);
        list.add(secList);
        return list;
    }

    private List<List<TaskObject>> getPolicyDeploymentTask(boolean isReadOnly, GroupObject group) {
        ArrayList<TaskObject> task = new ArrayList<TaskObject>();
        ArrayList<TaskObject> secTask = new ArrayList<TaskObject>();
        boolean isManageClient = AdminPrivilegeObject.isCurrentAdminHasComputerUserPrivilege();
        boolean isSb = LicenseObject.getInstance().isSBProduct();
        if (!isReadOnly && isManageClient && !isSb) {
            task.add(new TaskObject(MSG_RES.getString(CLIENT, "ClientTask.addLoc"), 0, addLocationAction));
        }
        if (isManageClient && !isSb) {
            task.add(new TaskObject(MSG_RES.getString(CLIENT, "ClientTask.manageLoc"), 3, manageAction));
        }
        if (!isReadOnly && isManageClient) {
            task.add(new TaskObject(MSG_RES.getString(CLIENT, "ClientTask.exportSylink"), 45, exportSylinkAction));
        }
        if (AdminPrivilegeObject.isCurrentAdminHasAllPoliciesTypesPrivilege() && AdminObject.retrieveCurrentAdminObject().hasGroupFullAccessRight()) {
            task.add(new TaskObject(MSG_RES.getString(CLIENT, "ClientTask.copyPolicy"), 19, copyAction));
        }
        if (!isReadOnly && PolicyHandler.hasCopiedObject(AgentPolicyObject.class)) {
            task.add(new TaskObject(MSG_RES.getString(CLIENT, "ClientTask.pastePolicy"), 20, pasteAction));
        }
        if (!isReadOnly && isManageClient && !isSb) {
            this.appendAddGroupTask(task, group);
        }
        if (isSb) {
            if (isManageClient && !isReadOnly) {
                this.appendAddGroupTask(secTask, group);
                secTask.add(new TaskObject(MSG_RES.getString(CLIENT, "ClientTask.editGroup"), 46, editAction));
                this.appendDelGroupTask(secTask, group);
            }
            if (AdminPrivilegeObject.hasClientCommandPrivilege() && (!isReadOnly || AdminPrivilegeObject.canRunCommandsForReadOnlyGroup())) {
                secTask.add(new TaskObject(MSG_RES.getString(CLIENT, "ClientTask.endPointActionsGroup"), 38, runCommandAction));
            }
        }
        ArrayList<List<TaskObject>> list = new ArrayList<List<TaskObject>>();
        list.add(task);
        list.add(secTask);
        return list;
    }

    private void appendAddGroupTask(List<TaskObject> taskList, GroupObject group) {
        if (ClientPanel.canAddGroup(group, false)) {
            taskList.add(new TaskObject(MSG_RES.getString(CLIENT, "ClientTask.addGroup"), 9, addGroupAction));
        }
    }

    private void appendDelGroupTask(List<TaskObject> taskList, GroupObject group) {
        if (ClientPanel.canDelGroup(group, false)) {
            taskList.add(new TaskObject(MSG_RES.getString(CLIENT, "ClientTask.delGroup"), 47, deleteAction));
        }
    }

    private void appendRenameGroupTask(List<TaskObject> taskList, GroupObject group) {
        if (ClientPanel.canRenameGroup(group, false)) {
            taskList.add(new TaskObject(MSG_RES.getString(CLIENT, "ClientTask.renameGroup"), 2, renameAction));
        }
    }

    private void appendMoveGroupTask(List<TaskObject> taskList, GroupObject group) {
        if (ClientPanel.canMoveGroup(group, false)) {
            taskList.add(new TaskObject(MSG_RES.getString(CLIENT, "ClientTask.moveGroup"), 5, moveGroupAction));
        }
    }

    private void appendImportOuTask(List<TaskObject> taskList, GroupObject group) {
        if (ClientPanel.canImportOU(group, false)) {
            taskList.add(new TaskObject(MSG_RES.getString(CLIENT, "ClientTask.importOU"), 43, impActiveAction));
        }
    }

    private List<List<TaskObject>> getGroupDetailTask(boolean isReadOnly, GroupObject group) {
        ArrayList<TaskObject> task = new ArrayList<TaskObject>();
        if (!isReadOnly) {
            this.appendAddGroupTask(task, group);
            this.appendImportOuTask(task, group);
            this.appendDelGroupTask(task, group);
            this.appendRenameGroupTask(task, group);
            this.appendMoveGroupTask(task, group);
        }
        if (!group.isTypeCloudNode()) {
            task.add(new TaskObject(MSG_RES.getString(CLIENT, "ClientTask.editGroup"), 3, editAction));
        }
        ArrayList<List<TaskObject>> list = new ArrayList<List<TaskObject>>();
        list.add(task);
        return list;
    }

    private List<List<TaskObject>> getInstalledPackageTask(boolean isReadOnly) {
        ArrayList<TaskObject> task = new ArrayList<TaskObject>();
        if (!isReadOnly) {
            TaskObject taskDeployPackage = new TaskObject(MSG_RES.getString(CLIENT, "ClientTask.deployPackage"), 18, addInstalledAction);
            taskDeployPackage.setAutomationLabel(AUTOMATION_TASK_NAME_DEPLOY_PACKAGE);
            task.add(taskDeployPackage);
        }
        ArrayList<List<TaskObject>> list = new ArrayList<List<TaskObject>>();
        list.add(task);
        return list;
    }

    private List<List<TaskObject>> getSelectedInstalledPackageTask(boolean isReadOnly) {
        ArrayList<TaskObject> task = new ArrayList<TaskObject>();
        if (!isReadOnly) {
            task.add(new TaskObject(MSG_RES.getString(CLIENT, "ClientTask.deletePackage"), 42, deleteAction));
            task.add(new TaskObject(MSG_RES.getString(CLIENT, "ClientTask.editPackageProps"), 41, editAction));
        } else {
            task.add(new TaskObject(MSG_RES.getString(CLIENT, "ClientTask.viewPackageProps"), 41, editAction));
        }
        if (this.isCopyLinkDisplayable) {
            task.add(new TaskObject(MSG_RES.getString(CLIENT, "ClientTask.copyPackage"), 19, copyAction));
            this.isCopyLinkDisplayable = false;
        }
        ArrayList<List<TaskObject>> list = new ArrayList<List<TaskObject>>();
        list.add(task);
        this.isCopyLinkDisplayable = true;
        list.add(this.getInstalledPackageTask(isReadOnly).get(0));
        return list;
    }

    private List<List<TaskObject>> getGroupAccessDeniedTask() {
        return new ArrayList<List<TaskObject>>();
    }

    private void createComputerCommonTask(boolean isReadOnly, List<TaskObject> task, GroupObject group) {
        boolean sbProduct = LicenseObject.getInstance().isSBProduct();
        if (!isReadOnly) {
            this.appendAddGroupTask(task, group);
            if (!sbProduct) {
                this.appendImportOuTask(task, group);
            } else {
                task.add(new TaskObject(MSG_RES.getString(CLIENT, "ClientTask.editGroup"), 46, editAction));
                this.appendDelGroupTask(task, group);
            }
        }
        if (AdminPrivilegeObject.hasClientCommandPrivilege() && (!isReadOnly || AdminPrivilegeObject.canRunCommandsForReadOnlyGroup())) {
            task.add(new TaskObject(MSG_RES.getString(CLIENT, "ClientTask.endPointActionsGroup"), 38, runCommandAction));
        }
        if (ClientTask.checkGroupReadOnlyPermission(group)) {
            task.add(new TaskObject(MSG_RES.getString(CLIENT, "ClientTask.search"), 16, searchAction));
        }
        if (!sbProduct) {
            task.add(new TaskObject(MSG_RES.getString(CLIENT, "ClientTask.filter"), 17, displayFilterAction));
        }
    }

    public static boolean checkGroupReadOnlyPermission(GroupObject groupObject) {
        if (groupObject == null || groupObject.getSemClientGroup() == null) {
            return true;
        }
        AuthorizationManager manager = AuthorizationManager.getInstance();
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        GroupPermission permission = new GroupPermission(groupObject.getSemClientGroup(), BasicPermission.AccessAction.READ_ONLY);
        return manager.checkPermission(context, (Permission)permission);
    }

    public void setEndTaskUsersPopupMenu(EndTaskUsersPopupMenu menu) {
        this.endTaskUsersPopupMenu = menu;
    }

    public EndTaskUsersPopupMenu getEndTaskUsersPopupMenu() {
        return this.endTaskUsersPopupMenu;
    }

    public void enableCommands(boolean isSingleSelection, Integer osType) {
        if (osType == null) {
            System.out.println("The osType is null");
            return;
        }
        MenuElement[] menus = this.endTaskUsersPopupMenu.getSubElements();
        String command = "";
        JMenuItem menu = null;
        for (MenuElement menu2 : menus) {
            menu = (JMenuItem)menu2;
            command = menu.getText();
            if (isSingleSelection) {
                if (2 == osType) {
                    menu.setEnabled(EndTaskUsersPopupMenu.isMenuEnabledForMac(command));
                    continue;
                }
                if (3 != osType) continue;
                menu.setEnabled(EndTaskUsersPopupMenu.isMenuEnabledForLinux(command));
                continue;
            }
            menu.setEnabled(true);
        }
    }

    public EndTaskUsersPopupMenu getSideBarPopup() {
        return this.endTaskUsersPopupMenu;
    }
}

