/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingManager;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.ui.client.ClientSearchResultPanel;
import com.sygate.scm.console.ui.util.ResultTableModel;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.SwingWorker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class ClientTableNavigationPanel
extends ClientSearchResultPanel {
    private static final long serialVersionUID = 1L;
    private final String PAGE_OF = MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "ResultTablePanel.msg.page_of");
    private final String PAGE_RANGE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "ClientSearchResultPanel.msg.pageOf");
    static Pattern numberPattern = Pattern.compile("\\d+");

    public ClientTableNavigationPanel(JPanel parent, ResultTableModel model) {
        super(parent, model);
    }

    @Override
    protected void initialize() {
        this.setLayout(new BorderLayout());
        JPanel jp = new JPanel(new BorderLayout());
        jp.putClientProperty("cssClass", "clientTableContainer");
        jp.add((Component)this.getResultTablePane(), "Center");
        jp.add((Component)this.getPageHandlerPanel(), "South");
        jp.setBorder(null);
        this.add(jp);
    }

    @Override
    protected JPanel getPageHandlerPanel() {
        ImageIcon prevIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("prev.gif")));
        ImageIcon firstIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("first.gif")));
        ImageIcon nextIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("next.gif")));
        ImageIcon lastIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("last.gif")));
        this.jBFirst.setMargin(new Insets(0, 0, 0, 0));
        this.jBFirst.setIcon(firstIcon);
        this.jBFirst.setBorder(null);
        this.jBNext.setMargin(new Insets(0, 0, 0, 0));
        this.jBNext.setIcon(nextIcon);
        this.jBNext.setBorder(null);
        this.jBNext.setText("");
        this.jBPrevious.setMargin(new Insets(0, 0, 0, 0));
        this.jBPrevious.setIcon(prevIcon);
        this.jBPrevious.setBorder(null);
        this.jBPrevious.setText("");
        this.jBLast.setIcon(lastIcon);
        this.jBLast.setMargin(new Insets(0, 0, 0, 0));
        this.jBLast.setBorder(null);
        this.jBPrevious.setEnabled(false);
        this.jBPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientTableNavigationPanel.this.glassPane.setVisible(true);
                SwingWorker worker = new SwingWorker(){

                    public Object construct() {
                        ClientTableNavigationPanel.this.getPage(0);
                        ClientTableNavigationPanel.this.resetPanel(false);
                        return null;
                    }

                    public void finished() {
                        ClientTableNavigationPanel.this.glassPane.setVisible(false);
                        AjaxSwingManager.endOperation();
                    }
                };
                AjaxSwingManager.beginOperation();
                worker.start();
            }
        });
        this.jBFirst.setEnabled(false);
        this.jBFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientTableNavigationPanel.this.glassPane.setVisible(true);
                SwingWorker worker = new SwingWorker(){

                    public Object construct() {
                        ClientTableNavigationPanel.this.getPage(3);
                        ClientTableNavigationPanel.this.resetPanel(false);
                        return null;
                    }

                    public void finished() {
                        ClientTableNavigationPanel.this.glassPane.setVisible(false);
                        AjaxSwingManager.endOperation();
                    }
                };
                AjaxSwingManager.beginOperation();
                worker.start();
            }
        });
        this.jTFPage.setPreferredSize(new Dimension(70, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
        this.jTFPage.setMinimumSize(new Dimension(70, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
        this.jTFPage.setMaximumSize(new Dimension(70, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
        this.jTFPage.setHorizontalAlignment(0);
        this.jTFPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientTableNavigationPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                String pageNumber = ClientTableNavigationPanel.this.jTFPage.getText();
                if (pageNumber != null && pageNumber.trim().length() > 0) {
                    ClientTableNavigationPanel.this.getPage(2);
                    ClientTableNavigationPanel.this.resetPanel(false);
                }
                ClientTableNavigationPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.jBNext.setEnabled(false);
        this.jBNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientTableNavigationPanel.this.glassPane.setVisible(true);
                SwingWorker worker = new SwingWorker(){

                    public Object construct() {
                        ClientTableNavigationPanel.this.getPage(1);
                        ClientTableNavigationPanel.this.resetPanel(false);
                        return null;
                    }

                    public void finished() {
                        ClientTableNavigationPanel.this.glassPane.setVisible(false);
                        AjaxSwingManager.endOperation();
                    }
                };
                AjaxSwingManager.beginOperation();
                worker.start();
            }
        });
        this.jBLast.setEnabled(true);
        this.jBLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientTableNavigationPanel.this.glassPane.setVisible(true);
                SwingWorker worker = new SwingWorker(){

                    public Object construct() {
                        ClientTableNavigationPanel.this.getPage(4);
                        ClientTableNavigationPanel.this.resetPanel(false);
                        return null;
                    }

                    public void finished() {
                        ClientTableNavigationPanel.this.glassPane.setVisible(false);
                        AjaxSwingManager.endOperation();
                    }
                };
                AjaxSwingManager.beginOperation();
                worker.start();
            }
        });
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        panel.setLayout(new BoxLayout(panel, 0));
        this.setWestSide(panel);
        panel.add(Box.createGlue());
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.jBFirst);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.jBPrevious);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.jTFPage);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.jBNext);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.jBLast);
        panel.putClientProperty("cssClass", "tabNavigationPanelClientPanel");
        return panel;
    }

    @Override
    protected void setControls() {
        int pageCount = this.getTableModel().getTotalPages();
        int currentPage = this.getTableModel().getCurrentPage();
        this.jBPrevious.setEnabled(pageCount > 1 && ++currentPage > 1);
        this.jBNext.setEnabled(currentPage < pageCount);
        this.jBFirst.setEnabled(currentPage > 1);
        this.jBLast.setEnabled(currentPage < pageCount);
        this.jTFPage.setEnabled(pageCount > 1);
        this.jTFPage.setText("");
    }

    @Override
    protected void setDisplayOfPageNumbers() {
        int currentPage = this.getTableModel().getCurrentPage() + 1;
        int totalPages = this.getTableModel().getTotalPages();
        if (totalPages == 0) {
            this.jTFPage.setText("");
        } else {
            Object[] obj = new Object[]{Integer.toString(currentPage), Integer.toString(totalPages)};
            String fm = MessageFormat.format(this.PAGE_RANGE, obj);
            this.jTFPage.setText(fm);
        }
    }

    @Override
    protected void resetPanel(boolean resizeColumn) {
        if (resizeColumn) {
            this.resizeTableColumns();
        }
        this.setControls();
        this.setDisplayOfPageNumbers();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int getSelectedPage(String enteredPageNumberString) {
        Object[] obj2 = new Object[]{"\\s*(([1-9]\\d*)|(0*[1-9]\\d*))\\s*", "\\s*(([1-9]\\d*)|(0*[1-9]\\d*))\\s*"};
        Pattern pageRangePattern = Pattern.compile("^" + MessageFormat.format(this.PAGE_RANGE, obj2) + "$");
        Matcher m = pageRangePattern.matcher(this.jTFPage.getText().trim());
        boolean matchFound = m.matches();
        int pageCount = this.getTableModel().getTotalPages();
        if (matchFound) {
            Pattern ps = Pattern.compile("\\{[01]\\}");
            Matcher msequence = ps.matcher(this.PAGE_RANGE);
            int order = 1;
            if (!msequence.find()) throw new IllegalStateException("Invalid page number");
            if (msequence.group().equals("{0}")) {
                order = 1;
            } else if (msequence.group().equals("{1}")) {
                order = 2;
            }
            String pagenum = null;
            Matcher mdigital = numberPattern.matcher(enteredPageNumberString);
            if (!mdigital.find()) throw new IllegalStateException("Invalid page number");
            if (order == 1) {
                pagenum = mdigital.group();
            } else {
                if (order != 2 || !mdigital.find()) throw new IllegalStateException("Invalid page number");
                pagenum = mdigital.group();
            }
            int enteredPageNumber = Integer.parseInt(pagenum);
            if (enteredPageNumber <= pageCount) return --enteredPageNumber;
            enteredPageNumber = pageCount;
            return --enteredPageNumber;
        }
        try {
            int enteredPageNumber = Integer.parseInt(enteredPageNumberString);
            if (enteredPageNumber <= 0) {
                throw new IllegalStateException();
            }
            if (enteredPageNumber <= pageCount) return --enteredPageNumber;
            enteredPageNumber = pageCount;
            return --enteredPageNumber;
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    protected String getDisplayedPageNumber(int pageNumber) {
        int indexOf = this.jTFPage.getText().trim().indexOf(this.PAGE_OF);
        if (indexOf > 1) {
            return this.jTFPage.getText().trim().substring(0, indexOf - 1);
        }
        if (indexOf == -1) {
            return this.jTFPage.getText();
        }
        return "";
    }
}

