/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client;

import com.sygate.scm.common.configobject.rpc.HardwareKey;
import com.sygate.scm.common.configobject.rpc.HardwareKeyArray;
import com.sygate.scm.common.configobject.rpc.RpcData;
import com.sygate.scm.common.configobject.schema.Command;
import com.sygate.scm.common.configobject.table.SemClient;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.common.ui.MultiLineLabel;
import com.sygate.scm.console.handler.GroupHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.SemClientHandler;
import com.sygate.scm.console.handler.SemComputerHandler;
import com.sygate.scm.console.handler.SemUserHandler;
import com.sygate.scm.console.logicobject.AdminPrivilegeObject;
import com.sygate.scm.console.logicobject.ClientObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.client.ClientComputersTablePanel;
import com.sygate.scm.console.ui.client.ClientCustomTableModel;
import com.sygate.scm.console.ui.client.ClientPanel;
import com.sygate.scm.console.ui.client.ClientTaskPanel;
import com.sygate.scm.console.ui.client.CommandUtil;
import com.sygate.scm.console.ui.client.EndTaskUsersPopupMenu;
import com.sygate.scm.console.ui.client.FindObjectPanel;
import com.sygate.scm.console.ui.client.dlg.ClientPropertiesDlg;
import com.sygate.scm.console.ui.client.dlg.ConfigLanSensorDlg;
import com.sygate.scm.console.ui.client.dlg.FindObjectDlg;
import com.sygate.scm.console.ui.client.dlg.PowerEraserScanProgressLinkDlg;
import com.sygate.scm.console.ui.client.dlg.SelectGroupDlg;
import com.sygate.scm.console.ui.dlg.SimpleProgressDlg;
import com.sygate.scm.console.ui.util.ConfirmationMsgBox;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.MultiLineMsgBox;
import com.sygate.scm.console.ui.util.ResultTableModel;
import com.sygate.scm.console.ui.util.SearchResultPanel;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.ScmProperties;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.SwingWorker;
import com.sygate.scm.util.TimeCounter;
import com.sygate.scm.util.Utility;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.ListSelectionEvent;

public class ClientSearchResultPanel
extends SearchResultPanel
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private static final int REFRESH_NODE_OK = 0;
    private static final int REFRESH_NODE_ERROR_KEEPSHOWINGMSG = 1;
    private static final int REFRESH_NODE_ERROR_IGNOREMSG = 2;
    private static final String SCAN_COMMAND = "Scan";
    private final String cantsetnonspaagentaslansensor = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.onlySymantecProtectionAgentIsAllowedMsg");
    private final String CAN_ENABLE_LAN_SENSOR_ON_COMPUTER_ONLY = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.canOnlyEnableLanSensorMsg");
    private final String CAN_DISABLE_ON_LAN_SENSOR_ONLY = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.canOnlyDisableExistingLanSensorMsg");
    private final String CAN_CONFIGURE_ON_LAN_SENSOR_ONLY = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.canOnlyConfigExistingSensorMsg");
    private final String NO_SELECTED_COMPUTER_OR_USER = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.noSelectedComputerOrUserMsg");
    private final String MSG_LAN_SENOR_LICENSE_DISABLED = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.noLanSensorLicMsg");
    private final String ENABLE_LAN_SENSOR_SINGLE_SELECTION_WARNING = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.selectOnlyOneItermToEnableSensorMsg");
    private final String ENABLE_LAN_SENSOR_TITLE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.enableSensorMsg");
    private final String DISABLE_LAN_SENSOR_SINGLE_SELECTION_WARNING = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.selectOnlyOneItemToDisableSensorMsg");
    private final String DISABLE_LAN_SENSOR_TITLE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.disableSensorMsg");
    private final String CONFIGURE_LAN_SENSOR_SINGLE_SELECTION_WARNING = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.selectOneItermToConfigSensorMsg");
    private final String CONFIGURE_LAN_SENSOR_TITLE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.configureSensorMsg");
    private final String DEFAULT_SINGLE_SELECTION_WARNING = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.selectOneItemMsg");
    private final String DEFAULT_SINGLE_SELECTION_TITLE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.singleSelectionMsg");
    private final String DEFAULT_ERROR_TITLE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.error");
    private final String CONSOLE_ERROR_TITLE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.consoleError");
    private final String SWITCH_TO_COMPUTER_MODE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.switchToComputerModeMsg");
    private final String SWITCH_TO_USER_MODE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.swithchToUserModeMsg");
    private final String TITLE_MOVE_TO = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.moveToTitle");
    private final String TITLE_COPY_TO = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.copyToTitle");
    private final String GROUP_CONTAINS_MAX = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.groupContainsMax");
    private static final int PARENT_TYPE_COMPUTER_TABLE = 0;
    private static final int PARENT_TYPE_SEARCH_TABLE = 1;
    private final JMenuItem delMenuItem = new JMenuItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.deleteLabel"));
    private final JMenuItem switchMenuItem = new JMenuItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.switchPolicyModeLabel"));
    private final JMenuItem moveMenuItem = new JMenuItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.moveLabel"));
    private final JMenuItem enableLanSensorMenuItem = new JMenuItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.enableLanSensorLabel"));
    private final JMenuItem disableLanSensorMenuItem = new JMenuItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.disableLanSensorLabel"));
    private final JMenuItem configLanSensorMenuItem = new JMenuItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.configureLanSensorLabel"));
    private final JMenuItem propertyMenuItem = new JMenuItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.propertiesLabel"));
    private final JMenuItem scanComputerUserNowMenuItem = new JMenuItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.scanComputerUserNowLabel"));
    private final JMenuItem updateComputerUserNowMenuItem = new JMenuItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.updateComputerUserNowLabel"));
    private final JMenuItem updateScanComputerUserNowMenuItem = new JMenuItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.updateAndScanComputerUserNowLabel"));
    private final JMenuItem powerEraserScanComputerUserNowMenuItem = new JMenuItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.powerEraserScanComputerUserNowLabel"));
    private final JMenuItem rebootMenuItem = new JMenuItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.rebootLabel"));
    private final JMenuItem apOnMenuItem = new JMenuItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.apOnLabel"));
    private final JMenuItem fwOnMenuItem = new JMenuItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.fwOnLabel"));
    private final JMenuItem fwOffMenuItem = new JMenuItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.fwOffLabel"));
    private final JMenuItem daOnMenuItem = new JMenuItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.daOnLabel"));
    private final JMenuItem daOffMenuItem = new JMenuItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.daOffLabel"));
    private final JMenuItem collectFileFingerprintListMenuItem = new JMenuItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.collectFileFingerprintListLabel"));
    private JMenuItem adminQuarantineEnabledMenuItem = new JMenuItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.adminQuarantineEnabledLabel"));
    private JMenuItem adminQuarantineDisabledMenuItem = new JMenuItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.adminQuarantineDisabledLabel"));
    private final JPopupMenu popup = new JPopupMenu();
    private final JMenu endPointActionMenu = new JMenu(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.endPointActions"));
    private JLabel clientsLabel;
    private JButton jBSearch;
    private static String SEARCH = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.search");
    private final JPanel parent;
    private int[] selectedRows;
    private GroupObject group;
    boolean showErrorMsg = true;
    int parentType = 0;
    private SimpleProgressDlg progressDlg = null;
    private boolean m_isWorkerDone = true;
    private boolean popupEnabled = true;
    private ClientComputersTablePanel cctpPanel;
    boolean noOfLegacyClients = false;

    public ClientSearchResultPanel(JPanel parent, ResultTableModel model) {
        super(model);
        this.parent = parent;
        this.setParentType(parent);
        this.setupPopupMenu();
        this.jBExport.setVisible(!(parent instanceof ClientComputersTablePanel));
        this.jBClear.setVisible(!(parent instanceof ClientComputersTablePanel));
        this.jTResult.setAutoResizeMode(4);
        this.jTResult.setSelectionMode(2);
        this.setTableMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Point origin = e.getPoint();
        int row = this.jTResult.rowAtPoint(origin);
        if (row != -1 && (e.getModifiers() & 0x10) != 0 && e.getClickCount() == 2) {
            this.jTResult.setRowSelectionInterval(row, row);
            this.doProps();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.maybeShowPopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.maybeShowPopup(e);
        }
    }

    @Override
    protected void setWestSide(JPanel panel) {
        if (this.parentType == 0) {
            panel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            this.clientsLabel = new JLabel();
            this.jBSearch = new JButton(SEARCH);
            this.jBSearch.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClientSearchResultPanel.this.doSearch();
                }
            });
            this.jBSearch.setVisible(false);
            panel.add(this.jBSearch);
        }
        super.setWestSide(panel);
    }

    public void setClientLabelTextMax(boolean isMax) {
        if (isMax) {
            this.clientsLabel.setText(this.GROUP_CONTAINS_MAX);
            this.clearPageNumberDisplay();
            if (this.jBSearch != null) {
                this.jBSearch.setVisible(true);
                this.getTableModel().setCurrentPage(-1);
            }
        } else {
            this.clientsLabel.setText("");
            if (this.jBSearch != null) {
                this.jBSearch.setOpaque(false);
                this.jBSearch.setVisible(false);
            }
        }
    }

    private void doSearch() {
        try {
            if (this.group == null) {
                return;
            }
            FindObjectDlg dlg = new FindObjectDlg(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.searchComputersOrUsers"), true);
            dlg.init(this.group);
            dlg.setVisible(true);
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
        }
    }

    private void doDelete(int[] rows) throws ConsoleException {
        if (rows == null) {
            return;
        }
        Boolean okToDelete = false;
        this.showErrorMsg = true;
        Boolean confirmShown = false;
        HashMap<String, ClientObject> theSameUserClientsWithDeletedOnes = new HashMap<String, ClientObject>();
        ArrayList<String> allRelatedOnes = new ArrayList<String>();
        for (int i = 0; i < rows.length; ++i) {
            int row = rows[i];
            TableRow tableRow = this.tableModel.getRow(row);
            ClientObject client = (ClientObject)tableRow;
            if (allRelatedOnes.contains(client.getClientId())) continue;
            String GroupId2 = this.getGroupId(client);
            if (!ClientPanel.canDelClient(client, true)) {
                return;
            }
            HashMap<String, ClientObject> map = this.getClientsBySameUserInUserMode(client, GroupId2);
            allRelatedOnes.addAll(map.keySet());
            if (!this.isParentTypeComputerTable()) {
                okToDelete = this.okToDelete(confirmShown, okToDelete);
                confirmShown = true;
                if (!okToDelete.booleanValue()) continue;
            }
            SemClientHandler.delete(client);
            theSameUserClientsWithDeletedOnes.putAll(map);
        }
        Set entrySet = theSameUserClientsWithDeletedOnes.entrySet();
        for (Map.Entry entry : entrySet) {
            ClientObject client = (ClientObject)entry.getValue();
            if (!ClientPanel.canDelClient(client, true)) {
                return;
            }
            SemClientHandler.delete(client);
        }
        if (this.cctpPanel != null) {
            this.cctpPanel.sort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDelete() {
        final int[] rows = this.getSelectedRows(true, false, null, false);
        if (rows != null && rows.length > 0) {
            try {
                String msg = rows.length > 1 ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.areyouSureToDeleteClientsMsg") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.areyouSureToDeleteClientMsg");
                if (0 != JOptionPane.showConfirmDialog(Manager.getFrame(), msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.deleteMsg"), 0)) {
                    return;
                }
                Manager.getFrame().setCursor(Cursor.getPredefinedCursor(3));
                if (rows.length > 10 && this.isParentTypeComputerTable()) {
                    this.m_isWorkerDone = false;
                    SwingWorker worker = new SwingWorker(){
                        private Throwable exception = null;

                        public Object construct() {
                            try {
                                ClientSearchResultPanel.this.doDelete(rows);
                            }
                            catch (Throwable e) {
                                this.exception = e;
                            }
                            return ClientSearchResultPanel.this.progressDlg;
                        }

                        public void finished() {
                            if (this.exception != null) {
                                if (this.exception instanceof ConsoleException) {
                                    JOptionPane.showMessageDialog(Manager.getFrame(), this.exception.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.consoleError"), 0);
                                    if (((ConsoleException)this.exception).needRelogin()) {
                                        Manager.getFrame().showLoginPanel();
                                    } else {
                                        ClientSearchResultPanel.this.refresh();
                                    }
                                } else {
                                    LoggerUtilities.logException((Throwable)this.exception);
                                }
                            } else {
                                ClientSearchResultPanel.this.refresh();
                            }
                            ClientSearchResultPanel.this.m_isWorkerDone = true;
                            if (ClientSearchResultPanel.this.progressDlg != null) {
                                ClientSearchResultPanel.this.progressDlg.setCursor(Cursor.getDefaultCursor());
                                ClientSearchResultPanel.this.progressDlg.dispose();
                            }
                        }
                    };
                    worker.start();
                    this.progressDlg = new SimpleProgressDlg((Frame)Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.deleteClient(s)Msg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.deletingClientsMsg"), true);
                    this.progressDlg.setCursor(Cursor.getPredefinedCursor(3));
                    this.progressDlg.setVisible(!this.m_isWorkerDone);
                } else {
                    this.doDelete(rows);
                    this.refresh();
                }
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), this.DEFAULT_ERROR_TITLE, 0);
                if (ex.needRelogin()) {
                    Manager.getFrame().showLoginPanel();
                }
            }
            finally {
                Manager.getFrame().setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private boolean isParentTypeComputerTable() {
        return this.parentType == 0;
    }

    private boolean okToDelete(boolean confirmShown, boolean okToDelete) {
        boolean toDelete = true;
        switch (this.parentType) {
            case 0: {
                if (!confirmShown) {
                    toDelete = 0 == JOptionPane.showConfirmDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.areYouSureToDeleteItemMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.deleteMsg"), 0);
                    break;
                }
                toDelete = okToDelete;
                break;
            }
        }
        return toDelete;
    }

    public void setGroup(GroupObject group) {
        this.group = group;
        this.getTableModel().setCurrentPage(0);
    }

    private void doMove(int[] rows, GroupObject newParentGroup, boolean isMove) throws ConsoleException {
        Map.Entry entry;
        ClientObject client;
        if (rows == null) {
            return;
        }
        HashMap<String, ClientObject> theSameClientsWithDetetedOnes = new HashMap<String, ClientObject>();
        ArrayList<String> allRelatedClients = new ArrayList<String>();
        for (int i = 0; i < rows.length; ++i) {
            int row = rows[i];
            TableRow tableRow = this.tableModel.getRow(row);
            ClientObject client2 = (ClientObject)tableRow;
            if (allRelatedClients.contains(client2.getClientId()) || !this.isTargetGroupOk(client2, newParentGroup, isMove)) continue;
            if (!this.moveGroupForOneClient(client2, newParentGroup, isMove, theSameClientsWithDetetedOnes)) break;
            allRelatedClients.addAll(theSameClientsWithDetetedOnes.keySet());
        }
        Set set = theSameClientsWithDetetedOnes.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext() && this.moveGroupForOneClient(client = (ClientObject)(entry = iterator.next()).getValue(), newParentGroup, isMove, null)) {
        }
    }

    private HashMap<String, ClientObject> getClientsBySameUserInUserMode(ClientObject client, String groupId) throws ConsoleException {
        HashMap<String, ClientObject> sameUsersForOneClient = new HashMap<String, ClientObject>();
        String userDomainName = client.getUserDomainName();
        String userName = client.getUserName();
        String domainId = client.getSemClient().getOptDomainId();
        if (client.getPolicyMode() == 1 || "".equals(userDomainName) || "".equals(userName) || "".equals(domainId)) {
            return sameUsersForOneClient;
        }
        RpcData rpc = new RpcData();
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"NAME", (String)userName);
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"DOMAIN_NAME", (String)userDomainName);
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"GROUP_ID", (String)groupId);
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"CLIENT_ID", (String)client.getClientId());
        ArrayList<ClientObject> v = SemClientHandler.get(805, rpc, 0, Integer.MAX_VALUE);
        for (int i = 0; i < v.size(); ++i) {
            sameUsersForOneClient.put(v.get(i).getClientId(), v.get(i));
        }
        return sameUsersForOneClient;
    }

    private boolean moveGroupForOneClient(ClientObject client, GroupObject newParentGroup, boolean isMove, HashMap<String, ClientObject> allTheSameUserClients) throws ConsoleException {
        client = SemClientHandler.getClientById(client.getClientId());
        String oldGroupId = this.getGroupId(client);
        if (isMove) {
            if (!ClientPanel.canMoveClient(client, true)) {
                return false;
            }
            SemClientHandler.moveGroup(client, newParentGroup);
            if (allTheSameUserClients != null) {
                allTheSameUserClients.putAll(this.getClientsBySameUserInUserMode(client, oldGroupId));
            }
        } else {
            if (!ClientPanel.canCopyClient(client, true)) {
                return false;
            }
            if (this.isOkToCopy(client)) {
                SemClientHandler.copyClient(client, newParentGroup, true);
                if (allTheSameUserClients != null) {
                    allTheSameUserClients.putAll(this.getClientsBySameUserInUserMode(client, oldGroupId));
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doMove() {
        final int[] rows = this.getSelectedRows(true, false, null, false);
        if (rows != null && rows.length > 0) {
            Window dlg = null;
            try {
                Manager.getFrame().setCursor(Cursor.getPredefinedCursor(3));
                final boolean isMove = !this.isGroupTypeAdSelected(this.selectedRows);
                dlg = new SelectGroupDlg(isMove ? this.TITLE_MOVE_TO : this.TITLE_COPY_TO, isMove ? 2 : 1);
                ((DialogBase)dlg).setVisible(true);
                if (((DialogBase)dlg).isOk()) {
                    ArrayList<GroupObject> newParentGroups = ((SelectGroupDlg)dlg).getListGroupObjs();
                    for (final GroupObject newParentGroup : newParentGroups) {
                        ClientPanel cp;
                        if (!ClientPanel.checkAndRefreshGroup(newParentGroup, cp = this.getClientPanel())) {
                            return;
                        }
                        if (!this.isTargetGroupOk(null, newParentGroup, isMove)) continue;
                        TimeCounter counter = new TimeCounter();
                        if (rows.length > 10) {
                            this.m_isWorkerDone = false;
                            SwingWorker worker = new SwingWorker(){
                                private Throwable exception = null;

                                public Object construct() {
                                    try {
                                        ClientSearchResultPanel.this.doMove(rows, newParentGroup, isMove);
                                    }
                                    catch (Throwable e) {
                                        this.exception = e;
                                    }
                                    return ClientSearchResultPanel.this.progressDlg;
                                }

                                public void finished() {
                                    if (this.exception != null) {
                                        if (this.exception instanceof ConsoleException) {
                                            JOptionPane.showMessageDialog(Manager.getFrame(), this.exception.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.consoleError"), 0);
                                            if (((ConsoleException)this.exception).needRelogin()) {
                                                Manager.getFrame().showLoginPanel();
                                            } else {
                                                ClientSearchResultPanel.this.refresh();
                                            }
                                        } else {
                                            LoggerUtilities.logException((Throwable)this.exception);
                                        }
                                    } else {
                                        ClientSearchResultPanel.this.refresh();
                                    }
                                    ClientSearchResultPanel.this.m_isWorkerDone = true;
                                    if (ClientSearchResultPanel.this.progressDlg != null) {
                                        ClientSearchResultPanel.this.progressDlg.setCursor(Cursor.getDefaultCursor());
                                        ClientSearchResultPanel.this.progressDlg.dispose();
                                    }
                                }
                            };
                            worker.start();
                            this.progressDlg = new SimpleProgressDlg((Frame)Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.moveClient(s)Msg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.movingClientsMsg"), true);
                            this.progressDlg.setCursor(Cursor.getPredefinedCursor(3));
                            this.progressDlg.setVisible(!this.m_isWorkerDone);
                        } else {
                            this.doMove(rows, newParentGroup, isMove);
                            this.refresh();
                        }
                        System.out.println("<< move: Done! " + counter.toStringEx2(true));
                    }
                }
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), this.CONSOLE_ERROR_TITLE, 0);
                if (ex.needRelogin()) {
                    Manager.getFrame().showLoginPanel();
                }
            }
            finally {
                if (dlg != null) {
                    dlg.dispose();
                }
                Manager.getFrame().setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doProps() {
        int row = this.getSelectedRow(true, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.selectOnlyOneItemToSeePropertiesMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.propertiesMsg"));
        if (row >= 0) {
            Window dlg = null;
            try {
                ClientObject client;
                TableRow tableRow = this.tableModel.getRow(row);
                if (this.isRefreshNodeOK(row, tableRow, true, true) && tableRow instanceof ClientObject && ((DialogBase)(dlg = new ClientPropertiesDlg(client = (ClientObject)tableRow))).isOk()) {
                    this.jTResult.updateUI();
                }
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), this.CONSOLE_ERROR_TITLE, 0);
                if (ex.needRelogin()) {
                    Manager.getFrame().showLoginPanel();
                }
            }
            finally {
                if (dlg != null) {
                    dlg.dispose();
                }
            }
        }
    }

    public void doEnableLANSensor() {
        if (this.isLanSensorLicenseEnabled()) {
            ClientObject client;
            int row = this.getSelectedRow(true, this.ENABLE_LAN_SENSOR_SINGLE_SELECTION_WARNING, this.ENABLE_LAN_SENSOR_TITLE);
            if (row >= 0 && (client = this.getComputerClient(row, true, this.CAN_ENABLE_LAN_SENSOR_ON_COMPUTER_ONLY)) != null) {
                if (this.isSpAgent(client)) {
                    this.setLanSensor(client, true);
                    this.tableModel.fireTableRowsUpdated(row, row);
                    this.getClientPanel().valueChanged(new ListSelectionEvent(this, 0, 0, true));
                } else {
                    JOptionPane.showMessageDialog(Manager.getFrame(), this.cantsetnonspaagentaslansensor, this.DEFAULT_ERROR_TITLE, 0);
                }
            }
        } else {
            JOptionPane.showMessageDialog(Manager.getFrame(), this.MSG_LAN_SENOR_LICENSE_DISABLED, this.DEFAULT_ERROR_TITLE, 0);
        }
    }

    public void doDisableLANSensor() {
        ClientObject client;
        int row = this.getSelectedRow(true, this.DISABLE_LAN_SENSOR_SINGLE_SELECTION_WARNING, this.DISABLE_LAN_SENSOR_TITLE);
        if (row >= 0 && (client = this.getComputerClient(row, true, this.CAN_DISABLE_ON_LAN_SENSOR_ONLY)) != null && this.isLanSensor(client, true, this.CAN_DISABLE_ON_LAN_SENSOR_ONLY)) {
            this.setLanSensor(client, false);
            this.tableModel.fireTableRowsUpdated(row, row);
            this.getClientPanel().valueChanged(new ListSelectionEvent(this, 0, 0, true));
        }
    }

    public void doConfigLANSensor() {
        ClientObject client;
        int row = this.getSelectedRow(true, this.CONFIGURE_LAN_SENSOR_SINGLE_SELECTION_WARNING, this.CONFIGURE_LAN_SENSOR_TITLE);
        if (row >= 0 && (client = this.getComputerClient(row, true, this.CAN_CONFIGURE_ON_LAN_SENSOR_ONLY)) != null && this.isLanSensor(client, true, this.CAN_CONFIGURE_ON_LAN_SENSOR_ONLY)) {
            new ConfigLanSensorDlg(client);
        }
    }

    public void checkLegacyClients() {
        this.noOfLegacyClients = false;
        TableRow[] selectedTableRows = this.getSelectedTableRows(this.selectedRows);
        int rowNum = selectedTableRows.length;
        if (rowNum > 0) {
            for (int i = 0; i < rowNum; ++i) {
                ClientObject clientObj = this.getClient(this.selectedRows[i], false, null);
                if (!clientObj.isLegacyClient()) continue;
                this.noOfLegacyClients = true;
                break;
            }
        }
    }

    public void executeCommand(String cmdName) {
        String actionName;
        block19: {
            Command cmd;
            String msg1;
            this.checkLegacyClients();
            actionName = CommandUtil.getActionName(cmdName);
            if (this.noOfLegacyClients) {
                msg1 = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.legacyClient");
                msg1 = MessageFormat.format(msg1, actionName);
                if (0 != JOptionPane.showConfirmDialog(Manager.getFrame(), new HtmlEnabledJLabel(msg1), actionName, 0)) {
                    return;
                }
            } else if (!"PowerEraser".equalsIgnoreCase(cmdName)) {
                msg1 = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.confirmCmdMsg");
                msg1 = MessageFormat.format(msg1, actionName);
                if (0 != JOptionPane.showConfirmDialog(Manager.getFrame(), msg1, actionName, 0)) {
                    return;
                }
            }
            if ((cmd = CommandUtil.getCommand(cmdName, this.group == null ? null : this.group.getName())) == null) {
                return;
            }
            int[] rows = this.getSelectedRows(false, false, null, false);
            int rowNum = rows.length;
            HardwareKeyArray hwKeyArray = new HardwareKeyArray();
            if (rowNum > 0) {
                String msg;
                for (int i = 0; i < rowNum; ++i) {
                    String key;
                    SemClient client;
                    ClientObject clientObj = this.getClient(rows[i], false, null);
                    if (clientObj == null || (client = clientObj.getSemClient()) == null || (key = client.getOptHardwareKey()) == null || (key = key.trim()).equals("")) continue;
                    HardwareKey hwKey = new HardwareKey();
                    hwKey.setContent(key);
                    hwKeyArray.addHardwareKey(hwKey);
                }
                if (hwKeyArray.getHardwareKeyCount() == 0) {
                    String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.noHardwareKeyTitle");
                    msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.noHardwareKeyMsg");
                    JOptionPane.showMessageDialog(Manager.getFrame(), msg, title, 0);
                    return;
                }
                if ("PowerEraser".equalsIgnoreCase(cmdName)) {
                    String msg12 = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.confirmCmdMsg");
                    msg12 = MessageFormat.format(msg12, actionName);
                    if (hwKeyArray.getHardwareKeyCount() > ScmProperties.getPowerEraserMaxClients()) {
                        msg12 = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.confirmCmdGreaterMaxMsg");
                        msg12 = MessageFormat.format(msg12, ScmProperties.getPowerEraserMaxClients());
                    }
                    if (0 != JOptionPane.showConfirmDialog(Manager.frame, msg12, actionName, 0)) {
                        return;
                    }
                }
                try {
                    GroupHandler.executeCommand(null, hwKeyArray, cmd);
                }
                catch (ConsoleException ex) {
                    String title;
                    if (ex.getErrorCode() == -133169152) {
                        msg = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.commandAlreadyExisted"), actionName);
                        title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.information");
                        MultiLineMsgBox.show(Manager.getFrame(), title, msg, 50, 1, -1);
                    } else if (ex.getErrorCode() == -134217728) {
                        msg = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.commandPartiallyExists"), actionName);
                        title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.information");
                        MultiLineMsgBox.show(Manager.getFrame(), title, msg, 50, 1, -1);
                    }
                    JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), this.CONSOLE_ERROR_TITLE, 0);
                    if (!ex.needRelogin()) break block19;
                    Manager.getFrame().showLoginPanel();
                }
            }
        }
        if ("PowerEraser".equalsIgnoreCase(cmdName)) {
            PowerEraserScanProgressLinkDlg dlg = new PowerEraserScanProgressLinkDlg();
            dlg.setVisible(true);
        } else {
            String msg = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.commandIssued"), actionName);
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.information");
            MultiLineMsgBox.show(Manager.getFrame(), title, msg, 50, 1, -1);
        }
    }

    public void setDisplayFilter() {
        if (this.tableModel != null && this.tableModel instanceof ClientCustomTableModel) {
            ((ClientCustomTableModel)this.tableModel).setDisplayFilter();
        }
        if (this.parent != null && this.parent instanceof ClientComputersTablePanel) {
            ((ClientComputersTablePanel)this.parent).setFilterSelected();
        }
    }

    public TableRow[] getSelectedTableRows() {
        int[] rows = this.getSelectedRows(false, false, null, false);
        return this.getSelectedTableRows(rows);
    }

    private TableRow[] getSelectedTableRows(int[] rows) {
        TableRow[] tableRows = new TableRow[]{};
        if (rows != null && rows.length != 0) {
            tableRows = new TableRow[rows.length];
            for (int i = 0; i < rows.length; ++i) {
                TableRow obj = this.tableModel.getRow(rows[i]);
                if (obj == null) continue;
                tableRows[i] = obj;
            }
        }
        return tableRows;
    }

    private void setParentType(JPanel parent) {
        if (parent != null) {
            if (parent instanceof ClientComputersTablePanel) {
                this.parentType = 0;
            } else if (parent instanceof FindObjectPanel) {
                this.parentType = 1;
            }
        }
    }

    private boolean isTargetGroupOk(ClientObject client, GroupObject targetGroup, boolean isMove) {
        boolean hasFullAccess;
        boolean isTargetGroupOk = true;
        boolean bl = hasFullAccess = targetGroup.getAccessConstraint(true) == 0;
        if (!hasFullAccess) {
            Object[] obj = new Object[]{GroupHandler.getGroupFullPath(targetGroup)};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.noMovePerm");
            String fm = MessageFormat.format(str, obj);
            JOptionPane.showMessageDialog(Manager.getFrame(), fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.consoleError"), 0);
            return false;
        }
        String groupId = this.getGroupId(client);
        if (groupId != null) {
            if (groupId.equals(targetGroup.getId())) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.theUserOrComputerIsInGroupMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.consoleError"), 0);
                isTargetGroupOk = false;
            }
        } else if (this.parentType == 0) {
            isTargetGroupOk = false;
        }
        if (isTargetGroupOk) {
            isTargetGroupOk = this.checkSpecialGroup(targetGroup, isMove);
            if (!isMove && isTargetGroupOk && targetGroup.doesBlockNewUser()) {
                isTargetGroupOk = false;
                Object[] obj = new Object[]{GroupHandler.getGroupFullPath(targetGroup)};
                String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.notAllowedToCopy_Msg");
                String fm = MessageFormat.format(str, obj);
                JOptionPane.showMessageDialog(Manager.getFrame(), fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.consoleError"), 0);
            }
        }
        return isTargetGroupOk;
    }

    private String getGroupId(ClientObject client) {
        String groupId = null;
        switch (this.parentType) {
            case 0: {
                groupId = this.group.getId();
                break;
            }
            case 1: {
                groupId = client == null ? null : client.getGroupId();
                break;
            }
        }
        return groupId;
    }

    private boolean checkSpecialGroup(GroupObject targetGroup, boolean isMove) {
        boolean isGroupOk = true;
        if (targetGroup.isTypeAd()) {
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.notAllowedToCopy_Msg");
            str = isMove ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.cannotBeMovedMsg") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.cannotBeCopiedMsg");
            MultiLineLabel multiL = new MultiLineLabel(str);
            JOptionPane.showMessageDialog(Manager.getFrame(), multiL, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.consoleError"), 0);
            isGroupOk = false;
        }
        return isGroupOk;
    }

    private boolean isOkToCopy(ClientObject client) {
        boolean isOkToCopy = true;
        try {
            String groupPath = SemClientHandler.getGroupFromClientEx(client.getName(), client.getDomainName(), client.getPolicyMode(), 1, false, client.getComputerId());
            if (groupPath != null) {
                groupPath = GroupHandler.getGroupFullPath(groupPath);
                String msg = "";
                if (groupPath != null && groupPath.length() > 0) {
                    String typeName = client.getPolicyModeTypeName();
                    Object[] obj = new Object[]{typeName, client.getCompoundName(false), groupPath};
                    String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.existsInGroupMsg");
                    msg = MessageFormat.format(str, obj);
                } else {
                    Object[] obj = new Object[]{client.getCompoundName(true)};
                    String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.existsInAnotherGroupMsg");
                    msg = MessageFormat.format(str, obj);
                }
                JOptionPane.showMessageDialog(Manager.getFrame(), msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.copyConflictMsg"), 0);
                isOkToCopy = false;
            }
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
            isOkToCopy = true;
        }
        return isOkToCopy;
    }

    private boolean isRefreshNodeOK(int row, TableRow tableRow, boolean useConfirmMsgBox, boolean removeRowIfError) {
        boolean isRefreshNodeOK = true;
        if (this.parentType == 0) {
            int result = this.refreshNode(row, tableRow, this.showErrorMsg, useConfirmMsgBox, removeRowIfError);
            if (result == 1) {
                this.showErrorMsg = true;
                isRefreshNodeOK = false;
            } else if (result == 2) {
                this.showErrorMsg = false;
                isRefreshNodeOK = false;
            }
        }
        return isRefreshNodeOK;
    }

    protected Set<Integer> getSelectedPlatforms() {
        HashSet<Integer> ret = new HashSet<Integer>(3);
        if (this.selectedRows != null && this.selectedRows.length != 0) {
            for (int row : this.selectedRows) {
                ret.add(((ClientObject)this.tableModel.getRow(row)).getClientPlatform());
                if (ret.size() == 3) break;
            }
        }
        return ret;
    }

    private void maybeShowPopup(MouseEvent e) {
        if (!this.popupEnabled) {
            System.out.println("Popup disabled.");
            return;
        }
        this.selectedRows = this.getSelectedRows(false, true, e.getPoint(), (e.getModifiers() & 2) != 0);
        if (this.selectedRows != null && this.selectedRows.length != 0) {
            LicenseObject licenseObject = LicenseObject.getInstance();
            TableRow tableRow = this.tableModel.getRow(this.selectedRows[0]);
            boolean singleSelection = this.selectedRows.length == 1;
            boolean isComputerMode = singleSelection && this.isComputerMode(tableRow);
            boolean isLanSensor = singleSelection && this.isLanSensor(tableRow);
            boolean isGroupTypeAd = this.isGroupTypeAdSelected(this.selectedRows);
            boolean isGroupTypeCloud = this.isGroupTypeCloudSelected(this.selectedRows);
            boolean isLanSensorLicenseEnabled = this.isLanSensorLicenseEnabled();
            boolean isReadOnly = ((ClientObject)tableRow).getGroupObject().getAccessConstraint(true) != 0;
            System.out.println("Popup:  " + ((ClientObject)tableRow).getGroupObject().getName() + "  " + isReadOnly);
            this.switchMenuItem.setVisible(!isReadOnly && !isLanSensor && !licenseObject.isSBProduct());
            this.moveMenuItem.setVisible(!isReadOnly);
            boolean containMacClient = false;
            if (this.getSelectedPlatforms().contains(2)) {
                containMacClient = true;
            }
            this.enableLanSensorMenuItem.setVisible(!containMacClient && !isReadOnly && isComputerMode && !isLanSensor && isLanSensorLicenseEnabled && !licenseObject.isSBProduct());
            this.disableLanSensorMenuItem.setVisible(!containMacClient && isLanSensor && isLanSensorLicenseEnabled);
            this.configLanSensorMenuItem.setVisible(!containMacClient && isLanSensor && isLanSensorLicenseEnabled);
            if (this.enableLanSensorMenuItem.isVisible() && this.getSelectedPlatforms().contains(3)) {
                this.appendDeprecatedBadge(this.enableLanSensorMenuItem, UIUtilities.NOT_SUPPORTED_ON_NEW_LINUX_TIP);
            } else {
                this.removeDeprecatedBadge(this.enableLanSensorMenuItem);
            }
            this.delMenuItem.setEnabled(!isReadOnly && !isGroupTypeAd && !isGroupTypeCloud);
            this.moveMenuItem.setEnabled(!isReadOnly && !isGroupTypeCloud);
            this.disableLanSensorMenuItem.setEnabled(!isReadOnly);
            this.endPointActionMenu.setEnabled(!isReadOnly || AdminPrivilegeObject.canRunCommandsForReadOnlyGroup());
            this.enableCommandsForSelectedPlatforms();
            this.moveMenuItem.setText(isGroupTypeAd ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.copyTxt") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.moveTxt"));
            this.switchMenuItem.setEnabled(singleSelection && !isGroupTypeAd && !isGroupTypeCloud && this.isModeSupported(((ClientObject)tableRow).getMode(), ((ClientObject)tableRow).getClientPlatform()));
            this.switchMenuItem.setText(isComputerMode ? this.SWITCH_TO_USER_MODE : this.SWITCH_TO_COMPUTER_MODE);
            this.enableLanSensorMenuItem.setEnabled(isLanSensorLicenseEnabled);
            this.propertyMenuItem.setEnabled(singleSelection);
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public boolean isModeSupported(int mode, int clientPlatform) {
        if (clientPlatform == 1) {
            return true;
        }
        return !(clientPlatform == 2 ? mode == 1 : clientPlatform == 3 && mode == 1);
    }

    public boolean isGroupTypeAdSelected(int[] selectedRows) {
        boolean isGroupTypeAdSelected = false;
        block0 : switch (this.parentType) {
            case 0: {
                isGroupTypeAdSelected = this.group != null && this.group.isTypeAd();
                break;
            }
            case 1: {
                if (selectedRows == null) break;
                GroupObject group = null;
                for (int i = 0; i < selectedRows.length; ++i) {
                    TableRow tableRow = this.tableModel.getRow(selectedRows[i]);
                    if (tableRow == null || !(tableRow instanceof ClientObject) || (group = ((ClientObject)tableRow).getGroupObject()) == null || !group.isTypeAd()) continue;
                    isGroupTypeAdSelected = true;
                    break block0;
                }
                break;
            }
        }
        return isGroupTypeAdSelected;
    }

    private int[] getSelectedRows(boolean showError, boolean forceSelection, Point clickedPoint, boolean ctrlKeyPressed) {
        int row;
        int[] rows = this.jTResult.getSelectedRows();
        if ((rows == null || rows.length == 0) && showError) {
            JOptionPane.showMessageDialog(Manager.getFrame(), this.NO_SELECTED_COMPUTER_OR_USER, this.DEFAULT_ERROR_TITLE, 0);
        }
        if (forceSelection && clickedPoint != null && (row = this.jTResult.rowAtPoint(clickedPoint)) != -1 && this.outOfRange(row, rows) && !ctrlKeyPressed) {
            rows = new int[]{row};
            this.jTResult.changeSelection(rows[0], this.jTResult.columnAtPoint(clickedPoint), false, false);
        }
        return rows;
    }

    private int getSelectedRow(boolean showError, String errorMsg, String title) {
        boolean isSingle;
        int row = -1;
        int[] rows = this.getSelectedRows(false, false, null, false);
        boolean bl = isSingle = rows.length == 1;
        if (isSingle) {
            row = rows[0];
        } else if (showError) {
            errorMsg = errorMsg == null ? this.DEFAULT_SINGLE_SELECTION_WARNING : errorMsg;
            title = title == null ? this.DEFAULT_SINGLE_SELECTION_TITLE : title;
            JOptionPane.showMessageDialog(Manager.getFrame(), errorMsg, title, 0);
        }
        return row;
    }

    private boolean outOfRange(int row, int[] rows) {
        boolean outOfRange = true;
        if (rows != null) {
            for (int i = 0; i < rows.length; ++i) {
                if (row != rows[i]) continue;
                outOfRange = false;
                break;
            }
        }
        return outOfRange;
    }

    private boolean isComputerMode(TableRow tableRow) {
        return tableRow instanceof ClientObject && ((ClientObject)tableRow).isComputerMode();
    }

    private boolean isLanSensor(TableRow tableRow) {
        return tableRow instanceof ClientObject && this.isLanSensor((ClientObject)tableRow, false, null);
    }

    private boolean isLanSensor(ClientObject client, boolean showError, String errorMsg) {
        boolean isLanSensor;
        boolean bl = isLanSensor = client != null && client.isLanSensor();
        if (!isLanSensor && showError) {
            JOptionPane.showMessageDialog(Manager.getFrame(), errorMsg, this.DEFAULT_ERROR_TITLE, 0);
        }
        return isLanSensor;
    }

    private void setupPopupMenu() {
        boolean isNotSnacOnlyProduct = !LicenseObject.getInstance().isSNACOnlyProduct();
        this.delMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ex) {
                ClientSearchResultPanel.this.doDelete();
                ClientSearchResultPanel.this.refresh("", "");
            }
        });
        this.popup.add(this.delMenuItem);
        this.switchMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ex) {
                ClientSearchResultPanel.this.switchMenuItemActionPerformed(ex);
            }
        });
        this.popup.add(this.switchMenuItem);
        this.moveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent exx) {
                ClientSearchResultPanel.this.doMove();
                ClientSearchResultPanel.this.refresh("", "");
            }
        });
        this.popup.add(this.moveMenuItem);
        this.enableLanSensorMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ex) {
                ClientSearchResultPanel.this.doEnableLANSensor();
            }
        });
        if (isNotSnacOnlyProduct) {
            this.popup.add(this.enableLanSensorMenuItem);
        }
        this.disableLanSensorMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ex) {
                ClientSearchResultPanel.this.doDisableLANSensor();
            }
        });
        if (isNotSnacOnlyProduct) {
            this.popup.add(this.disableLanSensorMenuItem);
        }
        this.configLanSensorMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ex) {
                ClientSearchResultPanel.this.doConfigLANSensor();
            }
        });
        if (isNotSnacOnlyProduct) {
            this.popup.add(this.configLanSensorMenuItem);
        }
        this.scanComputerUserNowMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ex) {
                ClientSearchResultPanel.this.executeCommand("ScanNow");
            }
        });
        if (AdminPrivilegeObject.hasCommandPrivilege("0xF1")) {
            this.endPointActionMenu.add(this.scanComputerUserNowMenuItem);
        }
        this.updateComputerUserNowMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ex) {
                ClientSearchResultPanel.this.executeCommand("Update_Now");
            }
        });
        if (AdminPrivilegeObject.hasCommandPrivilege("0xF2")) {
            this.endPointActionMenu.add(this.updateComputerUserNowMenuItem);
        }
        this.updateScanComputerUserNowMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ex) {
                ClientSearchResultPanel.this.executeCommand("Update_ScanNow");
            }
        });
        if (AdminPrivilegeObject.hasCommandPrivilege("0xF3")) {
            this.endPointActionMenu.add(this.updateScanComputerUserNowMenuItem);
        }
        this.powerEraserScanComputerUserNowMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ex) {
                ClientSearchResultPanel.this.executeCommand("PowerEraser");
            }
        });
        if (AdminPrivilegeObject.hasCommandPrivilege("0xF10")) {
            this.endPointActionMenu.add(this.powerEraserScanComputerUserNowMenuItem);
        }
        this.rebootMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ex) {
                ClientSearchResultPanel.this.executeCommand("Reboot");
            }
        });
        if (AdminPrivilegeObject.hasCommandPrivilege("0xF4")) {
            this.endPointActionMenu.add(this.rebootMenuItem);
        }
        this.apOnMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ex) {
                ClientSearchResultPanel.this.executeCommand("ApOn");
            }
        });
        if (AdminPrivilegeObject.hasCommandPrivilege("0xF5")) {
            this.endPointActionMenu.add(this.apOnMenuItem);
        }
        this.fwOnMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ex) {
                ClientSearchResultPanel.this.executeCommand("FwOn");
            }
        });
        if (AdminPrivilegeObject.hasCommandPrivilege("0xF6")) {
            this.endPointActionMenu.add(this.fwOnMenuItem);
        }
        this.fwOffMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ex) {
                ClientSearchResultPanel.this.executeCommand("FwOff");
            }
        });
        if (AdminPrivilegeObject.hasCommandPrivilege("0xF7")) {
            this.endPointActionMenu.add(this.fwOffMenuItem);
        }
        this.daOnMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ex) {
                ClientSearchResultPanel.this.executeCommand("DaOn");
            }
        });
        if (AdminPrivilegeObject.hasCommandPrivilege("0xF9")) {
            this.endPointActionMenu.add(this.daOnMenuItem);
        }
        this.daOffMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ex) {
                ClientSearchResultPanel.this.executeCommand("DaOff");
            }
        });
        if (AdminPrivilegeObject.hasCommandPrivilege("0xFA")) {
            this.endPointActionMenu.add(this.daOffMenuItem);
        }
        this.collectFileFingerprintListMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ex) {
                ClientSearchResultPanel.this.executeCommand("Collect_FileFingerprintList");
            }
        });
        if (AdminPrivilegeObject.hasCommandPrivilege("0xF12")) {
            this.endPointActionMenu.add(this.collectFileFingerprintListMenuItem);
        }
        this.adminQuarantineEnabledMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent excep) {
                ClientSearchResultPanel.this.executeCommand("AdminQuarantineEnabled");
            }
        });
        if (ScmProperties.isDeceptionEnabled()) {
            this.endPointActionMenu.add(this.adminQuarantineEnabledMenuItem);
        }
        this.adminQuarantineDisabledMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent excep) {
                ClientSearchResultPanel.this.executeCommand("AdminQuarantineDisabled");
            }
        });
        if (ScmProperties.isDeceptionEnabled()) {
            this.endPointActionMenu.add(this.adminQuarantineDisabledMenuItem);
        }
        if (AdminPrivilegeObject.hasClientCommandPrivilege()) {
            this.popup.addSeparator();
            this.popup.add(this.endPointActionMenu);
        }
        this.popup.addSeparator();
        this.propertyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ex) {
                ClientSearchResultPanel.this.doProps();
            }
        });
        this.popup.add(this.propertyMenuItem);
    }

    public JPopupMenu getPopupMenu() {
        return this.popup;
    }

    public void allowPopupMenu(boolean tf) {
        this.popupEnabled = tf;
    }

    private void setLanSensor(ClientObject client, boolean isLanSensor) {
        block4: {
            try {
                client.setLanSensor(isLanSensor);
                SemClientHandler.update(client);
                if (isLanSensor) {
                    ConsoleLogger.logAdminEvent(8213, null, client.getClientId());
                } else {
                    ConsoleLogger.logAdminEvent(8214, null, client.getClientId());
                }
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), this.CONSOLE_ERROR_TITLE, 0);
                if (!ex.needRelogin()) break block4;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    private boolean isSpAgent(ClientObject client) {
        try {
            return SemClientHandler.isSPAgent(client);
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            return false;
        }
    }

    public void setCCTPPanelHandle(ClientComputersTablePanel cctp) {
        this.cctpPanel = cctp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchMenuItemActionPerformed(ActionEvent ex) {
        boolean ok = false;
        boolean isComputerMode = true;
        try {
            Manager.getFrame().setCursor(Cursor.getPredefinedCursor(3));
            TableRow[] selectedTableRows = this.getSelectedTableRows(this.selectedRows);
            ClientObject client = (ClientObject)selectedTableRows[0];
            if (!client.hasComputerId()) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.cannotDoTheSwitchWithoutAnAgentMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.switchErrorMsg"), 0);
                return;
            }
            int groupIsou = -1;
            if (client.isPinned()) {
                groupIsou = 0;
            }
            if (client.isComputerMode()) {
                if (StringUtilities.isEmpty((String)client.getUserName_Same_As_In_DB()) || StringUtilities.isEmpty((String)client.getUserDomainName_Same_As_In_DB())) {
                    String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.cannotSwitchUserNameEmpty") + " " + client.getCompoundName(true);
                    JOptionPane.showMessageDialog(Manager.getFrame(), msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.switchErrorMsg"), 0);
                    return;
                }
                ArrayList<ClientObject> userList = SemUserHandler.getUserList(client.getUserName(), client.getUserDomainName(), client.getHardwareKey(), groupIsou);
                if (userList.size() > 0) {
                    String groupPath = SemUserHandler.getGroupFromUser(client.getUserName(), client.getUserDomainName(), -1, true);
                    String typeName = ClientObject.getPolicyModeTypeName(0);
                    Object[] obj = new Object[]{typeName, client.getUserCompoundName(), groupPath};
                    String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.existsInGroupMsg");
                    String msg = MessageFormat.format(str, obj);
                    JOptionPane.showMessageDialog(Manager.getFrame(), msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.switchConflictMsg"), 0);
                    return;
                }
            } else {
                isComputerMode = false;
                if (client.getComputerName().length() < 1 || client.getComputerDomainName().length() < 1) {
                    Object[] obj = new Object[]{client.getCompoundName(true)};
                    String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.cannotDoSwitchComputerNameEmptyMsg");
                    String msg = MessageFormat.format(str, obj);
                    JOptionPane.showMessageDialog(Manager.getFrame(), msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.switchErrorMsg"), 0);
                    return;
                }
                String groupPath = SemComputerHandler.getGroupFromComputerEx(client.getComputerName(), client.getComputerDomainName(), client.getHardwareKey(), -1, true, groupIsou);
                if (groupPath != null) {
                    String typeName = ClientObject.getPolicyModeTypeName(1);
                    Object[] obj = new Object[]{typeName, client.getComputerCompoundName(), groupPath};
                    String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.existsInGroupMsg");
                    String msg = MessageFormat.format(str, obj);
                    JOptionPane.showMessageDialog(Manager.getFrame(), msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.switchConflictMsg"), 0);
                    return;
                }
            }
            client.switchMode();
            SemClientHandler.update(client);
            if (isComputerMode) {
                ConsoleLogger.logAdminEvent(8208, null, client.getClientId());
            } else {
                ConsoleLogger.logAdminEvent(8202, null, client.getClientId());
            }
            ok = true;
        }
        catch (ConsoleException exx) {
            JOptionPane.showMessageDialog(Manager.getFrame(), exx.getMessage(), this.CONSOLE_ERROR_TITLE, 0);
            if (exx.needRelogin()) {
                Manager.getFrame().showLoginPanel();
            }
        }
        finally {
            if (ok) {
                this.refresh();
                if (this.cctpPanel != null) {
                    this.cctpPanel.sort();
                }
            }
            Manager.getFrame().setCursor(Cursor.getDefaultCursor());
        }
    }

    private void refresh() {
        switch (this.parentType) {
            case 0: {
                this.refresh("", "");
                break;
            }
            case 1: {
                ((FindObjectPanel)this.parent).search();
                break;
            }
        }
    }

    private ClientObject getComputerClient(int row, boolean showError, String errorMsg) {
        ClientObject client = (ClientObject)this.tableModel.getRow(row);
        if (client == null || !client.isComputerMode()) {
            if (showError) {
                JOptionPane.showMessageDialog(Manager.getFrame(), errorMsg, this.DEFAULT_ERROR_TITLE, 0);
            }
            return null;
        }
        return client;
    }

    private ClientObject getClient(int row, boolean showError, String errorMsg) {
        ClientObject client = (ClientObject)this.tableModel.getRow(row);
        if (client == null) {
            if (showError) {
                JOptionPane.showMessageDialog(Manager.getFrame(), errorMsg, this.DEFAULT_ERROR_TITLE, 0);
            }
            return null;
        }
        return client;
    }

    private boolean isLanSensorLicenseEnabled() {
        return LicenseObject.getInstance().isLANSensor();
    }

    private int refreshNode(int index, TableRow tableRow, boolean showErrorMsg, boolean useConfirmMsgBox, boolean removeRowIfError) {
        int result = 1;
        if (tableRow != null) {
            ClientObject client = (ClientObject)tableRow;
            try {
                ClientObject newClient = SemClientHandler.getClientById(client.getId());
                if (newClient == null) {
                    if (showErrorMsg) {
                        if (useConfirmMsgBox) {
                            Object[] obj = new Object[]{client.getCompoundName(true)};
                            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.doesnotExistInSystem");
                            String msg = MessageFormat.format(str, obj);
                            result = this.getConfirmResult(client, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.consoleErrorOutOfSync"), msg);
                        } else {
                            Object[] obj = new Object[]{client.getCompoundName(true)};
                            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.doesnotExistInSystem");
                            String msg = MessageFormat.format(str, obj);
                            JOptionPane.showMessageDialog(Manager.getFrame(), msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.consoleErrorOutOfSync"), 0);
                        }
                    }
                    if (removeRowIfError) {
                        this.tableModel.removeRow(index);
                        this.tableModel.fireTableRowsDeleted(index, index);
                    }
                } else if (!newClient.getGroupId().equals(client.getGroupId())) {
                    if (showErrorMsg) {
                        Object[] obj = new Object[]{client.getCompoundName(true), GroupHandler.getGroupFullPath(client.getGroupId())};
                        String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.isMovedIntoGroup");
                        String msg = MessageFormat.format(str, obj);
                        if (useConfirmMsgBox) {
                            result = this.getConfirmResult(client, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.consoleErrorOutOfSync"), msg);
                        } else {
                            JOptionPane.showMessageDialog(Manager.getFrame(), msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.consoleErrorOutOfSync"), 0);
                        }
                    }
                    if (removeRowIfError) {
                        this.tableModel.removeRow(index);
                        this.tableModel.fireTableRowsDeleted(index, index);
                    }
                } else {
                    result = 0;
                }
            }
            catch (ConsoleException ex) {
                int errorCode = ex.getErrorCode();
                if (ex.needRelogin()) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.consoleError"), 0);
                    Manager.getFrame().showLoginPanel();
                    result = 2;
                } else if (errorCode == 0x16010000 || errorCode == 302645248) {
                    if (showErrorMsg) {
                        Object[] obj = new Object[]{client.getCompoundName(true)};
                        String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel._doesnotExistInSystemMsg");
                        String msg = MessageFormat.format(str, obj);
                        if (useConfirmMsgBox) {
                            result = this.getConfirmResult(client, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.consoleErrorOutOfSync"), msg);
                        } else {
                            JOptionPane.showMessageDialog(Manager.getFrame(), msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.consoleErrorOutOfSync"), 0);
                        }
                    }
                    if (removeRowIfError) {
                        this.tableModel.removeRow(index);
                        this.tableModel.fireTableRowsDeleted(index, index);
                    }
                } else if (showErrorMsg) {
                    if (useConfirmMsgBox) {
                        result = this.getConfirmResult(client, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.consoleErrorOutOfSync"), ex.getMessage());
                    } else {
                        JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientSearchResultPanel.consoleErrorOutOfSync"), 0);
                    }
                }
            }
            catch (Exception ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
        }
        return result;
    }

    private int getConfirmResult(ClientObject client, String title, String detail) {
        ConfirmationMsgBox msgbox = new ConfirmationMsgBox(Manager.getFrame(), title);
        msgbox.init(detail, 50);
        msgbox.show();
        return msgbox.isChecked() ? 2 : 1;
    }

    private ClientPanel getClientPanel() {
        for (Container cx = this.getParent(); cx != null; cx = cx.getParent()) {
            if (!(cx instanceof ClientTaskPanel)) continue;
            return ((ClientTaskPanel)cx).getClientPanel();
        }
        return null;
    }

    public void enableCommandsForSelectedPlatforms() {
        Set<Integer> selectedPlatforms = this.getSelectedPlatforms();
        int menuCount = this.endPointActionMenu.getItemCount();
        boolean areAllMacRequiringReboot = this.areAllMacClientWithRestartRequired(selectedPlatforms);
        boolean enableCommand = true;
        for (int commandCount = 0; commandCount < menuCount; ++commandCount) {
            JMenuItem commandMenu = this.endPointActionMenu.getItem(commandCount);
            if (selectedPlatforms.contains(1)) {
                enableCommand = true;
                this.removeDeprecatedBadge(commandMenu);
            } else if (areAllMacRequiringReboot) {
                enableCommand = false;
            } else {
                String action = commandMenu.getActionCommand();
                enableCommand = true;
                if (selectedPlatforms.contains(2)) {
                    enableCommand = EndTaskUsersPopupMenu.isMenuEnabledForMac(action);
                }
                if (enableCommand && selectedPlatforms.contains(3)) {
                    String tooltip;
                    enableCommand = EndTaskUsersPopupMenu.isMenuEnabledForLinux(action);
                    if (enableCommand && !action.equals(SCAN_COMMAND) && (tooltip = EndTaskUsersPopupMenu.getDeprecatedTooltipForNewLinux(action)) != null) {
                        this.appendDeprecatedBadge(commandMenu, tooltip);
                    }
                } else {
                    this.removeDeprecatedBadge(commandMenu);
                }
            }
            commandMenu.setEnabled(enableCommand);
        }
    }

    private void appendDeprecatedBadge(JMenuItem menuItem, String tooltip) {
        menuItem.setIcon(UIUtilities.DEPRECATED_LINUX_ICON);
        menuItem.setHorizontalTextPosition(2);
        menuItem.setToolTipText(tooltip);
    }

    private void removeDeprecatedBadge(JMenuItem menuItem) {
        menuItem.setIcon(null);
        menuItem.setToolTipText("");
    }

    private boolean isGroupTypeCloudSelected(int[] selectedRows) {
        boolean isGroupTypeAdSelected = false;
        block0 : switch (this.parentType) {
            case 0: {
                isGroupTypeAdSelected = this.group != null && this.group.isTypeCloudNode();
                break;
            }
            case 1: {
                if (selectedRows == null) break;
                GroupObject group = null;
                for (int i = 0; i < selectedRows.length; ++i) {
                    TableRow tableRow = this.tableModel.getRow(selectedRows[i]);
                    if (tableRow == null || !(tableRow instanceof ClientObject) || (group = ((ClientObject)tableRow).getGroupObject()) == null || !group.isTypeCloudNode()) continue;
                    isGroupTypeAdSelected = true;
                    break block0;
                }
                break;
            }
        }
        return isGroupTypeAdSelected;
    }

    protected boolean areAllMacClientWithRestartRequired(Set<Integer> selPltfrms) {
        boolean result = false;
        if (selPltfrms != null && selPltfrms.contains(2) && selPltfrms.size() == 1 && this.selectedRows != null && this.selectedRows.length != 0) {
            result = true;
            for (int row : this.selectedRows) {
                if (((ClientObject)this.tableModel.getRow(row)).getDeployStatus() == 302456833) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public void cleanUp() {
        this.group = null;
    }
}

