/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client;

import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.ui.MainPanel;
import com.sygate.scm.console.ui.client.ClientPanel;
import com.sygate.scm.console.ui.client.HtmlPanel;
import com.sygate.scm.console.ui.client.XSLTPanel;
import com.sygate.scm.console.ui.util.TabbedPageModel;
import com.sygate.scm.console.ui.util.TaskPanel;
import com.sygate.scm.console.util.NativeCommandUtilities;
import com.sygate.scm.util.SimpleTemplateParser;
import com.sygate.scm.util.Utility;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionListener;

public abstract class ClientRightPanel
extends JPanel
implements TabbedPageModel,
TaskPanel,
ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private static String urlOfConsoleMainDir = "";
    private HtmlPanel htmlPane;
    private ClientPanel clientPanel;

    public ClientRightPanel() {
        this(false);
    }

    public ClientRightPanel(boolean useXSLTemplate) {
        this.htmlPane = useXSLTemplate ? this.getXSLTPanel() : new HtmlPanel(this.getHtmlTemplateFileName());
        this.htmlPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                ClientRightPanel.this.doCommonTasks(e.getURL().getRef());
            }
        });
    }

    @Override
    public void executeTask(int taskIndex, Object userObject) {
    }

    @Override
    public void addTableSelectionListener(ListSelectionListener listener) {
    }

    @Override
    public void refresh() {
        this.setSelectedItem(this.getCurrentSelectedGroup());
    }

    protected void doCommonTasks(String ref) {
    }

    protected ClientPanel getClientPane() {
        if (this.clientPanel == null) {
            this.clientPanel = (ClientPanel)MainPanel.getCurrentPanel();
        }
        return this.clientPanel;
    }

    protected JTextPane getHtmlPane() {
        return this.htmlPane;
    }

    protected SimpleTemplateParser getHtmlParser() {
        return this.htmlPane.getTemplateParser();
    }

    protected void updateHtmlPane() {
        this.htmlPane.updateText();
    }

    protected XSLTPanel getXSLTPanel() {
        return new XSLTPanel(this.getHtmlTemplateFileName());
    }

    protected abstract String getHtmlTemplateFileName();

    protected abstract int getTaskType();

    private GroupObject getCurrentSelectedGroup() {
        GroupObject newGroup = this.getClientPane().getSelectedGroup(true);
        if (newGroup == null) {
            return null;
        }
        if (newGroup.getItemType() != 10 && newGroup.getItemType() != 11 && newGroup.getItemType() != 9 && newGroup.getItemType() != 307) {
            return null;
        }
        return newGroup;
    }

    public static String getUrlOfConsoleMainDir() {
        return urlOfConsoleMainDir;
    }

    @Override
    public int getTableSelectedItem() {
        return -1;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return null;
    }

    static {
        urlOfConsoleMainDir = Utility.escapeRegexString((String)NativeCommandUtilities.getConsoleMainClassDir());
    }
}

