/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client;

import com.sygate.scm.common.configobject.rpc.RpcData;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.handler.SemComputerHandler;
import com.sygate.scm.console.handler.SemUserHandler;
import com.sygate.scm.console.logicobject.ClientObject;
import com.sygate.scm.console.logicobject.ComputerObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.logicobject.UserObject;
import com.sygate.scm.console.ui.client.ClientSearchSortableTableModel;
import com.sygate.scm.console.ui.util.QueryTableModel;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class ClientQueryTableModel
extends QueryTableModel {
    private static final long serialVersionUID = 1L;
    private boolean isComputer;
    private int columnIndex = -1;
    private boolean isAscending = true;
    private static final MessageResourcesFile MSGRES = new MessageResourcesFile("com.sygate.scm.console.ui.client.client");
    private static final HashMap<String, String> COMPUTER_COLUMNS_MAP = new HashMap();
    private static final HashMap<String, String> USER_COLUMNS_MAP;

    public ClientQueryTableModel() {
        super(new ClientSearchSortableTableModel(true));
        ((ClientSearchSortableTableModel)this.model).setTableModel(this);
        this.setIsFixedColumns(true);
    }

    public void setColumnIndex(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public void setAscending(boolean isAscending) {
        this.isAscending = isAscending;
    }

    public String getOrder(boolean isAscending) {
        return isAscending ? " ASC" : " DESC";
    }

    public void resetData() {
        super.resetData(this.getCurrentPage() * this.getMaxPageRowNumber(), this.getMaxPageRowNumber(), "", " ");
    }

    public boolean setQueryString(RpcData rpc, boolean isComputer) {
        if (rpc.getSqlParameterCount() == 0) {
            this.rowCount = 0;
            return false;
        }
        this.isComputer = isComputer;
        this.rpc = rpc;
        this.rowCount = this.getRowCount(this.getUnmodifiedRpcData());
        boolean isValidQuery = this.rowCount != -1;
        this.rowCount = this.rowCount < 0 ? 0 : this.rowCount;
        return isValidQuery;
    }

    @Override
    protected int getRowCount(String queryString) {
        return this.getRowCount(this.getUnmodifiedRpcData());
    }

    @Override
    protected void doQuery(int start, int size, boolean isForExport) {
        ArrayList<ClientObject> result = null;
        try {
            RpcData rpc = this.getUnmodifiedRpcData();
            if (this.isComputer) {
                if (this.columnIndex > -1) {
                    Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"STRING", (String)(COMPUTER_COLUMNS_MAP.get(this.getColumnName(this.columnIndex)) + this.getOrder(this.isAscending)));
                }
                result = SemComputerHandler.findComputerCompositeInfo(rpc, start, size, isForExport);
            } else {
                if (this.columnIndex > -1) {
                    Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"STRING", (String)(USER_COLUMNS_MAP.get(this.getColumnName(this.columnIndex)) + this.getOrder(this.isAscending)));
                }
                result = SemUserHandler.findUserCompositeInfo(rpc, start, size, isForExport);
            }
        }
        catch (Exception e) {
            System.out.println("ClientQueryTableModel.doQuery(): exception=");
            LoggerUtilities.logException((Throwable)e);
        }
        this.setPageData(result, 0, size, isForExport);
    }

    protected void setPageData(ArrayList<ClientObject> result) {
        this.setPageData(result, 0, this.getMaxPageRowNumber(), false);
    }

    protected void setPageData(ArrayList<ClientObject> result, int start, int size, boolean isForExport) {
        Vector queryData = isForExport ? this.exportData : this.data;
        queryData.clear();
        if (result != null) {
            int count = result.size();
            for (int i = start; i < start + Math.min(count, size); ++i) {
                TableRow obj = result.get(i);
                if (obj == null || !(obj instanceof ClientObject)) continue;
                ((ClientObject)obj).setShowOnlineStatus(true);
                if (obj instanceof ComputerObject) {
                    ((ComputerObject)obj).setShowFinderTable(true);
                } else {
                    ((UserObject)obj).setShowFinderTable(true);
                }
                queryData.add(obj);
            }
        }
    }

    private int getRowCount(RpcData rpc) {
        try {
            if (this.isComputer) {
                return SemComputerHandler.findComputerCount(rpc);
            }
            return SemUserHandler.findUserCount(rpc);
        }
        catch (Exception e) {
            System.out.println("ClientQueryTableModel.getRowCount(): failed to find computer count, exception=" + e.getMessage());
            LoggerUtilities.logException((Throwable)e);
            return 0;
        }
    }

    static {
        COMPUTER_COLUMNS_MAP.put(MSGRES.getString("FindObjectPanel.nameCName"), "SEM_CLIENT.COMPUTER_NAME");
        COMPUTER_COLUMNS_MAP.put(MSGRES.getString("FindObjectPanel.operatingSystemCName"), "SEM_COMPUTER.OPERATION_SYSTEM");
        COMPUTER_COLUMNS_MAP.put(MSGRES.getString("FindObjectPanel.domainCName"), "SEM_CLIENT.COMPUTER_DOMAIN_NAME");
        COMPUTER_COLUMNS_MAP.put(MSGRES.getString("FindObjectPanel.descriptonCName"), "SEM_CLIENT.DESCRIPTION");
        USER_COLUMNS_MAP = new HashMap();
        USER_COLUMNS_MAP.put(MSGRES.getString("FindObjectPanel.nameCName"), "SEM_CLIENT.USER_NAME");
        USER_COLUMNS_MAP.put(MSGRES.getString("FindObjectPanel.operatingSystemCName"), "SEM_COMPUTER.OPERATION_SYSTEM");
        USER_COLUMNS_MAP.put(MSGRES.getString("FindObjectPanel.domainCName"), "SEM_CLIENT.USER_DOMAIN_NAME");
        USER_COLUMNS_MAP.put(MSGRES.getString("FindObjectPanel.descriptonCName"), "SEM_CLIENT.DESCRIPTION");
    }
}

