/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client;

import com.sygate.scm.common.configobject.TimeUtil;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.rpc.Group;
import com.sygate.scm.common.configobject.rpc.GroupArray;
import com.sygate.scm.common.configobject.schema.Command;
import com.sygate.scm.common.configobject.schema.DirectoryServer;
import com.sygate.scm.common.configobject.schema.SemAgentPolicy;
import com.sygate.scm.common.configobject.schema.SemClientGroup;
import com.sygate.scm.common.configobject.schema.SemClientGroupTree;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.AjaxSwingManager;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.common.ui.UIFontUtilities;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.AdminHandler;
import com.sygate.scm.console.handler.GroupHandler;
import com.sygate.scm.console.handler.ImportADSIHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.handler.SoftwarePackageHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.AdminPrivilegeObject;
import com.sygate.scm.console.logicobject.AgentPolicyObject;
import com.sygate.scm.console.logicobject.ClientObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.OrganizationalUnitObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.ui.client.ClientComputersPanel;
import com.sygate.scm.console.ui.client.ClientTask;
import com.sygate.scm.console.ui.client.ClientTaskPanel;
import com.sygate.scm.console.ui.client.ClientTreePopupMenu;
import com.sygate.scm.console.ui.client.CommandUtil;
import com.sygate.scm.console.ui.client.EndTaskActionsPopupMenu;
import com.sygate.scm.console.ui.client.EndTaskUsersPopupMenu;
import com.sygate.scm.console.ui.client.GroupAccessDeniedPanel;
import com.sygate.scm.console.ui.client.dlg.AddGroupDlg;
import com.sygate.scm.console.ui.client.dlg.ExportSylinkDlg;
import com.sygate.scm.console.ui.client.dlg.FindObjectDlg;
import com.sygate.scm.console.ui.client.dlg.GroupPropertiesDlg;
import com.sygate.scm.console.ui.client.dlg.ImportADSIDlg;
import com.sygate.scm.console.ui.client.dlg.InstallClientWizardDialog;
import com.sygate.scm.console.ui.client.dlg.RenameGroupDlg;
import com.sygate.scm.console.ui.client.dlg.SelectGroupDlg;
import com.sygate.scm.console.ui.dlg.SwingWorkerProgressDialog;
import com.sygate.scm.console.ui.monitoring.Browser;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.MultiLineMsgBox;
import com.sygate.scm.console.ui.util.PagePanel;
import com.sygate.scm.console.ui.util.SideBar;
import com.sygate.scm.console.ui.util.SortableTreeNode;
import com.sygate.scm.console.ui.util.SwingWorkerExecutor;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.KeepAlive;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.ldap.LdapPath;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ClientPanel
extends PagePanel {
    private static final long serialVersionUID = -6208601485206468778L;
    private static final String AUTOMATION_ID_GROUP_TREE_NODE = "ClientTabGroupTreeNode";
    private static final String AUTOMATION_ID_CLIENT_SIDE_BAR = "ClientSideBar";
    public static final int USERS_AND_COMPUTERS_NODE = 1;
    public static final int PACKAGE_NODE_INDEX = 2;
    protected JTree tree = new JTree();
    private ClientTreePopupMenu popup;
    private ClientTaskPanel panelClientTabs;
    private GroupAccessDeniedPanel groupAccessDeniedPanel = new GroupAccessDeniedPanel();
    private String lastGroupTreeRefreshChecksum = "";
    private ClientTask clientTask;
    private GroupObject groupCopyDeploymentSource;
    private EndTaskActionsPopupMenu endTaskpopupMenu;

    @Override
    public void initPanel() {
        this.initialize();
        this.clientTask = new ClientTask(this);
        this.panelClientTabs = new ClientTaskPanel(this);
        this.popup = new ClientTreePopupMenu(this);
        this.endTaskpopupMenu = new EndTaskActionsPopupMenu(this);
        this.sideBar.setEndTaskPopupMenu(this.endTaskpopupMenu);
        this.sideBar.setEndTaskUsersPopupMenu(this.clientTask.getSideBarPopup());
        final ImageIcon cloudIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("Terra_2_sec.gif")));
        UIUtilities.setName(this.sideBar, "clientPage", UIUtilities.ComponentType.JPANEL, AUTOMATION_ID_CLIENT_SIDE_BAR);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ClientPanel.this.treeValueChanged(e);
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.maybeShowPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.maybeShowPopup(e);
                }
            }

            private void maybeShowPopup(MouseEvent e) {
                int selRow = ClientPanel.this.tree.getRowForLocation(e.getX(), e.getY());
                if (selRow == -1) {
                    return;
                }
                ClientPanel.this.tree.setSelectionRow(selRow);
                GroupObject groupObj = ClientPanel.this.getSelectedGroup(true);
                if (groupObj == null) {
                    return;
                }
                if (e.isPopupTrigger() && groupObj.isAccessible()) {
                    ClientPanel.this.popup.setMenuItem(groupObj);
                    ClientPanel.this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.tree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    if (e.isAltDown() || e.isControlDown()) {
                        return;
                    }
                    ClientPanel.this.doDeleteGroup();
                }
            }
        });
        this.refreshTaskBarViews();
        this.tree.setSelectionRow(0);
        this.tree.setBackground(UIColorUtilities.SECONDARY_NAVIGATION_BACKGROUND);
        this.tree.setCellRenderer(new DefaultTreeCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTreeCellRendererComponent(final JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                JLabel label = new JLabel(value.toString());
                label.setBackground(tree.getBackground());
                if (sel) {
                    label.setForeground(UIColorUtilities.SECONDARY_NAVIGATION_SELECTED_FOREGROUND);
                } else {
                    label.setForeground(UIColorUtilities.SECONDARY_NAVIGATION_FOREGROUND);
                }
                label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                Object userObj = node.getUserObject();
                if (userObj instanceof GroupObject) {
                    TreeItem groupItem = (TreeItem)userObj;
                    UIUtilities.setName(label, "clientPage", UIUtilities.ComponentType.TREENODE, "ClientTabGroupTreeNode_" + label.getText());
                    if (groupItem.getItemType() == 11 || groupItem.getItemType() == 307) {
                        label.setFont(UIFontUtilities.ITALIC_FONT);
                        if (node.isRoot()) {
                            if (((GroupObject)userObj).getSemClientGroup().getOptExtReferenceId() == null) {
                                label.setIcon(cloudIcon);
                                label.setHorizontalTextPosition(10);
                                label.setAlignmentX(4.0f);
                                label.setIconTextGap(105);
                                tree.setToolTipText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.upSyncText"));
                                final TreePath path = tree.getSelectionPath();
                                cloudIcon.setImageObserver(new ImageObserver(){

                                    @Override
                                    public boolean imageUpdate(Image img, int infoflags, int x1, int y1, int w1, int h1) {
                                        if (!tree.isShowing()) {
                                            return false;
                                        }
                                        Rectangle cellRect = tree.getPathBounds(path);
                                        if ((infoflags & 0x30) != 0 && Objects.nonNull(cellRect)) {
                                            tree.repaint(cellRect);
                                        }
                                        return (infoflags & 0xA0) == 0;
                                    }
                                });
                            } else if (((GroupObject)userObj).getSemClientGroup().getOptExtReferenceId() != null) {
                                label.setIcon(null);
                                tree.setToolTipText(null);
                                cloudIcon.setImageObserver(null);
                            }
                        }
                    } else if (label.getIcon() == null) {
                        tree.setToolTipText(null);
                    }
                }
                return label;
            }
        });
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.putClientProperty("enableTreePagination", "true");
        this.tree.setExpandsSelectedPaths(true);
        this.tree.setShowsRootHandles(false);
        this.tree.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 0));
        this.isInitialized = true;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.sideBar.updateTasks(this.clientTask.getTask(this.panelClientTabs.getSelectedPanel().getTaskType()));
    }

    @Override
    public void selectItemIndex(int index) {
        if (index == 0 && !this.isTreeDataChanged()) {
            return;
        }
        this.tree.setSelectionRow(index);
        this.tree.scrollRowToVisible(index);
    }

    @Override
    public int getItemIndex(int id) {
        return -1;
    }

    private void treeValueChanged(TreeSelectionEvent e) {
        this.refreshRightPanel();
    }

    public void refreshRightPanel() {
        if (Browser.isLogOutInProgress()) {
            return;
        }
        GroupObject group = this.getSelectedGroup(false);
        if (group == null) {
            return;
        }
        if (group.isAccessible()) {
            this.panelClientTabs.setSelectedItem(group);
            this.setCurrentTaskPanel(this.panelClientTabs);
            this.updateTask(this.panelClientTabs.getSelectedPanel().getTaskType());
        } else {
            this.groupAccessDeniedPanel.setSelectedItem(group);
            this.setCurrentTaskPanel(this.groupAccessDeniedPanel);
            this.updateTask(this.groupAccessDeniedPanel.getTaskType());
        }
    }

    protected void updateTask(int taskType) {
        this.setSideBarTasks(this.clientTask.getTask(taskType));
    }

    private boolean isTreeDataChanged() {
        TreeModel oldTreeModel = this.tree.getModel();
        if (oldTreeModel == null) {
            return true;
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)oldTreeModel.getRoot();
        if (root == null) {
            return true;
        }
        if (root.getUserObject() == null) {
            return true;
        }
        if (!((root = (DefaultMutableTreeNode)root.getChildAt(1).getChildAt(0)).getUserObject() instanceof GroupObject)) {
            return true;
        }
        GroupObject rootGroup = (GroupObject)root.getUserObject();
        if (rootGroup == null) {
            return true;
        }
        try {
            SemClientGroup parent = rootGroup.getSemClientGroup();
            while (parent.getParent() != null) {
                parent = parent.getParent();
            }
            SemClientGroupTree parentOld = (SemClientGroupTree)parent;
            SemClientGroupTree parentNew = (SemClientGroupTree)DataobjectManager.getInstance().getObjectByGUID("SemClientGroupTree", parentOld.getId());
            if (parentOld != parentNew) {
                return true;
            }
            boolean bChanged = DataobjectManager.getInstance().isObjectChanged("SemClientGroupTree", ((TopLevelObject)parent).getId());
            return bChanged;
        }
        catch (ConsoleException e) {
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.consoleError"), 0);
            if (e.needRelogin()) {
                Manager.getFrame().showLoginPanel();
            }
            return true;
        }
    }

    @Override
    public void refreshTaskBarViews() {
        block9: {
            try {
                AdminHandler.refreshCurrentAdmin();
                if (GroupHandler.isGroupTreeRefreshChecksumChanged(this.lastGroupTreeRefreshChecksum)) {
                    DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
                    TreeModel treeModel = this.setupTreeModel();
                    this.tree.setModel(treeModel);
                    this.setSideBarViews(this.tree);
                    if (selNode != null && (DefaultMutableTreeNode)treeModel.getRoot() != null) {
                        this.expand(selNode, true);
                        this.refreshRightPanel();
                    } else if (selNode == null && (DefaultMutableTreeNode)treeModel.getRoot() != null) {
                        selNode = (DefaultMutableTreeNode)treeModel.getRoot();
                        this.expand(selNode, true);
                        this.refreshRightPanel();
                    } else if ((DefaultMutableTreeNode)treeModel.getRoot() == null) {
                        this.groupAccessDeniedPanel.setSelectedItem(new GroupObject());
                        this.setCurrentTaskPanel(this.groupAccessDeniedPanel);
                        this.updateTask(this.groupAccessDeniedPanel.getTaskType());
                    }
                }
                int row = 0;
                int[] rows = this.tree.getSelectionRows();
                if (rows != null && rows.length > 0) {
                    row = rows[0];
                }
                this.tree.setSelectionRow(row);
                this.tree.setBackground(UIColorUtilities.SECONDARY_NAVIGATION_BACKGROUND);
            }
            catch (ConsoleException e) {
                JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.consoleError"), 0);
                if (!e.needRelogin()) break block9;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    private TreeModel setupTreeModel() throws ConsoleException {
        DefaultMutableTreeNode groupNode = GroupHandler.getGroups(true);
        this.lastGroupTreeRefreshChecksum = GroupHandler.getGroupTreeRefreshChecksum();
        return new DefaultTreeModel(groupNode);
    }

    private void deleteGroup(DefaultMutableTreeNode node) {
        block8: {
            if (node == null) {
                return;
            }
            final GroupObject group = (GroupObject)node.getUserObject();
            if (group == null) {
                return;
            }
            try {
                Manager.getFrame().setCursor(Cursor.getPredefinedCursor(3));
                boolean result = GroupHandler.isGroupCanbeDeleted(group);
                Manager.getFrame().setCursor(Cursor.getDefaultCursor());
                if (result) {
                    SemClientGroup scg = group.getSemClientGroup();
                    SemClientGroup parentGrp = group.getParent();
                    parentGrp.removeSemClientGroup(scg);
                    parentGrp.setModifiedTime(Long.valueOf(TimeUtil.getServerTime()));
                    final SemClientGroupTree topParent = (SemClientGroupTree)scg.getTopLevelObject();
                    SwingWorker<SemClientGroupTree, Void> deleteThread = new SwingWorker<SemClientGroupTree, Void>(){

                        @Override
                        protected SemClientGroupTree doInBackground() throws Exception {
                            return DataobjectManager.getInstance().deleteClientGroup(topParent, group.getId());
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        protected void done() {
                            try {
                                SemClientGroupTree ret = (SemClientGroupTree)this.get();
                                if (ret == null) {
                                    ConsoleLogger.log("Failed to delete group from group tree.");
                                }
                                String groupName = group.getName();
                                MessageResources msgRes = MessageResources.getInstance();
                                String description = MessageFormat.format(msgRes.getString("com.sygate.scm.console.handler.handler", "GroupHandler.GroupDeleted"), groupName);
                                ConsoleLogger.logAdminEvent(8194, description);
                            }
                            catch (InterruptedException e) {
                                ConsoleLogger.log(e);
                            }
                            catch (ExecutionException e) {
                                Manager.getFrame().setCursor(Cursor.getDefaultCursor());
                                JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
                                ConsoleLogger.log(e);
                            }
                            finally {
                                ClientPanel.this.refreshTaskBarViews();
                                ClientPanel.this.tree.updateUI();
                            }
                        }
                    };
                    SwingWorkerExecutor.getInstance().execute(deleteThread);
                    DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                    TreePath newPath = new TreePath(parent.getPath());
                    TreeNode nextSibling = parent.getChildAfter(node);
                    if (nextSibling != null) {
                        newPath = new TreePath(nextSibling);
                    } else {
                        TreeNode beforeSibling = parent.getChildBefore(node);
                        if (beforeSibling != null) {
                            newPath = new TreePath(beforeSibling);
                        }
                    }
                    ((DefaultTreeModel)this.tree.getModel()).removeNodeFromParent(node);
                    this.tree.setSelectionPath(newPath);
                    this.setSideBarViews(this.tree);
                    this.tree.updateUI();
                    this.tree.requestFocusInWindow();
                }
            }
            catch (ConsoleException ex) {
                Manager.getFrame().setCursor(Cursor.getDefaultCursor());
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessageString(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
                if (!ex.needRelogin()) break block8;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    public void doDeleteGroup() {
        this.doDeleteGroup(true);
    }

    public void doDeleteGroup(boolean confirmDelete) {
        GroupObject group = this.getSelectedGroup(true);
        if (!ClientPanel.canDelGroup(group, true)) {
            return;
        }
        if (confirmDelete && 0 != JOptionPane.showConfirmDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.sureToDeleteGroupMsg"), group.getName()), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.deleteMsg"), 0)) {
            return;
        }
        this.deleteGroup((DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent());
    }

    public static boolean canRenameGroup(GroupObject group, boolean showErrMsg) {
        String msg = null;
        if (group == null) {
            msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.failToRenameNonGroupMsg");
        } else if (group.isTemp()) {
            msg = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.cannotRenameTemporaryGroup"), group.getName());
        } else if (group.isGlobal()) {
            msg = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.cannotRenameGlobalGroupMsg"), GroupHandler.getGlobalGroupName());
        } else if (group.isTypeAd()) {
            msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.cannotRenameOUGroupMsg");
        } else if (group.isTypeCloudNode()) {
            msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.cannotRenameOUGroupMsg");
        }
        if (msg != null) {
            if (showErrMsg) {
                JOptionPane.showMessageDialog(Manager.getFrame(), msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
            }
            return false;
        }
        return true;
    }

    public void doRenameGroup() {
        RenameGroupDlg dlg;
        block5: {
            GroupObject group = this.getSelectedGroup(true);
            if (!ClientPanel.canRenameGroup(group, true)) {
                return;
            }
            String oldName = group.getName();
            dlg = new RenameGroupDlg(group);
            if (dlg.isOk()) {
                String groupName = dlg.getName();
                if (!ClientPanel.checkAndRefreshGroup(group, this)) {
                    return;
                }
                group.setName(groupName);
                try {
                    Manager.getFrame().setCursor(Cursor.getPredefinedCursor(3));
                    GroupHandler.updateGroup(group);
                    String description = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "GroupHandler.GroupRenamed"), oldName, groupName);
                    ConsoleLogger.logAdminEvent(8195, description);
                    Manager.getFrame().setCursor(Cursor.getDefaultCursor());
                    this.refreshTaskBarViews();
                    this.tree.updateUI();
                    this.tree.scrollPathToVisible(new TreePath(((DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent()).getPath()));
                }
                catch (ConsoleException ex) {
                    Manager.getFrame().setCursor(Cursor.getDefaultCursor());
                    group.setName(oldName);
                    JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
                    if (!ex.needRelogin()) break block5;
                    Manager.getFrame().showLoginPanel();
                }
            }
        }
        dlg.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doMoveGroup() {
        GroupObject group = this.getSelectedGroup(true);
        if (!ClientPanel.canMoveGroup(group, true)) {
            return;
        }
        if (!AdminPrivilegeObject.isCurrentAdminHasAllPoliciesTypesPrivilege()) {
            String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.notHaveAllPolicyPrivilege");
            JOptionPane.showMessageDialog(Manager.getFrame(), msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
            return;
        }
        try {
            GroupPolicyObject policyObject = PolicyHandler.getGroupPolicyByGroup(group);
            if (policyObject.isInherit()) {
                String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.cannotMoveInheritedPolicyModeGroup");
                JOptionPane.showMessageDialog(Manager.getFrame(), msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
                return;
            }
        }
        catch (ConsoleException e) {
            String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.cannotGetGroupPolicyMode");
            JOptionPane.showMessageDialog(Manager.getFrame(), msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
            ConsoleLogger.log(msg);
            return;
        }
        GroupObject parent = group.getParentGroup();
        if (parent == null || parent.getAccessConstraint(true) != 0) {
            String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.noPrivilegeToMoveGroupMsg");
            JOptionPane.showMessageDialog(Manager.getFrame(), msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
            return;
        }
        String thename = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.moveGroupToTitle");
        String s = group.getName();
        Object[] o = new Object[]{s};
        String fm1 = MessageFormat.format(thename, o);
        SelectGroupDlg dlg = new SelectGroupDlg(fm1, 2);
        dlg.setVisible(true);
        if (!dlg.isOk()) {
            dlg.dispose();
            return;
        }
        GroupObject oldParentGroup = group.getParentGroup();
        ArrayList<GroupObject> newParentGroups = dlg.getListGroupObjs();
        dlg.dispose();
        for (GroupObject newParentGroup : newParentGroups) {
            if (!ClientPanel.checkAndRefreshGroup(newParentGroup, this)) {
                return;
            }
            try {
                if (!GroupHandler.isNewGroupNameValidForChildGroups(group, newParentGroup)) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.groupPathTooLongMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
                    return;
                }
                if (newParentGroup.getId().equals(oldParentGroup.getId())) {
                    return;
                }
                if (newParentGroup.getId().equals(group.getId())) {
                    throw new ConsoleException(-2046492672, 97);
                }
                DefaultMutableTreeNode newParent = dlg.getNode();
                Manager.getFrame().setCursor(Cursor.getPredefinedCursor(3));
                if (GroupHandler.hasChildGroup(group, newParentGroup)) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.cannotMoveGroupToSubGroupMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
                    return;
                }
                String groupName = group.getName();
                if (GroupHandler.getChildGroup(newParentGroup, groupName) != null) {
                    Object[] obj = new Object[]{groupName};
                    String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.groupNameExistMsg");
                    String fm = MessageFormat.format(str, obj);
                    JOptionPane.showMessageDialog(Manager.getFrame(), fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
                    return;
                }
                if (!GroupHandler.moveGroup(group.getId(), newParentGroup.getId())) continue;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
                ((DefaultTreeModel)this.tree.getModel()).removeNodeFromParent(node);
                ((DefaultTreeModel)this.tree.getModel()).insertNodeInto(node, newParent, newParent.getChildCount());
                TreePath path = new TreePath(node.getPath());
                this.tree.setSelectionPath(path);
                this.refreshTaskBarViews();
            }
            catch (ConsoleException ex) {
                try {
                    GroupHandler.moveGroup(group.getId(), oldParentGroup.getId());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
                if (!ex.needRelogin()) continue;
                Manager.getFrame().showLoginPanel();
            }
            finally {
                Manager.getFrame().setCursor(Cursor.getDefaultCursor());
            }
        }
        this.tree.updateUI();
    }

    public void doSearch() {
        try {
            GroupObject groupObj = this.getSelectedGroup(true);
            if (groupObj == null) {
                return;
            }
            FindObjectDlg dlg = FindObjectDlg.newInstanceForSearchClient(Manager.frame, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.searchComputersOrUsers"), true);
            dlg.init(groupObj);
            dlg.setVisible(true);
            this.refreshRightPanel();
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
            if (ex.needRelogin()) {
                Manager.getFrame().showLoginPanel();
            }
        }
        finally {
            Manager.getFrame().setCursor(Cursor.getDefaultCursor());
        }
    }

    public void doEditProps() {
        block4: {
            GroupObject group = this.getSelectedGroup(true);
            if (group == null) {
                return;
            }
            try {
                GroupPropertiesDlg dlg = new GroupPropertiesDlg(group);
                this.panelClientTabs.refresh();
                LicenseObject licenseObject = LicenseObject.getInstance();
                if (!this.isGroupPanelSelected() && !licenseObject.isSBProduct() && dlg.isOk()) {
                    this.gotoGroupPanel();
                }
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
                if (!ex.needRelogin()) break block4;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    public void refreshMenuItemActionPerformed(ActionEvent e) {
        block3: {
            try {
                Manager.getFrame().setCursor(Cursor.getPredefinedCursor(3));
                if (GroupHandler.isGroupTreeChanged()) {
                    GroupHandler.getGroups(true);
                    this.refreshTaskBarViews();
                }
                Manager.getFrame().setCursor(Cursor.getDefaultCursor());
            }
            catch (ConsoleException ex) {
                Manager.getFrame().setCursor(Cursor.getDefaultCursor());
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
                if (!ex.needRelogin()) break block3;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    public GroupObject getSelectedGroup(boolean checkExistence) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null || !(node.getUserObject() instanceof GroupObject)) {
            return null;
        }
        if (checkExistence && !this.refreshNode(node)) {
            return null;
        }
        return (GroupObject)node.getUserObject();
    }

    public void doCopyDeployments() {
        GroupObject group = this.getSelectedGroup(true);
        if (group == null) {
            return;
        }
        int count = 0;
        try {
            count = SoftwarePackageHandler.getSoftwareDeploymentEntityCount(group);
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
            if (ex.needRelogin()) {
                Manager.getFrame().showLoginPanel();
                return;
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        if (count < 1) {
            String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.noSoftwareDeploymentMsg");
            JOptionPane.showMessageDialog(Manager.getFrame(), msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
            return;
        }
        this.groupCopyDeploymentSource = group;
        ArrayList<GroupObject> groups = this.selectDestGroup();
        for (GroupObject groupObject : groups) {
            this.doPasteDeployments(groupObject);
        }
    }

    public void doCopyPolicy() {
        try {
            TreeItem item;
            DefaultMutableTreeNode node;
            Object uObj;
            TreePath selectPath = this.tree.getSelectionPath();
            if (selectPath != null && (uObj = (node = (DefaultMutableTreeNode)selectPath.getLastPathComponent()).getUserObject()) instanceof TreeItem && ((item = (TreeItem)uObj).getItemType() == 11 || item.getItemType() == 9 || item.getItemType() == 10 || item.getItemType() == 163 || item.getItemType() == 307)) {
                GroupObject gObj = (GroupObject)item;
                if (!AdminObject.retrieveCurrentAdminObject().isDisableCopyPolicyReminder()) {
                    new GroupPolicyCopyDialog(gObj.getName()).setVisible(true);
                }
                GroupPolicyObject gpObj = PolicyHandler.getGroupPolicyByGroupFromDB(gObj);
                PolicyHandler.copyObject(new AgentPolicyObject(gpObj.getSemAgentPolicyObject()));
            }
        }
        catch (ConsoleException e) {
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    public void doPastePolicy() {
        try {
            TreeItem item;
            DefaultMutableTreeNode node;
            Object uObj;
            TreePath selectPath = this.tree.getSelectionPath();
            if (selectPath != null && (uObj = (node = (DefaultMutableTreeNode)selectPath.getLastPathComponent()).getUserObject()) instanceof TreeItem && ((item = (TreeItem)uObj).getItemType() == 11 || item.getItemType() == 9 || item.getItemType() == 10 || item.getItemType() == 307) && PolicyHandler.hasCopiedObject(AgentPolicyObject.class)) {
                GroupObject gObj = (GroupObject)item;
                GroupPolicyObject gpObj = PolicyHandler.getGroupPolicyByGroup(gObj);
                SemAgentPolicy selectedPolicy = gpObj.getSemAgentPolicyObject();
                AgentPolicyObject copiedObj = (AgentPolicyObject)PolicyHandler.getCopiedObject();
                if (selectedPolicy.getId().equals(copiedObj.getId())) {
                    String errorMsg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.samePolicy");
                    String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error");
                    JOptionPane.showMessageDialog(Manager.getFrame(), errorMsg, title, 0);
                    return;
                }
                boolean isInherit = gpObj.isInherit();
                String message = isInherit ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.turnOffInherits") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.overwriteCurPolicy");
                int ret = JOptionPane.showConfirmDialog(Manager.getFrame(), message, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.confirmPolicyOverwrite"), 0);
                if (ret == 0) {
                    AgentPolicyObject newPolicy = (AgentPolicyObject)PolicyHandler.getPastedObject();
                    gpObj.pasteAgentPolicy(newPolicy);
                    PolicyHandler.updateGroupPolicy(gpObj);
                    this.treeValueChanged(null);
                }
            }
        }
        catch (ConsoleException e) {
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    private ArrayList<GroupObject> selectDestGroup() {
        ArrayList<GroupObject> groups = new ArrayList<GroupObject>();
        try {
            DefaultMutableTreeNode rootNode = GroupHandler.getGroups(false, true);
            if (rootNode == null) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.cannotCopyDeploymentSettings"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
            } else {
                SelectGroupDlg dlg = new SelectGroupDlg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.selectAGroupToPasteMsg"), 5);
                dlg.setVisible(true);
                if (dlg.isOk()) {
                    groups = dlg.getListGroupObjs();
                }
                dlg.dispose();
            }
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
        }
        return groups;
    }

    public void doPasteDeployments(GroupObject group) {
        block7: {
            if (this.groupCopyDeploymentSource == null) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.selectGroupToCopyMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.pasteSoftwareDeploymentMsg"), 0);
                return;
            }
            if (group == null) {
                return;
            }
            if (group.getId().equals(this.groupCopyDeploymentSource.getId())) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.cannotPasteTheDeploymentMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.pasteSoftwareDeploymentMsg"), 0);
                return;
            }
            if (group.getAccessConstraint() != 0) {
                Object[] obj = new Object[]{group.getName(), this.groupCopyDeploymentSource.getName()};
                String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.cantPastDeploymentMsg");
                String fm = MessageFormat.format(str, obj);
                JOptionPane.showMessageDialog(Manager.getFrame(), fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.pasteSoftwareDeploymentMsg"), 0);
                return;
            }
            Object[] obj = new Object[]{group.getName(), this.groupCopyDeploymentSource.getName()};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.currentDeploymentWillBeReplacedMsg");
            String fm = MessageFormat.format(str, obj);
            if (0 != JOptionPane.showConfirmDialog(Manager.getFrame(), fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.pasteDeploymentMsg"), 0)) {
                return;
            }
            try {
                SoftwarePackageHandler.copySoftwareSoftwareDeploymentEntities(this.groupCopyDeploymentSource, group);
                this.panelClientTabs.refresh();
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
                if (!ex.needRelogin()) break block7;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    public void doAddNewComputers() {
        GroupObject group = this.getSelectedGroup(true);
        if (group == null) {
            return;
        }
        new InstallClientWizardDialog(group);
    }

    public static boolean canAddGroup(GroupObject group, boolean showErrMsg) {
        String msg = null;
        if (group == null) {
            msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.failToAddGroupNonGroupMsg");
        } else if (group.isTemp()) {
            msg = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.cannotAddGroupToTemp"), group.getName());
        } else if (!group.isTypeNative()) {
            msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.cannotAddGroupToOU");
        } else if (group.getAccessConstraint(true) != 0) {
            msg = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "GroupAccessToAddGroup.noPrivilege"), group.getName());
        }
        if (msg != null) {
            if (showErrMsg) {
                JOptionPane.showMessageDialog(Manager.getFrame(), msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
            }
            return false;
        }
        return true;
    }

    public void doAddGroup() {
        GroupObject group = this.getSelectedGroup(true);
        if (LicenseObject.getInstance().isSBProduct() && !group.isGlobal()) {
            group = group.getParentGroup();
        }
        if (!ClientPanel.canAddGroup(group, true)) {
            return;
        }
        String groupname = group.getName();
        AddGroupDlg dlg = new AddGroupDlg(groupname);
        if (dlg.isOk()) {
            DefaultMutableTreeNode node = LicenseObject.getInstance().isSBProduct() ? (DefaultMutableTreeNode)this.tree.getSelectionPath().getPathComponent(0) : (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
            this.addGroup(node, dlg.getGroupName(), dlg.getDescription());
        }
        dlg.dispose();
    }

    public void executeCommandTask(int taskId) {
        switch (taskId) {
            case 29: {
                this.executeCommand("ScanNow");
                break;
            }
            case 30: {
                this.executeCommand("Update_Now");
                break;
            }
            case 31: {
                this.executeCommand("Update_ScanNow");
                break;
            }
            case 32: {
                this.executeCommand("Reboot");
                break;
            }
            case 33: {
                this.executeCommand("ApOn");
                break;
            }
            case 34: {
                this.executeCommand("ApOff");
                break;
            }
            case 35: {
                this.executeCommand("FwOn");
                break;
            }
            case 36: {
                this.executeCommand("FwOff");
                break;
            }
        }
    }

    public void executeCommand(String cmdName) {
        String actionName;
        block7: {
            GroupObject group = this.getSelectedGroup(true);
            if (group == null) {
                return;
            }
            actionName = CommandUtil.getActionName(cmdName);
            String msg1 = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.confirmCmdMsg");
            msg1 = MessageFormat.format(msg1, actionName);
            if (0 != JOptionPane.showConfirmDialog(Manager.getFrame(), msg1, actionName, 0)) {
                return;
            }
            Command cmd = CommandUtil.getCommand(cmdName, group.getName());
            if (cmd == null) {
                return;
            }
            GroupArray groupArray = new GroupArray();
            SemClientGroup clientGroup = group.getSemClientGroup();
            this.addAllGroups(clientGroup, groupArray);
            try {
                GroupHandler.executeCommand(groupArray, null, cmd);
            }
            catch (ConsoleException ex) {
                String msg;
                if (ex.getErrorCode() == -133169152) {
                    msg = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.commandAlreadyExisted"), actionName);
                    String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.information");
                    MultiLineMsgBox.show(Manager.getFrame(), title, msg, 50, 1, -1);
                }
                if (ex.getErrorCode() == -134217728) {
                    msg = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.commandPartiallyExists"), actionName);
                    String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.information");
                    MultiLineMsgBox.show(Manager.getFrame(), title, msg, 50, 1, -1);
                }
                String CONSOLE_ERROR_TITLE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.consoleError");
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), CONSOLE_ERROR_TITLE, 0);
                if (!ex.needRelogin()) break block7;
                Manager.getFrame().showLoginPanel();
            }
        }
        String msg = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.commandIssued"), actionName);
        String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.information");
        MultiLineMsgBox.show(Manager.getFrame(), title, msg, 50, 1, -1);
    }

    private void addAllGroups(SemClientGroup clientGroup, GroupArray groupArray) {
        Group group = new Group();
        group.setContent(clientGroup.getId());
        groupArray.addGroup(group);
        for (SemClientGroup subGroupObj : clientGroup.getSemClientGroup()) {
            this.addAllGroups(subGroupObj, groupArray);
        }
    }

    public void syncOuForGroup(final GroupObject group) throws ConsoleException {
        if (!this.isOUGroup(group)) {
            String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.cannotSyncaNonOUgroupMsg");
            JOptionPane.showMessageDialog(Manager.getFrame(), msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
            return;
        }
        if (null == ImportADSIHandler.getDirectoryServerForGroup(group)) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ClientTreePopupMenu.deletedLDAPServerMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.warning"), 2);
            return;
        }
        System.out.println("ClientPanel>> syncOUMenuItemActionPerformed: syncing  group=" + group.getName() + ", id=" + group.getId() + ", ADsPath=" + group.getAdsPath() + "...");
        SwingWorkerProgressDialog progressDialog = new SwingWorkerProgressDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ImportADSIDlg.updateMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ImportADSIDlg.updatingOUsMsg"), 3){

            @Override
            public void run(ActionEvent e) {
                try {
                    if (ImportADSIHandler.syncOuNow(group)) {
                        GroupHandler.getGroups(true);
                        ClientPanel.this.refreshTaskBarViews();
                    } else {
                        System.out.println("ClientPanel>> syncOUMenuItemActionPerformed: Failed to synch  group=" + group.getName() + ", id=" + group.getId() + ", ADsPath=" + group.getAdsPath());
                    }
                }
                catch (ConsoleException ex) {
                    ClientPanel.this.handleOUSyncConsoleException(ex, group);
                }
                catch (Throwable ex) {
                    LoggerUtilities.logException((Throwable)ex);
                }
            }

            @Override
            public void doFinished() {
                ClientPanel.this.panelClientTabs.setSelectedItem(group);
            }

            @Override
            public void doCancelled() {
                ClientPanel.this.cancelSync();
            }
        };
        progressDialog.start();
    }

    private void handleOUSyncConsoleException(ConsoleException consolException, AbstractUIObject obj) {
        if (consolException == null) {
            return;
        }
        ConsoleLogger.log(consolException);
        String msg = consolException.getMessage();
        if (consolException.getMessageId() == 512) {
            String serverName = this.getDirectoryServerNameByUIObj(obj);
            msg = MessageFormat.format(msg, serverName);
        }
        JOptionPane.showMessageDialog(Manager.getFrame(), msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
        if (consolException.needRelogin()) {
            Manager.getFrame().showLoginPanel();
        }
    }

    private String getDirectoryServerNameByUIObj(AbstractUIObject obj) {
        DirectoryServer d = null;
        String serverName = "";
        try {
            if (obj instanceof GroupObject) {
                d = ImportADSIHandler.getDirectoryServerForGroup((GroupObject)obj);
            } else if (obj instanceof OrganizationalUnitObject) {
                d = ImportADSIHandler.getDirectoryServerForOU((OrganizationalUnitObject)obj);
            }
        }
        catch (ConsoleException ignore) {
            ConsoleLogger.log(ignore);
        }
        catch (RuntimeException ex) {
            ConsoleLogger.log(ex);
        }
        if (d != null) {
            serverName = d.getName();
        }
        return serverName;
    }

    public boolean isOUGroup(GroupObject group) {
        if (group == null) {
            return false;
        }
        return group.isTypeAdTree() || group.isTypeAdNode();
    }

    public static boolean canImportOU(GroupObject group, boolean showErrMsg) {
        String msg = null;
        if (!AdminPrivilegeObject.isCurrentAdminHasRightToImportADOU()) {
            msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.limitedOrDomainAdminCannotImportOU");
        } else if (group == null) {
            msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.failToImportOUNonGroupMsg");
        } else if (group.isTemp()) {
            msg = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.cannotImportAnyOUToTempMsg"), group.getName());
        } else if (!group.isTypeNative()) {
            msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.cannotImportAnyOUMsg");
        }
        if (msg != null) {
            if (showErrMsg) {
                JOptionPane.showMessageDialog(Manager.getFrame(), msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
            }
            return false;
        }
        return true;
    }

    public void doImportOU() {
        block6: {
            GroupObject group = this.getSelectedGroup(true);
            if (!ClientPanel.canImportOU(group, true)) {
                return;
            }
            try {
                ArrayList<DirectoryServer> directoryServers = ImportADSIHandler.getDirectoryServer();
                if (directoryServers.size() == 0) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.addLDAPServerMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.warning"), 2);
                    return;
                }
                final ImportADSIDlg dlg = new ImportADSIDlg();
                dlg.initData(directoryServers);
                dlg.setVisible(true);
                if (dlg.isOk()) {
                    SwingWorkerProgressDialog progressDlg = new SwingWorkerProgressDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ImportADSIDlg.updateMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ImportADSIDlg.updatingOUsMsg"), 3){
                        DefaultMutableTreeNode nodeParent;
                        ConsoleException exception;
                        volatile boolean cancelled;
                        OrganizationalUnitObject currentOU;
                        {
                            super(title, message, buttonOptions);
                            this.nodeParent = (DefaultMutableTreeNode)ClientPanel.this.tree.getLastSelectedPathComponent();
                            this.exception = null;
                            this.cancelled = false;
                            this.currentOU = null;
                        }

                        @Override
                        public void run(ActionEvent e) {
                            GroupObject parentGroup;
                            ArrayList<OrganizationalUnitObject> list = dlg.getSelectionList();
                            GroupObject groupObject = parentGroup = this.nodeParent != null ? (GroupObject)this.nodeParent.getUserObject() : null;
                            if (list != null && list.size() > 0 && parentGroup != null) {
                                try {
                                    for (int i = 0; i < list.size() && !this.cancelled; ++i) {
                                        this.currentOU = list.get(i);
                                        String ouName = this.currentOU.getName();
                                        if (GroupHandler.getChildGroup(parentGroup, ouName) != null) {
                                            System.out.println("ClientPanel>> addGroupSilently: Warning-> group already exist, name = " + ouName);
                                            Object[] obj = new Object[]{this.currentOU.getName()};
                                            String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "ImportADSIDlg.importGroupHasSameName");
                                            String fm = MessageFormat.format(msg, obj);
                                            throw new ConsoleException(fm);
                                        }
                                        final GroupObject subGroup = ClientPanel.this.addOU(this.currentOU, parentGroup);
                                        if (subGroup == null) continue;
                                        SwingUtilities.invokeLater(new Runnable(){

                                            @Override
                                            public void run() {
                                                this.addGroupToTree(subGroup);
                                            }
                                        });
                                    }
                                }
                                catch (ConsoleException ex) {
                                    ConsoleLogger.log(ex);
                                    this.exception = ex;
                                }
                            }
                        }

                        @Override
                        public void doCancelled() {
                            this.cancelled = true;
                            AjaxSwingManager.endOperation();
                        }

                        private void addGroupToTree(GroupObject subGroup) {
                            SortableTreeNode nodeNew = new SortableTreeNode(subGroup, true);
                            this.nodeParent.add(nodeNew);
                            ClientPanel.this.tree.scrollPathToVisible(new TreePath(nodeNew.getPath()));
                            ClientPanel.this.refresh();
                        }

                        @Override
                        public void doFinished() {
                            ClientPanel.this.handleOUSyncConsoleException(this.exception, this.currentOU);
                            AjaxSwingManager.endOperation();
                        }
                    };
                    AjaxSwingManager.beginOperation();
                    progressDlg.start();
                } else {
                    dlg.dispose();
                }
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
                if (!ex.needRelogin()) break block6;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    public GroupObject addOU(OrganizationalUnitObject ou, GroupObject parentGroup) throws ConsoleException {
        GroupObject groupNewOU;
        String guid = ou.getGuid();
        if (guid == null || guid.length() < 1) {
            guid = LdapPath.generateGuidByLdapPathAndName((String)ou.getADsPath(), null);
            ou.setGuid(guid);
        }
        if ((groupNewOU = this.addGroupSilently(parentGroup, ou.getName(), "", SemClientGroup.ADTREE)) == null) {
            ConsoleLogger.log("ClientPanel>> addOU: Error-> Failed to addGroup, ou=" + ou.getName());
            return null;
        }
        try {
            KeepAlive.suspend();
            GroupObject groupNewOuUpdated = ImportADSIHandler.mapGroupToOU(groupNewOU, ou);
            ConsoleLogger.logAdminEvent(8210);
            GroupObject groupObject = groupNewOuUpdated;
            return groupObject;
        }
        catch (ConsoleException e) {
            ConsoleLogger.log("ClientPanel>> addOU: Error-> Failed to map group to OU, ou=" + ou.getName());
            GroupHandler.delGroup(groupNewOU);
            throw e;
        }
        finally {
            KeepAlive.resume();
        }
    }

    @Override
    public synchronized void refresh() {
        this.refreshTaskBarViews();
        this.refreshRightPanel();
    }

    public DefaultMutableTreeNode getNodeByPathStrings(ArrayList<String> listPathStr) {
        DefaultMutableTreeNode node;
        if (listPathStr == null || listPathStr.size() == 0) {
            return null;
        }
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        DefaultMutableTreeNode currentNode = node = (DefaultMutableTreeNode)model.getRoot();
        TreeItem treeItem = null;
        while (listPathStr.size() > 0) {
            treeItem = (TreeItem)node.getUserObject();
            if (treeItem.getName().equals(listPathStr.get(0))) {
                currentNode = node;
                listPathStr.remove(0);
                if (node.getChildCount() == 0) break;
                node = (DefaultMutableTreeNode)node.getFirstChild();
                continue;
            }
            if ((node = node.getNextSibling()) != null) continue;
        }
        if (listPathStr.size() != 0) {
            return null;
        }
        return currentNode;
    }

    private ArrayList<String> getNodePathStrings(DefaultMutableTreeNode node) {
        if (this.tree == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        Object treeItem = null;
        while (node != null && (treeItem = node.getUserObject()) != null && treeItem instanceof TreeItem) {
            list.add(0, ((TreeItem)treeItem).getName());
            node = (DefaultMutableTreeNode)node.getParent();
        }
        return list;
    }

    private void expand(DefaultMutableTreeNode node) {
        TreePath path = new TreePath(node.getPath());
        this.tree.expandPath(path);
    }

    protected void expand(DefaultMutableTreeNode selNode, boolean focused) {
        DefaultMutableTreeNode node;
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        DefaultMutableTreeNode currentNode = node = (DefaultMutableTreeNode)model.getRoot();
        TreeItem treeItem = null;
        ArrayList<String> listPathStr = this.getNodePathStrings(selNode);
        while (listPathStr.size() > 0) {
            treeItem = (TreeItem)node.getUserObject();
            if (treeItem.getName().equals(listPathStr.get(0))) {
                this.expand(node);
                currentNode = node;
                listPathStr.remove(0);
                if (node.getChildCount() == 0) break;
                node = (DefaultMutableTreeNode)node.getFirstChild();
                continue;
            }
            if ((node = node.getNextSibling()) != null) continue;
        }
        if (focused) {
            this.focussedNodeChanges(currentNode, selNode);
        }
    }

    private void focussedNodeChanges(DefaultMutableTreeNode currentNode, DefaultMutableTreeNode selNode) {
        TreePath path = new TreePath(currentNode.getPath());
        if (((TreeItem)selNode.getUserObject()).getId().equals(((TreeItem)currentNode.getUserObject()).getId())) {
            TreeSelectionListener[] selListener = this.tree.getTreeSelectionListeners();
            if (selListener.length > 0) {
                this.tree.removeTreeSelectionListener(selListener[0]);
            }
            this.tree.setSelectionPath(path);
            if (selListener.length > 0) {
                this.tree.addTreeSelectionListener(selListener[0]);
            }
        } else {
            this.tree.setSelectionPath(path);
        }
    }

    private DefaultMutableTreeNode addGroup(DefaultMutableTreeNode node, String groupName, String description) {
        return this.addGroup(node, groupName, description, SemClientGroup.NATIVE);
    }

    private DefaultMutableTreeNode addGroup(DefaultMutableTreeNode node, String groupName, String description, Integer groupType) {
        if (node == null) {
            return null;
        }
        GroupObject group = (GroupObject)node.getUserObject();
        if (group == null) {
            return null;
        }
        GroupObject subGroup = null;
        try {
            if (GroupHandler.getChildGroup(group, groupName) != null) {
                Object[] obj = new Object[]{groupName};
                String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.groupNameExistMsg");
                String fm = MessageFormat.format(str, obj);
                MultiLineMsgBox.show(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), fm, 50, 0, -1);
                return null;
            }
            subGroup = new GroupObject(group, groupName, description, Manager.getCurrentAdminId());
            if (groupType != null) {
                subGroup.getSemClientGroup().setOptType(groupType);
            }
            if (!SemClientGroup.ADTREE.equals(groupType)) {
                Manager.getFrame().setCursor(Cursor.getPredefinedCursor(3));
            }
            subGroup = GroupHandler.addGroup(subGroup);
            if (!SemClientGroup.ADTREE.equals(groupType)) {
                Manager.getFrame().setCursor(Cursor.getDefaultCursor());
            }
            DefaultMutableTreeNode newNode = new SortableTreeNode(subGroup, true);
            newNode.setUserObject(subGroup);
            node.add(newNode);
            this.tree.scrollPathToVisible(new TreePath(newNode.getPath()));
            ArrayList<String> list = this.getNodePathStrings(newNode);
            this.refresh();
            newNode = this.getNodeByPathStrings(list);
            this.tree.scrollPathToVisible(new TreePath(newNode.getPath()));
            return newNode;
        }
        catch (ConsoleException ex) {
            if (subGroup != null && subGroup.getParent() != null) {
                subGroup.getParent().removeSemClientGroup(subGroup.getSemClientGroup());
            }
            Manager.getFrame().setCursor(Cursor.getDefaultCursor());
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
            if (ex.needRelogin()) {
                Manager.getFrame().showLoginPanel();
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
            LoggerUtilities.logException((Throwable)ex);
        }
        return null;
    }

    private GroupObject addGroupSilently(GroupObject parentGroup, String groupName, String description, Integer groupType) throws ConsoleException {
        if (GroupHandler.getChildGroup(parentGroup, groupName) != null) {
            System.out.println("ClientPanel>> addGroupSilently: Warning-> group already exist, name = " + groupName);
            return null;
        }
        GroupObject subGroup = new GroupObject(parentGroup, groupName, description, Manager.getCurrentAdminId());
        if (groupType != null) {
            subGroup.getSemClientGroup().setOptType(groupType);
        }
        subGroup = GroupHandler.addGroup(subGroup);
        return subGroup;
    }

    public static boolean checkAndRefreshGroup(GroupObject oldGroup, ClientPanel cp) {
        Object[] obj = new Object[]{oldGroup.getName()};
        String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.groupDoesnotExistMsg");
        String fm = MessageFormat.format(str, obj);
        try {
            String groupId = oldGroup.getId();
            GroupObject group = GroupHandler.getGroupById(groupId);
            if (group == null) {
                JOptionPane.showMessageDialog(Manager.getFrame(), fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.consoleError"), 0);
                if (cp != null) {
                    cp.refresh();
                }
                return false;
            }
        }
        catch (ConsoleException ex) {
            int errorCode = ex.getErrorCode();
            if (ex.needRelogin()) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.consoleError"), 0);
                Manager.getFrame().showLoginPanel();
            } else {
                if (errorCode == 0x16010000) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.consoleError"), 0);
                    if (cp != null) {
                        cp.refresh();
                    }
                    return false;
                }
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.consoleError"), 0);
            }
            return false;
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            return false;
        }
        return true;
    }

    private boolean refreshNode(DefaultMutableTreeNode node) {
        if (node == null) {
            return false;
        }
        TreeItem item = (TreeItem)node.getUserObject();
        if (item == null) {
            return false;
        }
        if (item instanceof GroupObject) {
            String groupId = null;
            GroupObject oldGroup = (GroupObject)item;
            Object[] obj = new Object[]{oldGroup.getName()};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.groupDoesnotExistMsg");
            String fm = MessageFormat.format(str, obj);
            try {
                groupId = item.getId();
                GroupObject group = GroupHandler.getGroupById(groupId);
                if (group == null) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.consoleError"), 0);
                    this.removeNode(node);
                    return false;
                }
                group.setAccessible(group.isAccessible(true));
                group.setAccessConstraint(group.getAccessConstraint(true));
                node.setUserObject(group);
                this.tree.updateUI();
            }
            catch (ConsoleException ex) {
                int errorCode = ex.getErrorCode();
                if (ex.needRelogin()) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.consoleError"), 0);
                    Manager.getFrame().showLoginPanel();
                } else if (errorCode == 0x16010000) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.consoleError"), 0);
                    this.removeNode(node);
                } else {
                    JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.consoleError"), 0);
                }
                return false;
            }
            catch (Exception ex) {
                LoggerUtilities.logException((Throwable)ex);
                return false;
            }
            return true;
        }
        return true;
    }

    private void removeNode(DefaultMutableTreeNode node) {
        UIUtilities.removeTreeNode(this.tree, node, true);
    }

    public void removeSelectedNode() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        UIUtilities.removeTreeNode(this.tree, node, true);
    }

    protected void gotoComputersPanel() {
        GroupObject group = this.getSelectedGroup(true);
        this.panelClientTabs.gotoComputersPanel(group);
        this.setCurrentTaskPanel(this.panelClientTabs);
    }

    protected void gotoGroupPanel() {
        GroupObject group = this.getSelectedGroup(true);
        this.panelClientTabs.gotoGroupPanel(group);
        this.setCurrentTaskPanel(this.panelClientTabs);
    }

    private boolean isGroupPanelSelected() {
        return this.getCurrentTaskPanel() == this.panelClientTabs && this.panelClientTabs.isGroupPanelSelected();
    }

    public DefaultTreeModel getGroupTreeModel() {
        DefaultMutableTreeNode root;
        block2: {
            root = null;
            try {
                root = GroupHandler.getGroups(false, Manager.getCurrentDomainId(), true, true);
            }
            catch (ConsoleException e) {
                ConsoleLogger.log(e);
                if (!e.needRelogin()) break block2;
                Manager.getFrame().showLoginPanel();
            }
        }
        return new DefaultTreeModel(root);
    }

    public static boolean canAddClient(GroupObject group, boolean user, boolean showErrorMsg) {
        if (group == null) {
            return false;
        }
        String clientType = user ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.users") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.computers");
        String msg = null;
        if (group.isTypeAd()) {
            Object[] obj = new Object[]{clientType};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.cannotBeAddedMsg");
            msg = MessageFormat.format(str, obj);
        } else if (group.doesBlockNewUser()) {
            Object[] obj = new Object[]{clientType};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.noNewAreAllowedMsg");
            msg = MessageFormat.format(str, obj);
        }
        if (showErrorMsg && msg != null) {
            JOptionPane.showMessageDialog(Manager.getFrame(), msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
            return false;
        }
        return true;
    }

    public static boolean canDelGroup(GroupObject group, boolean showErrorMsg) {
        String msg = null;
        if (group == null) {
            msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.failedToDeleteMsg");
        } else if (group.isTemp()) {
            msg = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.temporaryGroupCannotBeDeletedMsg"), group.getName());
        } else if (group.isGlobal()) {
            msg = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.globalGroupCannotBeDeletedMsg"), group.getName());
        } else if (group.isTypeAdNode()) {
            msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.OUSubCAnnotBeDeletedMsg");
        } else if (group.isTypeCloudNode()) {
            msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.CloudGroupCannotBeDeletedMsg");
        }
        if (msg != null) {
            if (showErrorMsg) {
                JOptionPane.showMessageDialog(Manager.getFrame(), msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
            }
            return false;
        }
        return true;
    }

    public static boolean canMoveGroup(GroupObject group, boolean showErrorMsg) {
        String msg = null;
        if (group == null) {
            msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.failedToMoveMsg");
        } else if (group.isTemp() || group.isGlobal() || group.isTypeCloudNode()) {
            msg = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.cannotMoveGroupMsg"), group.getName());
        } else if (group.isTypeAdNode()) {
            msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.OUSubCannotBeMoved");
        }
        if (msg != null) {
            if (showErrorMsg) {
                JOptionPane.showMessageDialog(Manager.getFrame(), msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.msg"), 0);
            }
            return false;
        }
        if (!AdminPrivilegeObject.isCurrentAdminHasAllPoliciesTypesPrivilege()) {
            msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.notHaveAllPolicyPrivilege");
            if (showErrorMsg) {
                JOptionPane.showMessageDialog(Manager.getFrame(), msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
            }
            return false;
        }
        try {
            GroupPolicyObject policyObject = PolicyHandler.getGroupPolicyByGroup(group);
            if (policyObject.isInherit()) {
                msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.cannotMoveInheritedPolicyModeGroup");
                if (showErrorMsg) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
                }
                return false;
            }
        }
        catch (ConsoleException e) {
            msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.cannotGetGroupPolicyMode");
            if (showErrorMsg) {
                JOptionPane.showMessageDialog(Manager.getFrame(), msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
            }
            ConsoleLogger.log(e);
            if (e.needRelogin()) {
                Manager.getFrame().showLoginPanel();
            }
            return false;
        }
        GroupObject parent = group.getParentGroup();
        if (parent == null || parent.getAccessConstraint(true) != 0) {
            msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.noPrivilegeToMoveGroupMsg");
            if (showErrorMsg) {
                JOptionPane.showMessageDialog(Manager.getFrame(), msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
            }
            return false;
        }
        return true;
    }

    public static boolean canDelClient(ClientObject clientObject, boolean showErrorMsg) {
        boolean canDelete = true;
        String msg = null;
        GroupObject group = null;
        if (clientObject != null) {
            group = clientObject.getGroupObject();
        }
        if (clientObject == null) {
            msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.noClientSelectedMsg");
            canDelete = false;
        } else if (group == null) {
            msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.clientDoesnotBelongToAnyGroupMsg");
            canDelete = false;
        } else if (group.isTypeAd()) {
            Object[] obj = new Object[]{clientObject.isComputerMode() ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.computer") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.user")};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.cannotDeleteAnyInOUMsg");
            msg = MessageFormat.format(str, obj);
            canDelete = false;
        }
        if (!canDelete && showErrorMsg) {
            JOptionPane.showMessageDialog(Manager.getFrame(), msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
        }
        return canDelete;
    }

    public static boolean canMoveClient(ClientObject clientObject, boolean showErrorMsg) {
        boolean canMove = true;
        String msg = null;
        GroupObject group = null;
        String clientType = "";
        if (clientObject != null) {
            group = clientObject.getGroupObject();
            String string = clientType = clientObject.isComputerMode() ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.computer") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.user");
        }
        if (clientObject == null) {
            msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.failedToMovenoClientSelectedMsg");
            canMove = false;
        } else if (group == null) {
            msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.failedToMoveClientDoesnotBelongToMsg");
            canMove = false;
        } else if (group.isTypeAd()) {
            Object[] obj = new Object[]{clientType};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.cannotMoveAnyInOUGroupMsg");
            msg = MessageFormat.format(str, obj);
            canMove = false;
        }
        if (!canMove && showErrorMsg) {
            JOptionPane.showMessageDialog(Manager.getFrame(), msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
        }
        return canMove;
    }

    public static boolean canCopyClient(ClientObject clientObject, boolean showErrorMsg) {
        boolean canCopy = true;
        String msg = null;
        GroupObject group = null;
        if (clientObject != null) {
            group = clientObject.getGroupObject();
        }
        if (clientObject == null) {
            msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.failedToCopyNoClientSelectedMsg");
            canCopy = false;
        } else if (group == null) {
            msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.failedToCopyClientDoesnotBelolngToMsg");
            canCopy = false;
        }
        if (!canCopy && showErrorMsg) {
            JOptionPane.showMessageDialog(Manager.getFrame(), msg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
        }
        return canCopy;
    }

    public EndTaskActionsPopupMenu getEndTaskActionMenu() {
        return this.endTaskpopupMenu;
    }

    public void setUserPopupMenu(EndTaskUsersPopupMenu popupMenu) {
        this.sideBar.setEndTaskUsersPopupMenu(popupMenu);
    }

    public void cancelSync() {
        ImportADSIHandler.stopLdapSync();
    }

    public void doExportSylink() {
        try {
            GroupObject group = this.getSelectedGroup(true);
            if (group == null) {
                return;
            }
            ExportSylinkDlg dlg = new ExportSylinkDlg(group.getFullGroupPath());
            if (dlg.isOk()) {
                GroupPolicyObject gpObj = PolicyHandler.getGroupPolicyByGroupFromDB(group);
                int agentMode = dlg.isComputerMode() ? 1 : 0;
                Object path = dlg.getExportPath();
                if (!AjaxSwingCommonUtil.isAjaxSwingRunning() && new File((String)path).exists()) {
                    int option;
                    if (new File((String)path).isDirectory()) {
                        path = (String)path + File.separator + dlg.getDefaultExportFileName();
                    }
                    if (new File((String)path).exists() && (option = JOptionPane.showConfirmDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.ExportFileExists"), path), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.title.ExportSylink"), 2)) != 0) {
                        return;
                    }
                }
                boolean isFile = true;
                PolicyHandler.exportSylink((String)path, gpObj, agentMode, isFile);
                if (!AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.successMsg"));
                }
            }
        }
        catch (ConsoleException e) {
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
        }
        catch (IOException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
        }
    }

    public ClientTaskPanel getPanelClientTabs() {
        return this.panelClientTabs;
    }

    public SideBar getSideBarObject() {
        return this.sideBar;
    }

    public void cleanUp() {
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        root.removeAllChildren();
        model.reload();
        model.setRoot(null);
        ClientComputersPanel clientComputersPanel = this.panelClientTabs.getComputersPanel();
        clientComputersPanel.cleanUp();
    }

    private static class GroupPolicyCopyDialog
    extends DialogBase {
        private static final long serialVersionUID = -6036600664666986763L;

        public GroupPolicyCopyDialog(String groupName) {
            super(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "GroupPolicyCopyDialog.GroupCopyPolicyDialogTitle"), true);
            this.initialize(groupName);
            UiUtilities.centerComponent((Component)this);
        }

        @Override
        protected boolean isCancelButtonShown() {
            return false;
        }

        @Override
        protected boolean isHelpButtonShown() {
            return false;
        }

        private void initialize(String groupName) {
            final JCheckBox jCbxNoShow = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "GroupPolicyCopyDialog.GroupCopyPolicyDialogNoShow"));
            jCbxNoShow.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        AdminObject admin = AdminObject.retrieveCurrentAdminObject();
                        admin.setDisableCopyPolicyReminder(jCbxNoShow.isSelected());
                        AdminHandler.updateAdmin(admin);
                    }
                    catch (ConsoleException e1) {
                        ConsoleLogger.log(e1);
                    }
                }
            });
            Object[] args = new Object[]{groupName};
            String copyMsg = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "GroupPolicyCopyDialog.GroupCopyPolicyDialogCopyMsg"), args);
            JLabel pasteLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "GroupPolicyCopyDialog.GroupCopyPolicyDialogPasteMsg"));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(20, 20, 30, 20));
            panel.add((Component)new DescriptionTextArea(copyMsg), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)pasteLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
            panel.add((Component)jCbxNoShow, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(20, 0, 0, 0), 0, 0));
            this.getContentPane().add((Component)panel, "Center");
            this.getContentPane().add((Component)this.getButtonPanel(0, 0, true), "South");
            this.pack();
        }
    }
}

