/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client;

import com.sygate.scm.common.configobject.rpc.RpcData;
import com.sygate.scm.common.configobject.schema.DisplayFilter;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingManager;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.console.handler.AdminHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.SemClientAgentHandler;
import com.sygate.scm.console.handler.SemComputerHandler;
import com.sygate.scm.console.handler.SemUserHandler;
import com.sygate.scm.console.logicobject.ClientObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.ICustomView;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.client.ClientViewTableModel;
import com.sygate.scm.console.ui.client.CustomSortableTableModel;
import com.sygate.scm.console.ui.client.dlg.FilterObjectDlg;
import com.sygate.scm.console.ui.util.CustomTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.SwingWorkerExecutor;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.TimeCounter;
import com.sygate.scm.util.Utility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingWorker;

public class ClientCustomTableModel
extends ClientViewTableModel {
    private static final long serialVersionUID = 5309696582203132017L;
    public static final int MAX_CLIENTS_AUTO_DISPLAY = 1000000;
    public static final int CLIENT_STATUS = 1;
    public static final int CLIENT_PROTECTION = 2;
    public static final int CLIENT_NETWORK = 3;
    public static final int CLIENT_SYSTEM = 4;
    public static final int CLIENT_DEFAULT = 0;
    private transient GroupObject group;
    private int totalUserRowCount = 0;
    private int totalComputerRowCount = 0;
    protected transient Vector<ClientObject> data = new Vector();
    protected boolean isDynamicHeaders = true;
    protected JTable table = new StripesTable();
    private String sortColKey;
    protected transient SwingWorker<List<ClientObject>, Void> swingWorker;
    protected Object unitTestSyncObject = new Object();

    public ClientCustomTableModel() {
        this(0);
    }

    public ClientCustomTableModel(int index) {
        this(false);
        if (index > 0) {
            this.viewType = index;
            LicenseObject lic = LicenseObject.getInstance();
            if (lic.isSNACOnlyProduct() && this.viewType > 1) {
                ++this.viewType;
            }
        } else {
            this.viewType = 0;
        }
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.model == null) {
            return new Object();
        }
        try {
            return this.model.getValueAt(row, column);
        }
        catch (Exception ex) {
            return new Object();
        }
    }

    public ClientCustomTableModel(JTable t, int index) {
        super(AdminHandler.getCurrentSemAdminFilter());
        this.table = t;
        this.viewType = index;
    }

    public ClientCustomTableModel(boolean isDynamicHeaders) {
        super(AdminHandler.getCurrentSemAdminFilter());
        this.isDynamicHeaders = isDynamicHeaders;
        this.setIsFixedColumns(!isDynamicHeaders);
    }

    @Override
    public Vector<TableRow> getData(int startRow, int count, boolean isForExport) {
        QueryParameters qp = new QueryParameters(this.group.getId(), startRow, count, this.currentAdminDisplayFilter, this.getViewType(), this.sortColKey, this.sortDir, new UserComputerRowCounts(this.totalUserRowCount, this.totalComputerRowCount), this.getMaxPageRowNumber());
        List<ClientObject> x = this.doQuery(qp);
        this.setPageData(x, 0, this.getMaxPageRowNumber());
        return (Vector)Cast.cast(this.data);
    }

    public void setGroup(GroupObject group) {
        this.group = group;
        this.setRowCount(group);
    }

    public void setDisplayFilter() {
        if (this.group != null) {
            boolean isOfflineNPVDIClient;
            boolean ODCHostedFilter;
            boolean unknownOSFilter;
            boolean platformFilterLinux;
            boolean platformFilterMac;
            boolean platformFilterWin;
            int platformFilter;
            boolean platformFilterAll;
            boolean isOnline;
            FilterObjectDlg dlg;
            this.currentAdminDisplayFilter = AdminHandler.getCurrentSemAdminFilter();
            int modeFilter = AdminHandler.getCurrentSemAdminFilterMode(this.currentAdminDisplayFilter);
            int displayMax = AdminHandler.getCurrentSemAdminFilterPageSize(this.currentAdminDisplayFilter);
            if (displayMax > 1000) {
                displayMax = 1000;
            }
            if ((dlg = new FilterObjectDlg(modeFilter, displayMax, isOnline = AdminHandler.getCurrentSemAdminFilterOnlineStatus(this.currentAdminDisplayFilter), platformFilterAll = (platformFilter = AdminHandler.getCurrentSemAdminFilterShowPlatform(this.currentAdminDisplayFilter)) == 2, platformFilterWin = AdminHandler.getCurrentSemAdminFilterShowPlatformWin(), platformFilterMac = AdminHandler.getCurrentSemAdminFilterShowPlatformMac(), platformFilterLinux = AdminHandler.getCurrentSemAdminFilterShowPlatformLinux(), unknownOSFilter = AdminHandler.getCurrentSemAdminFilterNewClient(this.currentAdminDisplayFilter), ODCHostedFilter = AdminHandler.getCurrentSemAdminFilterODCHosted(this.currentAdminDisplayFilter), isOfflineNPVDIClient = AdminHandler.getCurrentSemAdminFilterOfflineStatusForNPVDIClients(this.currentAdminDisplayFilter))).isOk()) {
                block5: {
                    try {
                        AdminHandler.updateCurrentSemAdminFilter(dlg.getPlatformFilterAll(), dlg.getPlatformFilterWin(), dlg.getPlatformFilterMac(), dlg.getPlatformFilterLinux(), dlg.getFilterType(), dlg.getNewClients(), dlg.getOnlineStatus(), dlg.getCount(), dlg.getODCHosted(), dlg.getOfflineNPVDIClients());
                        this.setMaxPageRowNumber(dlg.getCount());
                    }
                    catch (ConsoleException e) {
                        JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientTableModel.consoleError"), 0);
                        if (!e.needRelogin()) break block5;
                        Manager.getFrame().showLoginPanel();
                    }
                }
                this.setGroup(this.group);
            }
            dlg.dispose();
        }
    }

    @Override
    protected int getModelRowCount(String queryTable, String queryFilter) {
        int filter = AdminHandler.getCurrentSemAdminFilterMode(this.currentAdminDisplayFilter);
        if (filter == 0) {
            return this.totalUserRowCount;
        }
        if (filter == 1) {
            return this.totalComputerRowCount;
        }
        return this.totalComputerRowCount + this.totalUserRowCount;
    }

    protected UserComputerRowCounts getRowCounts(GroupObject group, int filter) {
        int totalComputerRowCount;
        int totalUserRowCount;
        block7: {
            totalUserRowCount = 0;
            totalComputerRowCount = 0;
            int platformFilter = AdminHandler.getCurrentSemAdminFilterShowPlatform(this.currentAdminDisplayFilter);
            boolean newClientsFilter = AdminHandler.getCurrentSemAdminFilterNewClient(this.currentAdminDisplayFilter);
            boolean isOfflineNVDIClient = AdminHandler.getCurrentSemAdminFilterOfflineStatusForNPVDIClients(this.currentAdminDisplayFilter);
            try {
                TimeCounter counter = new TimeCounter();
                if (filter == 2) {
                    totalUserRowCount = SemClientAgentHandler.getCountByGroupIdAndOS(group.getId(), platformFilter, newClientsFilter, 2, this.viewType, isOfflineNVDIClient);
                } else if (filter == 0) {
                    totalUserRowCount = SemUserHandler.getGroupUserCountByOS(group.getId(), platformFilter, newClientsFilter, this.viewType, isOfflineNVDIClient);
                } else if (filter == 1) {
                    totalComputerRowCount = SemComputerHandler.getGroupComputerCountByOS(group.getId(), platformFilter, newClientsFilter, this.viewType, isOfflineNVDIClient);
                }
                System.out.println(">>>>>>ClientCustomTableModel>>>>GetRowCounts>>>>Type:" + filter + ">>>cost:" + counter.toStringEx2(true));
            }
            catch (ConsoleException e) {
                JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientTableModel.consoleError"), 0);
                if (!e.needRelogin()) break block7;
                Manager.getFrame().showLoginPanel();
            }
        }
        return new UserComputerRowCounts(totalUserRowCount, totalComputerRowCount);
    }

    protected void setRowCount(GroupObject group) {
        this.currentAdminDisplayFilter = AdminHandler.getCurrentSemAdminFilter();
        UserComputerRowCounts x = this.getRowCounts(group, AdminHandler.getCurrentSemAdminFilterMode(this.currentAdminDisplayFilter));
        this.totalUserRowCount = x.getUserCount();
        this.totalComputerRowCount = x.getComputerCount();
    }

    @Override
    protected void resetData(int startRow, final int count, String queryTable, String queryFilter) {
        this.sortColKey = this.getSortColNameKey();
        final QueryParameters qp = new QueryParameters(this.group.getId(), startRow, count, this.currentAdminDisplayFilter, this.getViewType(), this.sortColKey, this.sortDir, new UserComputerRowCounts(this.totalUserRowCount, this.totalComputerRowCount), this.getMaxPageRowNumber());
        if (this.swingWorker != null) {
            this.swingWorker.cancel(true);
        }
        this.swingWorker = new SwingWorker<List<ClientObject>, Void>(){

            @Override
            protected List<ClientObject> doInBackground() throws Exception {
                return ClientCustomTableModel.this.doQuery(qp);
            }

            /*
             * Exception decompiling
             */
            @Override
            protected void done() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        AjaxSwingManager.beginOperation();
        SwingWorkerExecutor.getInstance().execute(this.swingWorker);
    }

    @Override
    public TableRow getRow(int index) {
        return this.model == null ? null : this.model.getRow(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<ClientObject> getObjectList(String groupId, int start, int length, int viewType, String sortColKey, boolean isAscending, RpcData rpc) {
        ArrayList<ClientObject> objList = new ArrayList();
        TimeCounter counter = new TimeCounter();
        System.out.println("start = " + start + " length=" + length);
        try {
            objList = SemComputerHandler.getComputerList(groupId, start, length, sortColKey, viewType, AdminHandler.getCurrentSemAdminFilterMode(this.currentAdminDisplayFilter), isAscending, rpc);
        }
        catch (ConsoleException e) {
            System.out.println("start = " + start + " length=" + length);
            LoggerUtilities.logException((Throwable)e);
            if (e.needRelogin()) {
                Manager.getFrame().showLoginPanel();
            }
        }
        finally {
            ConsoleLogger.log("SemComputerHandler.getComputerList>>" + counter.toString());
        }
        return objList;
    }

    private List<ClientObject> doQuery(QueryParameters qParams) {
        ArrayList<ClientObject> result = new ArrayList<ClientObject>();
        int start = qParams.getStart();
        int maxPageRowNumber = qParams.getMaxPageRowNumber();
        boolean isAscending = qParams.isAscending();
        int viewType = qParams.getViewType();
        String groupId = qParams.getGroupId();
        String sortColKey = qParams.getSortColKey();
        try {
            result.addAll(this.getObjectList(groupId, start, maxPageRowNumber, viewType, sortColKey, isAscending, this.getOtherFilterConditions()));
        }
        catch (Exception e) {
            System.err.println("ClientCustomModel.doQuery(): exception=" + e.getMessage());
            LoggerUtilities.logException((Throwable)e);
        }
        return result;
    }

    @Override
    public int calculateTotalPages(String queryTable, String queryFilter) {
        return super.calculateTotalPages("", "");
    }

    protected void setPageData(List<ClientObject> result) {
        this.setPageData(result, 0, this.getMaxPageRowNumber());
    }

    protected void setPageData(List<ClientObject> result, int start, int size) {
        Vector<ClientObject> queryData = this.data;
        queryData.clear();
        ArrayList<String> idList = new ArrayList<String>();
        if (result != null) {
            int count = result.size();
            for (int i = start; i < start + Math.min(count, size); ++i) {
                ClientObject obj = result.get(i);
                if (obj == null) continue;
                String id = obj.getClientId();
                if (!idList.contains(id)) {
                    obj.setShowOnlineStatus(AdminHandler.getCurrentSemAdminFilterOnlineStatus(this.currentAdminDisplayFilter));
                    obj.setShowFinderTable(false);
                    idList.add(id);
                    queryData.add(obj);
                    continue;
                }
                int index = idList.indexOf(id);
                ClientObject target = queryData.get(index);
                long newTime = ((ICustomView)((Object)obj)).getAgentTime();
                if (newTime <= target.getCreationTime()) continue;
                obj.setShowOnlineStatus(AdminHandler.getCurrentSemAdminFilterOnlineStatus(this.currentAdminDisplayFilter));
                obj.setShowFinderTable(false);
                queryData.setElementAt(obj, index);
            }
        }
    }

    private RpcData getOtherFilterConditions() {
        RpcData rpc = new RpcData();
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"INTEGER_2", (String)String.valueOf(AdminHandler.getCurrentSemAdminFilterShowPlatform(this.currentAdminDisplayFilter)));
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"BOOLEAN_1", (String)String.valueOf(AdminHandler.getCurrentSemAdminFilterODCHosted(this.currentAdminDisplayFilter)));
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"BOOLEAN_2", (String)String.valueOf(AdminHandler.getCurrentSemAdminFilterNewClient(this.currentAdminDisplayFilter)));
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"BOOLEAN_3", (String)String.valueOf(AdminHandler.getCurrentSemAdminFilterOfflineStatusForNPVDIClients(this.currentAdminDisplayFilter)));
        return rpc;
    }

    public static String getOSFilter(ArrayList<String> platformsSelected) {
        StringBuffer buffer = new StringBuffer();
        if (platformsSelected.size() == 0) {
            return "";
        }
        buffer.append(" AND ( ");
        for (int osCount = 0; osCount < platformsSelected.size(); ++osCount) {
            if (osCount != 0) {
                buffer.append(" OR ");
            }
            buffer.append(platformsSelected.get(osCount));
        }
        if (buffer.length() > 0) {
            buffer.append(") ");
        }
        return buffer.toString();
    }

    @Override
    public void refresh(String queryTable, String queryFilter) throws ConsoleException {
        this.setMaxPageRowNumber(AdminHandler.getCurrentSemAdminFilterPageSize(this.currentAdminDisplayFilter));
        int calTotalPages = this.calculateTotalPages("", "");
        int newCurrentPage = this.getCurrentPage();
        if (calTotalPages > 0) {
            if (newCurrentPage >= calTotalPages) {
                newCurrentPage = calTotalPages - 1;
            }
        } else {
            newCurrentPage = 0;
        }
        this.getPage(newCurrentPage, "", "", calTotalPages);
    }

    public void setSortOrder(int column) {
    }

    public int getSortedColumn() {
        return ((CustomSortableTableModel)this.model).getSortedColumn();
    }

    public String getSortColKey() {
        return this.sortColKey;
    }

    public void setSortColKey(String sortColKey) {
        this.sortColKey = sortColKey;
    }

    public void cleanUp() {
        this.group = null;
    }

    static /* synthetic */ CustomTableModel access$000(ClientCustomTableModel x0) {
        return x0.model;
    }

    static /* synthetic */ CustomTableModel access$100(ClientCustomTableModel x0) {
        return x0.model;
    }

    static class QueryParameters {
        private final int viewType;
        private final String groupId;
        private final UserComputerRowCounts counts;
        private final int start;
        private final int size;
        private final boolean isAscending;
        private final String sortColKey;
        private final DisplayFilter diplayFilter;

        public QueryParameters(String groupId, int start, int size, DisplayFilter df, int viewType, String sortColKey, boolean isAscending, UserComputerRowCounts counts, int maxPageRowNumber) {
            this.diplayFilter = df;
            this.viewType = viewType;
            this.groupId = groupId;
            this.counts = counts;
            this.start = start;
            this.size = size;
            this.sortColKey = sortColKey;
            this.isAscending = isAscending;
        }

        public int getMaxPageRowNumber() {
            return AdminHandler.getCurrentSemAdminFilterPageSize(this.diplayFilter);
        }

        public int getFilter() {
            return AdminHandler.getCurrentSemAdminFilterMode(this.diplayFilter);
        }

        public int getViewType() {
            return this.viewType;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public UserComputerRowCounts getCounts() {
            return this.counts;
        }

        public int getStart() {
            return this.start;
        }

        public int getSize() {
            return this.size;
        }

        public String getSortColKey() {
            return this.sortColKey;
        }

        public boolean isAscending() {
            return this.isAscending;
        }
    }

    static class UserComputerRowCounts {
        private final int computerCount;
        private final int userCount;

        public UserComputerRowCounts(int userCount, int computerCount) {
            this.userCount = userCount;
            this.computerCount = computerCount;
        }

        public int getUserCount() {
            return this.userCount;
        }

        public int getComputerCount() {
            return this.computerCount;
        }
    }
}

