/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client;

import com.sygate.scm.common.configobject.schema.DisplayFilter;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.AjaxSwingManager;
import com.sygate.scm.console.handler.AdminHandler;
import com.sygate.scm.console.handler.LicenseHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.AdminPreferenceObject;
import com.sygate.scm.console.logicobject.ClientObject;
import com.sygate.scm.console.logicobject.ClientStatusObject;
import com.sygate.scm.console.logicobject.ClientStatusUserObject;
import com.sygate.scm.console.logicobject.ClientSystemObject;
import com.sygate.scm.console.logicobject.ClientSystemUserObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.logicobject.UserObject;
import com.sygate.scm.console.ui.client.ClientCustomTableModel;
import com.sygate.scm.console.ui.client.ClientTableNavigationPanel;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.TableResizeUtil;
import com.sygate.scm.console.ui.util.renderer.IPv6CellRenderer;
import com.sygate.scm.console.ui.util.renderer.JLabelCellRenderer;
import com.sygate.scm.console.ui.util.renderer.TableHeaderRenderer;
import com.sygate.scm.console.util.CloudUtil;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.ScmProperties;
import com.sygate.scm.console.util.i18n.ConsoleMessageResourcesFile;
import com.sygate.scm.util.AutoUpgradeUtils;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ClientComputersTablePanel
extends JPanel
implements ListSelectionListener,
TableModelListener,
MouseListener,
ActionListener {
    private static final long serialVersionUID = -6789710045201657159L;
    private static final int PREFERRED_NAME_COLUMN_WIDTH = 140;
    public static final MessageResourcesFile MSGRES = new ConsoleMessageResourcesFile("com.sygate.scm.console.ui.client.client");
    private static final String[] COMBO_CHOICES = new String[]{MSGRES.getString("ClientComputersTablePanel.choiceDefault"), MSGRES.getString("ClientComputersTablePanel.choiceClientStatus"), MSGRES.getString("ClientComputersTablePanel.choiceClientTechnology"), MSGRES.getString("ClientComputersTablePanel.choiceClientNetworkInfo"), MSGRES.getString("ClientComputersTablePanel.choiceClientSystemInfo")};
    private static final String[] COMBO_CHOICES_SNAC = new String[]{MSGRES.getString("ClientComputersTablePanel.choiceDefault"), MSGRES.getString("ClientComputersTablePanel.choiceClientStatus"), MSGRES.getString("ClientComputersTablePanel.choiceClientNetworkInfo"), MSGRES.getString("ClientComputersTablePanel.choiceClientSystemInfo")};
    private JComboBox<String> choiceCombo = null;
    private JButton filterButton = null;
    static final String[][] COLS_NAMES = new String[][]{{MSGRES.getString("ClientComputersTablePanel.nameColHead"), MSGRES.getString("ClientComputersTablePanel.healthStateColHead"), MSGRES.getString("ClientComputersTablePanel.userColHead"), MSGRES.getString("ClientComputersTablePanel.clientStatusView.lastCheckin"), MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.virusDef"), MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.AMLAVDef"), MSGRES.getString("ClientComputersTablePanel.clientStatusView.policySerial"), MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.lastScan"), MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.avStatus"), MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.fwStatus"), MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.LB"), MSGRES.getString("ClientComputersTablePanel.clientStatusView.rebootRequired"), MSGRES.getString("ClientComputersTablePanel.descriptionColHeader")}, {MSGRES.getString("ClientComputersTablePanel.nameColHead"), MSGRES.getString("ClientComputersTablePanel.healthStateColHead"), MSGRES.getString("ClientComputersTablePanel.userColHead"), MSGRES.getString("ClientComputersTablePanel.clientStatusView.IP"), MSGRES.getString("ClientComputersTablePanel.clientStatusView.version"), MSGRES.getString("ClientComputersTablePanel.clientStatusView.lastCheckin"), MSGRES.getString("ClientComputersTablePanel.clientStatusView.rebootRequired"), MSGRES.getString("ClientComputersTablePanel.clientStatusView.policySerial")}, {MSGRES.getString("ClientComputersTablePanel.nameColHead"), MSGRES.getString("ClientComputersTablePanel.healthStateColHead"), MSGRES.getString("ClientComputersTablePanel.userColHead"), MSGRES.getString("ClientComputersTablePanel.clientStatusView.IP"), MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.lastScan"), MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.avStatus"), MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.fwStatus"), MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.TruScanStatus"), MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.Mr.Clean"), MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.PEP"), MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.CIDS"), MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.CIDS.IE"), MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.CIDS.FF"), MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.CIDS.CHROME"), MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.TP"), MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.virusDef"), MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.IPSDef"), MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.MrCleanDef"), MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.PTPDef"), MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.AMLAVDef"), MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.EDRDef"), MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.WTRDef"), MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.TDADDef"), MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.ELAM"), MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.LB"), MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.NTR"), MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.TDAD")}, {MSGRES.getString("ClientComputersTablePanel.nameColHead"), MSGRES.getString("ClientComputersTablePanel.healthStateColHead"), MSGRES.getString("ClientComputersTablePanel.clientNetworkView.DomainOrWorkgroup"), MSGRES.getString("ClientComputersTablePanel.userColHead"), MSGRES.getString("ClientComputersTablePanel.clientNetworkView.IP"), MSGRES.getString("ClientComputersTablePanel.clientNetworkView.DNS"), MSGRES.getString("ClientComputersTablePanel.clientNetworkView.WINS"), MSGRES.getString("ClientComputersTablePanel.clientNetworkView.MAC"), MSGRES.getString("ClientComputersTablePanel.clientNetworkView.Gateway")}, {MSGRES.getString("ClientComputersTablePanel.nameColHead"), MSGRES.getString("ClientComputersTablePanel.healthStateColHead"), MSGRES.getString("ClientComputersTablePanel.userColHead"), MSGRES.getString("ClientComputersTablePanel.clientSystemView.IP"), MSGRES.getString("ClientComputersTablePanel.clientSystemView.osType"), MSGRES.getString("ClientComputersTablePanel.clientSystemView.servicePack"), MSGRES.getString("ClientComputersTablePanel.clientSystemView.freeMemory"), MSGRES.getString("ClientComputersTablePanel.clientSystemView.freeDisk"), MSGRES.getString("ClientComputersTablePanel.clientSystemView.totalDisk")}};
    public static final int CLIENT_DEFAULT = 0;
    public static final int CLIENT_STATUS = 1;
    public static final int CLIENT_TECHNOLOGY = 2;
    public static final int CLIENT_NETWORK = 3;
    public static final int CLIENT_SYSTEM = 4;
    private static final String[] VIEW_NAMES = new String[]{"OLDDEFAULT", "CLIENT STATUS", "CLIENT TECHNOLOGY", "CLIENT NETWORK", "CLIENT SYSTEM"};
    private String[] savedCols;
    private String[] savedColSizes;
    private GroupObject group = null;
    private ClientTableNavigationPanel clientSearchResultPanel;
    private ClientCustomTableModel customModel = null;
    private ClientCustomTableModel tableModel = null;
    JPanel switchPanel;
    protected JLabel filterSelectionLabel;
    private int currentView = 0;
    protected JTable resultTable;
    private boolean refreshHasBeenCalled = false;
    public static final String COLUMN_SPLIT_COMMA = ",";
    private AdminObject adminObject = null;
    private AdminPreferenceObject prefObject = null;
    private final JLegacyClientVersionCellRender legacyClientCellRender = new JLegacyClientVersionCellRender();
    private final JLegacyClientVersionCellRender legacyClientOsCellRender = new JLegacyClientVersionCellRender();
    private final IPv6CellRenderer ipv6ShorteningCellRenderer = new IPv6CellRenderer();
    public static final String IPS_DEFINITIONS = MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.IPSDef");
    public static final String DOWNLOAD_PROTECTION_DEFINITIONS = MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.MrCleanDef");
    public static final String SORNA_DEFINITIONS = MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.PTPDef");
    public static final String EDR_DEFINITIONS = MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.EDRDef");
    public static final String WTR_DEFINITIONS = MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.WTRDef");
    public static final String TDAD_DEFINITIONS = MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.TDADDef");
    private static final HashMap<String, String> MAP_DISPLAYNAME2KEY_DEFAULTVIEW = new HashMap();
    private static final HashMap<String, String> MAP_DISPLAYNAME2KEY_STATUSVIEW;
    private static final HashMap<String, String> MAP_DISPLAYNAME2KEY_TECHNOLOGYVIEW;
    private static final HashMap<String, String> MAP_DISPLAYNAME2KEY_NETWORKVIEW;
    private static final HashMap<String, String> MAP_DISPLAYNAME2KEY_SYSTEMVIEW;
    static final List<Map<String, String>> COLS_NAMES_KEYS;

    public ClientComputersTablePanel() {
        this.initTable();
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ConsoleLogger.log(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ex) {
        this.refresh(this.group);
    }

    public void doDelete() {
        this.clientSearchResultPanel.doDelete();
    }

    public void doMove() {
        this.clientSearchResultPanel.doMove();
    }

    public void doEnableLanSensor() {
        this.clientSearchResultPanel.doEnableLANSensor();
    }

    public void doDisableLanSensor() {
        this.clientSearchResultPanel.doDisableLANSensor();
    }

    public void doConfigLanSensor() {
        this.clientSearchResultPanel.doConfigLANSensor();
    }

    public void doProps() {
        this.clientSearchResultPanel.doProps();
    }

    @Override
    public void mouseReleased(MouseEvent ex) {
        AjaxSwingCommonUtil.executeIfWebConsoleIsNotRunning(this::saveColAndSizePreference);
    }

    @Override
    public void mouseClicked(MouseEvent ex) {
        AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(this::saveColAndSizePreference);
    }

    @Override
    public void mouseEntered(MouseEvent ex) {
    }

    @Override
    public void mousePressed(MouseEvent ex) {
    }

    @Override
    public void mouseExited(MouseEvent ex) {
    }

    public void executeCommandTask(int taskId) {
        switch (taskId) {
            case 21: {
                this.clientSearchResultPanel.executeCommand("ScanNow");
                break;
            }
            case 22: {
                this.clientSearchResultPanel.executeCommand("Update_Now");
                break;
            }
            case 23: {
                this.clientSearchResultPanel.executeCommand("Update_ScanNow");
                break;
            }
            case 53: {
                this.clientSearchResultPanel.executeCommand("PowerEraser");
                break;
            }
            case 24: {
                this.clientSearchResultPanel.executeCommand("Reboot");
                break;
            }
            case 25: {
                this.clientSearchResultPanel.executeCommand("ApOn");
                break;
            }
            case 26: {
                this.clientSearchResultPanel.executeCommand("ApOff");
                break;
            }
            case 27: {
                this.clientSearchResultPanel.executeCommand("FwOn");
                break;
            }
            case 28: {
                this.clientSearchResultPanel.executeCommand("FwOff");
                break;
            }
            case 54: {
                this.clientSearchResultPanel.executeCommand("Collect_FileFingerprintList");
                break;
            }
            case 50: {
                this.clientSearchResultPanel.executeCommand("DaOff");
                break;
            }
            case 49: {
                this.clientSearchResultPanel.executeCommand("DaOn");
                break;
            }
            case 57: {
                this.clientSearchResultPanel.executeCommand("AdminQuarantineEnabled");
                break;
            }
            case 58: {
                this.clientSearchResultPanel.executeCommand("AdminQuarantineDisabled");
                break;
            }
        }
    }

    public void setDisplayFilter() {
        this.clientSearchResultPanel.setDisplayFilter();
        this.adminObject = AdminObject.retrieveCurrentAdminObject();
        this.refresh();
    }

    public void refresh() {
        if (this.group != null) {
            this.refreshHasBeenCalled = true;
            this.refresh(this.group);
        }
    }

    public void refresh(Object item) {
        this.refreshHasBeenCalled = true;
        if (item != null) {
            this.group = (GroupObject)item;
        }
        this.tableModel = this.getCustomTableModel(this.currentView);
        this.tableModel.setColumnNames(COLS_NAMES[this.currentView], true);
        this.tableModel.setPanelHandle(this);
        AjaxSwingManager.beginOperation();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientComputersTablePanel.this.setCursor(Cursor.getPredefinedCursor(3));
                    ClientComputersTablePanel.this.setupTable();
                    ClientComputersTablePanel.this.autoResizeColumns();
                    ClientComputersTablePanel.this.syncModel();
                    ClientComputersTablePanel.this.setSortIconToHeader(ClientComputersTablePanel.this.resultTable, ClientComputersTablePanel.this.tableModel);
                    ClientComputersTablePanel.this.setCursor(Cursor.getPredefinedCursor(0));
                }
                catch (Throwable ex) {
                    ClientComputersTablePanel.this.setCursor(Cursor.getPredefinedCursor(0));
                    ConsoleLogger.log(ex);
                }
                finally {
                    AjaxSwingManager.endOperation();
                    AjaxSwingCommonUtil.updateSwingAgentBrowser((boolean)true);
                }
            }
        });
    }

    @Override
    public void valueChanged(ListSelectionEvent ex) {
    }

    public void addTableSelectionListener(ListSelectionListener listener) {
        this.clientSearchResultPanel.getTable().getSelectionModel().removeListSelectionListener(listener);
        this.clientSearchResultPanel.getTable().getSelectionModel().addListSelectionListener(listener);
    }

    public int getTableSelectedItem() {
        boolean isMove = false;
        switch (this.clientSearchResultPanel.getTable().getSelectedRowCount()) {
            case 0: {
                return 0;
            }
            case 1: {
                boolean bl = isMove = !this.clientSearchResultPanel.isGroupTypeAdSelected(this.clientSearchResultPanel.getTable().getSelectedRows());
                if (isMove) {
                    return 1;
                }
                return 8;
            }
        }
        boolean bl = isMove = !this.clientSearchResultPanel.isGroupTypeAdSelected(this.clientSearchResultPanel.getTable().getSelectedRows());
        if (isMove) {
            return 2;
        }
        return 9;
    }

    public boolean isSelectedOneUserMode() {
        TableRow[] tableRows;
        if (this.clientSearchResultPanel.getTable().getSelectedRowCount() == 1 && (tableRows = this.clientSearchResultPanel.getSelectedTableRows())[0] != null && tableRows[0] instanceof ClientObject) {
            ClientObject clientObject = (ClientObject)tableRows[0];
            return clientObject.isComputerMode();
        }
        return false;
    }

    public boolean isSelectedOneLanSensor() {
        TableRow[] tableRows;
        if (this.clientSearchResultPanel.getTable().getSelectedRowCount() == 1 && (tableRows = this.clientSearchResultPanel.getSelectedTableRows())[0] != null && tableRows[0] instanceof ClientObject) {
            ClientObject clientObject = (ClientObject)tableRows[0];
            return clientObject.isLanSensor();
        }
        return false;
    }

    public boolean isSelectedOneMacClient() {
        TableRow[] tableRows;
        if (this.clientSearchResultPanel.getTable().getSelectedRowCount() == 1 && (tableRows = this.clientSearchResultPanel.getSelectedTableRows())[0] != null && tableRows[0] instanceof ClientObject) {
            ClientObject clientObject = (ClientObject)tableRows[0];
            return clientObject.getClientPlatform() == 2;
        }
        return false;
    }

    public Integer getSelectedOneClientOsType() {
        TableRow[] tableRows;
        Integer osType = null;
        if (this.clientSearchResultPanel.getTable().getSelectedRowCount() == 1 && (tableRows = this.clientSearchResultPanel.getSelectedTableRows())[0] != null && tableRows[0] instanceof ClientObject) {
            ClientObject clientObject = (ClientObject)tableRows[0];
            if (clientObject.getClientPlatform() == 1) {
                osType = 1;
            } else if (clientObject.getClientPlatform() == 3) {
                osType = 3;
            } else if (clientObject.getClientPlatform() == 2) {
                osType = 2;
            }
        }
        return osType;
    }

    private void jbInit() throws Exception {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getSwitchPanel(), "North");
        this.add((Component)this.clientSearchResultPanel, "Center");
    }

    public ClientCustomTableModel getCustomTableModel(int it) {
        if (this.customModel == null) {
            this.customModel = new ClientCustomTableModel(this.resultTable, it);
            this.customModel.addTableModelListener(this.legacyClientCellRender);
            this.customModel.addTableModelListener(this.legacyClientOsCellRender);
        } else {
            this.customModel.setViewType(it);
        }
        return this.customModel;
    }

    private String generateColumnSizeSequence() {
        int is;
        StringBuffer colString = new StringBuffer("");
        int count = this.tableModel.getColumnCount();
        TableColumn column = null;
        for (is = 0; is < count - 1; ++is) {
            column = this.resultTable.getColumnModel().getColumn(is);
            colString.append(column.getPreferredWidth() + COLUMN_SPLIT_COMMA);
        }
        column = this.resultTable.getColumnModel().getColumn(is);
        colString.append(column.getPreferredWidth());
        return colString.toString();
    }

    public String[] convertToColumns(String colString) {
        String[] cols = null;
        StringTokenizer st = new StringTokenizer(colString, COLUMN_SPLIT_COMMA);
        ArrayList<String> columnList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String col = st.nextToken();
            columnList.add(col);
        }
        if (columnList.size() < 1) {
            return null;
        }
        cols = new String[columnList.size()];
        for (int i = 0; i < columnList.size(); ++i) {
            cols[i] = (String)columnList.get(i);
        }
        return cols;
    }

    private JPanel getSwitchPanel() {
        if (this.switchPanel == null) {
            this.switchPanel = new JPanel();
            this.switchPanel.setLayout(new BorderLayout());
            this.switchPanel.setBorder(BorderFactory.createEmptyBorder(1, 5, 5, 1));
            JPanel comboPanel = new JPanel();
            comboPanel.setLayout(new GridBagLayout());
            JLabel viewLabel = new JLabel(MSGRES.getString("ClientComputersTablePanel.viewLabelText"));
            comboPanel.add((Component)viewLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 2, 5), 0, 0));
            LicenseObject lic = LicenseObject.getInstance();
            this.choiceCombo = lic.isSNACOnlyProduct() ? new JComboBox<String>(COMBO_CHOICES_SNAC) : new JComboBox<String>(COMBO_CHOICES);
            viewLabel.setLabelFor(this.choiceCombo);
            comboPanel.add(this.choiceCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.filterSelectionLabel = new JLabel();
            JPanel filterSelectionPanel = new JPanel();
            filterSelectionPanel.setLayout(new GridBagLayout());
            filterSelectionPanel.add((Component)this.filterSelectionLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.switchPanel.add((Component)comboPanel, "West");
            JPanel filterPanel = new JPanel();
            this.filterButton = new JButton(MSGRES.getString("ClientComputersTablePanel.FilterButtonLabel"));
            this.filterButton.setMargin(new Insets(0, 0, 0, 0));
            filterPanel.add((Component)this.filterButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 0), 0, 0));
            this.switchPanel.add((Component)filterSelectionPanel, "Center");
            this.switchPanel.add((Component)filterPanel, "East");
            this.setFilterSelected();
            this.filterButton.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent ex) {
                    ClientComputersTablePanel.this.setDisplayFilter();
                }
            });
            this.applyViewPrefToCombBox();
            this.choiceCombo.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent ex) {
                    LicenseObject lic = LicenseObject.getInstance();
                    int index = ClientComputersTablePanel.this.choiceCombo.getSelectedIndex();
                    if (index < 0) {
                        index = 0;
                    } else if (index > 1 && lic.isSNACOnlyProduct()) {
                        ++index;
                    }
                    if (ClientComputersTablePanel.this.currentView != index) {
                        ClientComputersTablePanel.this.saveViewPreference(index);
                        ClientComputersTablePanel.this.loadColumnAndSizePref();
                        ClientComputersTablePanel.this.tableModel = ClientComputersTablePanel.this.getCustomTableModel(index);
                        ClientComputersTablePanel.this.tableModel.setColumnNames(COLS_NAMES[index], true);
                        ClientComputersTablePanel.this.tableModel.setPanelHandle(ClientComputersTablePanel.this);
                        AjaxSwingManager.beginOperation();
                        SwingUtilities.invokeLater(new SwitchRunnable(index));
                    }
                }
            });
        }
        return this.switchPanel;
    }

    public void setFilterSelected() {
        this.filterSelectionLabel.setText(this.getDisplayFilterText());
    }

    public String getCurrentViewSortColNameKey(int sortColNo) {
        String currentSortColNameKey = null;
        try {
            currentSortColNameKey = this.savedCols[sortColNo];
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.error"), 0);
        }
        return currentSortColNameKey;
    }

    public void sort() {
        if (!this.refreshHasBeenCalled) {
            return;
        }
        AjaxSwingManager.beginOperation();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientComputersTablePanel.this.setCursor(Cursor.getPredefinedCursor(3));
                    ClientComputersTablePanel.this.tableModel = ClientComputersTablePanel.this.getCustomTableModel(ClientComputersTablePanel.this.currentView);
                    ClientComputersTablePanel.this.tableModel.setColumnNames(COLS_NAMES[ClientComputersTablePanel.this.currentView], true);
                    ClientComputersTablePanel.this.tableModel.setPanelHandle(ClientComputersTablePanel.this);
                    ClientComputersTablePanel.this.syncModel();
                    ClientComputersTablePanel.this.clientSearchResultPanel.refresh("", "");
                    ClientComputersTablePanel.this.setSortIconToHeader(ClientComputersTablePanel.this.resultTable, ClientComputersTablePanel.this.tableModel);
                    ClientComputersTablePanel.this.autoResizeColumns();
                    ClientComputersTablePanel.this.setCursor(Cursor.getPredefinedCursor(0));
                }
                catch (Throwable ex) {
                    LoggerUtilities.logException((Throwable)ex);
                }
                finally {
                    AjaxSwingManager.endOperation();
                    AjaxSwingCommonUtil.updateSwingAgentBrowser((boolean)true);
                }
            }
        });
    }

    private void setSortIconToHeader(JTable table, ClientCustomTableModel tableModel) {
        int sortedColumn = tableModel.getSortModelColOrder();
        if (sortedColumn != -1) {
            int oldViewCol = table.convertColumnIndexToView(sortedColumn);
            TableColumnModel colModel = table.getColumnModel();
            TableColumn column = colModel.getColumn(oldViewCol);
            JLabel headerLabel = (JLabel)((Object)column.getHeaderRenderer());
            if (headerLabel == null) {
                headerLabel = new TableHeaderRenderer();
                column.setHeaderRenderer((TableCellRenderer)((Object)headerLabel));
                headerLabel.setPreferredSize(new Dimension(column.getPreferredWidth(), table.getTableHeader().getHeight()));
            }
            if (tableModel.isSortDir()) {
                headerLabel.setIcon(SortableTableModel.upIcon);
            } else {
                headerLabel.setIcon(SortableTableModel.downIcon);
            }
            table.getTableHeader().repaint();
        }
    }

    private void removeSortIconToHeader() {
        JTableHeader tableHeader = this.resultTable.getTableHeader();
        TableColumnModel tableHeaderColumnModel = tableHeader.getColumnModel();
        int columnCount = tableHeaderColumnModel.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            TableColumn column = tableHeaderColumnModel.getColumn(i);
            JLabel headerLabel = (JLabel)((Object)column.getHeaderRenderer());
            if (headerLabel == null) continue;
            headerLabel.setIcon(null);
            headerLabel.setPreferredSize(new Dimension(column.getPreferredWidth(), this.resultTable.getTableHeader().getHeight()));
        }
    }

    private void refreshSortIconToHeader(JTable table, ClientCustomTableModel tableModel) {
        this.removeSortIconToHeader();
        this.setSortIconToHeader(table, tableModel);
    }

    private void setupTable() {
        if (this.customModel == null) {
            this.customModel = new ClientCustomTableModel(this.resultTable, this.currentView);
            this.customModel.addTableModelListener(this.legacyClientCellRender);
            this.customModel.addTableModelListener(this.legacyClientOsCellRender);
        }
        this.tableModel = this.customModel;
        this.customModel.setGroup(this.group);
        this.customModel.setPanelHandle(this);
        this.customModel.getSortDelegator().setCCTModel(this.customModel);
        this.clientSearchResultPanel.setTableModel(this.tableModel);
        this.clientSearchResultPanel.setGroup(this.group);
        int rowCount = 0;
        rowCount = this.customModel.getModelRowCount("", "");
        int triggerDisplay = 1000000;
        if (rowCount > triggerDisplay) {
            this.clientSearchResultPanel.setClientLabelTextMax(true);
            this.clientSearchResultPanel.setDisplayWhenCountExceeds();
            this.clientSearchResultPanel.enableNext_PrevAndPage(true, false, false);
            if (this.clientSearchResultPanel.getScrollPanel() != null) {
                this.clientSearchResultPanel.getScrollPanel().setVisible(false);
            }
        } else {
            this.clientSearchResultPanel.setClientLabelTextMax(false);
            this.clientSearchResultPanel.refresh("", "");
            if (this.clientSearchResultPanel.getScrollPanel() != null) {
                this.clientSearchResultPanel.getScrollPanel().setVisible(true);
            }
        }
    }

    private void initTable() {
        if (ScmProperties.isIpsOobFeatureEnabled()) {
            ClientComputersTablePanel.addColumn(2, "ClientComputersTablePanel.clientTechnologyView.IPS_OOB");
        }
        if (ScmProperties.isStarPulseFeatureEnabled()) {
            ClientComputersTablePanel.addColumn(2, "ClientComputersTablePanel.clientTechnologyView.URL_ONOFF");
        }
        ClientComputersTablePanel.addColumn(2, "ClientComputersTablePanel.clientTechnologyView.acStatus");
        ClientComputersTablePanel.addColumn(2, "ClientComputersTablePanel.clientTechnologyView.dcStatus");
        this.loadAdminPref();
        this.applyViewPrefToModel();
        this.clientSearchResultPanel = new ClientTableNavigationPanel(this, this.tableModel);
        this.clientSearchResultPanel.setCCTPPanelHandle(this);
        this.resultTable = this.clientSearchResultPanel.getTable();
        this.resultTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent ex) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent ex) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent ex) {
                ClientComputersTablePanel.this.setTableColumnCellRenderer();
            }

            @Override
            public void columnMarginChanged(ChangeEvent ex) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent ex) {
            }
        });
        this.clientSearchResultPanel.getRefreshHanlder().addObserver(new Observer(){

            @Override
            public void update(Observable client, Object obj) {
                ClientComputersTablePanel.this.applyColNameAndColSizePref();
                ClientComputersTablePanel.this.refreshSortIconToHeader(ClientComputersTablePanel.this.resultTable, ClientComputersTablePanel.this.tableModel);
            }
        });
        this.tableModel.addTableModelListener(this);
        this.resultTable.getTableHeader().addMouseListener(this);
        this.tableModel.addTableModelListener(this);
        this.sort();
        this.applyViewPrefToTable();
        this.applyColNameAndColSizePref();
    }

    static void addColumn(int table, String name) {
        String localizedName = MSGRES.getString(name);
        if (!Arrays.asList(COLS_NAMES[table]).contains(localizedName)) {
            int length = COLS_NAMES[table].length;
            ClientComputersTablePanel.COLS_NAMES[table] = Arrays.copyOf(COLS_NAMES[table], length + 1);
            ClientComputersTablePanel.COLS_NAMES[table][length] = localizedName;
        }
    }

    public String getViewName(int iv) {
        String name = VIEW_NAMES[0];
        if (iv < 0 || iv > 4) {
            return name;
        }
        return VIEW_NAMES[iv];
    }

    private void loadAdminPref() {
        this.adminObject = AdminObject.retrieveCurrentAdminObject();
        this.prefObject = this.adminObject.getAdminPreferenceObject();
        this.loadViewPref();
        this.loadColumnAndSizePref();
    }

    private void loadViewPref() {
        String preView = this.prefObject.getClientViewName();
        for (int i = 0; i < VIEW_NAMES.length; ++i) {
            if (!VIEW_NAMES[i].equals(preView)) continue;
            this.currentView = i;
            break;
        }
    }

    private void loadColumnAndSizePref() {
        String[] array = this.prefObject.getColumnAndSizeSequence(this.getViewName(this.currentView));
        this.savedColSizes = null;
        if (array[0] != null && array[0].length() > 0) {
            this.savedCols = array[0].split(COLUMN_SPLIT_COMMA);
        }
        if (array[1] != null && array[1].length() > 0) {
            this.savedColSizes = array[1].split(COLUMN_SPLIT_COMMA);
        }
    }

    private void saveViewPreference(int index) {
        this.currentView = index;
        this.prefObject.setClientViewName(this.getViewName(index));
        try {
            this.adminObject.update();
        }
        catch (ConsoleException ex) {
            ConsoleLogger.log(ex);
        }
    }

    public void saveColAndSizePreference() {
        String colString = this.generateColumnString();
        String sizeString = this.generateColumnSizeSequence();
        ConsoleLogger.log("Save View=[" + this.getViewName(this.currentView) + "],size=[" + sizeString + "]");
        boolean changed = this.prefObject.setColumnAndSizeSequence(this.getViewName(this.currentView), new String[]{colString, sizeString});
        if (changed) {
            this.savedCols = colString.split(COLUMN_SPLIT_COMMA);
            this.savedColSizes = sizeString.split(COLUMN_SPLIT_COMMA);
            try {
                this.adminObject.update();
            }
            catch (ConsoleException ex) {
                ConsoleLogger.log(ex);
            }
        }
    }

    private String generateColumnString() {
        int ic;
        StringBuffer colString = new StringBuffer("");
        int count = this.tableModel.getColumnCount();
        Map<String, String> currentName2KeyMap = this.getCurrentViewName2KeyMap();
        String currentColNameKey = null;
        for (ic = 0; ic < count - 1; ++ic) {
            currentColNameKey = currentName2KeyMap.get(this.resultTable.getColumnName(ic).trim());
            colString.append(currentColNameKey + COLUMN_SPLIT_COMMA);
        }
        currentColNameKey = currentName2KeyMap.get(this.resultTable.getColumnName(ic));
        colString.append(currentColNameKey);
        return colString.toString();
    }

    public void applyPrefColOrder() {
        int count = this.savedCols.length;
        for (int i = 0; i < count; ++i) {
            int modelIndex = this.getRealColumnIndex(this.savedCols[i]);
            if (modelIndex < 0 || modelIndex > count) {
                return;
            }
            if (i == modelIndex) continue;
            this.clientSearchResultPanel.getTable().moveColumn(modelIndex, i);
        }
    }

    private boolean validatePreferenceColumns() {
        boolean valid = false;
        String[] viewColumns = this.tableModel.getColumnNames();
        int count = this.tableModel.getColumnCount();
        String viewString = this.generateColumnString();
        if (count < 1 || viewColumns.length != this.savedCols.length) {
            valid = false;
        } else {
            for (int i = 0; i < count; ++i) {
                String tokenString = this.savedCols[i];
                if (viewString.indexOf(tokenString) >= 0) continue;
                valid = false;
                break;
            }
            valid = true;
        }
        return valid;
    }

    private void autoResizeColumns() {
        TableResizeUtil.autoResizeColumns(this.resultTable, this.savedColSizes, false);
        if (null == this.savedColSizes || this.savedColSizes.length == 0) {
            this.clientSearchResultPanel.getTable().getColumn(COLS_NAMES[0][0]).setPreferredWidth(140);
        }
    }

    private void applyColNameAndColSizePref() {
        if (this.savedCols != null && this.validatePreferenceColumns()) {
            this.applyPrefColOrder();
        }
        this.autoResizeColumns();
    }

    private void applyViewPrefToTable() {
        this.resultTable.setAutoResizeMode(0);
        this.clientSearchResultPanel.getScrollPanel().setHorizontalScrollBarPolicy(32);
        this.setTableColumnCellRenderer();
        this.setCellRenderToTable();
        this.clientSearchResultPanel.getTable().getSelectionModel().removeListSelectionListener(this);
        this.clientSearchResultPanel.getTable().getSelectionModel().addListSelectionListener(this);
        this.clientSearchResultPanel.allowPopupMenu(true);
        this.resultTable.setName(this.getViewName(this.currentView));
    }

    private void applyViewPrefToCombBox() {
        LicenseObject lic = LicenseObject.getInstance();
        if (lic.isSNACOnlyProduct() && this.currentView > 2) {
            this.choiceCombo.setSelectedIndex(this.currentView - 1);
        } else {
            this.choiceCombo.setSelectedIndex(this.currentView);
        }
    }

    private void setCellRenderToTable() {
        Enumeration<TableColumn> columns = this.clientSearchResultPanel.getTable().getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            Object valueObj = column.getHeaderValue();
            if (!(valueObj instanceof String)) continue;
            String value = (String)valueObj;
            if (MSGRES.getString("ClientComputersTablePanel.nameColHead.ee").equals(value.trim()) || MSGRES.getString("ClientComputersTablePanel.healthStateColHead").equals(value.trim())) {
                column.setCellRenderer(new JLabelCellRenderer());
                continue;
            }
            if (this.currentView == 1 && MSGRES.getString("ClientComputersTablePanel.clientStatusView.version").equals(value.trim())) {
                column.setCellRenderer(this.legacyClientCellRender);
                continue;
            }
            if (this.currentView == 4 && MSGRES.getString("ClientComputersTablePanel.clientSystemView.osType").equals(value.trim())) {
                column.setCellRenderer(this.legacyClientOsCellRender);
                continue;
            }
            if (this.currentView == 2 && MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.PEP").equals(value.trim())) {
                if (LicenseHandler.isPEPActivated()) continue;
                this.hideColumn(column);
                continue;
            }
            if (MSGRES.getString("ClientComputersTablePanel.clientStatusView.IP").equals(value.trim()) || MSGRES.getString("ClientComputersTablePanel.clientNetworkView.IP").equals(value.trim()) || MSGRES.getString("ClientComputersTablePanel.clientSystemView.IP").equals(value.trim()) || MSGRES.getString("ClientComputersTablePanel.clientNetworkView.DNS").equals(value.trim()) || MSGRES.getString("ClientComputersTablePanel.clientNetworkView.Gateway").equals(value.trim())) {
                column.setCellRenderer(this.ipv6ShorteningCellRenderer);
                continue;
            }
            if (MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.LB").equals(value.trim())) {
                if (CloudUtil.isCloudEnrolled(Manager.getCurrentDomainId())) continue;
                this.hideColumn(column);
                continue;
            }
            if (!MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.AMLAVDef").equals(value.trim()) || CloudUtil.isCloudEnrolled(Manager.getCurrentDomainId())) continue;
            this.hideColumn(column);
        }
    }

    private void hideColumn(TableColumn column) {
        ConsoleLogger.log("Hiding Column");
        column.setMaxWidth(0);
        column.setMinWidth(0);
        column.setPreferredWidth(0);
        column.setResizable(false);
        column.setWidth(0);
    }

    private void applyViewPrefToModel() {
        this.tableModel = this.getCustomTableModel(this.currentView);
        this.tableModel.setColumnNames(COLS_NAMES[this.currentView], true);
    }

    public void loadPreferenceModel() {
        int count = this.savedCols.length;
        for (int i = 0; i < count; ++i) {
            int modelIndex = this.getRealColumnIndex(this.savedCols[i]);
            if (modelIndex < 0 || modelIndex >= count) {
                return;
            }
            if (i == modelIndex) continue;
            try {
                this.clientSearchResultPanel.getTable().moveColumn(modelIndex, i);
                continue;
            }
            catch (Exception ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
        }
    }

    private void syncModel() {
        if (this.currentView > 0) {
            this.resultTable.setAutoResizeMode(0);
            this.clientSearchResultPanel.getScrollPanel().setHorizontalScrollBarPolicy(32);
            this.clientSearchResultPanel.allowPopupMenu(true);
            this.resultTable.setName(this.getViewName(this.currentView));
        } else {
            this.resultTable.setAutoResizeMode(0);
            this.clientSearchResultPanel.getScrollPanel().getHorizontalScrollBar().setVisible(false);
            this.clientSearchResultPanel.getPopupMenu().setEnabled(true);
            this.clientSearchResultPanel.allowPopupMenu(true);
        }
        this.setTableColumnCellRenderer();
        this.setCellRenderToTable();
        this.clientSearchResultPanel.getTable().getSelectionModel().removeListSelectionListener(this);
        this.clientSearchResultPanel.getTable().getSelectionModel().addListSelectionListener(this);
    }

    private Map<String, String> getCurrentViewName2KeyMap() {
        return COLS_NAMES_KEYS.get(this.currentView);
    }

    private int getRealColumnIndex(String colNameKey) {
        Map<String, String> currentName2KeyMap = this.getCurrentViewName2KeyMap();
        int count = this.savedCols.length;
        int retValue = -1;
        for (int i = 0; i < count; ++i) {
            String nameKey = currentName2KeyMap.get(this.resultTable.getColumnName(i).trim());
            if (nameKey == null) {
                nameKey = currentName2KeyMap.get(this.resultTable.getColumnName(i));
            }
            if (nameKey == null) {
                ConsoleLogger.logError("Did not find column nameKey for column name : [" + this.resultTable.getColumnName(i) + "]");
            }
            if (nameKey == null || !nameKey.equalsIgnoreCase(colNameKey)) continue;
            retValue = i;
            break;
        }
        return retValue;
    }

    @Override
    public void tableChanged(TableModelEvent excep) {
        this.clientSearchResultPanel.setClientLabelTextMax(false);
        if (this.clientSearchResultPanel.getScrollPanel() != null) {
            this.clientSearchResultPanel.getScrollPanel().setVisible(true);
        }
    }

    private void setTableColumnCellRenderer() {
        TableColumnModel columnModel = this.resultTable.getColumnModel();
        Enumeration<TableColumn> tableColumns = columnModel.getColumns();
        while (tableColumns.hasMoreElements()) {
            TableColumn tableColumn = tableColumns.nextElement();
            tableColumn.setCellRenderer(new JLabelCellRenderer());
            tableColumn.setCellEditor(null);
        }
    }

    private String[] getPlatformList() {
        ArrayList<String> osList = new ArrayList<String>();
        int allOs = AdminHandler.getCurrentSemAdminFilterShowPlatform(AdminHandler.getCurrentSemAdminFilter());
        boolean platformFilterAll = allOs == 2;
        boolean platformFilterWin = AdminHandler.getCurrentSemAdminFilterShowPlatformWin();
        boolean platformFilterMac = AdminHandler.getCurrentSemAdminFilterShowPlatformMac();
        boolean platformFilterLinux = AdminHandler.getCurrentSemAdminFilterShowPlatformLinux();
        if (platformFilterWin || platformFilterAll) {
            osList.add(MSGRES.getString("ClientComputersTablePanel.filterWindows"));
        }
        if (platformFilterMac || platformFilterAll) {
            osList.add(MSGRES.getString("ClientComputersTablePanel.filterMac"));
        }
        if (platformFilterLinux || platformFilterAll) {
            osList.add(MSGRES.getString("ClientComputersTablePanel.filterLinux"));
        }
        return osList.toArray(new String[osList.size()]);
    }

    public String getDisplayFilterText() {
        DisplayFilter filter = AdminHandler.getCurrentSemAdminFilter();
        int allOs = AdminHandler.getCurrentSemAdminFilterShowPlatform(filter);
        boolean platformFilterAll = allOs == 2;
        String displayFilterText = "";
        Object[] platformlist = this.getPlatformList();
        int accountTypeFilter = AdminHandler.getCurrentSemAdminFilterMode(filter);
        if (2 == accountTypeFilter) {
            if (platformFilterAll) {
                displayFilterText = MSGRES.getString("ClientComputersTablePanel.userAndComputer_filter");
            } else if (platformlist.length == 3) {
                displayFilterText = MSGRES.getString("ClientComputersTablePanel.threeOsUserAndComputer_filter");
                displayFilterText = MessageFormat.format(displayFilterText, platformlist);
            } else if (platformlist.length == 2) {
                displayFilterText = MSGRES.getString("ClientComputersTablePanel.twoOsUserAndComputer_filter");
                displayFilterText = MessageFormat.format(displayFilterText, platformlist);
            } else if (platformlist.length == 1) {
                displayFilterText = MSGRES.getString("ClientComputersTablePanel.oneOsUserAndComputer_filter");
                displayFilterText = MessageFormat.format(displayFilterText, platformlist);
            }
        } else if (1 == accountTypeFilter) {
            if (platformFilterAll) {
                displayFilterText = MSGRES.getString("ClientComputersTablePanel.all_selected_computer");
            } else if (platformlist.length == 3) {
                displayFilterText = MSGRES.getString("ClientComputersTablePanel.threeOS_filter_computer");
                displayFilterText = MessageFormat.format(displayFilterText, platformlist);
            } else if (platformlist.length == 2) {
                displayFilterText = MSGRES.getString("ClientComputersTablePanel.twoOS_filter_computer");
                displayFilterText = MessageFormat.format(displayFilterText, platformlist);
            } else if (platformlist.length == 1) {
                displayFilterText = MSGRES.getString("ClientComputersTablePanel.oneOS_filter_computer");
                displayFilterText = MessageFormat.format(displayFilterText, platformlist);
            }
        } else if (0 == accountTypeFilter) {
            if (platformFilterAll) {
                displayFilterText = MSGRES.getString("ClientComputersTablePanel.all_selected_user");
            } else if (platformlist.length == 3) {
                displayFilterText = MSGRES.getString("ClientComputersTablePanel.threeOs_filter_user");
                displayFilterText = MessageFormat.format(displayFilterText, platformlist);
            } else if (platformlist.length == 2) {
                displayFilterText = MSGRES.getString("ClientComputersTablePanel.twoOs_filter_user");
                displayFilterText = MessageFormat.format(displayFilterText, platformlist);
            } else if (platformlist.length == 1) {
                displayFilterText = MSGRES.getString("ClientComputersTablePanel.oneOs_filter_user");
                displayFilterText = MessageFormat.format(displayFilterText, platformlist);
            }
        }
        return displayFilterText;
    }

    private boolean containMultipleWindowsClientVersion(TableModel tm) {
        int clientNumber = 0;
        int legacyWinClientNumber = 0;
        if (tm instanceof ClientCustomTableModel) {
            ClientCustomTableModel cctm = (ClientCustomTableModel)tm;
            if (1 == this.currentView || 4 == this.currentView) {
                Vector<ClientObject> datas = cctm.data;
                for (ClientObject co : datas) {
                    if (!(co instanceof ClientStatusObject) && !(co instanceof ClientSystemObject) && !(co instanceof ClientSystemUserObject) && !(co instanceof ClientStatusUserObject)) continue;
                    if (this.isLegacyWindowsClientVersion(co)) {
                        ++legacyWinClientNumber;
                    } else {
                        ++clientNumber;
                    }
                    if (legacyWinClientNumber <= 0 || clientNumber <= 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isLegacyWindowsClientVersion(ClientObject co) {
        int iagenttype;
        UserObject csuo;
        String strAgentType = null;
        Long rostype = null;
        String servicePack = null;
        String operationSystem = null;
        if (co instanceof ClientStatusObject) {
            ClientStatusObject cto = (ClientStatusObject)co;
            strAgentType = cto.getAgent().getOptAgentType();
            rostype = cto.getAgent().getOptROsType();
            servicePack = cto.getClientOSSerivePack();
            operationSystem = cto.getClientOperationSystem();
        } else if (co instanceof ClientSystemObject) {
            ClientSystemObject cso = (ClientSystemObject)co;
            strAgentType = cso.getAgent().getOptAgentType();
            rostype = cso.getAgent().getOptROsType();
            servicePack = cso.getServicePack();
            operationSystem = cso.getEnglishOperatingSystemName();
        } else if (co instanceof ClientStatusUserObject) {
            csuo = (ClientStatusUserObject)co;
            strAgentType = ((ClientStatusUserObject)csuo).getAgent().getOptAgentType();
            rostype = ((ClientStatusUserObject)csuo).getAgent().getOptROsType();
            servicePack = ((ClientStatusUserObject)csuo).getClientOSSerivePack();
            operationSystem = ((ClientStatusUserObject)csuo).getClientOperationSystem();
        } else if (co instanceof ClientSystemUserObject) {
            csuo = (ClientSystemUserObject)co;
            strAgentType = ((ClientSystemUserObject)csuo).getAgent().getOptAgentType();
            rostype = ((ClientSystemUserObject)csuo).getAgent().getOptROsType();
            servicePack = ((ClientSystemUserObject)csuo).getServicePack();
            operationSystem = csuo.getEnglishOperatingSystemName();
        }
        if (!(StringUtilities.isEmpty((String)strAgentType) || (iagenttype = Integer.parseInt(strAgentType.trim())) != 300 && iagenttype != 301)) {
            return false;
        }
        return !AutoUpgradeUtils.isAgentOSVersionSupported((Long)rostype, operationSystem, (String)servicePack);
    }

    public int getCurrentView() {
        return this.currentView;
    }

    public void setCurrentView(int currentView) {
        this.currentView = currentView;
    }

    public JComboBox<String> getChoiceCombo() {
        return this.choiceCombo;
    }

    public void cleanUp() {
        this.group = null;
        this.clientSearchResultPanel.cleanUp();
        this.customModel.cleanUp();
    }

    static {
        MAP_DISPLAYNAME2KEY_DEFAULTVIEW.put(MSGRES.getString("ClientComputersTablePanel.nameColHead.ee"), "ClientComputersTablePanel.nameColHead.ee");
        MAP_DISPLAYNAME2KEY_DEFAULTVIEW.put(MSGRES.getString("ClientComputersTablePanel.healthStateColHead"), "ClientComputersTablePanel.healthStateColHead");
        MAP_DISPLAYNAME2KEY_DEFAULTVIEW.put(MSGRES.getString("ClientComputersTablePanel.userColHead.ee"), "ClientComputersTablePanel.userColHead.ee");
        MAP_DISPLAYNAME2KEY_DEFAULTVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientStatusView.lastCheckin"), "ClientComputersTablePanel.clientStatusView.lastCheckin");
        MAP_DISPLAYNAME2KEY_DEFAULTVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.virusDef"), "ClientComputersTablePanel.clientTechnologyView.virusDef");
        MAP_DISPLAYNAME2KEY_DEFAULTVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.AMLAVDef"), "ClientComputersTablePanel.clientTechnologyView.AMLAVDef");
        MAP_DISPLAYNAME2KEY_DEFAULTVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientStatusView.policySerial"), "ClientComputersTablePanel.clientStatusView.policySerial");
        MAP_DISPLAYNAME2KEY_DEFAULTVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.lastScan"), "ClientComputersTablePanel.clientTechnologyView.lastScan");
        MAP_DISPLAYNAME2KEY_DEFAULTVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.avStatus"), "ClientComputersTablePanel.clientTechnologyView.avStatus");
        MAP_DISPLAYNAME2KEY_DEFAULTVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.fwStatus"), "ClientComputersTablePanel.clientTechnologyView.fwStatus");
        MAP_DISPLAYNAME2KEY_DEFAULTVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.LB"), "ClientComputersTablePanel.clientTechnologyView.LB");
        MAP_DISPLAYNAME2KEY_DEFAULTVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientStatusView.rebootRequired"), "ClientComputersTablePanel.clientStatusView.rebootRequired");
        MAP_DISPLAYNAME2KEY_DEFAULTVIEW.put(MSGRES.getString("ClientComputersTablePanel.descriptionColHeader"), "ClientComputersTablePanel.descriptionColHeader");
        MAP_DISPLAYNAME2KEY_STATUSVIEW = new HashMap();
        MAP_DISPLAYNAME2KEY_STATUSVIEW.put(MSGRES.getString("ClientComputersTablePanel.nameColHead.ee"), "ClientComputersTablePanel.nameColHead.ee");
        MAP_DISPLAYNAME2KEY_STATUSVIEW.put(MSGRES.getString("ClientComputersTablePanel.healthStateColHead"), "ClientComputersTablePanel.healthStateColHead");
        MAP_DISPLAYNAME2KEY_STATUSVIEW.put(MSGRES.getString("ClientComputersTablePanel.userColHead.ee"), "ClientComputersTablePanel.userColHead.ee");
        MAP_DISPLAYNAME2KEY_STATUSVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientStatusView.IP"), "ClientComputersTablePanel.clientStatusView.IP");
        MAP_DISPLAYNAME2KEY_STATUSVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientStatusView.version"), "ClientComputersTablePanel.clientStatusView.version");
        MAP_DISPLAYNAME2KEY_STATUSVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientStatusView.lastCheckin"), "ClientComputersTablePanel.clientStatusView.lastCheckin");
        MAP_DISPLAYNAME2KEY_STATUSVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientStatusView.rebootRequired"), "ClientComputersTablePanel.clientStatusView.rebootRequired");
        MAP_DISPLAYNAME2KEY_STATUSVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientStatusView.policySerial"), "ClientComputersTablePanel.clientStatusView.policySerial");
        MAP_DISPLAYNAME2KEY_TECHNOLOGYVIEW = new HashMap();
        MAP_DISPLAYNAME2KEY_TECHNOLOGYVIEW.put(MSGRES.getString("ClientComputersTablePanel.nameColHead.ee"), "ClientComputersTablePanel.nameColHead.ee");
        MAP_DISPLAYNAME2KEY_TECHNOLOGYVIEW.put(MSGRES.getString("ClientComputersTablePanel.healthStateColHead"), "ClientComputersTablePanel.healthStateColHead");
        MAP_DISPLAYNAME2KEY_TECHNOLOGYVIEW.put(MSGRES.getString("ClientComputersTablePanel.userColHead.ee"), "ClientComputersTablePanel.userColHead.ee");
        MAP_DISPLAYNAME2KEY_TECHNOLOGYVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientStatusView.IP"), "ClientComputersTablePanel.clientStatusView.IP");
        MAP_DISPLAYNAME2KEY_TECHNOLOGYVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.lastScan"), "ClientComputersTablePanel.clientTechnologyView.lastScan");
        MAP_DISPLAYNAME2KEY_TECHNOLOGYVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.avStatus"), "ClientComputersTablePanel.clientTechnologyView.avStatus");
        MAP_DISPLAYNAME2KEY_TECHNOLOGYVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.fwStatus"), "ClientComputersTablePanel.clientTechnologyView.fwStatus");
        MAP_DISPLAYNAME2KEY_TECHNOLOGYVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.TruScanStatus"), "ClientComputersTablePanel.clientTechnologyView.TruScanStatus");
        MAP_DISPLAYNAME2KEY_TECHNOLOGYVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.Mr.Clean"), "ClientComputersTablePanel.clientTechnologyView.Mr.Clean");
        MAP_DISPLAYNAME2KEY_TECHNOLOGYVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.CIDS"), "ClientComputersTablePanel.clientTechnologyView.CIDS");
        MAP_DISPLAYNAME2KEY_TECHNOLOGYVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.CIDS.IE"), "ClientComputersTablePanel.clientTechnologyView.CIDS.IE");
        MAP_DISPLAYNAME2KEY_TECHNOLOGYVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.CIDS.FF"), "ClientComputersTablePanel.clientTechnologyView.CIDS.FF");
        MAP_DISPLAYNAME2KEY_TECHNOLOGYVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.CIDS.CHROME"), "ClientComputersTablePanel.clientTechnologyView.CIDS.CHROME");
        MAP_DISPLAYNAME2KEY_TECHNOLOGYVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.TP"), "ClientComputersTablePanel.clientTechnologyView.TP");
        MAP_DISPLAYNAME2KEY_TECHNOLOGYVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.virusDef"), "ClientComputersTablePanel.clientTechnologyView.virusDef");
        MAP_DISPLAYNAME2KEY_TECHNOLOGYVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.IPSDef"), "ClientComputersTablePanel.clientTechnologyView.IPSDef");
        MAP_DISPLAYNAME2KEY_TECHNOLOGYVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.MrCleanDef"), "ClientComputersTablePanel.clientTechnologyView.MrCleanDef");
        MAP_DISPLAYNAME2KEY_TECHNOLOGYVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.PTPDef"), "ClientComputersTablePanel.clientTechnologyView.PTPDef");
        MAP_DISPLAYNAME2KEY_TECHNOLOGYVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.AMLAVDef"), "ClientComputersTablePanel.clientTechnologyView.AMLAVDef");
        MAP_DISPLAYNAME2KEY_TECHNOLOGYVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.EDRDef"), "ClientComputersTablePanel.clientTechnologyView.EDRDef");
        MAP_DISPLAYNAME2KEY_TECHNOLOGYVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.WTRDef"), "ClientComputersTablePanel.clientTechnologyView.WTRDef");
        MAP_DISPLAYNAME2KEY_TECHNOLOGYVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.TDADDef"), "ClientComputersTablePanel.clientTechnologyView.TDADDef");
        MAP_DISPLAYNAME2KEY_TECHNOLOGYVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.ELAM"), "ClientComputersTablePanel.clientTechnologyView.ELAM");
        MAP_DISPLAYNAME2KEY_TECHNOLOGYVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.PEP"), "ClientComputersTablePanel.clientTechnologyView.PEP");
        MAP_DISPLAYNAME2KEY_TECHNOLOGYVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.LB"), "ClientComputersTablePanel.clientTechnologyView.LB");
        MAP_DISPLAYNAME2KEY_TECHNOLOGYVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.NTR"), "ClientComputersTablePanel.clientTechnologyView.NTR");
        MAP_DISPLAYNAME2KEY_TECHNOLOGYVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.TDAD"), "ClientComputersTablePanel.clientTechnologyView.TDAD");
        MAP_DISPLAYNAME2KEY_TECHNOLOGYVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.IPS_OOB"), "ClientComputersTablePanel.clientTechnologyView.IPS_OOB");
        MAP_DISPLAYNAME2KEY_TECHNOLOGYVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.URL_ONOFF"), "ClientComputersTablePanel.clientTechnologyView.URL_ONOFF");
        MAP_DISPLAYNAME2KEY_TECHNOLOGYVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.acStatus"), "ClientComputersTablePanel.clientTechnologyView.acStatus");
        MAP_DISPLAYNAME2KEY_TECHNOLOGYVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientTechnologyView.dcStatus"), "ClientComputersTablePanel.clientTechnologyView.dcStatus");
        MAP_DISPLAYNAME2KEY_NETWORKVIEW = new HashMap();
        MAP_DISPLAYNAME2KEY_NETWORKVIEW.put(MSGRES.getString("ClientComputersTablePanel.nameColHead.ee"), "ClientComputersTablePanel.nameColHead.ee");
        MAP_DISPLAYNAME2KEY_NETWORKVIEW.put(MSGRES.getString("ClientComputersTablePanel.healthStateColHead"), "ClientComputersTablePanel.healthStateColHead");
        MAP_DISPLAYNAME2KEY_NETWORKVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientNetworkView.DomainOrWorkgroup"), "ClientComputersTablePanel.clientNetworkView.DomainOrWorkgroup");
        MAP_DISPLAYNAME2KEY_NETWORKVIEW.put(MSGRES.getString("ClientComputersTablePanel.userColHead.ee"), "ClientComputersTablePanel.userColHead.ee");
        MAP_DISPLAYNAME2KEY_NETWORKVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientNetworkView.IP"), "ClientComputersTablePanel.clientNetworkView.IP");
        MAP_DISPLAYNAME2KEY_NETWORKVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientNetworkView.DNS"), "ClientComputersTablePanel.clientNetworkView.DNS");
        MAP_DISPLAYNAME2KEY_NETWORKVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientNetworkView.WINS"), "ClientComputersTablePanel.clientNetworkView.WINS");
        MAP_DISPLAYNAME2KEY_NETWORKVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientNetworkView.MAC"), "ClientComputersTablePanel.clientNetworkView.MAC");
        MAP_DISPLAYNAME2KEY_NETWORKVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientNetworkView.Gateway"), "ClientComputersTablePanel.clientNetworkView.Gateway");
        MAP_DISPLAYNAME2KEY_SYSTEMVIEW = new HashMap();
        MAP_DISPLAYNAME2KEY_SYSTEMVIEW.put(MSGRES.getString("ClientComputersTablePanel.nameColHead.ee"), "ClientComputersTablePanel.nameColHead.ee");
        MAP_DISPLAYNAME2KEY_SYSTEMVIEW.put(MSGRES.getString("ClientComputersTablePanel.healthStateColHead"), "ClientComputersTablePanel.healthStateColHead");
        MAP_DISPLAYNAME2KEY_SYSTEMVIEW.put(MSGRES.getString("ClientComputersTablePanel.userColHead.ee"), "ClientComputersTablePanel.userColHead.ee");
        MAP_DISPLAYNAME2KEY_SYSTEMVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientSystemView.IP"), "ClientComputersTablePanel.clientSystemView.IP");
        MAP_DISPLAYNAME2KEY_SYSTEMVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientSystemView.osType"), "ClientComputersTablePanel.clientSystemView.osType");
        MAP_DISPLAYNAME2KEY_SYSTEMVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientSystemView.servicePack"), "ClientComputersTablePanel.clientSystemView.servicePack");
        MAP_DISPLAYNAME2KEY_SYSTEMVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientSystemView.freeMemory"), "ClientComputersTablePanel.clientSystemView.freeMemory");
        MAP_DISPLAYNAME2KEY_SYSTEMVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientSystemView.freeDisk"), "ClientComputersTablePanel.clientSystemView.freeDisk");
        MAP_DISPLAYNAME2KEY_SYSTEMVIEW.put(MSGRES.getString("ClientComputersTablePanel.clientSystemView.totalDisk"), "ClientComputersTablePanel.clientSystemView.totalDisk");
        ArrayList<Map<String, String>> columnNamesKeys = new ArrayList<Map<String, String>>();
        columnNamesKeys.add(Collections.unmodifiableMap(MAP_DISPLAYNAME2KEY_DEFAULTVIEW));
        columnNamesKeys.add(Collections.unmodifiableMap(MAP_DISPLAYNAME2KEY_STATUSVIEW));
        columnNamesKeys.add(Collections.unmodifiableMap(MAP_DISPLAYNAME2KEY_TECHNOLOGYVIEW));
        columnNamesKeys.add(Collections.unmodifiableMap(MAP_DISPLAYNAME2KEY_NETWORKVIEW));
        columnNamesKeys.add(Collections.unmodifiableMap(MAP_DISPLAYNAME2KEY_SYSTEMVIEW));
        COLS_NAMES_KEYS = Collections.unmodifiableList(columnNamesKeys);
    }

    private class JLegacyClientVersionCellRender
    extends JLabel
    implements TableCellRenderer,
    TableModelListener {
        private static final long serialVersionUID = 1L;
        private boolean isMultipleClientVersion = false;

        private JLegacyClientVersionCellRender() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ClientObject co;
            ClientCustomTableModel cctm;
            TableRow rowData;
            this.setOpaque(true);
            this.setHorizontalTextPosition(10);
            if (value == null) {
                this.setText("");
                return this;
            }
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            if (value instanceof String) {
                this.setText((String)value);
            } else {
                this.setText("");
            }
            TableModel tm = table.getModel();
            if (tm instanceof ClientCustomTableModel && (rowData = (cctm = (ClientCustomTableModel)tm).getRow(row)) != null && ((co = (ClientObject)rowData) instanceof ClientStatusObject || co instanceof ClientSystemObject || co instanceof ClientSystemUserObject || co instanceof ClientStatusUserObject)) {
                ClientComputersTablePanel.this.isLegacyWindowsClientVersion(co);
            }
            this.setIcon(null);
            if (!"".equals(this.getText())) {
                this.setToolTipText(this.getText());
            }
            return this;
        }

        @Override
        public void tableChanged(TableModelEvent excep) {
            TableModel tm = (TableModel)excep.getSource();
            this.isMultipleClientVersion = ClientComputersTablePanel.this.containMultipleWindowsClientVersion(tm);
        }
    }

    public class SwitchRunnable
    implements Runnable {
        public SwitchRunnable(int viewIndex) {
            ClientComputersTablePanel.this.currentView = viewIndex;
        }

        @Override
        public void run() {
            try {
                ClientComputersTablePanel.this.getCustomTableModel(ClientComputersTablePanel.this.currentView).resumeModel2InitState();
                ClientComputersTablePanel.this.setCursor(Cursor.getPredefinedCursor(3));
                ClientComputersTablePanel.this.applyViewPrefToModel();
                ClientComputersTablePanel.this.applyViewPrefToTable();
                ClientComputersTablePanel.this.clientSearchResultPanel.refresh("", "");
                ClientComputersTablePanel.this.autoResizeColumns();
                ClientComputersTablePanel.this.syncModel();
                ClientComputersTablePanel.this.setCursor(Cursor.getPredefinedCursor(0));
            }
            catch (Throwable ex) {
                ClientComputersTablePanel.this.setCursor(Cursor.getPredefinedCursor(0));
                ConsoleLogger.log(ex);
            }
            finally {
                AjaxSwingManager.endOperation();
                AjaxSwingCommonUtil.updateSwingAgentBrowser((boolean)true);
            }
        }
    }
}

