/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.client;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.SoftwarePackageObject;
import com.sygate.scm.console.ui.client.PackageWorker;
import com.sygate.scm.console.ui.util.MultiLineMsgBox;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;

public abstract class AbstractExportPackageValidator {
    protected long pkg_size = 0L;
    protected long pkg_unzipped_size = 0L;
    protected long hbPkgSizeWithLatestContent = 0L;
    protected long lbPkgSizeWithLatestContent = 0L;
    protected long packageCoreSize = 0L;
    protected static final long ONE_MEGA_BYTE = 0x100000L;
    private SoftwarePackageObject packageObj;
    private List<SoftwarePackageObject> selectedPackageList;
    protected static final long EXTRA_MARGIN_SPACE_PER_PACKAGE = 0x500000L;

    protected AbstractExportPackageValidator(SoftwarePackageObject packageObj) {
        this.packageObj = packageObj;
        if (packageObj != null) {
            this.pkg_size = packageObj.getSize();
            this.pkg_unzipped_size = packageObj.getUnZippedSize();
            this.packageCoreSize = packageObj.getPkgSizeWithoutDefs();
        }
    }

    protected AbstractExportPackageValidator(List<SoftwarePackageObject> listPackageObj) {
        this.selectedPackageList = listPackageObj;
        if (listPackageObj != null) {
            for (SoftwarePackageObject packageObj : listPackageObj) {
                this.pkg_size += packageObj.getSize();
                this.pkg_unzipped_size += packageObj.getUnZippedSize();
                this.packageCoreSize += packageObj.getPkgSizeWithoutDefs().longValue();
            }
        }
    }

    public String getGroupPathFromFullPath(String dirName, String full) {
        String path = "";
        if (full == null || full.isEmpty() || dirName == null || dirName.isEmpty()) {
            return "";
        }
        path = full.substring(dirName.length());
        return path;
    }

    private void dispayValidationErrorMessage(String fullpath, int limitDir, int limitFull) {
        Object[] obj = new Object[]{Integer.toString(limitDir), Integer.toString(limitFull), fullpath};
        String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.pathCharacteresExceed0Msg");
        String fm = MessageFormat.format(str, obj);
        JOptionPane.showMessageDialog(Manager.getFrame(), fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.error"), 0);
    }

    private void dispayValidationWarningMessage(String fullpath, int limitFull) {
        Object[] obj = new Object[]{Integer.toString(limitFull), fullpath};
        String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.pathCharacteresExceed0WarnMsg");
        String fm = MessageFormat.format(str, obj);
        JOptionPane.showMessageDialog(Manager.getFrame(), fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.warning"), 2);
    }

    protected int getMaxSourceDirLength() {
        return 80;
    }

    protected int getMaxTargetDirLength() {
        return 240;
    }

    public boolean validateExportDir(String dirName, boolean isSingleExe, ArrayList<GroupObject> listGroups, int pkgContentOption, long hbPkgSizeWithLatestContent, long lbPkgSizeWithLatestContent, String osForExport) {
        this.hbPkgSizeWithLatestContent = hbPkgSizeWithLatestContent;
        this.lbPkgSizeWithLatestContent = lbPkgSizeWithLatestContent;
        return this.validateExportDir(dirName, isSingleExe, listGroups, pkgContentOption, osForExport);
    }

    public boolean validateExportDir(String dirName, boolean isSingleExe, ArrayList<GroupObject> listGroups, int pkgContentOption, String osForExport) {
        String dirPathName = dirName;
        int maxSourceDirLen = this.getMaxSourceDirLength();
        ArrayList<Object> listExportDirs = new ArrayList();
        if (this.selectedPackageList != null && this.selectedPackageList.size() > 0) {
            for (int i = 0; i < this.selectedPackageList.size(); ++i) {
                SoftwarePackageObject pkgObj = this.selectedPackageList.get(i);
                listExportDirs = PackageWorker.generateExportFullPathes(pkgObj, dirName, listGroups, osForExport);
                if (listExportDirs == null || listExportDirs.size() <= 0) continue;
                for (int j = 0; j < listExportDirs.size(); ++j) {
                    String fullPath = (String)listExportDirs.get(j);
                    if (!AjaxSwingCommonUtil.isAjaxSwingRunning() && dirPathName.length() > maxSourceDirLen) {
                        this.dispayValidationErrorMessage(fullPath, maxSourceDirLen, this.getMaxTargetDirLength());
                        return false;
                    }
                    if (fullPath.length() <= this.getMaxTargetDirLength()) continue;
                    this.dispayValidationWarningMessage(fullPath, this.getMaxTargetDirLength());
                }
            }
        } else {
            listExportDirs = PackageWorker.generateExportFullPathes(this.packageObj, dirName, listGroups, osForExport);
            if (listExportDirs != null && listExportDirs.size() > 0) {
                for (int j = 0; j < listExportDirs.size(); ++j) {
                    String fullPath = (String)listExportDirs.get(j);
                    if (!AjaxSwingCommonUtil.isAjaxSwingRunning() && dirPathName.length() > maxSourceDirLen) {
                        this.dispayValidationErrorMessage(fullPath, maxSourceDirLen, this.getMaxTargetDirLength());
                        return false;
                    }
                    if (fullPath.length() <= this.getMaxTargetDirLength()) continue;
                    this.dispayValidationWarningMessage(fullPath, this.getMaxTargetDirLength());
                }
            }
        }
        int result = 0;
        int groupCnt = listGroups == null || listGroups.size() == 0 ? 1 : listGroups.size();
        int hbGroupCnt = 0;
        int lbGroupCnt = 0;
        long target_size_required = this.calculateRequiredDiskSpaceOnTargetFolder(hbGroupCnt, lbGroupCnt, isSingleExe, pkgContentOption);
        long cache_size_required = this.calculateRequiredDiskSpaceOnCache(isSingleExe);
        long total_size_required = target_size_required + cache_size_required + 0x500000L * (long)groupCnt;
        System.out.println("Cache size required: " + cache_size_required + " target size required: " + target_size_required);
        int disk_cnt = 2;
        boolean bEnough_disk_target = true;
        boolean bEnough_disk_cache = true;
        try {
            disk_cnt = 1;
            result = SoftwarePackageObject.checkValidDirAndDiskSpace(dirName, false, total_size_required);
            if (result == -2) {
                bEnough_disk_target = false;
                bEnough_disk_cache = false;
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.error"), 0);
            LoggerUtilities.logException((Throwable)ex);
            return false;
        }
        if (result == -1) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.invalidExportDirectoryMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.error"), 0);
            return false;
        }
        if (result == -2) {
            String msg = null;
            String msg_html = null;
            if (disk_cnt == 1) {
                msg = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.noEnoughSpaceForExportingAndCacheOnSingleDisk"), total_size_required / 0x100000L + 1L);
            } else if (!bEnough_disk_target && !bEnough_disk_cache) {
                msg_html = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.noEnoughSpaceForExportingAndCacheOnTwoDisk"), cache_size_required / 0x100000L + 1L, target_size_required / 0x100000L + 1L);
            } else {
                msg = !bEnough_disk_target ? MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.noEnoughSpaceForExportingAndCacheOnSingleDisk"), target_size_required / 0x100000L + 1L) : MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.noEnoughSpaceForCacheOnSingleDisk"), cache_size_required / 0x100000L + 1L);
            }
            if (msg != null) {
                UIUtilities.showErrorDialog(msg);
            } else if (msg_html != null) {
                UIUtilities.showHTMLErrorDialog(Manager.getFrame(), msg_html);
            }
            return false;
        }
        if (result == 1) {
            if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                if (!new File(dirName).mkdirs()) {
                    return false;
                }
            } else {
                Object[] obj = new Object[]{dirName};
                String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.0DoesnotExistCreateItMsg");
                String fm = MessageFormat.format(str, obj);
                if (0 != MultiLineMsgBox.show(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.confirmation"), fm, 50, 3, 0)) {
                    return false;
                }
            }
        } else {
            for (int i = 0; i < listExportDirs.size(); ++i) {
                String dir = (String)listExportDirs.get(i);
                int validCode = PackageWorker.isValidDir(dir);
                if (validCode != 0 && validCode != 1) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.invalidExportDirectoryMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.error"), 0);
                    return false;
                }
                result = Utility.checkIfDirEmpty((String)dir);
                if (result <= 0) continue;
                Object[] obj = new Object[]{dir};
                String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.0IsNotEmptyDeleteAllMsg");
                String fm = MessageFormat.format(str, obj);
                if (0 != MultiLineMsgBox.show(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "PackageWorker.confirmation"), fm, 50, 3, 0)) {
                    return false;
                }
                Utility.emptyDir((String)dir, (boolean)false);
                System.out.println("PackageWorker>> validateExportDir: Deleted all of files and sub-dirs in the export dir=" + dir);
            }
        }
        return true;
    }

    protected abstract long calculateRequiredDiskSpaceOnCache(boolean var1);

    protected abstract long calculateRequiredDiskSpaceOnTargetFolder(int var1, int var2, boolean var3, int var4);
}

