/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.logicobject;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.ClientInstallationSettings;
import com.sygate.scm.common.configobject.schema.CommunicationOption;
import com.sygate.scm.common.configobject.schema.InstallationOption;
import com.sygate.scm.common.configobject.schema.RebootOptions;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.Utility;
import java.awt.Toolkit;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class ClientInstallationSettingObject
implements TableRow {
    private ClientInstallationSettings installSettings;
    private HashMap<Integer, ImageIcon> iconMap = new HashMap();
    private HashMap<Integer, String> platformMap = new HashMap();

    public ClientInstallationSettingObject() {
        this.installSettings = new ClientInstallationSettings();
        this.installSettings.setId(Utility.getGUIDString());
        InstallationOption installOptions = new InstallationOption();
        this.installSettings.setInstallationOption(installOptions);
        this.installSettings.setOptPlatform(ClientInstallationSettings.WINDOWS);
        installOptions.setKeepAllDataOnUpgrade(Boolean.TRUE);
        installOptions.setUserInterfaceLevel(InstallationOption.UNATTENDED);
        installOptions.setOptEnableInstallationLog(Boolean.TRUE);
        installOptions.setOptRestartOption(InstallationOption.DO_NOTHING);
        installOptions.setOptSpecifyReducedInstallSize(Boolean.FALSE);
        installOptions.setOptDarkNetwork(Boolean.FALSE);
        this.installSettings.setOptRefCount(Integer.valueOf(0));
        CommunicationOption com = new CommunicationOption();
        this.installSettings.setCommunicationOption(com);
        RebootOptions ro = new RebootOptions();
        this.installSettings.setOptRebootOptions(ro);
        this.initPlatformInfo();
    }

    public Integer getPlatform() {
        Integer ret = this.installSettings.getOptPlatform();
        return ret == null ? this.installSettings.getDefPlatform() : ret;
    }

    public void setPlatform(Integer platform) {
        this.installSettings.setOptPlatform(platform);
    }

    private JLabel getPlatformLabel() {
        JLabel label = new JLabel();
        label.setIcon(this.iconMap.get(this.getPlatform()));
        label.setText(this.platformMap.get(this.getPlatform()));
        return label;
    }

    private void initPlatformInfo() {
        this.iconMap.put(ClientInstallationSettings.WINDOWS, new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("windowsIcon.png"))));
        this.iconMap.put(ClientInstallationSettings.MAC, new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("appleIcon.png"))));
        this.platformMap.put(ClientInstallationSettings.WINDOWS, MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "ClientInstallationSettingObject.WindowsOsColumn"));
        this.platformMap.put(ClientInstallationSettings.MAC, MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "ClientInstallationSettingObject.MacOsColumn"));
    }

    public ClientInstallationSettingObject(ClientInstallationSettings s) {
        this.installSettings = s;
        this.initPlatformInfo();
    }

    @Override
    public Object getValueAt(int index) {
        switch (index) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this.getPlatformLabel();
            }
            case 2: {
                return this.getDescription();
            }
        }
        return "";
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        switch (index) {
            case 1: {
                return JLabel.class;
            }
        }
        return String.class;
    }

    @Override
    public void setValueAt(Object value, int index) {
    }

    public String getName() {
        return this.installSettings.getName();
    }

    public String getDescription() {
        String desc = this.installSettings.getOptDescription();
        return desc == null ? "" : desc;
    }

    public InstallationOption getInstallationOption() {
        return this.installSettings.getInstallationOption();
    }

    public CommunicationOption getCommunicationOption() {
        return this.installSettings.getCommunicationOption();
    }

    public void setInstallationOption(InstallationOption install) {
        this.installSettings.setInstallationOption(install);
    }

    public void setCommunicationOption(CommunicationOption com) {
        this.installSettings.setCommunicationOption(com);
    }

    public RebootOptions getOptRebootOptions() {
        RebootOptions ro = this.installSettings.getOptRebootOptions();
        return ro;
    }

    public void setOptRebootOptions(RebootOptions ro) {
        this.installSettings.setOptRebootOptions(ro);
    }

    public void setName(String name) {
        this.installSettings.setName(name);
    }

    public void setDescription(String desc) {
        this.installSettings.setOptDescription(desc);
    }

    public ClientInstallationSettings getClientInstallationSettings() {
        return this.installSettings;
    }

    public void setClientInstallationSetting(ClientInstallationSettings settings) {
        this.installSettings = settings;
    }

    public void incRefCount() {
        Integer ref = this.installSettings.getOptRefCount();
        ref = ref == null ? Integer.valueOf(1) : Integer.valueOf(ref + 1);
        this.installSettings.setOptRefCount(ref);
    }

    public void decRefCount() {
        Integer ref = this.installSettings.getOptRefCount();
        if (ref != null) {
            ref = ref <= 0 ? 0 : ref - 1;
            this.installSettings.setOptRefCount(ref);
        }
    }

    public Integer getRefCount() {
        return this.installSettings.getOptRefCount();
    }

    public ClientInstallationSettingObject getCopy() throws ConsoleException {
        ClientInstallationSettings newSetting = (ClientInstallationSettings)PolicyHandler.getCopyOfObj((ConfigObject)this.installSettings);
        ClientInstallationSettingObject newObj = new ClientInstallationSettingObject(newSetting);
        return newObj;
    }

    public String getId() {
        return this.installSettings.getId();
    }

    public boolean isSystemObject() {
        Long attr = this.installSettings.getOptObjAttributes();
        if (attr != null) {
            return attr.intValue() == 1;
        }
        return false;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object obj) {
        ClientInstallationSettingObject anotherCIS;
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof ClientInstallationSettingObject && (anotherCIS = (ClientInstallationSettingObject)obj).getId().equals(this.getId());
    }

    public int hashCode() {
        return super.hashCode();
    }
}

