/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.logicobject;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.ClientFeature;
import com.sygate.scm.common.configobject.schema.ClientInstallationFeatures;
import com.sygate.scm.common.configobject.schema.EnabledClientFeatures;
import com.sygate.scm.common.ui.ClientInstallFeatureSetUtility;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.PackageUtil;

public class ClientInstallationFeatureObject
implements TableRow {
    public static final String DEFAULT_VERSION = "14.3.4000.0";
    private String currentVersion = "14.3.4000.0";
    ClientInstallationFeatures _feature;

    public ClientInstallationFeatureObject() {
        this._feature = this.createSAVFeature(DEFAULT_VERSION);
    }

    public ClientInstallationFeatureObject(String version) {
        this._feature = this.createSAVFeature(version);
        this.currentVersion = version;
    }

    public ClientInstallationFeatureObject(ClientInstallationFeatures s) {
        this._feature = s;
    }

    public void incRefCount() {
        Integer ref = this._feature.getOptRefCount();
        ref = ref == null ? Integer.valueOf(1) : Integer.valueOf(ref + 1);
        this._feature.setOptRefCount(ref);
    }

    public void decRefCount() {
        Integer ref = this._feature.getOptRefCount();
        if (ref != null) {
            ref = ref <= 0 ? 0 : ref - 1;
            this._feature.setOptRefCount(ref);
        }
    }

    public void setCurrentVersion(String currentVersion) {
        this.currentVersion = currentVersion;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public EnabledClientFeatures getEnabledFeaturesByVersion(String version) {
        return PackageUtil.getEnabledFeaturesByVersion((ClientInstallationFeatures)this._feature, (String)version);
    }

    public EnabledClientFeatures getEnabledFeaturesByPackageVersion(String pkgVersion) {
        return PackageUtil.getEnabledFeaturesByPackageVersion((ClientInstallationFeatures)this._feature, (String)pkgVersion);
    }

    private ClientInstallationFeatures createSAVFeature(String version) {
        ClientInstallationFeatures newFeature = ClientInstallFeatureSetUtility.createNewFeatureSet();
        return newFeature;
    }

    private ClientFeature getClientFeature(String type) {
        EnabledClientFeatures eFeature = ClientInstallFeatureSetUtility.findFeatureVersionFromFeatureSet((String)this.getCurrentVersion(), (ClientInstallationFeatures)this._feature, (boolean)false);
        for (ClientFeature cFeature : eFeature.getClientFeature()) {
            if (!type.equals(cFeature.getFeatureName())) continue;
            return cFeature;
        }
        return null;
    }

    private void addFeature(ClientFeature feature) {
        EnabledClientFeatures enabledFeature = ClientInstallFeatureSetUtility.findFeatureVersionFromFeatureSet((String)this.getCurrentVersion(), (ClientInstallationFeatures)this._feature, (boolean)false);
        enabledFeature.addClientFeature(feature);
    }

    @Override
    public Object getValueAt(int index) {
        switch (index) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this.getDescription();
            }
        }
        return "";
    }

    public Class<String> getValueTypeAt(int index) {
        switch (index) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public void setValueAt(Object value, int index) {
    }

    public String getName() {
        return this._feature.getName();
    }

    public String getDescription() {
        String desc = this._feature.getOptDescription();
        return desc == null ? "" : desc;
    }

    public void setName(String name) {
        this._feature.setName(name);
    }

    public void setDescription(String desc) {
        this._feature.setOptDescription(desc);
    }

    public ClientInstallationFeatures getClientInstallationFeatures() {
        return this._feature;
    }

    public void setClientInstallationFeatures(ClientInstallationFeatures settings) {
        this._feature = settings;
    }

    public String getId() {
        return this._feature.getId();
    }

    public boolean hasFeature(String featureType) {
        ClientFeature feature = this.getClientFeature(featureType);
        return feature != null;
    }

    public boolean isFeatureEnabled(String featureType) {
        ClientFeature feature = this.getClientFeature(featureType);
        if (feature != null) {
            Boolean enabled = feature.getOptEnabled();
            if (enabled == null) {
                enabled = feature.getDefEnabled();
            }
            return enabled;
        }
        return false;
    }

    public void setFeature(String type, boolean enabled) {
        ClientFeature feature = this.getClientFeature(type);
        if (feature == null) {
            feature = new ClientFeature();
            feature.setFeatureName(type);
            this.addFeature(feature);
        }
        feature.setOptEnabled(Boolean.valueOf(enabled));
    }

    public ClientInstallationFeatureObject getCopy() throws ConsoleException {
        ClientInstallationFeatures newSetting = (ClientInstallationFeatures)PolicyHandler.getCopyOfObj((ConfigObject)this._feature);
        ClientInstallationFeatureObject newObj = new ClientInstallationFeatureObject(newSetting);
        return newObj;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isSystemObject() {
        Long attr = this._feature.getOptObjAttributes();
        if (attr != null) {
            return attr.intValue() == 1;
        }
        return false;
    }

    public static boolean hasCustomizedFeatures(int appType) {
        return appType == 105;
    }

    public static boolean isSupportedByPlatform(String packagePlatform) {
        return "WIN32BIT".equals(packagePlatform) || "WIN64BIT".equals(packagePlatform);
    }

    public boolean equals(Object obj) {
        ClientInstallationFeatureObject anotherCIF;
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof ClientInstallationFeatureObject && (anotherCIF = (ClientInstallationFeatureObject)obj).getId().equals(this.getId());
    }

    public int hashCode() {
        return super.hashCode();
    }
}

