/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.logicobject;

import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.ClientInstallationSettings;
import com.sygate.scm.common.configobject.schema.ClientInstallationSettingsPool;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.ObjectPool;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.admin.logicobject.ClientInstallationSettingObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ClientInstallPoolObject {
    ClientInstallationSettingsPool pool;
    SemDomain myDomain;

    public ClientInstallPoolObject() throws ConsoleException {
        this.initializeData();
    }

    public void addClientInstallationSettingObject(ClientInstallationSettingObject settingObj) throws ConsoleException {
        if (this.pool == null) {
            this.pool = new ClientInstallationSettingsPool();
            ObjectPool objPool = this.myDomain.getObjectPool();
            objPool.setOptClientInstallationSettingsPool(this.pool);
        }
        ClientInstallationSettings settings = settingObj.getClientInstallationSettings();
        ObjReference objRef = new ObjReference();
        objRef.setName("ClientInstallationSettings");
        objRef.setTargetType("ClientInstallationSettings");
        objRef.setTargetId(settings.getId());
        this.pool.addObjReference(objRef);
        ArrayList<DataobjectManager.UpdateObjectEntry> updateList = new ArrayList<DataobjectManager.UpdateObjectEntry>();
        DataobjectManager.UpdateObjectEntry entry = new DataobjectManager.UpdateObjectEntry((TopLevelObject)this.myDomain, 0);
        updateList.add(entry);
        entry = new DataobjectManager.UpdateObjectEntry((TopLevelObject)settings, 1);
        updateList.add(entry);
        Map<String, Object> resultTable = DataobjectManager.getInstance().updateObject("Merge", updateList);
        settingObj.setClientInstallationSetting((ClientInstallationSettings)resultTable.get(settings.getId()));
    }

    public void updateClientInstallationSetting(ClientInstallationSettingObject newSettingObj) throws ConsoleException {
        ClientInstallationSettings settings = newSettingObj.getClientInstallationSettings();
        ClientInstallationSettings newSettings = DataobjectManager.getInstance().updateClientInstallationSettings("Merge", settings);
        newSettingObj.setClientInstallationSetting(newSettings);
    }

    public void deleteClientInstallationSettings(ClientInstallationSettingObject settingObj) throws ConsoleException {
        ClientInstallationSettings settings = settingObj.getClientInstallationSettings();
        String curId = settingObj.getId();
        for (ObjReference objRef : this.pool.getObjReference()) {
            if (!objRef.getTargetId().equals(curId)) continue;
            this.pool.removeObjReference(objRef);
            break;
        }
        ArrayList<DataobjectManager.UpdateObjectEntry> updateList = new ArrayList<DataobjectManager.UpdateObjectEntry>();
        DataobjectManager.UpdateObjectEntry entry = new DataobjectManager.UpdateObjectEntry((TopLevelObject)this.myDomain, 0);
        updateList.add(entry);
        entry = new DataobjectManager.UpdateObjectEntry((TopLevelObject)settings, 2);
        updateList.add(entry);
        DataobjectManager.getInstance().updateObject("Merge", updateList);
    }

    private void initializeData() throws ConsoleException {
        DataobjectManager data = DataobjectManager.getInstance();
        this.myDomain = (SemDomain)data.getObjectByGUID("SemDomain", data.getLoginInformation().getOptDomainGUID());
        ObjectPool objPool = this.myDomain.getObjectPool();
        this.pool = objPool.getOptClientInstallationSettingsPool();
    }

    public List<ClientInstallationSettingObject> getAllObjects() throws ConsoleException {
        return this.getObjectsByPlatform(null);
    }

    public List<ClientInstallationSettingObject> getObjectsByPlatform(String softwarePackagePlatformStr) throws ConsoleException {
        ArrayList<ClientInstallationSettingObject> all = new ArrayList<ClientInstallationSettingObject>();
        if (this.pool != null) {
            DataobjectManager manager = DataobjectManager.getInstance();
            for (ObjReference objRef : this.pool.getObjReference()) {
                Boolean reduced;
                ClientInstallationSettings installSettings = manager.getClientInstallationSettings(objRef.getTargetId());
                if (softwarePackagePlatformStr != null) {
                    Integer platform = installSettings.getOptPlatform();
                    if (platform == null) {
                        platform = installSettings.getDefPlatform();
                    }
                    if (!platform.equals(ClientInstallPoolObject.getClientInstallPlatfform(softwarePackagePlatformStr))) continue;
                }
                if ((reduced = installSettings.getInstallationOption().getOptSpecifyReducedInstallSize()) != null && reduced.booleanValue() && LicenseObject.getInstance().isSNACOnlyProduct()) continue;
                ClientInstallationSettingObject sObj = new ClientInstallationSettingObject(installSettings);
                all.add(sObj);
            }
        }
        return all;
    }

    public static Integer getClientInstallPlatfform(String softwarePackagePlatformStr) throws ConsoleException {
        Integer retValue = null;
        if ("WIN32BIT".equals(softwarePackagePlatformStr) || "WIN64BIT".equals(softwarePackagePlatformStr)) {
            retValue = ClientInstallationSettings.WINDOWS;
        } else if ("Mac".equals(softwarePackagePlatformStr)) {
            retValue = ClientInstallationSettings.MAC;
        }
        return retValue;
    }

    public static List<String> getAllNames(String curId) throws ConsoleException {
        ArrayList<String> all = new ArrayList<String>();
        DataobjectManager data = DataobjectManager.getInstance();
        SemDomain domain = (SemDomain)data.getObjectByGUID("SemDomain", data.getLoginInformation().getOptDomainGUID());
        ObjectPool objPool = domain.getObjectPool();
        ClientInstallationSettingsPool cpool = objPool.getOptClientInstallationSettingsPool();
        if (cpool != null) {
            DataobjectManager manager = DataobjectManager.getInstance();
            for (ObjReference objRef : cpool.getObjReference()) {
                String targetId = objRef.getTargetId();
                if (curId.equals(targetId)) continue;
                ClientInstallationSettings installSettings = manager.getClientInstallationSettings(objRef.getTargetId());
                all.add(installSettings.getName());
            }
        }
        return all;
    }
}

