/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.logicobject;

import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.ClientInstallationFeatures;
import com.sygate.scm.common.configobject.schema.ClientInstallationFeaturesPool;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.ObjectPool;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.console.ui.admin.logicobject.ClientInstallationFeatureObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class ClientInstallFeaturePoolObject {
    ClientInstallationFeaturesPool pool;
    SemDomain myDomain;

    public ClientInstallFeaturePoolObject() throws ConsoleException {
        this.initializeData();
    }

    private void initializeData() throws ConsoleException {
        DataobjectManager data = DataobjectManager.getInstance();
        this.myDomain = (SemDomain)data.getObjectByGUID("SemDomain", data.getLoginInformation().getOptDomainGUID());
        ObjectPool objPool = this.myDomain.getObjectPool();
        this.pool = objPool.getOptClientInstallationFeaturesPool();
    }

    public void addClientInstallationSettingObject(ClientInstallationFeatureObject settingObj) throws ConsoleException {
        ObjReference objRef = null;
        try {
            if (this.pool == null) {
                this.pool = new ClientInstallationFeaturesPool();
                ObjectPool objPool = this.myDomain.getObjectPool();
                objPool.setOptClientInstallationFeaturesPool(this.pool);
            }
            ClientInstallationFeatures settings = settingObj.getClientInstallationFeatures();
            objRef = new ObjReference();
            objRef.setName("ClientInstallationFeatures");
            objRef.setTargetType("ClientInstallationFeatures");
            objRef.setTargetId(settings.getId());
            this.pool.addObjReference(objRef);
            ArrayList<DataobjectManager.UpdateObjectEntry> updateList = new ArrayList<DataobjectManager.UpdateObjectEntry>();
            DataobjectManager.UpdateObjectEntry entry = new DataobjectManager.UpdateObjectEntry((TopLevelObject)this.myDomain, 0);
            updateList.add(entry);
            entry = new DataobjectManager.UpdateObjectEntry((TopLevelObject)settings, 1);
            updateList.add(entry);
            Map<String, Object> resultTable = DataobjectManager.getInstance().updateObject("Merge", updateList);
            settingObj.setClientInstallationFeatures((ClientInstallationFeatures)resultTable.get(settings.getId()));
        }
        catch (ConsoleException ex) {
            if (objRef != null) {
                this.pool.removeObjReference(objRef);
            }
            throw ex;
        }
    }

    public void updateClientInstallationSetting(ClientInstallationFeatureObject newSettingObj) throws ConsoleException {
        ClientInstallationFeatures settings = newSettingObj.getClientInstallationFeatures();
        ClientInstallationFeatures newSettings = DataobjectManager.getInstance().updateClientInstallationFeatures("Merge", settings);
        newSettingObj.setClientInstallationFeatures(newSettings);
    }

    public void deleteClientInstallationFeatures(ClientInstallationFeatureObject settingObj) throws ConsoleException {
        ClientInstallationFeatures settings = settingObj.getClientInstallationFeatures();
        String curId = settingObj.getId();
        for (ObjReference objRef : this.pool.getObjReference()) {
            if (!objRef.getTargetId().equals(curId)) continue;
            this.pool.removeObjReference(objRef);
            break;
        }
        ArrayList<DataobjectManager.UpdateObjectEntry> updateList = new ArrayList<DataobjectManager.UpdateObjectEntry>();
        DataobjectManager.UpdateObjectEntry entry = new DataobjectManager.UpdateObjectEntry((TopLevelObject)this.myDomain, 0);
        updateList.add(entry);
        entry = new DataobjectManager.UpdateObjectEntry((TopLevelObject)settings, 2);
        updateList.add(entry);
        DataobjectManager.getInstance().updateObject("Merge", updateList);
    }

    public List<ClientInstallationFeatureObject> getAllObjects() throws ConsoleException {
        ArrayList<ClientInstallationFeatureObject> all = new ArrayList<ClientInstallationFeatureObject>();
        if (this.pool != null) {
            DataobjectManager manager = DataobjectManager.getInstance();
            Vector allRef = this.pool.getObjReference();
            if (allRef == null || allRef.size() < 1) {
                return null;
            }
            for (int i = 0; i < allRef.size(); ++i) {
                ObjReference objRef = (ObjReference)allRef.get(i);
                ClientInstallationFeatures installFeatures = manager.getClientInstallationFeatures(objRef.getTargetId());
                if (installFeatures.getEnabledClientFeatures().size() > 5) {
                    ClientInstallationFeatureObject sObj = new ClientInstallationFeatureObject(installFeatures);
                    all.add(sObj);
                    continue;
                }
                System.out.println("Hide Invalid Client Install Feature Set - " + installFeatures.getName() + "[id=" + installFeatures.getId() + "], it's feature version size is " + installFeatures.getEnabledClientFeatures().size());
            }
        }
        return all;
    }

    public ClientInstallationFeatureObject getFeatureByName(String featureSetName) {
        try {
            List<ClientInstallationFeatureObject> allFeatures = this.getAllObjects();
            for (ClientInstallationFeatureObject sObj : allFeatures) {
                if (!sObj.getName().equals(featureSetName)) continue;
                return sObj;
            }
        }
        catch (ConsoleException e) {
            ConsoleLogger.log(e);
        }
        return null;
    }

    public ClientInstallationFeatureObject getFirstDefaultFeatureObject() {
        try {
            List<ClientInstallationFeatureObject> allFeatures = this.getAllObjects();
            for (ClientInstallationFeatureObject sObj : allFeatures) {
                if (!sObj.isSystemObject()) continue;
                return sObj;
            }
        }
        catch (ConsoleException e) {
            ConsoleLogger.log(e);
        }
        return null;
    }

    public static List<String> getAllNames(String curId) throws ConsoleException {
        ArrayList<String> all = new ArrayList<String>();
        DataobjectManager data = DataobjectManager.getInstance();
        SemDomain domain = (SemDomain)data.getObjectByGUID("SemDomain", data.getLoginInformation().getOptDomainGUID());
        ObjectPool objPool = domain.getObjectPool();
        ClientInstallationFeaturesPool cpool = objPool.getOptClientInstallationFeaturesPool();
        if (cpool != null) {
            DataobjectManager manager = DataobjectManager.getInstance();
            for (ObjReference objRef : cpool.getObjReference()) {
                String targetId = objRef.getTargetId();
                if (curId.equals(targetId)) continue;
                ClientInstallationFeatures installSettings = manager.getClientInstallationFeatures(objRef.getTargetId());
                all.add(installSettings.getName());
            }
        }
        return all;
    }
}

