/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.iplLicense;

import com.creamtec.ajaxswing.support.FileOpener;
import com.creamtec.sepm.ajaxswing.support.ComponentUtils;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.logicobject.ElsLicenseObject;
import com.sygate.scm.console.ui.admin.iplLicense.IPLLicenseHandler;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseActivationWizardDialog;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseFileRow;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseFilesModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class UploadLicenseFilesPanel
extends JPanel
implements TableModelListener,
FileOpener {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String ADMINDIALOG = "com.sygate.scm.console.ui.admin.dlg.admindialog";
    private LicenseActivationWizardDialog parent = null;
    private final JLabel taInfoText = new JLabel(MSGRES.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "UploadLicenseFilesPanel.uploadNoLicenseFileDesc"));
    private final JLabel validityInfoText = new JLabel(" ");
    private HtmlEnabledJLabel jLblHelpLink = null;
    private HtmlEnabledJLabel jLblAddFileLink = null;
    private final JScrollPane jScrollPaneForLicenseFilesTable = new JScrollPane(20, 30);
    private final JTable jTableLicenseFiles = new StripesTable(false, false);
    private JPanel descPanel = null;
    private ArrayList<ElsLicenseObject> newLicenseXMLs = new ArrayList();
    private String lastSelectedPath = null;

    public UploadLicenseFilesPanel(LicenseActivationWizardDialog parent) {
        this.parent = parent;
        this.initPanel();
    }

    private void initPanel() {
        this.setLayout(new GridBagLayout());
        int row = -1;
        String title = MSGRES.getString(ADMINDIALOG, "UploadLicenseFilesPanel.uploadLicenseFile");
        JPanel headPanel = UIUtilities.getTopBannerWithLogo(title, "");
        this.add((Component)headPanel, new GridBagConstraints(0, ++row, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        LicenseFilesModel model = new LicenseFilesModel();
        this.jTableLicenseFiles.setModel(model);
        model.addMouseListenerToHeaderInTable(this.jTableLicenseFiles);
        model.addTableModelListener(this);
        this.initTableCellRender();
        this.addTableListener();
        UIUtilities.setTableColumnWidth(this.jTableLicenseFiles, new float[]{0.8f, 0.1f, 0.1f}, (int)this.jTableLicenseFiles.getPreferredScrollableViewportSize().getWidth());
        this.jTableLicenseFiles.setPreferredScrollableViewportSize(LicenseActivationWizardDialog.TABLE_DIMENSION);
        UiUtilities.setupScrollPane((JScrollPane)this.jScrollPaneForLicenseFilesTable, (JTable)this.jTableLicenseFiles);
        this.jScrollPaneForLicenseFilesTable.setMinimumSize(LicenseActivationWizardDialog.TABLE_DIMENSION);
        this.jScrollPaneForLicenseFilesTable.setMaximumSize(LicenseActivationWizardDialog.TABLE_DIMENSION);
        this.jScrollPaneForLicenseFilesTable.setPreferredSize(LicenseActivationWizardDialog.TABLE_DIMENSION);
        this.jLblHelpLink = IPLLicenseHandler.getslfFileHelpLabel();
        this.descPanel = new JPanel(new BorderLayout());
        this.descPanel.add((Component)this.taInfoText, "West");
        this.descPanel.add((Component)this.jLblHelpLink, "East");
        this.add((Component)this.descPanel, new GridBagConstraints(0, ++row, 1, 1, 1.0, 0.0, 17, 2, new Insets(8, 25, 10, 25), 0, 0));
        this.add((Component)this.jScrollPaneForLicenseFilesTable, new GridBagConstraints(0, ++row, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 10, 10, 10), 0, 0));
        this.jLblAddFileLink = new HtmlEnabledJLabel(MSGRES.getString(ADMINDIALOG, "UploadLicenseFilesPanel.addFile"), true);
        this.jLblAddFileLink.setBorder(BorderFactory.createEmptyBorder());
        this.jLblAddFileLink.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                UploadLicenseFilesPanel.this.openFileChooser();
            }
        });
        AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> ComponentUtils.setFileOpener((JComponent)this.jLblAddFileLink, (FileOpener)this));
        this.add((Component)this.jLblAddFileLink, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 25, 10, 50), 0, 0));
        this.add((Component)this.validityInfoText, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 25, 10, 50), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, ++row, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void initTableCellRender() {
        TableColumn statusColumn = this.jTableLicenseFiles.getColumnModel().getColumn(2);
        RemoveFileRenderer render = new RemoveFileRenderer(this.jTableLicenseFiles);
        render.setHorizontalAlignment(0);
        render.setHorizontalTextPosition(0);
        statusColumn.setCellRenderer(render);
        TableColumn licensecountColumn = this.jTableLicenseFiles.getColumnModel().getColumn(1);
        DefaultTableCellRenderer lcrender = new DefaultTableCellRenderer();
        lcrender.setHorizontalAlignment(2);
        lcrender.setHorizontalTextPosition(2);
        licensecountColumn.setCellRenderer(lcrender);
    }

    private void addTableListener() {
        this.jTableLicenseFiles.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Object obj;
                if (UploadLicenseFilesPanel.this.jTableLicenseFiles.getSelectedColumn() == 2 && (obj = UploadLicenseFilesPanel.this.jTableLicenseFiles.getValueAt(UploadLicenseFilesPanel.this.jTableLicenseFiles.getSelectedRow(), UploadLicenseFilesPanel.this.jTableLicenseFiles.getSelectedColumn())) != null) {
                    File file = (File)obj;
                    int result = JOptionPane.showConfirmDialog(UploadLicenseFilesPanel.this.parent, MSGRES.getString(UploadLicenseFilesPanel.ADMINDIALOG, "UploadLicenseFilesPanel.removeFileConfirm"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "UIUtilities.warning"), 2, 2);
                    if (result == 0) {
                        UploadLicenseFilesPanel.this.getLicenseFilesModel().removeLicenseFile(file);
                    }
                }
            }
        });
    }

    @Override
    public void tableChanged(TableModelEvent event) {
        LicenseFilesModel model;
        if ((event.getType() == 1 || event.getType() == -1) && (model = this.getLicenseFilesModel()) != null) {
            int totalLicenseNum = model.getRowCount();
            if (totalLicenseNum == 1) {
                this.taInfoText.setText(MSGRES.getString(ADMINDIALOG, "UploadLicenseFilesPanle.uploadOneLicenseFileDesc"));
            } else if (totalLicenseNum > 1) {
                String desc = MSGRES.getString(ADMINDIALOG, "UploadLicenseFilesPanle.uploadMultipleLicenseFileDesc");
                desc = MessageFormat.format(desc, String.valueOf(totalLicenseNum));
                this.taInfoText.setText(desc);
            } else {
                this.taInfoText.setText(MSGRES.getString(ADMINDIALOG, "UploadLicenseFilesPanel.uploadNoLicenseFileDesc"));
            }
            int counter = 0;
            for (int j = 0; j < model.getColumnCount(); ++j) {
                if (!model.getColumnName(j).equals(LicenseFilesModel.COLUMNNAMES[1])) continue;
                for (int i = 0; i < model.getRowCount(); ++i) {
                    counter += ((Integer)model.getValueAt(i, j)).intValue();
                }
                this.parent.getjBNext().setEnabled(counter > 0);
                break;
            }
        }
    }

    protected LicenseFilesModel getLicenseFilesModel() {
        return (LicenseFilesModel)this.jTableLicenseFiles.getModel();
    }

    public int getElsLicenseCount() {
        return this.getLicenseFilesModel().getAllElsLicenses().size();
    }

    private void openFileChooser() {
        int dlgResult;
        JFileChooser fileDlg = new JFileChooser();
        fileDlg.setDialogTitle(MSGRES.getString(ADMINDIALOG, "UploadLicenseFilesPanel.addFileDialogTitle"));
        FileFilter slicFilter = new FileFilter(){

            @Override
            public String getDescription() {
                return MSGRES.getString(UploadLicenseFilesPanel.ADMINDIALOG, "UploadLicenseFilesPanel.fileFilterSlic");
            }

            @Override
            public boolean accept(File f) {
                if (f.getName().endsWith(".slf")) {
                    return true;
                }
                return f.isDirectory();
            }
        };
        fileDlg.addChoosableFileFilter(slicFilter);
        fileDlg.setAcceptAllFileFilterUsed(true);
        fileDlg.setFileFilter(slicFilter);
        fileDlg.setMultiSelectionEnabled(true);
        if (this.lastSelectedPath != null) {
            fileDlg.setCurrentDirectory(new File(this.lastSelectedPath));
        }
        if ((dlgResult = fileDlg.showDialog(this, MSGRES.getString(ADMINDIALOG, "UploadLicenseFilesPanel.addFileDialogTitle"))) != 0) {
            return;
        }
        this.addLicenseFile(fileDlg.getSelectedFiles());
        this.lastSelectedPath = fileDlg.getSelectedFile().getParent();
    }

    private void addLicenseFile(File[] files) {
        boolean added = false;
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].exists()) continue;
                try {
                    this.getLicenseFilesModel().addLicenseFile(files[i]);
                    added = true;
                    continue;
                }
                catch (LicenseFileRow.LicenseImportConsoleException e) {
                    JOptionPane.showMessageDialog(null, IPLLicenseHandler.getHyperLinkEditorPane(e.getMessage(), "", true, 290), MSGRES.getString(ADMINDIALOG, "IPLLicenseHandler.error"), 0);
                }
            }
        }
        if (added) {
            ArrayList<ElsLicenseObject> data = this.getLicenseFilesModel().getAllElsLicenses();
            if (data == null || data.size() == 0) {
                this.validityInfoText.setText(MSGRES.getString(ADMINDIALOG, "UploadLicenseFilesPanel.importFileEmpty"));
            } else {
                this.validityInfoText.setText(" ");
            }
        }
    }

    public void openFile(File file) {
        ConsoleLogger.log("file = " + file);
        if (file != null) {
            this.addLicenseFile(new File[]{file});
        } else {
            ConsoleLogger.log("File object returned from browser (AjaxSwing mode) is null.");
        }
    }

    public boolean isValidated() {
        if (this.getLicenseFilesModel().getAllLicenseFiles() == null || this.getLicenseFilesModel().getAllLicenseFiles().size() == 0) {
            UIUtilities.showErrorDialog(MSGRES.getString(ADMINDIALOG, "UploadLicenseFilesPanel.noLicenseFileUploaded"));
            return false;
        }
        ArrayList<ElsLicenseObject> data = this.getLicenseFilesModel().getAllElsLicenses();
        if (data == null || data.size() == 0) {
            this.validityInfoText.setText(MSGRES.getString(ADMINDIALOG, "UploadLicenseFilesPanel.importFileEmpty"));
            return false;
        }
        this.validityInfoText.setText(" ");
        this.setNewLicenseXMLs(data);
        return true;
    }

    public void disposeUI() {
    }

    public void setNewLicenseXMLs(ArrayList<ElsLicenseObject> data) {
        this.newLicenseXMLs = data;
    }

    public ArrayList<ElsLicenseObject> getNewLicenseXMLs() {
        return this.newLicenseXMLs;
    }

    public class RemoveFileRenderer
    extends HtmlEnabledJLabel
    implements TableCellRenderer,
    MouseInputListener {
        private static final long serialVersionUID = 1L;
        private int highlightR = -1;
        private int highlightC = -1;

        public RemoveFileRenderer(JTable table) {
            table.addMouseListener(this);
            table.addMouseMotionListener(this);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            this.setLink(true);
            if (row == this.highlightR && column == this.highlightC) {
                this.highlightLink();
            } else {
                this.unhighlightLink();
            }
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.setText(MSGRES.getString(UploadLicenseFilesPanel.ADMINDIALOG, "UploadLicenseFilesPanel.removeFile"));
            return this;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.highlightR = -1;
            this.highlightC = -1;
            UploadLicenseFilesPanel.this.jTableLicenseFiles.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            JTable target = (JTable)e.getSource();
            Point p = new Point(e.getX(), e.getY());
            int col = target.columnAtPoint(p);
            int row = target.rowAtPoint(p);
            if (2 == col) {
                Rectangle rec = target.getCellRect(row, col, false);
                int x = rec.x + rec.width;
                if (e.getPoint().x <= x) {
                    this.highlightR = row;
                    this.highlightC = col;
                    UploadLicenseFilesPanel.this.jTableLicenseFiles.setCursor(Cursor.getPredefinedCursor(12));
                }
                UploadLicenseFilesPanel.this.jTableLicenseFiles.repaint();
            } else if (this.highlightR != -1 || this.highlightC != -1) {
                this.highlightR = -1;
                this.highlightC = -1;
                UploadLicenseFilesPanel.this.jTableLicenseFiles.repaint();
            }
        }
    }
}

