/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.iplLicense;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.ui.admin.iplLicense.IPLLicenseHandler;
import com.sygate.scm.console.util.ConsoleLogger;
import com.symantec.slic.ipl.InputValidator;
import com.symantec.slic.ipl.SerialNumberError;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class SerialNumberInputPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String ADMINDIALOG = "com.sygate.scm.console.ui.admin.dlg.admindialog";
    private JEditorPane inputBoxErrorEditorPane = new JEditorPane();
    protected JTextField inputJTextField = new JTextField();
    protected int hasError = 0;
    private boolean isClearable = false;
    private Border defaultBorder = null;

    public SerialNumberInputPanel() {
        this.initialize();
        this.getInputBoxErrorEditorPane().setContentType("text/html");
        this.getInputBoxErrorEditorPane().setEditable(false);
        this.getInputBoxErrorEditorPane().setOpaque(false);
        this.getInputBoxErrorEditorPane().addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    HelpUtil.showURL(e);
                }
            }
        });
    }

    private final void initialize() {
        this.setLayout(new GridBagLayout());
        this.defaultBorder = this.getJTextField().getBorder();
        this.add((Component)this.inputJTextField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.getInputBoxErrorEditorPane(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 0, 5, 0), 0, 0));
        this.getInputBoxErrorEditorPane().setVisible(false);
        this.inputJTextField.setPreferredSize(new Dimension(250, this.inputJTextField.getPreferredSize().height));
        this.inputJTextField.addFocusListener(new SerialNoInputBoxFocusListener());
        this.inputJTextField.getAccessibleContext().setAccessibleName(MSGRES.getString(ADMINDIALOG, "SerialNumberEntryPanel.description"));
    }

    protected JTextField getJTextField() {
        return this.inputJTextField;
    }

    protected String getInputText() {
        return this.inputJTextField.getText().trim();
    }

    protected void setInputText(String str) {
        this.inputJTextField.setText(str);
    }

    protected void setPanelFont(Font font) {
        this.getInputBoxErrorEditorPane().setFont(font);
        this.inputJTextField.setFont(font);
    }

    protected void reset() {
        if (this.isClearable) {
            this.setInputBoxErrorLabelInfo(false, null);
        }
    }

    protected void setInputBoxErrorLabelInfo(boolean isVisible, String textStr) {
        this.setInputBoxErrorLabelInfo(isVisible, textStr, false);
    }

    protected void setInputBoxErrorLabelInfo(boolean isVisible, String textStr, boolean isClearable) {
        this.isClearable = isClearable;
        if (isVisible) {
            String hyperLinkText = IPLLicenseHandler.getHTMLTextInRed(textStr);
            this.getInputBoxErrorEditorPane().setText(hyperLinkText);
            Dimension dim = IPLLicenseHandler.getPreferredSize(new JLabel(), hyperLinkText, true, 250);
            this.getInputBoxErrorEditorPane().setPreferredSize(new Dimension(dim.width, dim.height + 3));
            this.getJTextField().setBorder(BorderFactory.createLineBorder(Color.RED, 1));
            this.getInputBoxErrorEditorPane().setVisible(isVisible);
            this.hasError = 1;
        } else {
            this.getInputBoxErrorEditorPane().setVisible(isVisible);
            this.getInputBoxErrorEditorPane().setText(null);
            this.getJTextField().setBorder(this.defaultBorder);
            this.hasError = 0;
        }
    }

    protected JEditorPane getInputBoxErrorEditorPane() {
        return this.inputBoxErrorEditorPane;
    }

    protected void setInputBoxErrorEditorPane(JEditorPane tempPane) {
        this.inputBoxErrorEditorPane = tempPane;
    }

    private class SerialNoInputBoxFocusListener
    implements FocusListener {
        private SerialNoInputBoxFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent evt) {
            String serialNumberStr = SerialNumberInputPanel.this.getInputText();
            SerialNumberError serialNumberError = InputValidator.validateSerialNumber((String)serialNumberStr);
            String msg = IPLLicenseHandler.processSerialNumberError(serialNumberError, true);
            if (msg == null) {
                SerialNumberInputPanel.this.setInputBoxErrorLabelInfo(false, null);
            } else {
                SerialNumberInputPanel.this.setInputBoxErrorLabelInfo(true, msg);
                ConsoleLogger.log(msg);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }
    }
}

