/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.iplLicense;

import com.sygate.scm.common.configobject.rpc.IPLFulfillmentError;
import com.sygate.scm.common.configobject.rpc.IPLSerialNumberError;
import com.sygate.scm.common.configobject.rpc.IPLSerialNumbersWithError;
import com.sygate.scm.common.configobject.rpc.IPLUserInputError;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.license.LicenseUtils;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.console.ui.admin.iplLicense.IPLLicenseHandler;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseActivationWizardDialog;
import com.sygate.scm.console.ui.admin.iplLicense.SerialNumberInputPanel;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleLogger;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SerialNumberEntryPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String ADMINDIALOG = "com.sygate.scm.console.ui.admin.dlg.admindialog";
    private LicenseActivationWizardDialog parent = null;
    private List<SerialNumberInputPanel> serialNumberPanelList = new LinkedList<SerialNumberInputPanel>();
    private JPanel licensePanel = new JPanel(new GridBagLayout());
    private HtmlEnabledJLabel addMoreInputBoxButton = null;
    private Set<String> serialNumbers = new HashSet<String>();
    private Set<String> duplicatedSerialNumbers = new HashSet<String>();
    private static final DescriptionTextArea DESC = new DescriptionTextArea(MSGRES.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "SerialNumberEntryPanel.description"));
    private int yIndex = 0;
    private static final int MAXSNENTER = 10;

    public SerialNumberEntryPanel(LicenseActivationWizardDialog parent) {
        this.parent = parent;
        this.initPanel();
    }

    private void initPanel() {
        String title = null;
        title = this.parent.isRenewalFlow() ? MSGRES.getString(ADMINDIALOG, "SerialNumberEntryPanel.renewalTitle") : MSGRES.getString(ADMINDIALOG, "SerialNumberEntryPanel.title");
        JPanel headPanel = UIUtilities.getTopBannerWithLogo(title, "");
        this.addMoreInputBoxButton = new HtmlEnabledJLabel(MSGRES.getString(ADMINDIALOG, "SerialNumberEntryPanel.addMoreSerialNumber"), true);
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SerialNumberEntryPanel.this.addMoreLicenseInputbox();
                SerialNumberEntryPanel.this.revalidate();
            }
        };
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                SerialNumberEntryPanel.this.addMoreLicenseInputbox();
                SerialNumberEntryPanel.this.revalidate();
            }
        };
        this.addMoreInputBoxButton.addMouseListener((MouseListener)mouseListener);
        this.addMoreInputBoxButton.addKeyListener(keyListener);
        DESC.setMargin(new Insets(0, 5, 0, 5));
        this.setLayout(new GridBagLayout());
        this.addMoreLicenseInputbox();
        this.add((Component)headPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel snPanel = new JPanel(new GridBagLayout());
        snPanel.add((Component)DESC, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(8, 25, 10, 25), 0, 0));
        snPanel.add((Component)this.licensePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(15, 40, 0, 25), 0, 0));
        snPanel.add((Component)this.addMoreInputBoxButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 0, new Insets(10, 110, 0, 25), 0, 0));
        snPanel.add(Box.createGlue(), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        JScrollPane infoPane = new JScrollPane(snPanel, 20, 30);
        infoPane.setPreferredSize(LicenseActivationWizardDialog.SCROLL_PANE_DIMENSION);
        infoPane.setMinimumSize(LicenseActivationWizardDialog.SCROLL_PANE_DIMENSION);
        infoPane.setBorder(null);
        this.add((Component)infoPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void addMoreLicenseInputbox() {
        SerialNumberInputPanel snInputPanel = new SerialNumberInputPanel();
        this.licensePanel.add((Component)snInputPanel, new GridBagConstraints(0, this.yIndex, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.serialNumberPanelList.add(snInputPanel);
        if (this.serialNumberPanelList.size() >= 10) {
            this.addMoreInputBoxButton.setVisible(false);
        }
        ++this.yIndex;
    }

    public void setLicenseBoxFocus() {
        this.serialNumberPanelList.get(0).getJTextField().requestFocusInWindow();
    }

    protected void setLicenseBoxError(Set<String> serialNumber, String errorMessage) {
        this.setLicenseBoxError(serialNumber, errorMessage, false);
    }

    protected void setLicenseBoxError(Set<String> serialNumber, String errorMessage, boolean isClearable) {
        for (String str : serialNumber) {
            for (SerialNumberInputPanel serialNumberPanel : this.serialNumberPanelList) {
                if (!serialNumberPanel.getInputText().equalsIgnoreCase(str)) continue;
                serialNumberPanel.setInputBoxErrorLabelInfo(true, errorMessage, isClearable);
                ConsoleLogger.log(str + ": " + errorMessage);
            }
        }
    }

    protected void setLicenseEntryPanelIPLFulfillmentError(IPLFulfillmentError iPLFulfillmentError) {
        Object msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.adminIPLdialog", iPLFulfillmentError.getOptErrorMessageToken());
        boolean isPopup = false;
        if (iPLFulfillmentError.getOptReason().intValue() == LicenseUtils.IPL_FULFILLMENT_ERROR_REASON.SERVER_INTERNAL_ERROR.getValue() || iPLFulfillmentError.getOptReason().intValue() == LicenseUtils.IPL_FULFILLMENT_ERROR_REASON.BLOCKED_BY_TRADE_COMPLIANCE.getValue()) {
            isPopup = true;
        }
        if (iPLFulfillmentError.getOptErrorCode() != null) {
            msg = (String)msg + "<BR>" + MSGRES.getString(ADMINDIALOG, "ErrorCode") + " (" + iPLFulfillmentError.getOptErrorCode() + ")";
        }
        if (isPopup) {
            JOptionPane.showMessageDialog(this.parent, IPLLicenseHandler.getHyperLinkEditorPane((String)msg, "", true, 290), MSGRES.getString(ADMINDIALOG, "SerialNumberEntryPanel.errorTitle"), 0);
            ConsoleLogger.log((String)msg);
        } else {
            HashSet<String> tmpSerialNumberSet = new HashSet<String>();
            if (iPLFulfillmentError.getIPLSerialNumbersWithError() != null) {
                Vector iPLSerialNumbersWithErrorVector = iPLFulfillmentError.getIPLSerialNumbersWithError();
                for (IPLSerialNumbersWithError iPLSerialNumbersWithError : iPLSerialNumbersWithErrorVector) {
                    String tmpSerialNumber = iPLSerialNumbersWithError.getOptIPLSerialNumbersWithError();
                    tmpSerialNumberSet.add(tmpSerialNumber);
                }
            }
            this.setLicenseBoxError(tmpSerialNumberSet, (String)msg);
        }
    }

    protected void setLicenseEntryPanelIPLSerialNumberError(IPLUserInputError iPLUserInputError) {
        IPLSerialNumberError iPLSerialNumberError = iPLUserInputError.getOptIPLSerialNumberError();
        Object msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.adminIPLdialog", iPLSerialNumberError.getOptErrorMessageToken());
        if (iPLSerialNumberError.getOptErrorCode() != null) {
            msg = (String)msg + "<BR>" + MSGRES.getString(ADMINDIALOG, "ErrorCode") + " (" + iPLSerialNumberError.getOptErrorCode() + ")";
        }
        HashSet<String> tmpSerialNumberSet = new HashSet<String>();
        if (iPLUserInputError.getIPLSerialNumbersWithError() != null) {
            Vector iPLSerialNumbersWithErrorVector = iPLUserInputError.getIPLSerialNumbersWithError();
            for (IPLSerialNumbersWithError iPLSerialNumbersWithError : iPLSerialNumbersWithErrorVector) {
                String tmpSerialNumber = iPLSerialNumbersWithError.getOptIPLSerialNumbersWithError();
                tmpSerialNumberSet.add(tmpSerialNumber);
            }
        }
        this.setLicenseBoxError(tmpSerialNumberSet, (String)msg);
    }

    public boolean isValidated() {
        String msg;
        boolean isValidated = true;
        for (SerialNumberInputPanel serialNumberPanel : this.serialNumberPanelList) {
            serialNumberPanel.reset();
        }
        for (SerialNumberInputPanel serialNumberPanel : this.serialNumberPanelList) {
            if (!serialNumberPanel.getInputBoxErrorEditorPane().isVisible()) continue;
            String msg2 = MSGRES.getString(ADMINDIALOG, "SerialNumberEntryPanel.hasError");
            JOptionPane.showMessageDialog(this.parent, IPLLicenseHandler.getHyperLinkEditorPane(msg2, "", true, 290), MSGRES.getString(ADMINDIALOG, "SerialNumberEntryPanel.errorTitle"), 0);
            ConsoleLogger.log(msg2);
            return false;
        }
        this.serialNumbers.clear();
        this.duplicatedSerialNumbers.clear();
        for (SerialNumberInputPanel serialNumberPanel : this.serialNumberPanelList) {
            String tempLicense = serialNumberPanel.getInputText();
            if (tempLicense.length() <= 0) continue;
            if (!this.serialNumbers.contains(tempLicense)) {
                this.serialNumbers.add(tempLicense);
                continue;
            }
            if (this.duplicatedSerialNumbers.contains(tempLicense)) continue;
            this.duplicatedSerialNumbers.add(tempLicense);
        }
        if (!this.duplicatedSerialNumbers.isEmpty()) {
            msg = MSGRES.getString(ADMINDIALOG, "SerialNumberEntryPanel.duplicatedSerialNumbers");
            this.setLicenseBoxError(this.duplicatedSerialNumbers, msg, true);
            ConsoleLogger.log(msg);
            return false;
        }
        if (this.serialNumbers.isEmpty()) {
            msg = LicenseUtils.ERROR_MESSAGE.ERROR_MESSAGE_SERIAL_NUMBER_FIELD_IS_MANDATORY.toErrorMessage();
            msg = IPLLicenseHandler.getHTMLText(msg);
            JOptionPane.showMessageDialog(this.parent, IPLLicenseHandler.getHyperLinkEditorPane(msg, "", true, 290), MSGRES.getString(ADMINDIALOG, "SerialNumberEntryPanel.errorTitle"), 0);
            ConsoleLogger.log(msg);
            this.setLicenseBoxFocus();
            isValidated = false;
        } else {
            this.parent.setSerialNumbers(this.serialNumbers);
        }
        return isValidated;
    }

    public void disposeUI() {
    }
}

