/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.iplLicense;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.logicobject.ElsLicenseObject;
import com.sygate.scm.console.ui.admin.iplLicense.IPLLicenseHandler;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseActivationHandler;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseActivationWizardDialog;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseInformationModel;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class RenewLicensePanel
extends JPanel {
    private static final long serialVersionUID = 3058431250404614366L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String ADMINDIALOG = "com.sygate.scm.console.ui.admin.dlg.admindialog";
    private ArrayList<ElsLicenseObject> elsLicensesList = new ArrayList();
    private JTable renewalLicenseTable = null;
    private LicenseInformationModel licenseModel = null;
    private JLabel desc = new JLabel(MSGRES.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "RenewLicensePanel.description"));
    private HtmlEnabledJLabel jLblHelpLink = null;
    private JLabel continueTextLabel = new HtmlEnabledJLabel();
    private JPanel descPanel = null;
    private LicenseActivationWizardDialog parent = null;

    public RenewLicensePanel(LicenseActivationWizardDialog parent) {
        this.parent = parent;
        this.elsLicensesList = parent.getElsLicensesList();
        this.initPanel();
    }

    private void initPanel() {
        this.setLayout(new GridBagLayout());
        this.jLblHelpLink = new HtmlEnabledJLabel(MSGRES.getString(ADMINDIALOG, "RenewLicensePanel.licenseRenewHelp"), true);
        this.jLblHelpLink.setIcon((Icon)ConsoleMain.whatsThisIcon);
        this.jLblHelpLink.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                IPLLicenseHandler.showRenewLicenseHelp();
            }
        });
        String title = MSGRES.getString(ADMINDIALOG, "RenewLicensePanel.title");
        JPanel headPanel = UIUtilities.getTopBannerWithLogo(title, "");
        this.add((Component)headPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.descPanel = new JPanel(new BorderLayout());
        this.descPanel.add((Component)this.desc, "West");
        this.descPanel.add((Component)this.jLblHelpLink, "East");
        this.continueTextLabel.setPreferredSize(IPLLicenseHandler.getPreferredSize(this.continueTextLabel, IPLLicenseHandler.getHTMLTextWithDefaultFont(MSGRES.getString(ADMINDIALOG, "RenewLicensePanel.continueMessage")), true, 580));
        this.add((Component)this.descPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 25, 10, 25), 0, 0));
        JScrollPane licenseListTablePanel = this.getLicenseListTable();
        this.add((Component)licenseListTablePanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
        this.add((Component)this.continueTextLabel, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 16, 1, new Insets(0, 25, 10, 25), 0, 0));
    }

    ArrayList<ElsLicenseObject> getSelectedLicenseList() {
        return this.getLicenseInformationModel().getSelectedLicenses();
    }

    private JScrollPane getLicenseListTable() {
        if (this.elsLicensesList != null) {
            this.renewalLicenseTable = LicenseActivationHandler.createLicenseInformationTable(this.elsLicensesList, LicenseActivationHandler.LICENSE_FLOW.LICENSE_RENEWAL_LIST, this.parent.getjBNext());
            this.licenseModel = (LicenseInformationModel)this.renewalLicenseTable.getModel();
            this.renewalLicenseTable.setPreferredScrollableViewportSize(LicenseActivationWizardDialog.TABLE_DIMENSION);
            this.renewalLicenseTable.setAutoCreateRowSorter(true);
            this.renewalLicenseTable.setPreferredScrollableViewportSize(LicenseActivationWizardDialog.TABLE_DIMENSION);
            JScrollPane scrollPane = new JScrollPane(this.renewalLicenseTable, 20, 30);
            scrollPane.setMinimumSize(LicenseActivationWizardDialog.TABLE_DIMENSION);
            return scrollPane;
        }
        return null;
    }

    protected LicenseInformationModel getLicenseInformationModel() {
        return this.licenseModel;
    }

    protected JTable getLicenseInformationTable() {
        return this.renewalLicenseTable;
    }

    public boolean isValidated() {
        ArrayList<ElsLicenseObject> seletecedLicenseList = this.licenseModel.getSelectedLicenses();
        if (seletecedLicenseList.size() < 1) {
            String msg = MSGRES.getString(ADMINDIALOG, "RenewLicensePanel.selectNoLicenseErrorMsg");
            JOptionPane.showMessageDialog(this, IPLLicenseHandler.getHyperLinkEditorPane(msg, "", true, 290), MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.errorTitle"), 0);
            ConsoleLogger.log(msg);
            return false;
        }
        this.parent.setSeletecedLicenseList(this.getSelectedLicenseList());
        return true;
    }
}

