/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.iplLicense;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.license.LicenseException;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.ElsLicenseObject;
import com.sygate.scm.console.ui.admin.iplLicense.IPLLicenseHandler;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseActivationHandler;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseActivationWizardDialog;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseInformationModel;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class RecoverDeletedLicenseDialog
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String ADMINDIALOG = "com.sygate.scm.console.ui.admin.dlg.admindialog";
    private ArrayList<ElsLicenseObject> recoverableLicenses = null;
    private LicenseInformationModel licenseModel = null;
    private DescriptionTextArea desc = new DescriptionTextArea(MSGRES.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "RecoverDeletedLicenseDialog.description"));

    public RecoverDeletedLicenseDialog() {
        super(Manager.getFrame(), "", true);
        String str = MSGRES.getString(ADMINDIALOG, "RecoverDeletedLicenseDialog.title");
        super.setTitle(str);
        this.initialize();
        this.pack();
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    @Override
    protected boolean isValidate() {
        ArrayList<ElsLicenseObject> recoverableLicenses = this.licenseModel.getSelectedLicenses();
        this.setRecoverableLicenses(recoverableLicenses);
        if (this.getRecoverableLicenses().size() < 1) {
            String msg = MSGRES.getString(ADMINDIALOG, "RecoverDeletedLicenseDialog.selectNoLicenseErrorMsg");
            JOptionPane.showMessageDialog(this, IPLLicenseHandler.getHyperLinkEditorPane(msg, "", true, 290), MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.errorTitle"), 0);
            ConsoleLogger.log(msg);
            return false;
        }
        return true;
    }

    private void initialize() {
        String title = MSGRES.getString(ADMINDIALOG, "RecoverDeletedLicenseDialog.title");
        JPanel headPanel = UIUtilities.getTopBannerWithLogo(title, "");
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)headPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.desc, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(15, 25, 10, 0), 0, 0));
        ArrayList<ElsLicenseObject> recoverableLicenses = null;
        try {
            recoverableLicenses = LicenseActivationHandler.getRecoverableLicenses();
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
        }
        if (recoverableLicenses == null) {
            recoverableLicenses = new ArrayList();
        }
        JTable table = LicenseActivationHandler.createLicenseInformationTable(recoverableLicenses, LicenseActivationHandler.LICENSE_FLOW.LICENSE_RECOVERY_LIST, this.jBOk);
        this.licenseModel = (LicenseInformationModel)table.getModel();
        table.setPreferredScrollableViewportSize(LicenseActivationWizardDialog.TABLE_DIMENSION);
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setMinimumSize(LicenseActivationWizardDialog.TABLE_DIMENSION);
        this.getContentPane().add((Component)scrollPane, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 10, 10, 10), 0, 0));
        this.getContentPane().add(Box.createGlue(), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 15, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.jBOk.setEnabled(false);
    }

    @Override
    protected boolean ok() {
        block4: {
            if (super.ok()) {
                try {
                    LicenseActivationHandler.recoverLicenses(this.getRecoverableLicenses());
                }
                catch (LicenseException e) {
                    ConsoleLogger.log(e);
                    JOptionPane.showMessageDialog(this, IPLLicenseHandler.getHyperLinkEditorPane(e.getMessage(), "", true, 290), MSGRES.getString(ADMINDIALOG, "IPLLicenseHandler.error"), 0);
                }
                catch (ConsoleException e) {
                    ConsoleLogger.log(e);
                    JOptionPane.showMessageDialog(this, IPLLicenseHandler.getHyperLinkEditorPane(e.getMessage(), "", true, 290), MSGRES.getString(ADMINDIALOG, "IPLLicenseHandler.error"), 0);
                    if (!e.needRelogin()) break block4;
                    Manager.getFrame().showLoginPanel();
                }
            }
        }
        return true;
    }

    @Override
    protected String getOkButtonText() {
        return MSGRES.getString(ADMINDIALOG, "RecoverDeletedLicenseDialog.jBOk");
    }

    public ArrayList<ElsLicenseObject> getRecoverableLicenses() {
        return this.recoverableLicenses;
    }

    public void setRecoverableLicenses(ArrayList<ElsLicenseObject> recoverableLicenses) {
        this.recoverableLicenses = recoverableLicenses;
    }

    @Override
    protected boolean isHelpButtonShown() {
        return false;
    }
}

