/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.iplLicense;

import com.sygate.scm.console.ui.admin.iplLicense.JLabelHyperLinkData;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseValidityLabelData;
import com.sygate.scm.util.HTMLUtilities;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.MouseInputListener;
import javax.swing.table.DefaultTableCellRenderer;

public class LicenseValidityRenderer
extends DefaultTableCellRenderer
implements MouseInputListener {
    private static final long serialVersionUID = 1L;
    private Object cellData = null;
    private int highlightR = -1;
    private int highlightC = -1;

    private void highlightCell(int row, int column) {
        this.highlightR = row;
        this.highlightC = column;
    }

    private Point getHighlightPoint() {
        return new Point(this.highlightR, this.highlightC);
    }

    private void turnoffHighlight() {
        this.highlightCell(-1, -1);
    }

    public LicenseValidityRenderer(JTable table) {
        table.addMouseListener(this);
        table.addMouseMotionListener(this);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel renderer = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.cellData = value;
        renderer.setOpaque(true);
        if (value == null) {
            renderer.setText("");
            return renderer;
        }
        if (row == this.highlightR && column == this.highlightC) {
            HTMLUtilities.highlightHyperLink((JComponent)renderer);
        } else {
            HTMLUtilities.enableHyperLink((JComponent)renderer);
        }
        if (isSelected) {
            renderer.setBackground(table.getSelectionBackground());
        } else {
            renderer.setBackground(table.getBackground());
        }
        if (value instanceof LicenseValidityLabelData) {
            LicenseValidityLabelData label = (LicenseValidityLabelData)value;
            renderer.setText(label.getText());
            renderer.setIcon(label.getIcon());
        } else if (value instanceof String) {
            renderer.setText((String)value);
        }
        return renderer;
    }

    public Object getCellData() {
        return this.cellData;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        JTable table = (JTable)e.getSource();
        this.turnoffHighlight();
        table.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        JTable table = (JTable)e.getSource();
        Point p = new Point(e.getX(), e.getY());
        int col = table.columnAtPoint(p);
        int row = table.rowAtPoint(p);
        table.setCursor(Cursor.getDefaultCursor());
        if (p.y <= table.getVisibleRect().y || p.y >= table.getVisibleRect().y + table.getVisibleRect().height) {
            this.turnoffHighlight();
        }
        if (p.x <= table.getVisibleRect().x || p.x >= table.getVisibleRect().x + table.getVisibleRect().width) {
            this.turnoffHighlight();
        }
        if (table.getValueAt(row, col) instanceof JLabelHyperLinkData) {
            Rectangle rec = table.getCellRect(row, col, false);
            int x = rec.x + rec.width;
            if (e.getPoint().x <= x) {
                this.highlightCell(row, col);
                table.setCursor(Cursor.getPredefinedCursor(12));
            }
            table.repaint();
        } else if (this.getHighlightPoint().x != -1 || this.getHighlightPoint().y != -1) {
            this.turnoffHighlight();
            table.repaint();
        }
    }
}

