/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.iplLicense;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.ClientAgent;
import com.sygate.scm.console.ui.admin.iplLicense.IPLLicenseHandler;
import com.sygate.scm.console.ui.admin.iplLicense.JLabelHyperLinkData;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseActivationHandler;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseInformationModel;
import com.sygate.scm.console.util.Env;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class LicenseTableListenersImpl
implements TableModelListener {
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String ADMINDIALOG = "com.sygate.scm.console.ui.admin.dlg.admindialog";
    private JTable table = null;
    private JButton wizardNextButton = null;

    public LicenseTableListenersImpl(JTable licenseTable, JButton wizardNextButton) {
        this.table = licenseTable;
        this.wizardNextButton = wizardNextButton;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        block6: {
            block8: {
                LicenseActivationHandler.LICENSE_FLOW licenseFlow;
                LicenseInformationModel model;
                int column;
                int row;
                block9: {
                    int result;
                    block7: {
                        row = e.getFirstRow();
                        column = e.getColumn();
                        model = (LicenseInformationModel)e.getSource();
                        licenseFlow = model.getLicenseFlow();
                        if (licenseFlow.isLicenseSelectable() && model.getColumnName(column).equals(LicenseInformationModel.getLicenseColumnName(0))) {
                            int counter = 0;
                            for (int i = 0; i < model.getRowCount(); ++i) {
                                Boolean isSelected = (Boolean)model.getValueAt(i, column);
                                if (!isSelected.booleanValue()) continue;
                                ++counter;
                            }
                            if (this.wizardNextButton != null) {
                                this.wizardNextButton.setEnabled(counter > 0);
                            }
                        }
                        if (!(model.getValueAt(row, column) instanceof Boolean) || !Utility.isBooleanEquals((Boolean)((Boolean)model.getValueAt(row, column)), (Boolean)Boolean.TRUE)) break block6;
                        if (licenseFlow != LicenseActivationHandler.LICENSE_FLOW.LICENSE_RENEWAL_LIST || !((LicenseInformationModel.LicenseInformationRow)model.getRow(row)).isLicenseValid() || ((LicenseInformationModel.LicenseInformationRow)model.getRow(row)).isLicenseExpire()) break block7;
                        if (Env.isUnitTest() || (result = JOptionPane.showConfirmDialog(this.table, IPLLicenseHandler.getHyperLinkEditorPane(MSGRES.getString(ADMINDIALOG, "LicenseInformationPanel.renewNonExpiredLicenseErrorMessage"), "", true, 290), MSGRES.getString(ADMINDIALOG, "LicenseInformationPanel.invalidLicenseTitle"), 0, 2)) == 0) break block8;
                        model.setValueAt(Boolean.FALSE, row, column);
                        break block8;
                    }
                    if (licenseFlow != LicenseActivationHandler.LICENSE_FLOW.LICENSE_RECOVERY_LIST || !((LicenseInformationModel.LicenseInformationRow)model.getRow(row)).isLicenseExpire()) break block9;
                    result = JOptionPane.showConfirmDialog(this.table, IPLLicenseHandler.getHyperLinkEditorPane(MSGRES.getString(ADMINDIALOG, "LicenseInformationPanel.recoverExpiredLicenseErrorMessage"), "", true, 290), MSGRES.getString(ADMINDIALOG, "LicenseInformationPanel.invalidLicenseTitle"), 0, 2);
                    if (result == 0) break block8;
                    model.setValueAt(Boolean.FALSE, row, column);
                    break block8;
                }
                if (licenseFlow == LicenseActivationHandler.LICENSE_FLOW.LICENSE_RENEWAL_LIST && ((LicenseInformationModel.LicenseInformationRow)model.getRow(row)).isLicenseExpire()) {
                    return;
                }
                if (!((LicenseInformationModel.LicenseInformationRow)model.getRow(row)).isLicenseValid()) {
                    for (int i = 0; i < model.getColumnCount(); ++i) {
                        if (!model.getColumnName(i).equals(LicenseInformationModel.getLicenseColumnName(5))) continue;
                        JLabelHyperLinkData value = (JLabelHyperLinkData)model.getValueAt(row, i);
                        model.setValueAt(Boolean.FALSE, row, column);
                        JOptionPane.showMessageDialog(this.table, IPLLicenseHandler.getHyperLinkEditorPane(value.getInvalidReason(), "", true, 290), MSGRES.getString(ADMINDIALOG, "LicenseInformationPanel.invalidLicenseTitle"), 0);
                        break;
                    }
                }
            }
            AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> {
                ClientAgent.getCurrentInstance().getHTMLPage().setComponentDirty((Component)this.table, true);
                ClientAgent.getCurrentInstance().setUpdateBrowser(true);
                ClientAgent.getCurrentInstance().setUpdateBrowserInterval(0);
            });
        }
    }
}

