/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.iplLicense;

import com.sygate.scm.common.util.Cast;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseInformationModel;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseValidityLabelData;
import com.sygate.scm.console.util.ConsoleLogger;
import java.sql.Date;
import java.util.Comparator;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.table.TableStringConverter;

public class LicenseInformationRowSorter
extends TableRowSorter<LicenseInformationModel> {
    private int validColumnIndex = 0;

    public LicenseInformationRowSorter(LicenseInformationModel model, int licenseValidityColumnIndex) {
        super(model);
        this.validColumnIndex = licenseValidityColumnIndex;
        this.setStringConverter(new LicenseTableStringConverter());
    }

    @Override
    public Comparator<Object> getComparator(int column) {
        Comparator result = (Comparator)Cast.cast(super.getComparator(column));
        if (column == this.validColumnIndex) {
            return new LicenseValidityColumnComparator(result);
        }
        return result;
    }

    private static class LicenseValidityColumnComparator
    implements Comparator<Object> {
        private Comparator<Object> candidate = null;

        public LicenseValidityColumnComparator(Comparator<Object> candidate) {
            this.candidate = candidate;
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 != null && o2 == null) {
                return 1;
            }
            if (o1 == null && o2 != null) {
                return -1;
            }
            if (o1 instanceof String && o2 instanceof String) {
                try {
                    Date d1 = Date.valueOf((String)o1);
                    Date d2 = Date.valueOf((String)o2);
                    return d1.compareTo(d2);
                }
                catch (Exception e) {
                    ConsoleLogger.log(e);
                }
            }
            return this.candidate.compare(o1, o2);
        }
    }

    private class LicenseTableStringConverter
    extends TableStringConverter {
        private LicenseTableStringConverter() {
        }

        @Override
        public String toString(TableModel model, int row, int column) {
            Object obj = model.getValueAt(row, column);
            if (LicenseInformationRowSorter.this.validColumnIndex == column) {
                LicenseValidityLabelData d1 = (LicenseValidityLabelData)obj;
                return String.valueOf(d1.getDate());
            }
            return null;
        }
    }
}

