/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.iplLicense;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.schema.ElsLicense;
import com.sygate.scm.common.configobject.schema.LicenseChain;
import com.sygate.scm.common.configobject.schema.SemConfigRoot;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.license.LicenseUtils;
import com.sygate.scm.common.license.MultiYearLicenseUtils;
import com.sygate.scm.console.logicobject.ElsLicenseObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseActivationHandler;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseActivationWizardDialog;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseInformationModel;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class LicenseInformationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String ADMINDIALOG = "com.sygate.scm.console.ui.admin.dlg.admindialog";
    private LicenseActivationWizardDialog parent = null;
    private JLabel taInfoText = new JLabel(MSGRES.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "LicenseInformationPanel.information"));
    private JLabel taValidSEPSeats = new JLabel(MSGRES.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "LicenseInformationPanel.validSEPSeats"));
    private JLabel taValidSNACSeats = new JLabel(MSGRES.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "LicenseInformationPanel.validSNACSeats"));
    private JLabel taLicenseAccepted = new JLabel(MSGRES.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "LicenseInformationPanel.licenseAccepted"));
    private JLabel removeLicenseText = new JLabel(MSGRES.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "LicenseInformationPanel.removeLicenseInformation"));
    private JPanel removeLicenseTextPanel = new JPanel();
    private JPanel gluePanel = new JPanel();
    private JScrollPane jScrollPaneForNewLicenses = new JScrollPane();
    private JTable jTableNewLicense = new JTable();
    private JScrollPane jScrollPaneForDeletingLicenses = new JScrollPane();
    private JTable jTableDeletingLicense = new JTable();

    public LicenseInformationPanel(LicenseActivationWizardDialog parent) {
        this.parent = parent;
        this.initPanel();
    }

    private void initPanel() {
        this.setLayout(new GridBagLayout());
        String title = MSGRES.getString(ADMINDIALOG, "LicenseInformationPanel.newSerialNumbers");
        JPanel headPanel = UIUtilities.getTopBannerWithLogo(title, "");
        this.add((Component)headPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.taInfoText, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(8, 25, 0, 25), 0, 0));
        this.jTableNewLicense = LicenseActivationHandler.createLicenseInformationTable(new ArrayList<ElsLicenseObject>(), LicenseActivationHandler.LICENSE_FLOW.LICENSE_INFORMATION_NEW);
        this.jScrollPaneForNewLicenses.setViewportView(this.jTableNewLicense);
        this.jTableNewLicense.setPreferredScrollableViewportSize(LicenseActivationWizardDialog.TABLE_DIMENSION_SMALL);
        this.jScrollPaneForNewLicenses.setMinimumSize(LicenseActivationWizardDialog.TABLE_DIMENSION_SMALL);
        this.jScrollPaneForNewLicenses.setMaximumSize(LicenseActivationWizardDialog.TABLE_DIMENSION_SMALL);
        this.jScrollPaneForNewLicenses.setPreferredSize(LicenseActivationWizardDialog.TABLE_DIMENSION_SMALL);
        this.add((Component)this.jScrollPaneForNewLicenses, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        JPanel countPanel = new JPanel(new BorderLayout());
        if (LicenseObject.getInstance().isSAVOnlyProduct() || LicenseObject.getInstance().isALLProduct()) {
            countPanel.add((Component)this.taValidSEPSeats, "North");
        }
        if (!LicenseObject.getInstance().isSEPSBProduct() && (LicenseObject.getInstance().isSNACOnlyProduct() || LicenseObject.getInstance().isALLProduct())) {
            countPanel.add((Component)this.taValidSNACSeats, "Center");
        }
        countPanel.add((Component)this.taLicenseAccepted, "South");
        this.add((Component)countPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 25, 0, 0), 0, 0));
        this.jTableDeletingLicense = LicenseActivationHandler.createLicenseInformationTable(new ArrayList<ElsLicenseObject>(), LicenseActivationHandler.LICENSE_FLOW.LICENSE_INFORMATION_RENEWAL);
        this.jTableDeletingLicense.setPreferredScrollableViewportSize(LicenseActivationWizardDialog.TABLE_DIMENSION_SMALL);
        this.add((Component)this.removeLicenseTextPanel, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 25, 0, 25), 0, 0));
        this.add((Component)this.jScrollPaneForDeletingLicenses, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 10, 5, 10), 0, 0));
        this.gluePanel.add(Box.createGlue());
        this.add((Component)this.gluePanel, new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 16, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void updateRenewalFlowStatus() {
        if (this.parent.isRenewalFlow()) {
            this.jTableNewLicense.setPreferredScrollableViewportSize(LicenseActivationWizardDialog.TABLE_DIMENSION_SMALL);
            this.jScrollPaneForNewLicenses.setMinimumSize(LicenseActivationWizardDialog.TABLE_DIMENSION_SMALL);
            this.jScrollPaneForNewLicenses.setMaximumSize(LicenseActivationWizardDialog.TABLE_DIMENSION_SMALL);
            this.jScrollPaneForNewLicenses.setPreferredSize(LicenseActivationWizardDialog.TABLE_DIMENSION_SMALL);
        } else {
            this.jTableNewLicense.setPreferredScrollableViewportSize(LicenseActivationWizardDialog.TABLE_DIMENSION);
            this.jScrollPaneForNewLicenses.setMinimumSize(LicenseActivationWizardDialog.TABLE_DIMENSION);
            this.jScrollPaneForNewLicenses.setMaximumSize(LicenseActivationWizardDialog.TABLE_DIMENSION);
            this.jScrollPaneForNewLicenses.setPreferredSize(LicenseActivationWizardDialog.TABLE_DIMENSION);
        }
        if (this.parent.isRenewalFlow()) {
            this.removeLicenseTextPanel.add(this.removeLicenseText);
            this.gluePanel.removeAll();
            this.jScrollPaneForDeletingLicenses.setVisible(true);
            this.jScrollPaneForDeletingLicenses.setViewportView(this.jTableDeletingLicense);
            this.jScrollPaneForDeletingLicenses.setMinimumSize(LicenseActivationWizardDialog.TABLE_DIMENSION_SMALL);
            this.jScrollPaneForDeletingLicenses.setMaximumSize(LicenseActivationWizardDialog.TABLE_DIMENSION_SMALL);
            this.jScrollPaneForDeletingLicenses.setPreferredSize(LicenseActivationWizardDialog.TABLE_DIMENSION_SMALL);
        } else {
            this.removeLicenseTextPanel.removeAll();
            this.gluePanel.add(Box.createGlue());
            this.jScrollPaneForDeletingLicenses.setVisible(false);
        }
    }

    public boolean isValidated() {
        if (this.hasValidLicense()) {
            return true;
        }
        UIUtilities.showErrorDialog(MSGRES.getString(ADMINDIALOG, "LicenseInformationPanel.noValidLicenseError"));
        return false;
    }

    public boolean hasValidLicense() {
        ArrayList<ElsLicenseObject> validLicenses = this.getAllValidLicenses();
        return validLicenses != null && validLicenses.size() != 0;
    }

    public void disposeUI() {
    }

    private LicenseInformationModel getLicenseInformationModel() {
        return (LicenseInformationModel)this.jTableNewLicense.getModel();
    }

    private LicenseInformationModel getDeletingLicenseInformationModel() {
        return (LicenseInformationModel)this.jTableDeletingLicense.getModel();
    }

    public void setLicenseList(ArrayList<ElsLicenseObject> newLicensesList) {
        if (newLicensesList == null) {
            newLicensesList = new ArrayList();
        }
        this.getLicenseInformationModel().setLicenses(newLicensesList, LicenseActivationHandler.LICENSE_FLOW.LICENSE_INFORMATION_NEW);
        this.showValidSeats();
        this.jTableNewLicense.validate();
        this.jTableNewLicense.invalidate();
        this.jTableNewLicense.repaint();
    }

    public void setDeletingLicenseList(ArrayList<ElsLicenseObject> selectedLicensesList) {
        if (selectedLicensesList == null) {
            selectedLicensesList = new ArrayList();
        }
        this.getDeletingLicenseInformationModel().setLicenses(selectedLicensesList, LicenseActivationHandler.LICENSE_FLOW.LICENSE_INFORMATION_RENEWAL);
        this.jTableDeletingLicense.validate();
        this.jTableDeletingLicense.invalidate();
        this.jTableDeletingLicense.repaint();
    }

    private void showValidSeats() {
        int validSEPSeats = 0;
        int validSNACSeats = 0;
        try {
            SemConfigRoot root = DataobjectManager.getInstance().getSemConfigRoot();
            Vector chainsAtRoot = root.getLicense().getLicenseChain();
            List<ElsLicense> licenses = ElsLicenseObject.getElsLicenses(this.getAllValidLicenses());
            ArrayList<LicenseChain> licenseChains = new ArrayList<LicenseChain>();
            for (int i = 0; licenses != null && i < licenses.size(); ++i) {
                LicenseChain chain = new LicenseChain();
                chain.setId(new GUIDGenerator().getGUIDString());
                chain.addChild((AbstractSchema)licenses.get(i));
                chain.setOptClientProductType(licenses.get(i).getOptClientProductType());
                LicenseUtils.updateChainProperties((LicenseChain)chain);
                licenseChains.add(chain);
            }
            Vector mergedChains = MultiYearLicenseUtils.getInstance().getMergedChainsByProcessByRow(chainsAtRoot, licenseChains);
            validSEPSeats = MultiYearLicenseUtils.getInstance().getSEPSeats((List)mergedChains) - MultiYearLicenseUtils.getInstance().getSEPSeats((List)chainsAtRoot);
            validSEPSeats = validSEPSeats >= 0 ? validSEPSeats : 0;
            validSNACSeats = MultiYearLicenseUtils.getInstance().getSNACSeats((List)mergedChains) - MultiYearLicenseUtils.getInstance().getSNACSeats((List)chainsAtRoot);
            validSNACSeats = validSNACSeats >= 0 ? validSNACSeats : 0;
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
        }
        Object[] obj = new Object[]{String.valueOf(validSEPSeats)};
        String str = MSGRES.getString(ADMINDIALOG, "LicenseInformationPanel.validSEPSeats");
        this.taValidSEPSeats.setText(MessageFormat.format(str, obj));
        obj = new String[]{String.valueOf(validSNACSeats)};
        str = MSGRES.getString(ADMINDIALOG, "LicenseInformationPanel.validSNACSeats");
        this.taValidSNACSeats.setText(MessageFormat.format(str, obj));
        int licenseCount = this.getLicenseInformationModel().getRowCount();
        obj = new String[]{String.valueOf(this.getAllValidLicenses().size()), String.valueOf(licenseCount)};
        str = licenseCount > 1 ? MSGRES.getString(ADMINDIALOG, "LicenseInformationPanel.licenseAccepted") : "";
        this.taLicenseAccepted.setText(MessageFormat.format(str, obj));
    }

    public ArrayList<ElsLicenseObject> getAllValidLicenses() {
        return this.getLicenseInformationModel().getValidLicenses(false);
    }
}

