/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.iplLicense;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.license.LicenseException;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.logicobject.ElsLicenseObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.admin.iplLicense.JLabelHyperLinkData;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseActivationHandler;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseDisplayStringHelper;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseValidityLabelData;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.Utilities;
import com.sygate.scm.console.util.ConsoleLogger;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.ImageIcon;

public class LicenseInformationModel
extends SortableTableModel {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String ADMINDIALOG = "com.sygate.scm.console.ui.admin.dlg.admindialog";
    private static final String[] COLUMNNAMES = new String[]{"", MSGRES.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "LicenseInformationPanel.columnSerialNumber"), MSGRES.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "LicenseInformationPanel.columnProductName"), MSGRES.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "LicenseInformationPanel.columnSeats"), MSGRES.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "LicenseInformationPanel.columnExpirationDate"), MSGRES.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "LicenseInformationPanel.columnValidity")};
    private static final ImageIcon validLicenseIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("license_invalid.png")));
    private static final ImageIcon invalidLicenseIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("license_valid.png")));
    private static final ImageIcon licenseWarningIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("licenseExpiring16.png")));
    private LicenseActivationHandler.LICENSE_FLOW licenseFlow = LicenseActivationHandler.LICENSE_FLOW.UNKNOWN;

    public static String getLicenseColumnName(int index) {
        int columnNamesCount = COLUMNNAMES.length;
        if (index < 0 || index > columnNamesCount - 1) {
            return null;
        }
        return COLUMNNAMES[index];
    }

    public LicenseInformationModel(ArrayList<ElsLicenseObject> licenseList, LicenseActivationHandler.LICENSE_FLOW licenseFlow) {
        super(COLUMNNAMES, null);
        this.licenseFlow = licenseFlow;
        this.setLicenses(licenseList, licenseFlow);
    }

    public LicenseActivationHandler.LICENSE_FLOW getLicenseFlow() {
        return this.licenseFlow;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (this.licenseFlow.isLicenseSelectable() && column == 0) {
            return true;
        }
        return this.isLastColumn(column);
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (this.isLastColumn(column)) {
            return;
        }
        super.setValueAt(value, row, column);
    }

    private boolean isLastColumn(int column) {
        return column == COLUMNNAMES.length - 1;
    }

    public void setLicenses(ArrayList<ElsLicenseObject> licenseList, LicenseActivationHandler.LICENSE_FLOW licenseFlow) {
        Vector<LicenseInformationRow> data = new Vector<LicenseInformationRow>();
        if (licenseList != null) {
            for (ElsLicenseObject license : licenseList) {
                data.add(new LicenseInformationRow(license, licenseFlow));
            }
        }
        this.setDataVector((Vector)Cast.cast(data));
    }

    public ArrayList<ElsLicenseObject> getValidLicenses(boolean onlySelectedLicense) {
        ArrayList<ElsLicenseObject> validLicenseList = new ArrayList<ElsLicenseObject>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            LicenseInformationRow row = (LicenseInformationRow)this.getRow(i);
            if (!row.licenseValid || onlySelectedLicense && !row.isSelected.booleanValue()) continue;
            validLicenseList.add(row.license);
        }
        return validLicenseList;
    }

    public ArrayList<ElsLicenseObject> getSelectedLicenses() {
        ArrayList<ElsLicenseObject> validLicenseList = new ArrayList<ElsLicenseObject>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            LicenseInformationRow row = (LicenseInformationRow)this.getRow(i);
            if (!row.isSelected.booleanValue()) continue;
            validLicenseList.add(row.license);
        }
        return validLicenseList;
    }

    protected static class LicenseInformationRow
    implements TableRow {
        private ElsLicenseObject license = null;
        private boolean licenseValid = false;
        private String invalidReason = null;
        private Boolean isSelected = Boolean.FALSE;
        private boolean isLicenseExpire = false;
        private ImageIcon licenseIcon = validLicenseIcon;

        public LicenseInformationRow(ElsLicenseObject license, LicenseActivationHandler.LICENSE_FLOW licenseFlow) {
            this.license = license;
            try {
                this.licenseValid = LicenseActivationHandler.isLicenseValid(license, licenseFlow);
                if (this.licenseValid && LicenseActivationHandler.isLicenseExpiring(license)) {
                    this.licenseIcon = licenseWarningIcon;
                    this.isLicenseExpire = true;
                    String url = MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.PartnerResellerLink");
                    if (licenseFlow == LicenseActivationHandler.LICENSE_FLOW.LICENSE_INFORMATION_NEW) {
                        if (LicenseObject.getInstance().isSEPSBProduct()) {
                            this.setInvalidReason(Utilities.getLocalizedMessage("AdminPanel.licenseExpiringSBE", new Object[]{url}));
                        } else {
                            this.setInvalidReason(Utilities.getLocalizedMessage("AdminPanel.licenseExpiringEE", new Object[]{url}));
                        }
                    } else if (LicenseObject.getInstance().isSEPSBProduct()) {
                        this.setInvalidReason(Utilities.getLocalizedMessage("AdminPanel.licenseExpiredExpiringSBE", new Object[]{url}));
                    } else {
                        this.setInvalidReason(Utilities.getLocalizedMessage("AdminPanel.licenseExpiredExpiringEE", new Object[]{url}));
                    }
                }
            }
            catch (LicenseException e) {
                ConsoleLogger.log("license(" + license.getSerialNumber() + ") is invalid: " + e.getMessage());
                if (e.getErrorType() == 769) {
                    this.licenseIcon = licenseFlow == LicenseActivationHandler.LICENSE_FLOW.LICENSE_INFORMATION_NEW ? invalidLicenseIcon : licenseWarningIcon;
                    this.isLicenseExpire = true;
                } else {
                    this.licenseIcon = invalidLicenseIcon;
                }
                this.setInvalidReason(e.getMessage());
            }
        }

        public String getInvalidReason() {
            return this.invalidReason;
        }

        public void setInvalidReason(String invalidReason) {
            this.invalidReason = invalidReason;
        }

        @Override
        public Object getValueAt(int index) {
            switch (index) {
                case 0: {
                    return this.isSelected;
                }
                case 1: {
                    return this.license.getSerialNumber();
                }
                case 2: {
                    return LicenseDisplayStringHelper.getLicenseDisplayString(this.license);
                }
                case 3: {
                    return String.valueOf(this.license.getCount());
                }
                case 4: {
                    return this.license.getExpireDate();
                }
                case 5: {
                    if (this.licenseIcon == validLicenseIcon) {
                        return new LicenseValidityLabelData(ElsLicenseObject.getDateStr(this.license.getExpireDate()), this.licenseIcon, this.license.getExpireDate());
                    }
                    return new JLabelHyperLinkData(MSGRES.getString(LicenseInformationModel.ADMINDIALOG, "LicenseInformationPanel.invalidLicenseStr"), this.licenseIcon, this.license.getExpireDate(), this.invalidReason);
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int index) {
            this.isSelected = (Boolean)value;
        }

        @Override
        public Class<?> getValueTypeAt(int index) {
            switch (index) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
                case 3: {
                    return String.class;
                }
                case 4: {
                    return Long.class;
                }
            }
            if (this.licenseIcon == validLicenseIcon) {
                return LicenseValidityLabelData.class;
            }
            return JLabelHyperLinkData.class;
        }

        public boolean isLicenseExpire() {
            return this.isLicenseExpire;
        }

        public boolean isLicenseValid() {
            return this.licenseValid;
        }
    }
}

