/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.iplLicense;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.ElsLicenseObject;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseFileRow;
import com.sygate.scm.console.ui.util.SortableTableModel;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;

class LicenseFilesModel
extends SortableTableModel {
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String ADMINDIALOG = "com.sygate.scm.console.ui.admin.dlg.admindialog";
    private static final long serialVersionUID = 1L;
    static final String[] COLUMNNAMES = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "UploadLicenseFilesPanel.columnLicenseFile"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "UploadLicenseFilesPanel.columnLicenseNumber"), ""};

    public LicenseFilesModel() {
        this.setColumnNames(COLUMNNAMES);
    }

    public void addLicenseFile(File file) throws LicenseFileRow.LicenseImportConsoleException {
        ArrayList<LicenseFileRow> licenseFilesList = this.getAllLicenseFileRows();
        boolean isExist = false;
        LicenseFileRow newRow = new LicenseFileRow(file);
        for (LicenseFileRow existFileRow : licenseFilesList) {
            if (!newRow.getFileChecksum().equalsIgnoreCase(existFileRow.getFileChecksum())) continue;
            isExist = true;
            break;
        }
        if (isExist) {
            throw new LicenseFileRow.LicenseImportConsoleException(LicenseFileRow.LicenseImportConsoleException.ErrorCode.DUPLICATE_LICENSE_TO_IMPORT, MessageFormat.format(MSGRES.getString(ADMINDIALOG, "UploadLicenseFilesPanel.duplicateLicenseFiles"), newRow.getDisplayableFileName()));
        }
        this.addRow(newRow);
        licenseFilesList.add(newRow);
    }

    public void removeLicenseFile(File file) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            LicenseFileRow row = (LicenseFileRow)this.getRow(i);
            if (row.getFile() != file) continue;
            this.removeRow(i);
            break;
        }
    }

    private ArrayList<LicenseFileRow> getAllLicenseFileRows() {
        ArrayList<LicenseFileRow> licenseFilesList = new ArrayList<LicenseFileRow>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            LicenseFileRow row = (LicenseFileRow)this.getRow(i);
            licenseFilesList.add(row);
        }
        return licenseFilesList;
    }

    public ArrayList<File> getAllLicenseFiles() {
        ArrayList<File> licenseFilesList = new ArrayList<File>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            LicenseFileRow row = (LicenseFileRow)this.getRow(i);
            licenseFilesList.add(row.getFile());
        }
        return licenseFilesList;
    }

    public ArrayList<ElsLicenseObject> getAllElsLicenses() {
        ArrayList<ElsLicenseObject> elsLicensesList = new ArrayList<ElsLicenseObject>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            LicenseFileRow row = (LicenseFileRow)this.getRow(i);
            elsLicensesList.addAll(row.getLicenseArrayList());
        }
        return elsLicensesList;
    }
}

